<?php
/**
 * Template part for displaying results in search pages.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Zomer
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<div class="hentry-inner">
		<header class="entry-header clearfix">
			<?php 
            if ( 'post' === ( $post_type = get_post_type() ) ) :
                zomer_entry_archive_categories(); 
            endif; ?>

			<?php if ( ! post_password_required() && ( comments_open() || get_comments_number() ) ) : ?>
			<span class="comments-link has-icon">
				<?php get_template_part( 'template-parts/content/comments', 'link' ); ?>
			</span><!-- .comments-link -->
			<?php endif; ?>

			<?php the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' ); ?>
		</header><!-- .entry-header -->

		<div class="entry-content">
			<?php the_excerpt(); ?>
		</div><!-- .entry-content -->

		<?php if ( 'post' === $post_type ) : ?>
		<footer class="entry-footer">
			<div class="entry-meta">
				<?php zomer_posted_on_archive(); ?>
			</div><!-- .entry-meta -->
		</footer><!-- .entry-footer -->
		<?php endif; ?>
	</div><!-- .hentry-inner -->

</article><!-- #post-## -->
