<?php
/**
 * Jetpack Compatibility File.
 *
 * @link https://jetpack.com/
 *
 * @package Zomer
 */

/**
 * Jetpack setup function.
 *
 * See: https://jetpack.com/support/responsive-videos/
 */
function zomer_jetpack_setup() {
	// Add theme support for Responsive videos.
	add_theme_support( 'jetpack-responsive-videos' );
}
add_action( 'after_setup_theme', 'zomer_jetpack_setup' );

/**
 * Due to the limited amount of space in archive views,
 * hide share buttons and likes.
 */
function zomer_remove_share_likes() {
	if ( is_home() || is_search() || is_archive() ) {
		remove_filter( 'the_content', 'sharing_display', 19 );
		remove_filter( 'the_excerpt', 'sharing_display', 19 );

		if ( class_exists( 'Jetpack_Likes' ) ) {
			remove_filter( 'the_content', array( Jetpack_Likes::init(), 'post_likes' ), 30, 1 );
		}
	}
}
add_action( 'loop_start', 'zomer_remove_share_likes' );

/**
 * Author Bio Avatar Size.
 */
function zomer_author_bio_avatar_size() {
	return 352;
}
add_filter( 'jetpack_author_bio_avatar_size', 'zomer_author_bio_avatar_size' );
