<?php
/**
 * Getting Started class.
 */

class Zomer_Getting_Started_Admin {

    /**
	 * Variables required for the theme helper.
	 *
	 * @since 1.0.0
	 */
	 protected $theme_slug = null;
     protected $strings = null;
     protected $rating_url = null;

    /**
	 * Initialize the class.
	 *
	 * @since 1.0.0
	 */
    function __construct( $config = array() ) {

        $config = wp_parse_args( $config, array(
			'remote_api_url' => '',
			'theme_slug' => '',
            'rating_url' => '',
		) );

        // Set config arguments.
		$this->remote_api_url = esc_url( $config['remote_api_url'] );
		$this->theme_slug = sanitize_key( $config['theme_slug'] );
        $this->rating_url = esc_url( $config['rating_url'] );

        $this->strings = array(
            'page-title' => esc_html__( 'Getting Started', 'zomer' ),
        );

        add_action( 'admin_menu', array( $this, 'help_menu' ) );
        add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ) );
    }

    /**
	 * Adds a menu item for the theme help under the appearance menu.
	 *
	 * since 1.0.0
	 */
	function help_menu() {

		$strings = $this->strings;

		add_theme_page(
			$strings['page-title'],
			$strings['page-title'],
			'manage_options',
			$this->theme_slug . '-help',
			array( $this, 'getting_started_page' )
		);
	}

    /**
	 * Outputs the markup used on the theme getting started page.
	 *
	 * since 1.0.0
	 */
	function getting_started_page() {

        // Get theme information.
        $theme = wp_get_theme( $this->theme_slug ); ?>

        <div id="getting-started-wrap" class="wrap getting-started">

            <div class="page-header clearfix">
                <div class="theme-info">
				    <h2 class="section-title"><?php printf( esc_html__( 'Getting Started with %s theme.', 'zomer' ), esc_html( $theme['Name'] ) ); ?></h2>
                    <div class="theme-description"><?php echo esc_html( $theme['Description'] ); ?></div><!-- .theme-description -->

                    <div class="theme-meta clearfix">
                        <p class="theme-author"><?php esc_html_e( 'Author:', 'zomer' ); ?> <a href="https://themesharbor.com/" target="_blank"><?php echo strip_tags( $theme['Author'] ); // WPCS: XSS OK. ?></a></p>
                        <p class="theme-version"><?php esc_html_e( 'Version:', 'zomer' ); ?> <span><?php echo esc_html( $theme['Version'] ); ?></span></p>
                    </div><!-- .theme-meta -->
				</div><!-- .theme-info -->

                <div class="theme-screenshot">
                    <img  src="<?php echo esc_url( get_template_directory_uri() . '/screenshot.png' ); ?>" alt="<?php esc_attr( $theme['Name'] ); ?>" />
                </div><!-- .theme-screenshot -->
            </div><!-- .page-header -->

            <div class="page-body clearfix">
                <div class="page-content">
                    <?php
                    $documentation_sections = array(
                        esc_html__( 'Setting Up the Sidebar', 'zomer' ),
                        esc_html__( 'Adding Featured Images', 'zomer' ),
                        esc_html__( 'Creating Post Summaries', 'zomer' ),
                        esc_html__( 'Customizing Widget Areas', 'zomer' ),
                        esc_html__( 'Adding Social Links', 'zomer' ),
                        esc_html__( 'Creating Custom Menus', 'zomer' ),
                    ); ?>

                    <h2><?php esc_html_e( 'Documentation', 'zomer' ); ?></h2>
                    <ul>
                        <?php foreach ( $documentation_sections as $section ) : ?>
                        <li><a href="https://themesharbor.com/documentation/zomer/" target="_blank"><?php echo $section; // WPCS: XSS OK. ?></a></li>
                        <?php endforeach; ?>
                    </ul>
                </div><!-- .page-content -->

                <div class="page-sidebar">

                    <div class="support-widget page-widget">
                        <h3 class="widget-title"><?php esc_html_e( 'Looking for help?', 'zomer' ); ?></h3>
                        <p><?php esc_html_e( 'We have collected some resources that you may find helpful:', 'zomer' ); ?></p>

                        <?php
                            $general_questions_link = '<a href="https://wordpress.org/support/forum/how-to-and-troubleshooting/" target="_blank">' . esc_html__( 'How-To and Troubleshooting', 'zomer' ) . '</a>';
                            $customization_link = '<a href="https://wordpress.org/support/forum/themes-and-templates/" target="_blank">' . esc_html__( 'Themes and Templates', 'zomer' ) . '</a>';
                            $contact_form_link = '<a href="https://themesharbor.com/contacts/" target="_blank">' . esc_html__( 'contact form', 'zomer' ) . '</a>';
                        ?>

                        <ul>
                            <li><?php printf( esc_html__( 'If you have a general question related to WordPress, please post it on WordPress.org %s forum.', 'zomer' ), $general_questions_link ); // WPCS: XSS OK. ?></li>
                            <li><?php printf( esc_html__( 'If you have a customization question, please post it on WordPress.org %s forum.', 'zomer' ), $customization_link ); // WPCS: XSS OK. ?></li>
                            <li><?php printf( esc_html__( 'If your answer can not be found in this help file and links that are posted above, please use our %s.', 'zomer' ), $contact_form_link ); // WPCS: XSS OK. ?></li>
                        </ul>
                    </div><!-- .support-widget -->

                    <?php if ( '' != $this->rating_url ) : ?>
                    <div class="rating-widget page-widget">
                        <h3 class="widget-title"><?php  printf( esc_html__( 'Thank you for using %s!', 'zomer' ), esc_html( $theme['Name'] ) ); ?></h3>
                        <?php

                            $rating_link = '<a href="' . esc_url( $this->rating_url ) . '" target="_blank">&bigstar;&bigstar;&bigstar;&bigstar;&bigstar;</a>';

                            printf( esc_html__( 'If you enjoy using %1$1s theme, please leave us a %2$2s rating. We appreciate your kind comments and taking the time to rate us!', 'zomer' ), esc_html( $theme['Name'] ), $rating_link ); // WPCS: XSS OK.

                        ?>
                    </div><!-- .rating-widget -->
                    <?php endif; ?>

                </div><!-- .page-sidebar -->
            </div><!-- .page-body -->

        </div><!-- #getting-started-wrap -->

    <?php
    }

     /**
     * Load Getting Started styles in the dashboard.
     *
     * since 1.0.0
     */
    function admin_scripts() {

        global $pagenow;

        if ( 'themes.php' != $pagenow ) {
            return;
        }

        // Getting Started javascript
        wp_enqueue_script( 'zomer-getting-started', get_template_directory_uri() . '/inc/help/assets/getting-started.js', array( 'jquery' ), '1.0.0', true );

        // Getting Started styles
        wp_enqueue_style( 'zomer-getting-started', get_template_directory_uri() . '/inc/help/assets/getting-started.css', false, '1.0.0' );
    }

}
