<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Zomer
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'zomer' ); ?></a>

	<div id="toggle-sidebar" aria-hidden="true">
		<div class="inner-panel">            
			<button id="close-toggle-sidebar" class="has-icon" type="button"><?php esc_html_e( 'Close Menu', 'zomer' ); ?></button>
			<nav id="mobile-navigation" class="mobile-navigation" role="navigation" aria-label="<?php esc_attr_e( 'Mobile Navigation', 'zomer' ); ?>"></nav><!-- #mobile-navigation -->
		</div><!-- .inner-panel -->
	</div><!-- #toggle-sidebar -->

	<header id="masthead" class="site-header" role="banner">
		<div class="top-bar clearfix">
			<button id="header-search" class="has-icon clean-button" type="button" data-close-text="<?php esc_attr_e( 'Close', 'zomer' ); ?>"><?php esc_html_e( 'Search', 'zomer' ); ?></button>

			<?php if ( has_nav_menu( 'social' ) ) : ?>
			<nav class="header-social-menu" role="navigation" aria-label="<?php esc_attr_e( 'Social Navigation', 'zomer' ); ?>">
				<?php get_template_part( 'menu', 'social' ); ?>
			</nav><!-- .header-social-menu -->
			<?php endif; ?>

			<?php
			$description = get_bloginfo( 'description', 'display' );
			if ( $description || is_customize_preview() ) : ?>
				<p class="site-description"><?php echo $description; /* WPCS: xss ok. */ ?></p>
			<?php
			endif;

			get_search_form();
			?>
		</div><!-- .top-bar -->

		<div class="container site-branding">
			<?php echo csl_CustomSiteLogo_show_logo(); ?>
			<?php
			zomer_the_custom_logo();

			if ( is_front_page() && is_home() ) : ?>
				<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
			<?php else : ?>
				<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
			<?php
			endif;
			?>

			<nav id="site-navigation" class="main-navigation menu-nav" aria-label="<?php esc_attr_e( 'Main Navigation', 'zomer' ); ?>" role="navigation">
				<?php wp_nav_menu( array( 'theme_location' => 'primary', 'menu_id' => 'primary-menu' ) ); ?>
			</nav><!-- #site-navigation -->
		</div><!-- .container.site-branding -->

		<button id="mobile-menu-button" class="has-icon clean-button" type="button"><?php esc_html_e( 'Menu', 'zomer' ); ?></button>		
	</header><!-- #masthead -->

	<div id="content" class="site-content">
