<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
/*
=================================================================================================================
fasto_critical_css() - inline critical css in head
=================================================================================================================
*/
function fasto_critical_css () { 
	$css = "html{line-height:1.65;-webkit-text-size-adjust:100%}*,::after,::before{box-sizing:border-box}body{margin:0;position:relative}main{display:block}h1{font-size:2em;margin:.67em 0}hr{box-sizing:content-box;height:0;overflow:visible}pre{font-family:monospace,monospace;font-size:1em;overflow:auto}a{background-color:transparent}a,button{-webkit-tap-highlight-color:transparent}abbr[title]{border-bottom:none;text-decoration:underline;text-decoration:underline dotted}b,strong{font-weight:700}code,kbd,samp{font-family:monospace,monospace;font-size:1em}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-.25em}sup{top:-.5em}img{border-style:none}button,input,optgroup,select,textarea{font-family:inherit;font-size:100%;line-height:1.15;margin:0}button,input{overflow:visible}button,select{text-transform:none}[type=button],[type=reset],[type=submit],button{-webkit-appearance:button}[type=button]::-moz-focus-inner,[type=reset]::-moz-focus-inner,[type=submit]::-moz-focus-inner,button::-moz-focus-inner{border-style:none;padding:0}[type=button]:-moz-focusring,[type=reset]:-moz-focusring,[type=submit]:-moz-focusring,button:-moz-focusring{outline:1px dotted ButtonText}fieldset{padding:.35em .75em .625em}legend{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal}progress{vertical-align:baseline}textarea{overflow:auto;line-height:1.7em}[type=checkbox],[type=radio]{box-sizing:border-box;padding:0}[type=number]::-webkit-inner-spin-button,[type=number]::-webkit-outer-spin-button{height:auto}[type=search]{-webkit-appearance:textfield;outline-offset:-2px}[type=search]::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}details{display:block}summary{display:list-item}template{display:none}[hidden]{display:none}.col-desktop-1,.col-desktop-10,.col-desktop-11,.col-desktop-12,.col-desktop-2,.col-desktop-3,.col-desktop-4,.col-desktop-5,.col-desktop-6,.col-desktop-7,.col-desktop-8,.col-desktop-9,.col-mobile-1,.col-mobile-10,.col-mobile-11,.col-mobile-12,.col-mobile-2,.col-mobile-3,.col-mobile-4,.col-mobile-5,.col-mobile-6,.col-mobile-7,.col-mobile-8,.col-mobile-9,.col-small-tablet-1,.col-small-tablet-10,.col-small-tablet-11,.col-small-tablet-12,.col-small-tablet-2,.col-small-tablet-3,.col-small-tablet-4,.col-small-tablet-5,.col-small-tablet-6,.col-small-tablet-7,.col-small-tablet-8,.col-small-tablet-9,.col-tablet-1,.col-tablet-10,.col-tablet-11,.col-tablet-12,.col-tablet-2,.col-tablet-3,.col-tablet-4,.col-tablet-5,.col-tablet-6,.col-tablet-7,.col-tablet-8,.col-tablet-9{position:relative;width:100%;padding-right:15px;padding-left:15px;min-width:0}@media (max-width:479px){.col-mobile-12{flex:0 0 100%;max-width:100%}.col-mobile-11{flex:0 0 91.66666667%;max-width:91.66666667%}.col-mobile-10{flex:0 0 83.33333333%;max-width:83.33333333%}.col-mobile-9{flex:0 0 75%;max-width:75%}.col-mobile-8{flex:0 0 66.66666667%;max-width:66.66666667%}.col-mobile-7{flex:0 0 58.33333333%;max-width:58.33333333%}.col-mobile-6{flex:0 0 50%;max-width:50%}.col-mobile-5{flex:0 0 41.66666667%;max-width:41.66666667%}.col-mobile-4{flex:0 0 33.33333333%;max-width:33.33333333%}.col-mobile-3{flex:0 0 25%;max-width:25%}.col-mobile-2{flex:0 0 16.66666667%;max-width:16.66666667%}.col-mobile-1{flex:0 0 8.33333333%;max-width:8.33333333%}}@media (min-width:480px) and (max-width:767px){.col-small-tablet-12{flex:0 0 100%;max-width:100%}.col-small-tablet-11{flex:0 0 91.66666667%;max-width:91.66666667%}.col-small-tablet-10{flex:0 0 83.33333333%;max-width:83.33333333%}.col-small-tablet-9{flex:0 0 75%;max-width:75%}.col-small-tablet-8{flex:0 0 66.66666667%;max-width:66.66666667%}.col-small-tablet-7{flex:0 0 58.33333333%;max-width:58.33333333%}.col-small-tablet-6{flex:0 0 50%;max-width:50%}.col-small-tablet-5{flex:0 0 41.66666667%;max-width:41.66666667%}.col-small-tablet-4{flex:0 0 33.33333333%;max-width:33.33333333%}.col-small-tablet-3{flex:0 0 25%;max-width:25%}.col-small-tablet-2{flex:0 0 16.66666667%;max-width:16.66666667%}.col-small-tablet-1{flex:0 0 8.33333333%;max-width:8.33333333%}}@media (min-width:767px) and (max-width:1023px){.col-tablet-12{flex:0 0 100%;max-width:100%}.col-tablet-11{flex:0 0 91.66666667%;max-width:91.66666667%}.col-tablet-10{flex:0 0 83.33333333%;max-width:83.33333333%}.col-tablet-9{flex:0 0 75%;max-width:75%}.col-tablet-8{flex:0 0 66.66666667%;max-width:66.66666667%}.col-tablet-7{flex:0 0 58.33333333%;max-width:58.33333333%}.col-tablet-6{flex:0 0 50%;max-width:50%}.col-tablet-5{flex:0 0 41.66666667%;max-width:41.66666667%}.col-tablet-4{flex:0 0 33.33333333%;max-width:33.33333333%}.col-tablet-3{flex:0 0 25%;max-width:25%}.col-tablet-2{flex:0 0 16.66666667%;max-width:16.66666667%}.col-tablet-1{flex:0 0 8.33333333%;max-width:8.33333333%}}@media (min-width:1024px){.col-desktop-12{flex:0 0 100%;max-width:100%}.col-desktop-11{flex:0 0 91.66666667%;max-width:91.66666667%}.col-desktop-10{flex:0 0 83.33333333%;max-width:83.33333333%}.col-desktop-9{flex:0 0 75%;max-width:75%}.col-desktop-8{flex:0 0 66.66666667%;max-width:66.66666667%}.col-desktop-7{flex:0 0 58.33333333%;max-width:58.33333333%}.col-desktop-6{flex:0 0 50%;max-width:50%}.col-desktop-5{flex:0 0 41.66666667%;max-width:41.66666667%}.col-desktop-4{flex:0 0 33.33333333%;max-width:33.33333333%}.col-desktop-3{flex:0 0 25%;max-width:25%}.col-desktop-2{flex:0 0 16.66666667%;max-width:16.66666667%}.col-desktop-1{flex:0 0 8.33333333%;max-width:8.33333333%}}.site-grid{max-width:1320px;box-sizing:border-box;display:block;margin:0 auto;margin-top:50px;padding:0 60px;position:relative}.site-grid-inner{padding:40px 70px 60px 70px;position:relative;box-shadow:-1px 0 16px 0 rgba(0,0,0,.07)}footer#footer{padding:20px 70px 40px 70px;border-radius:0 0 5px 5px;margin-bottom:20px}.fasto-row{display:-ms-flexbox;display:flex;-ms-flex-wrap:wrap;flex-wrap:wrap;margin-right:-15px;margin-left:-15px}.fasto-inner-row{display:-ms-flexbox;display:flex;-ms-flex-wrap:wrap;flex-wrap:wrap}.alignnone{margin:5px 20px 20px 0}.aligncenter,div.aligncenter{display:block;margin:5px auto 5px auto}.alignright{float:right;margin:5px 0 20px 20px}.alignleft,.wp-block-cover.alignleft{float:left;margin:20px 20px 20px 0}a img.alignright{float:right;margin:20px 0 20px 20px}a img.alignnone{margin:20px 20px 20px 0}a img.alignleft{float:left;margin:20px 20px 20px 0}a img.aligncenter{display:block;margin-left:auto;margin-right:auto}.wp-caption{border-style:solid;border-width:1px;max-width:96%;padding:5px 3px 10px;text-align:center}.wp-caption.alignnone{margin:5px 20px 20px 0}.wp-caption.alignleft{margin:5px 20px 20px 0}.wp-caption.alignright{margin:5px 0 20px 20px}.wp-caption img{border:0 none;height:auto;margin:0;max-width:98.5%;padding:0;width:auto}.wp-caption p.wp-caption-text{font-size:14px;line-height:1.54em;margin:0;padding:5px 4px 5px}.screen-reader-text{border:0;clip:rect(1px,1px,1px,1px);clip-path:inset(50%);height:1px;margin:-1px;overflow:hidden;padding:0;position:absolute!important;width:1px;word-wrap:normal!important}.screen-reader-text:focus{background-color:#eee;clip:auto!important;clip-path:none;color:#444;display:block;font-size:1em;height:auto;left:5px;line-height:normal;padding:15px 23px 14px;text-decoration:none;top:5px;width:auto;z-index:100000}.wp-block-gallery .blocks-gallery-item figcaption{box-sizing:border-box}.wp-block-pullquote,.wp-block-quote{padding:0 30px;margin:0 0 25px 0;position:relative;z-index:1}figure.wp-block-pullquote,figure.wp-block-quote{padding-left:0}body .wp-block-cover p:not(.has-text-color){color:#fff}.wp-block-button{margin-bottom:20px}blockquote.is-style-large,blockquote.is-style-large p{font-size:24px}.article-single ul.wp-block-gallery,.page ul.wp-block-gallery{padding-left:0!important;padding-right:20px}ul[class^=wp-block-]{margin-left:0;padding-left:0}.wc-block-grid__product-image img{height:auto}.wp-block-search{position:relative}.wp-block-search button[type=submit]{position:absolute;right:0;top:24px}.rtl .wp-block-search button[type=submit]{position:absolute;right:auto;left:0;top:24px}table.wp-block-table{margin-bottom:30px}.wp-block-embed{margin-left:0;margin-right:0}.wp-block-embed iframe{width:100%}.widget_media_gallery img{height:auto;border:none!important;border-radius:5px}.widget_media_gallery dt{margin-right:8px}.widget_media_gallery .gallery-item{margin:0!important}.has-large-font-size{line-height:normal}div[class^=wc-block] ul{list-style-type:none}.sticky .post-thumb{box-shadow:-2px 1px 37.6px 2.4px rgba(0,0,0,.37);border-radius:6px}body{font-size:16px}h1{font-size:36px;line-height:1.33em}h2{font-size:30px;line-height:1.4em}h3{font-size:24px}h4{font-size:20px}h5{font-size:18px}h6{font-size:16px}a{text-decoration:none;transition:color .2s,border-color .2s;cursor:pointer}p{line-height:2em;margin:30px 0}dd,dt,li{line-height:2em}ul{list-style-type:none;padding-left:20px}b,dt,strong,th{font-weight:700}img{max-width:100%}table{border-collapse:collapse;width:100%}td,th{border-width:1px;border-style:solid;text-align:left;padding:10px 15px}code,pre{font-size:14px;line-height:1.33em;border-radius:5px}pre{padding:20px}code{padding:5px 15px;display:inline-block}input[type=submit]{border:none;border-radius:5px;padding:14px 24px;transition:background .3s ease;cursor:pointer}input[type=email],input[type=number],input[type=password],input[type=search],input[type=tel],input[type=text],input[type=url],textarea{border-radius:5px;padding:13px 24px;border-width:1px;border-style:solid;box-sizing:border-box;width:100%}button{border-radius:5px;border:none;padding:15px 24px;transition:background .3s ease;cursor:pointer}select{width:100%;padding:15px 24px;border-style:solid;border-width:1px;-webkit-appearance:none;-moz-appearance:none;appearance:none;background:rgba(255,255,255,0) url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAABa0lEQVQ4jaWTMUtcQRSFv/PYYlkkhUhYxJntQrCwTJXKyjrYaCGyIZDUKUIQsUgRUqdLk3TiH5FgIbKFWFjITJfCIoQgYXknRXY2T90XIt5q4N7z3TvnzsiY+0SnLZFT7tvuS/puO8VBHM+qq1rED4E9SQe2P0tabms0EwDM235i+xHwFFi8K2Cak/Svmj8e5JQr2z1J4xDDVVtxTrkD9ICfIYYxQJVTriZj7tveySkvFIGkprgLrNs+sD3MKc+VCfq230haA1aBBeBjEdsuoGfAB2AJWAFGwNcO8AM4m4h7wEvgse0HjQk2gE2gI6kGzm1fAsi47Py9pO3GlWvb1QRS89fwEfAcOA4x1CovcbL7d8CW7W7xwHbxY2z7GHgRB3FUukxXFGL4BuwCnyRNDWycDyW9aoqvARqQPeAL8Ms2tuvG2CfcCM36TDnleeCt7aGkI+B1iOH0VmEboAFZsZ0kXYQY6jsB/jd+AygPouJBTG3AAAAAAElFTkSuQmCC) no-repeat 95% center;font-size:14px;margin-bottom:20px;border-radius:5px}.rtl select{background-position:5% center}svg{display:inline-flex;align-self:center;width:1em;fill:inherit;transition:color .3s ease}.wp-block-pullquote,.wp-block-quote,blockquote,blockquote p{font-size:18px;position:relative}blockquote p{padding-top:0;margin-top:0}blockquote{position:relative;margin-left:0;padding:0 30px}.rtl blockquote{margin-right:0}blockquote::before{position:absolute;content:' ';width:5px;height:100%;left:0;top:0;border-radius:5px}.rtl blockquote::before{right:0;left:auto}cite{font-size:14px;font-weight:400}::placeholder{font-size:13px}::-webkit-input-placeholder{font-size:13px}:-moz-placeholder{font-size:13px}::-moz-placeholder{font-size:13px}:-ms-input-placeholder{font-size:13px}.align-center{text-align:center}.align-left{text-align:left}.align-right{text-align:right}.width100{width:100%}.visible{opacity:1!important}.article-single ul,.page-content ul{list-style-type:square}.overlay::before{content:' ';opacity:0;transition:opacity .5s ease}.overlay.visible::before{position:absolute;left:0;top:-100px;width:100%;background:rgba(0,0,0,.8);z-index:3;opacity:1;height:calc(100% + 180px)}.body-color,.pagination a,.tagcloud a,body,ul.tags a{color:#5c6279}.comment-reply a,.menu .page_item>a,.menu>.menu-item>a,.sub-menu a,.widget a,.widget h2,h1,h1 a,h2,h2 a,h3,h3 a,h4,h4 a,h5,h5 a,h6,h6 a,header .logo h1{color:#0e1638}.mobile-trigger-inner,.mobile-trigger-inner::after,.mobile-trigger-inner::before,.mobile-trigger.is-active .mobile-trigger-inner,.mobile-trigger.is-active .mobile-trigger-inner::after,.mobile-trigger.is-active .mobile-trigger-inner::before,code,pre{background-color:#0e1638}#sidebar .widget,.author-box,.breadcrumb-navigation,.comment-container,body .wp-block-table.is-style-stripes td,input[type=email],input[type=number],input[type=password],input[type=search],input[type=tel],input[type=text],input[type=url],select,td,textarea,th{border-color:rgba(14,22,56 ,.2)}.article-single .vertical-separator,.articles .separator,.post-widget:after,.separator.single,article .separator,article .vertical-separator,header#theme-header::after{background-color:rgba(14,22,56 ,.2)}.main-separator{background-color:rgba(14,22,56 ,.3)}.articles .post-title:after,.related-articles .post-title:after{background-color:rgba(14,22,56 ,.7)}.tagcloud a,ul.tags a{border-color:rgba(14,22,56 ,.3)}.search-trigger.mobile svg{fill:#0e1638}.category-count span,.download-button a,.download-button a:hover,.footer-logo h1,.pagination a:hover,.pagination li.active a,.post-category a,.post-category a:hover,.post-category.single,.single .pagination span.current,article:hover .category-link,button,code,footer .widget a,footer .widget h1,footer .widget h2,footer .widget h3,footer .widget h4,footer .widget h5,footer .widget h6,footer#footer,input[type=submit],pre{color:#fff}.pagination a,.single .pagination span,.site-grid-inner,.sub-menu,.views-and-downloads span,.wp-caption,header#theme-header{background-color:#fff}footer .post-widget:after{background-color:rgba(255,255,255 ,.2)}#after-footer .social-and-search svg,.author-box .social-and-search svg,.download-button svg,.post-category.single,.slick-arrow svg,footer .post-widget span svg{fill:#fff}footer input[type=email],footer input[type=password],footer input[type=search],footer input[type=text],footer td,footer textarea,footer th{border-color:rgba(255,255,255 ,.1)}footer .widget{border-color:rgba(255,255,255 ,.2)}footer .tagcloud a{border-color:rgba(255,255,255,.5)}footer .widget p{color:rgba(255,255,255,.7)}.color-1,.comment-date,.menu .page_item:hover>a,.menu>.current-menu-ancestor>a,.menu>.current-menu-item>a,.menu>.menu-item:hover>a,.menu>.menu-item>a:hover,.sub-menu .current-menu-item>a,.sub-menu a:hover,.widget .color-1,.widget a:hover,.widget td a,.widget th a,a,ul.tags a:hover{color:#ff7c34}#after-footer .social-and-search,.author-box .social-and-search,.bg-color-1,.category-count span,.pagination a:hover,.pagination li.active a,.single .pagination span.current,.widget .line,.wp-block-pullquote::before,.wp-block-quote::before,blockquote::before,button,input[type=submit]{background-color:#ff7c34}.social-and-search:hover{border-color:#ff7c34}.social-and-search,.tagcloud a:hover,.tags a:hover{border-color:rgba(255,124,52,.4)}.author-date svg,.social-and-search svg{fill:rgba(255,124,52,.4)}header .author-date a:hover svg,header .social-and-search a:hover svg,li.author:hover>a.author-dropdown>svg{fill:#ff7c34}.color-2,.widget .color-2,a:hover{color:#8bc34a}.bg-color-2,button:hover,input[type=submit]:hover{background-color:#8bc34a}body{background-color:#e0e0e0}footer#footer{background:#000}.category-link{background-color:#ff7c34}.pagination,.pagination .nav-links,.post-thumb a:not(.category-link){background-color:#f3f3f3}.wp-caption{border-color:#c7c7c7}article:hover .post-category,header #searchform{box-shadow:-2px 1px 37.6px 2.4px rgba(0,0,0,.15)}.fasto-fallback-menu a{color:#0e1638}header#theme-header{display:flex;padding:22px 70px;width:100%;margin:0 auto;z-index:10;position:relative;border-radius:5px 5px 0 0;justify-content:space-between;position:sticky;top:0;box-shadow:-1px 0 16px 0 rgba(0,0,0,.07)}header#theme-header::after{content:none;position:absolute;width:calc(100% - 140px);left:70px;bottom:0;height:1px}header#theme-header.open::after{content:none}header#theme-header.header-sticky::after{content:none}#theme-header button{background:0 0}header#theme-header .logo h2{font-size:12px;margin-top:0}.author-social-search,.logo,.social-and-search,nav.primary{display:flex;align-items:center}.social-and-search{transition:all .4s ease}.social-and-search ul li{display:inline-block}.author-social-search{white-space:nowrap}.author-social-search svg{transition:all .4s ease}.logo{min-width:120px}.logo img{display:block}.logo .retina{width:50%}.social-and-search svg{width:20px;height:20px}.social-and-search{border-radius:5px;border-width:1px;border-style:solid}.social-and-search{border:none}.social-and-search ul{padding:0;margin:0;display:block;line-height:0;padding:0 10px}.social-and-search a{padding:10px 3px;line-height:0;display:block}.author-box .social-and-search svg{transition:all .4s ease;transform:translateY(0)}.author-box .social-and-search svg:hover{transform:translateY(-2px)}.breadcrumb-navigation .social-and-search a:hover svg{transform:translateY(-2px)}.search-mobile{display:none}.search-trigger:hover svg{opacity:.7}header #searchform{width:calc(100% - 120px);border-radius:5px;position:absolute;margin-left:auto;margin-right:auto;left:0;right:0;visibility:hidden;opacity:0;transition:all .3s ease;transform:translateY(10px);z-index:7;top:80px}header #searchform.active{opacity:1;width:calc(100% - 140px);visibility:visible;transform:translateY(0)}header #searchform input{padding:20px 24px;border:none;width:100%;border-radius:5px 7px 7px 5px}#searchform input[type=submit]{position:absolute;right:0;max-width:150px;border-radius:0 5px 5px 0}.rtl #searchform input[type=submit]{left:0;right:auto;border-radius:5px 0 0 5px}#search-form-holder{position:relative}header#theme-header .site-title{margin:0;padding:0;letter-spacing:-.05em;text-transform:uppercase;font-size:32px;line-height:1em;margin-right:10px}.site-description{font-size:11px;text-transform:uppercase;padding:0;margin:0}.header-image{margin-bottom:-10px}.menu{line-height:1;margin:0;padding:0;width:100%;list-style:none;list-style-type:none}.menu li{display:inline-block;margin:0;text-align:left}.rtl .menu li{text-align:right}.menu a{display:block;padding:4px 15px;position:relative}div#primary>ul>.current_page_item>a,div#primary>ul>.page_item>a,ul#primary>.menu-item>a{font-size:18px;font-weight:700}.menu .current-menu-item>a,.menu .current_page_item>a,.menu a:focus,.menu a:hover{text-decoration:none}.menu .children,.menu .sub-menu{-webkit-transition:opacity .4s ease-in-out;-moz-transition:opacity .4s ease-in-out;-ms-transition:opacity .4s ease-in-out;-o-transition:opacity .4s ease-in-out;transition:opacity .4s ease-in-out;max-width:190px;z-index:99;margin:0;padding:0;left:-9999px;opacity:0;position:absolute}.rtl .menu .children,.rtl .menu .sub-menu{left:auto}.menu .children a,.menu .sub-menu a{padding:0 20px;position:relative;width:190px}.menu .children .children,.menu .sub-menu .sub-menu{margin:-47px 0 0 190px}.rtl .menu .children .children,.rtl .menu .sub-menu .sub-menu{margin:-47px 190px 0 0}.sub-menu{padding:15px 0}.menu li.focus,.menu li:hover{position:static}.menu li.focus>.children,.menu li.focus>.sub-menu,.menu li:hover>.children,.menu li:hover>.sub-menu{left:auto;opacity:1}.mobile-menu-icon:focus,.mobile-menu-icon:hover{background:#7f181b}div#primary ul{padding:0;margin:0}@media only screen and (min-width:1024px){.menu .sub-menu{padding:15px 0}.menu .children,.menu .sub-menu{box-shadow:-1px 0 16px 0 rgba(0,0,0,.07);border-radius:5px}.menu li.menu-item-has-children>a:after{content:' ';width:0;height:0;border-left:4px solid transparent;border-right:4px solid transparent;border-top:4px solid #000;position:absolute;top:16px;right:20px;margin-left:10px;transform:rotate(-90deg)}.menu>li.menu-item-has-children>a:after{border-left:4px solid transparent;border-right:4px solid transparent;border-top:4px solid #000;position:relative;right:unset}.rtl .menu li.menu-item-has-children>a:after{right:auto;margin-left:0;margin-right:10px;transform:rotate(90deg);left:20px}.rtl .menu>li.menu-item-has-children>a:after{right:auto;margin-left:0;margin-right:10px;transform:rotate(98deg);left:20px}}.breadcrumb-navigation{padding:30px;border-radius:5px;border-style:solid;border-width:1px;margin-top:0;margin-bottom:0;border:none;padding-left:0;padding-top:0}.page .breadcrumb-navigation{margin-bottom:0;padding-bottom:0}.author .breadcrumb-navigation{padding:0;border:none}.breadcrumb-navigation h1{margin:0;padding:0}ul.breadcrumb{margin-top:0;margin-bottom:0;padding-left:0}.single ul.breadcrumb{margin-bottom:12px;font-size:12px}.rtl ul.breadcrumb{padding-right:0}ul.breadcrumb li{display:inline-block;vertical-align:middle}.single .article-title{-ms-word-wrap:break-word;word-wrap:break-word;width:100%;margin-top:10px;letter-spacing:-.6px;margin-bottom:30px}.single .other-posts{-ms-word-wrap:break-word;word-wrap:break-word}.post-thumb{position:relative;max-width:100%;transition:all .5s ease}.single .article-single .post-thumb{margin-bottom:30px}.single .article-single .post-thumb a{background:0 0}.post-thumb img{border-radius:5px;display:block;backface-visibility:hidden}.articles .post-thumb img,.related-articles .post-thumb img{width:100%;transition:filter .7s}.post-content{position:relative}.page-content a,.post-content-inner a{text-decoration:underline}.page-content img,.post-content img{transition:all .5s ease}.page-content img.lazyload,.post-content img.lazyload{opacity:0}.page-content ul li:before,.post-content ul li:not(.blocks-gallery-item):before{content:' - '}.page-content ul,.post-content ul{list-style-type:none}.page-content ul,.post-content ul{padding-left:15px}.page-content ul li,.post-content ul li{margin-bottom:2px}.page-content ul li,.post-content ul li{margin-bottom:6px}.page-content table,.post-content table{margin-bottom:40px}.post-thumb a{display:block;border-radius:8px}.cover-image{display:block;opacity:0;border-radius:5px}.unset-absolute{position:initial}.post-title{font-size:28px;line-height:1.23em;margin-top:0;margin-bottom:10px;letter-spacing:-.5px;-ms-word-wrap:break-word;word-wrap:break-word;position:relative}.articles .post-title,.related-articles .post-title{padding-bottom:20px}.related-articles .post-title a{margin-bottom:0}.articles .post-title:after,.related-articles .post-title:after{position:absolute;bottom:0;content:' ';width:70px;height:2px}.grid-4 .post-title{font-size:18px;line-height:1.43em}.post-title a{display:block}.post-details{padding:18px 0;margin-bottom:20px}.related-articles .post-details{padding:18px 0;margin-bottom:0;padding-bottom:0}article p{font-size:15px;line-height:1.75;margin-top:15px;margin-bottom:10px}.articles .separator,article .separator{height:1px;margin-bottom:10px}.main-separator{height:3px;width:calc(100% - 30px);margin-bottom:58px;margin-left:auto;margin-right:auto}.main-separator.mobile,.main-separator.tablet{display:none}.separator.single{height:1px;margin:20px 0 35px 0}.separator.single.big{margin-top:0}.article-single .vertical-separator,article .vertical-separator{width:1px;height:20px;margin:0 15px}.article-single img{border-radius:5px}.sl-image img{border-radius:5px}.post-category{position:absolute;bottom:15px;left:15px;z-index:2;font-weight:700;font-size:14px;text-transform:uppercase;transition:all .33s ease;transform:translate(0,0);display:flex}.post-category a:nth-of-type(2){margin-left:4px}.rtl .post-category a:nth-of-type(2){margin-left:0;margin-right:4px}.rtl .post-category{right:15px;left:auto}.post-category a{height:auto;display:flex;align-items:center;border-radius:5px;padding:7px;justify-content:center;font-size:12px;text-transform:capitalize;font-weight:400;letter-spacing:1px}.post-category span{z-index:2}.post-category.single{position:static;margin-bottom:12px;display:flex;align-items:center;flex-wrap:wrap}.post-category.single a,.post-category.single span{text-align:center;margin:0 5px 5px 0;padding:7px 15px;display:flex;align-items:center;border-radius:5px}.post-category.single span.downloads{padding:5px 15px}.post-category.single svg{width:22px;margin-right:5px}.rtl .post-category.single svg{margin-right:0;margin-left:5px}.post-category.single a::before{content:none}.post-category{overflow:hidden}.category-link::before{content:' ';position:absolute;border-radius:4px;width:100%;height:100%;transform:scale(0);transition:all .3s ease;right:0;top:0}article:hover .category-link::before{transform:scale(1)}.author-date{font-size:12px;padding-bottom:15px;display:flex;flex-wrap:wrap;align-items:center;text-transform:uppercase}.article-single .author-date{margin-top:-12px}.author-date svg{width:24px;height:24px;margin-right:5px}.rtl .author-date svg{margin-right:0;margin-left:5px}.author-date a{font-size:12px;display:flex;align-items:center}ul.tags{padding-left:0;clear:both}.rtl ul.tags{padding-right:0}ul.tags li{display:inline-block;margin:0 8px 8px 0}ul.tags a{padding:2px 8px 4px 8px;border-width:1px;border-style:solid;border-radius:5px}#comments{clear:both}#comments>ul{padding-left:0}.rtl #comments>ul{padding-right:0}.comment-container{display:flex;padding-bottom:25px;margin-bottom:25px;border-width:0 0 1px 0;border-style:solid}.comment-container img{max-width:80px;margin-right:15px;border-radius:5px}.rtl .comment-container img{margin-right:0;margin-left:15px}.comment-container h3{padding-top:0;margin-top:0;margin-bottom:5px}.comment-date{font-size:12px}.the-comment p{margin:5px 0;font-size:13px}.comment-reply{font-size:12px}.comment-holder{overflow:auto}.comment-author-img,.comment-holder{flex-direction:column}.comment-form input{margin-bottom:15px}.comment-form textarea{height:175px}.comment-respond h2,.comments-area h2{padding-bottom:10px}.comment-form-author,.comment-form-comment,.comment-form-email,.comment-form-url{margin:0}ul .pingback{list-style-type:none}ul .pingback p>a{display:block}ul .pingback .edit-link{font-size:12px}.nocomments{font-size:20px}input[name=post_password]{margin-bottom:20px}.author-box{width:100%;margin:0 auto;text-align:center;padding:75px 30px 45px 30px;border-radius:5px;border-width:1px;border-style:solid;position:relative;margin-top:70px}.archive .author-box{margin-top:0;margin-bottom:70px}.author-box h3{font-weight:400;font-size:12px;letter-spacing:5px;text-transform:uppercase}.author-box h2{padding:0 0 10px 0;margin-top:10px;padding-bottom:0;margin-bottom:15px;font-size:36px}.author-box p{max-width:720px;margin:auto;margin-top:0;margin-bottom:30px}.author-box .author{position:absolute;left:50%;transform:translateX(-50%);top:-40px;width:80px;height:80px;border-radius:5px}.author-box .author img{border-radius:5px}.author-box .social-and-search{display:table;margin:auto}.related-articles h2.title{margin:40px 0;font-size:36px}.number-of-shares{font-size:32px;line-height:.7em;margin-left:3px;text-align:center;margin-right:20px;font-weight:700;padding-top:8px}.rtl .number-of-shares{margin-right:3px;margin-left:20px}.number-of-shares span{font-size:12px;display:block;font-weight:400}.other-posts h2{margin-top:0}.other-posts h3{margin:10px 0 10px 0;font-size:20px;line-height:1.43em}.widget{font-size:14px;margin-top:50px;position:relative}.widget:last-of-type{border:none;padding-bottom:0}.widget{border-width:0 0 1px 0;border-style:solid;padding-bottom:40px}.widget h2{font-size:18px;letter-spacing:5px;text-transform:uppercase;font-weight:400;margin-bottom:50px;margin-top:0;display:inline-block}.widget .line{width:50px;height:1px;border-radius:20px;display:inline-block;margin-left:10px;position:relative;top:-4px}.rtl .widget .line{margin-left:0;margin-right:10px}.widget p{font-size:13px;line-height:1.69em}.widget a{line-height:2em;font-weight:700}.widget ul:not(.sub-menu-widget):not(.children){margin-left:0;padding-left:0;padding-right:0;margin-top:0}.widget td,.widget th{padding:5px;text-align:center}.widget td a,.widget th a{line-height:normal;font-weight:700}.widget table caption{padding-bottom:10px;text-align:left}.widget .comment-author-link,.widget .rsswidget{font-weight:700}.widget.widget_rss li{padding-bottom:15px}.widget .tagcloud a{display:inline-block;line-height:1em;padding:5px 10px;border-radius:5px;border-width:1px;border-style:solid;margin:0 4px 8px 0;text-transform:capitalize;font-size:14px}.widget_calendar,.widget_media_image,.widget_search{padding-bottom:60px}.widget_media_gallery,.widget_tag_cloud{padding-bottom:50px}.widget h3.post-title{font-size:16px;letter-spacing:.3px;margin-bottom:5px}.widget .post-title a{line-height:1.5em}.sidebar-posts{margin-top:10px;margin-bottom:-20px}.post-widget{margin-bottom:20px;position:relative;padding-bottom:20px}.post-widget:after{position:absolute;bottom:0;content:' ';width:200px;height:1px}article:last-child .post-widget:after{content:none}.post-widget span{display:flex;font-size:12px}.post-widget span svg{margin-right:5px}.post-widget .cover-image,.post-widget .post-thumb a{border-radius:5px}.post-widget .thumb{padding-right:0;max-width:120px}.rtl .post-widget .thumb{padding-right:15px;padding-left:0}.post-widget .slick-arrow.slick-prev{right:7px}.post-widget .slick-arrow.slick-next{left:7px}.category-count span{line-height:1em;margin-left:10px;font-size:10px;padding:1px 5px;border-radius:4px}.widget_search input[type=submit]{border-radius:0 5px 5px 0}#sidebar .widget:last-of-type{margin-bottom:50px}article{position:relative}.date-published{position:absolute;top:-12px;right:-10px;background:#fff;padding:7px 12px;border-radius:5px;text-align:center;box-shadow:-2px 1px 37.6px 2.4px rgba(0,0,0,.1)}.date-published span.small{font-size:12px;text-transform:uppercase;display:block;margin-top:-5px}.date-published span.big{font-size:32px;font-weight:700;line-height:1em}.slick-slider{position:relative;display:block;box-sizing:border-box;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;-webkit-touch-callout:none;-khtml-user-select:none;-ms-touch-action:pan-y;touch-action:pan-y;-webkit-tap-highlight-color:transparent}.slick-list{position:relative;display:block;overflow:hidden;margin:0;padding:0}.slick-list:focus{outline:0}.slick-list.dragging{cursor:pointer;cursor:hand}.slick-slider .slick-list,.slick-slider .slick-track{-webkit-transform:translate3d(0,0,0);-moz-transform:translate3d(0,0,0);-ms-transform:translate3d(0,0,0);-o-transform:translate3d(0,0,0);transform:translate3d(0,0,0)}.slick-track{position:relative;top:0;left:0;display:block;margin-left:auto;margin-right:auto}.slick-track:after,.slick-track:before{display:table;content:''}.slick-track:after{clear:both}.slick-loading .slick-track{visibility:hidden}.slick-slide{display:none;float:left;height:100%;min-height:1px;outline:0}[dir=rtl] .slick-slide{float:right}.slick-slide img{display:block}.slick-slide.slick-loading img{display:none}.slick-slide.dragging img{pointer-events:none}.slick-initialized .slick-slide{display:block}.slick-loading .slick-slide{visibility:hidden}.slick-vertical .slick-slide{display:block;height:auto;border:1px solid transparent}.slick-arrow.slick-hidden{display:none}.slick-arrow{position:absolute;top:50%;z-index:2;-webkit-transform:translate(0,-50%);transform:translate(0,-50%);transition:opacity .3s ease,color .3s ease}.slick-arrow svg{width:28px;height:28px}article .slick-arrow{padding:0;border-radius:5px;width:30px;height:30px;opacity:.7}article:hover .slick-arrow{padding:0;border-radius:5px;width:30px;height:30px;opacity:1}.slick-arrow.slick-next{left:15px}.slick-arrow.slick-prev{right:15px}#search-no-result h2{margin-top:0;margin-bottom:10px;font-size:36px}#search-no-result h3{margin-top:0;margin-bottom:60px}#page-404 h1{margin-top:0;margin-bottom:10px}#page-404 h3{margin-top:0;margin-bottom:60px}.pagination{width:calc(100% - 30px);margin:0 auto;clear:both}.page .pagination{width:100%}.pagination .nav-links{padding:35px 15px;text-align:center;border-radius:5px}.pagination{border-radius:5px}.pagination a,.pagination span,.single .pagination span{width:50px;height:50px;display:inline-block;border-radius:50px;padding-top:10px;transition:background .3s ease,color .3s ease;margin:0 3px}.page .pagination a,.page .pagination span{display:inline-block;margin:0 10px;vertical-align:middle}.single .pagination{width:100%}.single .pagination ul{padding:15px}.single .pagination li{text-align:center}.pagination li:before{content:none!important}.social-share-holder{margin:0;position:absolute;left:-114px;padding-left:0;max-width:40px;height:96%}.after-post{margin-bottom:40px;display:flex;align-items:center;width:100%}.after-post .social-share-holder{position:static;max-width:100%}.after-post .social-share-holder a{border-radius:3px}.after-post .social-share-holder ul{margin:0 -3px}.after-post .social-share-holder li{margin:3px}.after-post ul.social-share a::before{border-radius:2px;transform:scale(0)}.after-post ul.social-share a:hover::before{transform:scale(1)}ul.social-share{position:sticky;top:30px;padding:0}ul.social-share li{float:left;margin:0;padding:0;line-height:0;overflow:hidden;margin-bottom:5px}ul.social-share a{padding:10px 12px;display:block;min-width:20px;text-align:center;line-height:1.2em;border-radius:3px 0 0 3px;transition:all .5s ease;position:relative;z-index:2}ul.social-share svg{display:block;fill:#fff;width:20px;height:20px;z-index:1;position:relative;transition:all .5s ease}ul.social-share a.mail svg{fill:#0e1638}ul.social-share a.mail:hover svg{fill:#fff}ul.social-share a::before{position:absolute;content:' ';width:100%;height:100%;left:0;top:0;border-radius:3px 0 0 3px;opacity:0;transition:all .3s ease;transform:translateX(100%);z-index:0}ul.social-share a:hover::before{opacity:1;transform:translateX(0);background:#fff}ul.social-share a.mail:hover::before{background:#0e1638}ul.social-share a:hover svg{fill:#0e1638}ul.social-share a.facebook{background:#3a5799}ul.social-share a.twitter{background:#21bff3}ul.social-share a.pinterest{background:#cc2127}ul.social-share a.linkedin{background:#0274b3}ul.social-share a.mail{background:#fff600}.mobile-trigger{padding:15px 15px;display:inline-block;cursor:pointer;transition-property:opacity,filter;transition-duration:.15s;transition-timing-function:linear;font:inherit;color:inherit;text-transform:none;border:0;margin:0;line-height:0;overflow:visible;display:none}.mobile-trigger:hover{background:0 0}.mobile-trigger:hover{opacity:.7}.mobile-trigger.is-active:hover{opacity:.7}.mobile-trigger-box{width:40px;height:24px;display:inline-block;position:relative}.mobile-trigger-inner{display:block;top:50%;margin-top:-2px}.mobile-trigger-inner,.mobile-trigger-inner::after,.mobile-trigger-inner::before{width:40px;height:4px;border-radius:4px;position:absolute;transition-property:transform;transition-duration:.15s;transition-timing-function:ease}.mobile-trigger-inner::after,.mobile-trigger-inner::before{content:'';display:block}.mobile-trigger-inner::before{top:-10px}.mobile-trigger-inner::after{bottom:-10px}.mobile-trigger--slider .mobile-trigger-inner{top:2px}.mobile-trigger--slider .mobile-trigger-inner::before{top:10px;transition-property:transform,opacity;transition-timing-function:ease;transition-duration:.15s}.mobile-trigger--slider .mobile-trigger-inner::after{top:20px}.mobile-trigger--slider.is-active .mobile-trigger-inner{transform:translate3d(0,10px,0) rotate(45deg)}.mobile-trigger--slider.is-active .mobile-trigger-inner::before{transform:rotate(-45deg) translate3d(-5.71429px,-6px,0);opacity:0}.mobile-trigger--slider.is-active .mobile-trigger-inner::after{transform:translate3d(0,-20px,0) rotate(-90deg)}@media all and (-ms-high-contrast:none){.views-and-downloads span{height:36px}.download-button button{height:52px}.post-widget .thumb{max-width:115px}.menu .menu-item .menu-link svg{height:24px}.post-category.single span{height:37px}}.wpcf7 input:not([type=submit]){margin-bottom:30px}.wpcf7 textarea{margin-bottom:30px;max-height:200px}span.wpcf7-not-valid-tip{position:relative;top:-15px}body div.wpcf7-response-output{margin:2em 0}@media (min-width:1024px) and (max-width:1300px){header#theme-header{flex-wrap:wrap}nav.primary{order:3;flex-basis:100%}}@media (min-width:1024px) and (max-width:1366px){.grid-4 .post-category{min-width:unset}}@media (min-width:1024px){.home.has-sidebar .site-grid-inner{padding-top:0}.padding-right-0{padding-right:0}.padding-left-0{padding-left:0}.padding-right-15{padding-right:15px}.padding-right-30{padding-right:30px}#sidebar{border-color:rgba(14,22,56 ,.2)}.articles.grid-1,.articles.grid-2,.single.has-sidebar .article-single{padding-top:60px}.rtl.single.has-sidebar .article-single{padding-left:30px;padding-right:15px}.grid-1 .post-title{font-size:24px;line-height:1.33em}.rtl.has-sidebar .articles{padding-right:0;padding-left:15px}#sidebar{padding-left:30px;border-width:0 0 0 1px;border-style:solid;padding-top:60px}.rtl #sidebar{padding-left:15px;border-width:0 1px 0 0;padding-right:30px}#sidebar .widget:first-of-type{margin-top:0}.archive.author.has-sidebar .breadcrumb-navigation,.archive.category.has-sidebar .breadcrumb-navigation,.archive.date.has-sidebar .breadcrumb-navigation,.archive.tag.has-sidebar .breadcrumb-navigation{margin-bottom:0}.archive.author.has-sidebar .author-box{margin-bottom:0}.subscribe input[type=email]{max-width:400px}.single.has-sidebar .site-grid-inner{padding-top:0}}@media (max-width:1023px){#primary{margin-left:0;margin-right:0;padding:15px 0}.menu.responsive-menu{display:none;max-height:400px;overflow:scroll}#primary.open .menu.responsive-menu{display:block}.menu.responsive-menu li,.mobile-menu-icon{display:block}.menu.responsive-menu li.focus,.menu.responsive-menu li:hover{position:static}.menu.responsive-menu .children li.current_page_item>a:focus,.menu.responsive-menu .children li.current_page_item>a:hover,.menu.responsive-menu .sub-menu li.current-menu-item>a:focus,.menu.responsive-menu .sub-menu li.current-menu-item>a:hover,.menu.responsive-menu li a,.menu.responsive-menu li a:focus,.menu.responsive-menu li a:hover,.menu.responsive-menu li.current-menu-item>a,.menu.responsive-menu li.current_page_item>a{display:block;padding:0 20px;border:none}.menu .sub-menu li:first-child a{border-top:none}.menu .children li:first-child a{border-top:none}.menu.responsive-menu .menu-item-has-children,.menu.responsive-menu .page_item_has_children{cursor:pointer}.menu.responsive-menu .menu-item-has-children>a,.menu.responsive-menu .page_item_has_children>a{margin-right:50px}.menu.responsive-menu>.menu-item-has-children:before,.menu.responsive-menu>.page_item_has_children:before{content:' ';width:0;height:0;border-left:4px solid transparent;border-right:4px solid transparent;border-top:4px solid #000;position:relative;float:right;margin-right:15px;margin-top:14px}.menu.responsive-menu>li>.children,.menu.responsive-menu>li>.sub-menu{margin:0;padding:0;left:-9999px;opacity:0;position:absolute;-webkit-transition:opacity .4s ease-in-out;-moz-transition:opacity .4s ease-in-out;-ms-transition:opacity .4s ease-in-out;-o-transition:opacity .4s ease-in-out;transition:opacity .4s ease-in-out;z-index:99}.menu.responsive-menu>li.focus>.children,.menu.responsive-menu>li.focus>.sub-menu{position:relative;left:auto;opacity:1}.menu.responsive-menu>li>.children.submenu-toggle,.menu.responsive-menu>li>.sub-menu.submenu-toggle{position:relative;left:auto;opacity:1}.menu.responsive-menu .children,.menu.responsive-menu .sub-menu{left:auto;opacity:1;position:relative;-webkit-transition:opacity .4s ease-in-out;-moz-transition:opacity .4s ease-in-out;-ms-transition:opacity .4s ease-in-out;-o-transition:opacity .4s ease-in-out;transition:opacity .4s ease-in-out;width:100%;z-index:99;margin:0}.menu.responsive-menu .children .children,.menu.responsive-menu .sub-menu .sub-menu{background-color:transparent;margin:0;padding-left:15px}.menu.responsive-menu .children li a,.menu.responsive-menu .children li a:focus,.menu.responsive-menu .children li a:hover,.menu.responsive-menu .sub-menu li a,.menu.responsive-menu .sub-menu li a:focus,.menu.responsive-menu .sub-menu li a:hover{position:relative;width:100%}.mobile-trigger{display:block}.responsive-menu{position:absolute;top:75px;max-width:200px;background:#fff}.search-trigger.mobile{padding-left:10px}#sidebar{display:none}.main-separator,.main-separator.mobile{display:none}.main-separator.tablet{display:block}header#theme-header{flex-wrap:wrap}.breadcrumb-navigation{margin-bottom:60px}header#theme-header{padding:0 70px}}@media (min-width:768px) and (max-width:1023px){.padding-right-tablet-0{padding-right:0}.padding-left-tablet-0{padding-left:0}#sidebar .widget{width:50%;float:left;box-sizing:border-box}#sidebar .widget:nth-of-type(2n){padding-left:30px}#sidebar .widget:nth-of-type(2n+1){clear:both}}@media (max-width:767px){h1{font-size:1.6em}h2{font-size:1.4em}h3{font-size:1.3em}h4{font-size:1.2em}h5{font-size:1.1em}.site-grid-inner{padding:60px 20px 60px 20px}.site-grid{padding:0;margin-top:60px}header#theme-header::after{width:calc(100% - 40px);left:20px}header#theme-header{padding:3px 20px}.padding-right-mobile-0{padding-right:0}.padding-left-mobile-0{padding-left:0}.post-category{min-width:unset}.post-widget .post-thumb{margin-bottom:15px}footer#footer{padding:30px 20px 30px 20px}.social-share-holder{display:none}.after-post .social-share-holder{display:flex}.search-mobile{display:flex;justify-content:flex-end}.search-trigger.mobile svg{width:36px;height:36px}.author-social-search{order:3;width:100%;display:none}header#theme-header #searchform{top:65px}header#theme-header #searchform.active{width:calc(100% - 40px)}nav.nav{margin-right:20px}.rtl nav.nav{margin-left:20px;margin-right:0}.author-box h2,.related-articles h2.title{font-size:24px}}@media (max-width:479px){.main-separator,.main-separator.tablet{display:none}.main-separator.mobile{display:block}#searchform input[type=submit]{max-width:100px}.responsive-menu{left:50px}}@media (max-width:360px){.logo{max-width:100px}}.logged-in header#theme-header{top:32px}@media screen and (max-width:600px){body div[id^=wpadminbar]{top:-106px!important}.logged-in header#theme-header{top:0}}@media (min-width:601px) and (max-width:768px){.logged-in header#theme-header{top:46px}}.copyright-user{text-align:center;margin:auto;font-size:15px;padding:0 10px 10px}.copyright-fasto{margin-left:auto;margin-right:auto;font-size:12px;text-align:center;margin-bottom:30px;margin-top:-7px}";
	wp_add_inline_style( 'fasto-custom-css', $css );
}

/*
=================================================================================================================
fasto_dequeue_css() - dequeue theme style.css
=================================================================================================================
*/
function fasto_dequeue_css () {
	wp_dequeue_style( 'fasto-style' );
}

if ( fasto_mod( 'fasto_inline_css' ) == '1' ){
	add_action( 'wp_enqueue_scripts' , 'fasto_dequeue_css', 2 );	
	add_action( 'wp_enqueue_scripts' , 'fasto_critical_css',1 );
}