<?php
/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function news_base_widgets_init()
{

    register_sidebar(array(
        'name' => esc_html__('Main Sidebar', 'news-base'),
        'id' => 'sidebar-1',
        'description' => esc_html__('Add widgets here.', 'news-base'),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h2 class="widget-title widget-title-1">',
        'after_title' => '</h2>',
    ));

    register_sidebar(array(
        'name' => esc_html__('Off-Canvas Sidebar', 'news-base'),
        'id' => 'tab-sidebar-1',
        'description' => esc_html__('Add widgets here.', 'news-base'),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h2 class="widget-title">',
        'after_title' => '</h2>',
    ));

    register_sidebar(array(
        'name' => esc_html__('Home Page Sidebar One', 'news-base'),
        'id' => 'sidebar-home-1',
        'description' => esc_html__('Add widgets here.', 'news-base'),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h2 class="widget-title widget-title-2">',
        'after_title' => '</h2>',
    ));

    register_sidebar(array(
        'name' => esc_html__('Home Page Sidebar Two', 'news-base'),
        'id' => 'sidebar-home-2',
        'description' => esc_html__('Add widgets here.', 'news-base'),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h2 class="widget-title widget-title-1">',
        'after_title' => '</h2>',
    ));

    $news_base_footer_widgets_number = news_base_get_option('number_of_footer_widget');
    if ($news_base_footer_widgets_number > 0) {
        register_sidebar(array(
            'name' => esc_html__('Footer Column One', 'news-base'),
            'id' => 'footer-col-one',
            'description' => esc_html__('Displays items on footer section.', 'news-base'),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h2 class="widget-title widget-title-1">',
            'after_title' => '</h2>',
        ));
        if ($news_base_footer_widgets_number > 1) {
            register_sidebar(array(
                'name' => esc_html__('Footer Column Two', 'news-base'),
                'id' => 'footer-col-two',
                'description' => esc_html__('Displays items on footer section.', 'news-base'),
                'before_widget' => '<div id="%1$s" class="widget %2$s">',
                'after_widget' => '</div>',
                'before_title' => '<h2 class="widget-title widget-title-1">',
                'after_title' => '</h2>',
            ));
        }
        if ($news_base_footer_widgets_number > 2) {
            register_sidebar(array(
                'name' => esc_html__('Footer Column Three', 'news-base'),
                'id' => 'footer-col-three',
                'description' => esc_html__('Displays items on footer section.', 'news-base'),
                'before_widget' => '<div id="%1$s" class="widget %2$s">',
                'after_widget' => '</div>',
                'before_title' => '<h2 class="widget-title widget-title-1">',
                'after_title' => '</h2>',
            ));
        }
    }
}

add_action('widgets_init', 'news_base_widgets_init');
