<?php
if (!function_exists('news_base_banner_slider')) :
    /**
     * Banner Slider
     *
     * @since news-base 1.0.0
     *
     */
    function news_base_banner_slider()
    {
        if (1 != news_base_get_option('show_slider_section')) {
            return null;
        }
        $news_base_slider_category = esc_attr(news_base_get_option('select_category_for_slider'));
        $news_base_slider_double_post_category = esc_attr(news_base_get_option('select_category_for_slider_double_post'));
        $news_base_slider_number = 4;

        ?>

        <section class="main-banner section-block section-block-space">
            <div class="container">
                <div class="row row-collapse">
                    <?php
                    $news_base_banner_slider_args = array(
                        'post_type' => 'post',
                        'cat' => absint($news_base_slider_category),
                        'ignore_sticky_posts' => true,
                        'posts_per_page' => absint($news_base_slider_number),
                    ); ?>
                    <?php $rtl_class_c = 'false';
                    if(is_rtl()){ 
                        $rtl_class_c = 'true';
                    }?>
                    <div class="col-md-6 col-sm-12" data-mh="featured-height">
                        <div class="banner-slider slide-hover " data-slick='{"rtl": <?php echo($rtl_class_c); ?>}'>
                            <?php
                            $news_base_banner_slider_post_query = new WP_Query($news_base_banner_slider_args);
                            if ($news_base_banner_slider_post_query->have_posts()) :
                                while ($news_base_banner_slider_post_query->have_posts()) : $news_base_banner_slider_post_query->the_post();
                                    if (has_post_thumbnail()) {
                                        $thumb = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'news-base-1200-675');
                                        $url = $thumb['0'];
                                    } else {
                                        $url = '';
                                    }
                                    global $post;
                                    $author_id = $post->post_author;
                                    ?>
                                    <figure class="slick-item primary-bgcolor">
                                        <a href="<?php the_permalink(); ?>" class="data-bg data-bg-slide"
                                           data-background="<?php echo esc_url($url); ?>">
                                           <?php echo news_base_post_format($post->ID); ?>
                                        </a>
                                        <figcaption class="slider-figcaption">
                                            <?php news_base_category_only(); ?>
                                            <h2 class="slide-title">
                                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                            </h2>
                                            <div class="item-metadata-group">
                                                <?php news_base_posted_date_only(); ?>
                                                <?php news_base_posted_by_only(); ?>
                                                <?php news_base_posted_comment(); ?>
                                            </div>
                                        </figcaption>
                                    </figure>
                                <?php
                                endwhile;
                            endif;
                            wp_reset_postdata();
                            ?>
                        </div>
                    </div>


                    <?php
                    $news_base_slider_excerpt_number = absint(news_base_get_option('number_of_content_home_slider'));
                    $news_base_banner_slider_double_post_args = array(
                        'post_type' => 'post',
                        'cat' => absint($news_base_slider_double_post_category),
                        'ignore_sticky_posts' => true,
                        'posts_per_page' => 6,
                    ); ?>
                    <?php
                    $news_base_banner_slider_double_post_query = new WP_Query($news_base_banner_slider_double_post_args);
                    if ($news_base_banner_slider_double_post_query->have_posts()) :
                        while ($news_base_banner_slider_double_post_query->have_posts()) : $news_base_banner_slider_double_post_query->the_post();
                            if (has_post_thumbnail()) {
                                $thumb = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'news-base-1200-675');
                                $url = $thumb['0'];
                            } else {
                                $url = '';
                            }
                            global $post;
                            $author_id = $post->post_author;
                            ?>
                            <div class="col-md-3 col-sm-6" data-mh="featured-height">
                                <div class="slider-aside-item">
                                    <figure class="tm-article-item">
                                        <a href="<?php the_permalink(); ?>">
                                            <span class="data-bg data-bg-1" data-background="<?php echo esc_url($url); ?>">
                                                <?php echo news_base_post_format($post->ID); ?>
                                            </span>
                                        </a>
                                        <figcaption>
                                            <?php news_base_category_only(); ?>
                                            <div class="item-metadata item-metadata-1 posted-on">
                                                <?php
                                                $archive_year = get_the_time('Y');
                                                $archive_month = get_the_time('m');
                                                $archive_day = get_the_time('d');
                                                ?>
                                                <a href="<?php echo esc_url(get_day_link($archive_year, $archive_month, $archive_day)) ?>">
                                                    <?php echo esc_html(get_the_date()); ?>
                                                </a>
                                            </div>

                                            <h3 class="item-title item-title-medium">
                                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                            </h3>
                                            <!-- read time start -->
                                            <?php $show_read_time = news_base_get_option('enable_read_time');
                                            $show_read_words = news_base_get_option('number_of_words_per_min');
                                            if( 1 == ($show_read_time) ){
                                                $content = apply_filters( 'the_content', get_the_content() );
                                                $word_count = news_base_count_content_words( $content );
                                                //echo $word_count;
                                                $word_per_min = ($word_count / $show_read_words);
                                                $format_time = __('Read Time : ','news-base');
                                                $unit_time = __(' Minutes','news-base');
                                                echo "<div class='item-metadata read-time'><span class = 'read-time'>";
                                                echo $format_time;
                                                echo round($word_per_min).$unit_time;
                                                echo "</span></div>";
                                            } ?>
                                            <!-- read time ends -->
                                            <div class="item-details">
                                                <?php if ($news_base_slider_excerpt_number > 0 ) {
                                                    if (has_excerpt()) {
                                                        $news_base_slider_content = get_the_excerpt();
                                                    } else {
                                                        $news_base_slider_content = news_base_words_count($news_base_slider_excerpt_number, get_the_content());
                                                    }
                                                    echo esc_html($news_base_slider_content);
                                                }
                                                ?>
                                            </div>
                                        </figcaption>
                                    </figure>
                                </div>
                            </div>
                        <?php
                        endwhile;
                    endif;
                    wp_reset_postdata();
                    ?>
                </div>
            </div>
        </section>

        <?php
    }
endif;
add_action('news_base_action_front_page', 'news_base_banner_slider', 40);
