<?php
if (!function_exists('news_base_related_posts')) :
    /**
     * Related Posts
     *
     * @since 1.0.0
     */
    function news_base_related_posts()
    {
        if(is_singular()){
            $show_related_posts = news_base_get_option('show_related_posts');
            if($show_related_posts == 1){
                $related_posts_title = news_base_get_option('related_posts_title');
                $category_ids = array();
                $categories = get_the_category(get_the_ID());
                if (!empty($categories)) {
                    foreach ($categories as $category) {
                        $category_ids[] = $category->term_id;
                    }
                }
                if(!empty($category_ids)){
                    $args = array(
                        'posts_per_page' => 3,
                        'category__in' => $category_ids,
                        'post__not_in' => array(get_the_ID()),
                        'order' => 'ASC',
                        'orderby' => 'rand'
                    );
                    $related_posts = new WP_Query($args);
                    if($related_posts->have_posts()):?>
                        <section id="related-articles" class="page-section">
                            <?php if(!empty($related_posts_title)){
                                ?>
                                <header class="related-header">
                                    <h2 class="section-title section-title-2">
                                        <?php echo esc_html($related_posts_title); ?>
                                    </h2>
                                </header>
                                <?php
                            }?>
                            <div class="entry-content">
                                <div class="row row-sm">
                                    <?php while ($related_posts->have_posts()):$related_posts->the_post(); ?>
                                        <div class="col-sm-4">
                                            <figure class="tm-article-item">
                                                <?php if (has_post_thumbnail()) { ?>
                                                    <?php $thumb = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'news-base-1200-675');
                                                    $url = $thumb['0']; ?>
                                                    <a href="<?php the_permalink(); ?>">
                                                        <span class="data-bg data-bg-3" data-background="<?php echo esc_url($url) ?>">
                                                            <?php echo news_base_post_format(get_the_ID()); ?>
                                                        </span>
                                                    </a>
                                                <?php } ?>
                                                <figcaption class="figcaption-1">
                                                    <div class="item-metadata item-metadata-1 posted-on">
                                                        <?php
                                                        $archive_year  = get_the_time('Y');
                                                        $archive_month = get_the_time('m');
                                                        $archive_day   = get_the_time('d');
                                                        ?>
                                                        <a href="<?php echo esc_url(get_day_link( $archive_year, $archive_month, $archive_day)) ?>">
                                                            <?php echo esc_html(get_the_date()); ?>
                                                        </a>
                                                    </div>
                                                    <h3 class="item-title item-title-medium">
                                                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                                    </h3>
                                                </figcaption>
                                            </figure>
                                        </div>
                                    <?php endwhile;
                                    wp_reset_postdata(); ?>
                                </div>
                            </div>
                        </section>
                    <?php endif;
                }
            }
        }
    }
endif;
add_action('news_base_before_single_nav', 'news_base_related_posts', 10 );