<?php
if (!function_exists('news_base_footer_recomended')) :
    /**
     * Banner Slider
     *
     * @since news-base 1.0.0
     *
     */
    function news_base_footer_recomended()
    {
        if (1 != news_base_get_option('show_footer_recomended_section')) {
            return null;
        }
        $news_base_footer_recomended_category = absint(news_base_get_option('select_category_for_footer_recomended'));
        $news_base_footer_recomended_number = absint(news_base_get_option('number_of_home_footer_recomended'));
        $news_base_footer_recomended_section_title = esc_html(news_base_get_option('footer_recomended_section_title'));
        ?>
        <section class="section-panels section-block section-block-space">
            <div class="container">
                <div class="row">
                    <div class="col-sm-12">
                        <?php if (!empty($news_base_footer_recomended_section_title)) { ?>
                            <h2 class="section-title section-title-2">
                                <?php echo esc_html(news_base_get_option('footer_recomended_section_title'));?>
                            </h2>
                        <?php } ?>
                    </div>
                </div>
                <div class="row row-sm">
                    <?php
                    $news_base_footer_recomended_args = array(
                        'post_type' => 'post',
                        'cat' => absint($news_base_footer_recomended_category),
                        'ignore_sticky_posts' => true,
                        'posts_per_page' => absint($news_base_footer_recomended_number),
                    ); ?>
                    <?php
                    $news_base_footer_recomended_post_query = new WP_Query($news_base_footer_recomended_args);
                    if ($news_base_footer_recomended_post_query->have_posts()) :
                        while ($news_base_footer_recomended_post_query->have_posts()) : $news_base_footer_recomended_post_query->the_post();
                            if (has_post_thumbnail()) {
                                $thumb = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'news-base-1200-675');
                                $url = $thumb['0'];
                            } else {
                                $url = '';
                            }
                            global $post;
                            $author_id = $post->post_author;
                            ?>

                            <div class="col-md-3">
                                <figure class="tm-article-item">
                                    <a href="<?php the_permalink(); ?>">
                                        <span class="data-bg data-bg-2" data-background="<?php echo esc_url($url); ?>">
                                            <?php echo news_base_post_format($post->ID); ?>
                                        </span>
                                    </a>
                                    <figcaption class="figcaption-1">
                                        <div class="item-metadata item-metadata-1 posted-on">
                                            <?php
                                            $archive_year  = get_the_time('Y');
                                            $archive_month = get_the_time('m');
                                            $archive_day   = get_the_time('d');
                                            ?>
                                            <a href="<?php echo esc_url(get_day_link( $archive_year, $archive_month, $archive_day)) ?>">
                                                <?php echo esc_html(get_the_date()); ?>
                                            </a>
                                        </div>
                                        <h3 class="item-title item-title-medium">
                                            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                        </h3>
                                    </figcaption>
                                </figure>
                            </div>
                    <?php 
                        endwhile;
                    endif;
                    wp_reset_postdata();
                    ?>

                </div>
            </div>
        </section>

        <?php
    }
endif;
add_action('news_base_action_footer_recomended', 'news_base_footer_recomended', 10);
