<?php
/**
 * Theme Options Panel.
 *
 * @package news-base
 */

$default = news_base_get_default_theme_options();

// Add Theme Options Panel.
$wp_customize->add_panel('theme_option_panel',
    array(
        'title'      => esc_html__('Theme Options', 'news-base'),
        'priority'   => 200,
        'capability' => 'edit_theme_options',
    )
);


// Setting - header_text_color.

$wp_customize->add_setting('header_text_color',
    array(
        'default'           => $default['header_text_color'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color',
    )
);
$wp_customize->add_control ( new WP_Customize_Color_Control( $wp_customize, 'header_text_color',
    array(
        'label'    => __( 'Header Text Color', 'news-base' ),
        'section'  => 'header_image',
        'type'     => 'color',
        'priority' => 100,
    )
) );

// Add Homepage Options Panel.
$wp_customize->add_panel('theme_home_page_panel',
    array(
        'title'      => esc_html__('Frontpage Options', 'news-base'),
        'priority'   => 190,
        'capability' => 'edit_theme_options',
    )
);
// Trending News Section.
$wp_customize->add_section('trending_news_section_settings',
    array(
        'title'      => esc_html__('Trending News Section', 'news-base'),
        'priority'   => 50,
        'capability' => 'edit_theme_options',
        'panel'      => 'theme_home_page_panel',
    )
);

// Setting - show_trending_news_section.
$wp_customize->add_setting('show_trending_news_section',
    array(
        'default'           => $default['show_trending_news_section'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'news_base_sanitize_checkbox',
    )
);
$wp_customize->add_control('show_trending_news_section',
    array(
        'label'    => esc_html__('Enable Trending News', 'news-base'),
        'section'  => 'trending_news_section_settings',
        'type'     => 'checkbox',
        'priority' => 10,
    )
);

// Setting - trending_news_title.
$wp_customize->add_setting('trending_news_title',
    array(
        'default'           => $default['trending_news_title'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control('trending_news_title',
    array(
        'label'    => esc_html__('Section Title', 'news-base'),
        'section'  => 'trending_news_section_settings',
        'type'     => 'text',
        'priority' => 15,

    )
);

// Setting - drop down category for Trending Newssection.
$wp_customize->add_setting('select_category_for_trending_news',
    array(
        'default'           => $default['select_category_for_trending_news'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(new News_Base_Dropdown_Taxonomies_Control($wp_customize, 'select_category_for_trending_news',
    array(
        'label'       => esc_html__('Category for Trending News', 'news-base'),
        'description' => esc_html__('Select category to be shown on tab ', 'news-base'),
        'section'     => 'trending_news_section_settings',
        'type'        => 'dropdown-taxonomies',
        'taxonomy'    => 'category',
        'priority'    => 20,
    )));


// Fullwidth Slider Main Section.
$wp_customize->add_section('fullwidth_slider_section_settings',
    array(
        'title'      => esc_html__('Fullwidth Slider Section', 'news-base'),
        'priority'   => 60,
        'capability' => 'edit_theme_options',
        'panel'      => 'theme_home_page_panel',
    )
);

// Setting - show_fullwidth_slider_section.
$wp_customize->add_setting('show_fullwidth_slider_section',
    array(
        'default'           => $default['show_fullwidth_slider_section'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'news_base_sanitize_checkbox',
    )
);
$wp_customize->add_control('show_fullwidth_slider_section',
    array(
        'label'    => esc_html__('Enable Fullwidth Slider', 'news-base'),
        'section'  => 'fullwidth_slider_section_settings',
        'type'     => 'checkbox',
        'priority' => 100,
    )
);

// Setting - drop down category for fullwidth slider.
$wp_customize->add_setting('select_category_for_fullwidth_slider',
    array(
        'default'           => $default['select_category_for_fullwidth_slider'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(new News_Base_Dropdown_Taxonomies_Control($wp_customize, 'select_category_for_fullwidth_slider',
    array(
        'label'    => esc_html__('Category For Fullwidth slider', 'news-base'),
        'section'  => 'fullwidth_slider_section_settings',
        'type'     => 'dropdown-taxonomies',
        'taxonomy' => 'category',
        'priority' => 130,
    )));

/*content number of Fullwidth Slider*/
$wp_customize->add_setting('number_of_home_fullwidth_slider',
    array(
        'default'           => $default['number_of_home_fullwidth_slider'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'news_base_sanitize_positive_integer',
    )
);
$wp_customize->add_control('number_of_home_fullwidth_slider',
    array(
        'label'       => esc_html__('Number of Post Fullwidth slider', 'news-base'),
        'section'     => 'fullwidth_slider_section_settings',
        'type'        => 'number',
        'priority'    => 110,
        'input_attrs' => array('min' => 0, 'max' => 10, 'style' => 'width: 150px;'),

    )
);

// Slider Main Section.
$wp_customize->add_section('slider_section_settings',
    array(
        'title'      => esc_html__('Slider with Block Section', 'news-base'),
        'priority'   => 60,
        'capability' => 'edit_theme_options',
        'panel'      => 'theme_home_page_panel',
    )
);

// Setting - show_slider_section.
$wp_customize->add_setting('show_slider_section',
    array(
        'default'           => $default['show_slider_section'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'news_base_sanitize_checkbox',
    )
);
$wp_customize->add_control('show_slider_section',
    array(
        'label'    => esc_html__('Enable Slider', 'news-base'),
        'section'  => 'slider_section_settings',
        'type'     => 'checkbox',
        'priority' => 100,
    )
);

// Setting - drop down category for slider.
$wp_customize->add_setting('select_category_for_slider',
    array(
        'default'           => $default['select_category_for_slider'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(new News_Base_Dropdown_Taxonomies_Control($wp_customize, 'select_category_for_slider',
    array(
        'label'    => esc_html__('Category For Main slider', 'news-base'),
        'section'  => 'slider_section_settings',
        'type'     => 'dropdown-taxonomies',
        'taxonomy' => 'category',
        'priority' => 130,
    )));

// Setting - drop down category for slider.
$wp_customize->add_setting('select_category_for_slider_double_post',
    array(
        'default'           => $default['select_category_for_slider_double_post'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(new News_Base_Dropdown_Taxonomies_Control($wp_customize, 'select_category_for_slider_double_post',
    array(
        'label'       => esc_html__('Category For 2 Pined Post ', 'news-base'),
        'description' => esc_html__('Select category to be shown on side of slider i.e the 2 pined posts', 'news-base'),
        'section'     => 'slider_section_settings',
        'type'        => 'dropdown-taxonomies',
        'taxonomy'    => 'category',
        'priority'    => 140,
    )));


/*content excerpt in Slider*/
$wp_customize->add_setting('number_of_content_home_slider',
    array(
        'default'           => $default['number_of_content_home_slider'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'news_base_sanitize_positive_integer',
    )
);
$wp_customize->add_control('number_of_content_home_slider',
    array(
        'label'       => esc_html__('Select no words of Pin Post', 'news-base'),
        'section'     => 'slider_section_settings',
        'type'        => 'number',
        'priority'    => 140,
        'input_attrs' => array('min' => 0, 'max' => 200, 'style' => 'width: 150px;'),

    )
);

// Latest featured Section.
$wp_customize->add_section('top_section_settings',
    array(
        'title'      => esc_html__('Top Header Section', 'news-base'),
        'priority'   => 10,
        'capability' => 'edit_theme_options',
        'panel'      => 'theme_option_panel',
    )
);
// Setting - show_top_bar.
$wp_customize->add_setting('show_top_bar',
    array(
        'default'           => $default['show_top_bar'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'news_base_sanitize_checkbox',
    )
);
$wp_customize->add_control('show_top_bar',
    array(
        'label'       => esc_html__('Enable Top Bar', 'news-base'),
        'section'     => 'top_section_settings',
        'type'        => 'checkbox',
        'priority'    => 100,
    )
);

// Setting - show_navigation_collaps.
$wp_customize->add_setting('show_navigation_collaps',
    array(
        'default'           => $default['show_navigation_collaps'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'news_base_sanitize_checkbox',
    )
);
$wp_customize->add_control('show_navigation_collaps',
    array(
        'label'       => esc_html__('Enable navigation collapse', 'news-base'),
        'section'     => 'top_section_settings',
        'type'        => 'checkbox',
        'active_callback' => 'news_base_is_enable_top_bar',
        'priority'    => 100,
    )
);

// Setting - show_social_menu.
$wp_customize->add_setting('show_social_menu',
    array(
        'default'           => $default['show_social_menu'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'news_base_sanitize_checkbox',
    )
);
$wp_customize->add_control('show_social_menu',
    array(
        'label'       => esc_html__('Enable Social Menu', 'news-base'),
        'section'     => 'top_section_settings',
        'type'        => 'checkbox',
        'active_callback' => 'news_base_is_enable_top_bar',
        'priority'    => 100,
    )
);
// Setting - show_current_date.
$wp_customize->add_setting('show_current_date',
    array(
        'default'           => $default['show_current_date'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'news_base_sanitize_checkbox',
    )
);
$wp_customize->add_control('show_current_date',
    array(
        'label'       => esc_html__('Enable Current Date', 'news-base'),
        'section'     => 'top_section_settings',
        'type'        => 'checkbox',
        'active_callback' => 'news_base_is_enable_top_bar',
        'priority'    => 100,
    )
);
// Setting - show_search_option.
$wp_customize->add_setting('show_search_option',
    array(
        'default'           => $default['show_search_option'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'news_base_sanitize_checkbox',
    )
);
$wp_customize->add_control('show_search_option',
    array(
        'label'       => esc_html__('Enable Search Bar', 'news-base'),
        'section'     => 'top_section_settings',
        'type'        => 'checkbox',
        'active_callback' => 'news_base_is_enable_top_bar',
        'priority'    => 100,
    )
);

// Setting - show_single_latest_news_header.
$wp_customize->add_setting('show_single_latest_news_header',
    array(
        'default'           => $default['show_single_latest_news_header'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'news_base_sanitize_checkbox',
    )
);
$wp_customize->add_control('show_single_latest_news_header',
    array(
        'label'       => esc_html__('Enable Header Latest/Featured News', 'news-base'),
        'section'  => 'top_section_settings',
        'type'     => 'checkbox',
        'priority' => 120,
    )
);

// Setting - drop down category for Latest/Featured Newssection.
$wp_customize->add_setting('category_single_latest_news_header',
    array(
        'default'           => $default['category_single_latest_news_header'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(new News_Base_Dropdown_Taxonomies_Control($wp_customize, 'category_single_latest_news_header',
    array(
        'label'       => esc_html__('Category for Latest/Featured News', 'news-base'),
        'section'     => 'top_section_settings',
        'type'        => 'dropdown-taxonomies',
        'taxonomy'    => 'category',
        'active_callback' => 'show_single_latest_news_header',
        'priority'    => 120,
    )));

// Setting - show_advertisement_option.
$wp_customize->add_setting('show_advertisement_option',
    array(
        'default'           => $default['show_advertisement_option'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'news_base_sanitize_checkbox',
    )
);
$wp_customize->add_control('show_advertisement_option',
    array(
        'label'       => esc_html__('Enable Advertisement Uploader', 'news-base'),
        'section'     => 'top_section_settings',
        'type'        => 'checkbox',
        'priority'    => 120,
    )
);
// Setting top_section_advertisement.
$wp_customize->add_setting('top_section_advertisement',
    array(
        'default'           => $default['top_section_advertisement'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'news_base_sanitize_image',
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control($wp_customize, 'top_section_advertisement',
        array(
            'label'       => esc_html__('Top Section Advertisement', 'news-base'),
            'description' => sprintf(esc_html__('Recommended Size %1$s px X %2$s px', 'news-base'), 728, 90),
            'section'     => 'top_section_settings',
            'priority'    => 120,
            'active_callback' => 'show_advertisement_options',

        )
    )
);

/*top_section_advertisement_url*/
$wp_customize->add_setting('top_section_advertisement_url',
    array(
        'default'           => $default['top_section_advertisement_url'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'esc_url_raw',
    )
);
$wp_customize->add_control('top_section_advertisement_url',
    array(
        'label'    => esc_html__('URL Link', 'news-base'),
        'section'  => 'top_section_settings',
        'type'     => 'text',
        'priority' => 130,
        'active_callback' => 'show_advertisement_options',

    )
);
$wp_customize->add_setting('enable_language_switcher',
    array(
        'default'           => $default['enable_language_switcher'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'news_base_sanitize_checkbox',
    )
);
$wp_customize->add_control('enable_language_switcher',
    array(
        'label'       => esc_html__('Enable Language Switcher', 'news-base'),
        'section'     => 'top_section_settings',
        'type'        => 'checkbox',
        'priority'    => 140,
    )
);

/*shortcode_for _language_switcher*/
$wp_customize->add_setting('shortcode_for_language_switcher',
    array(
        'default'           => $default['shortcode_for_language_switcher'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'wp_filter_nohtml_kses',
    )
);
$wp_customize->add_control('shortcode_for_language_switcher',
    array(
        'label'    => esc_html__('Shortcode For Language Switcher', 'news-base'),
        'section'  => 'top_section_settings',
        'type'     => 'text',
        'priority' => 150,

    )
);

/*layout management section start */
$wp_customize->add_section('theme_option_section_settings',
    array(
        'title'      => esc_html__('Layout Management', 'news-base'),
        'priority'   => 100,
        'capability' => 'edit_theme_options',
        'panel'      => 'theme_option_panel',
    )
);

/* ========== Single Posts Section ========== */
$wp_customize->add_section(
    'single_posts_options',
    array(
        'title'      => __( 'Single Post Options', 'news-base' ),
        'panel'      => 'theme_option_panel',
        'priority'   => 100,
    )
);

/*Show Related Posts*/
$wp_customize->add_setting(
    'show_related_posts',
    array(
        'default'           => $default['show_related_posts'],
        'sanitize_callback' => 'news_base_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'show_related_posts',
    array(
        'label'    => __( 'Show related Posts', 'news-base' ),
        'section'  => 'single_posts_options',
        'type'     => 'checkbox',
    )
);
/**/

/* Related Post Title */
$wp_customize->add_setting(
    'related_posts_title',
    array(
        'default'           => $default['related_posts_title'],
        'sanitize_callback' => 'wp_filter_nohtml_kses',
    )
);
$wp_customize->add_control(
    'related_posts_title',
    array(
        'label'       => __( 'Related Posts title', 'news-base' ),
        'section'     => 'single_posts_options',
        'type'        => 'text',
    )
);
/**/
/* ========== Single Posts Section Close ========== */

/*Home Page Layout*/
$wp_customize->add_setting('home_page_content_status',
    array(
        'default'           => $default['home_page_content_status'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'news_base_sanitize_checkbox',
    )
);
$wp_customize->add_control('home_page_content_status',
    array(
        'label'    => esc_html__('Enable Static Page Content', 'news-base'),
        'section'  => 'static_front_page',
        'type'     => 'checkbox',
        'priority' => 150,
    )
);

/*Home Page Layout*/
$wp_customize->add_setting('homepage_layout_option',
    array(
        'default'           => $default['homepage_layout_option'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'news_base_sanitize_select',
    )
);
$wp_customize->add_control('homepage_layout_option',
    array(
        'label'       => esc_html__('Site Layout', 'news-base'),
        'section'     => 'theme_option_section_settings',
        'choices'     => array(
            'full-width' => esc_html__('Full Width', 'news-base'),
            'boxed'      => esc_html__('Boxed', 'news-base'),
        ),
        'type'     => 'select',
        'priority' => 160,
    )
);

/*Global Layout*/
$wp_customize->add_setting('global_layout',
    array(
        'default'           => $default['global_layout'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'news_base_sanitize_select',
    )
);
$wp_customize->add_control('global_layout',
    array(
        'label'          => esc_html__('Global Layout', 'news-base'),
        'section'        => 'theme_option_section_settings',
        'choices'        => array(
            'right-sidebar' => esc_html__('Content - Primary Sidebar', 'news-base'),
            'left-sidebar'  => esc_html__('Primary Sidebar - Content', 'news-base'),
            'no-sidebar'    => esc_html__('No Sidebar', 'news-base')
        ),
        'type'     => 'select',
        'priority' => 170,
    )
);

/*content excerpt in global*/
$wp_customize->add_setting('excerpt_length_global',
    array(
        'default'           => $default['excerpt_length_global'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'news_base_sanitize_positive_integer',
    )
);
$wp_customize->add_control('excerpt_length_global',
    array(
        'label'       => esc_html__('Set Global Archive Length', 'news-base'),
        'section'     => 'theme_option_section_settings',
        'type'        => 'number',
        'priority'    => 175,
        'input_attrs' => array('min' => 1, 'max' => 200, 'style' => 'width: 150px;'),

    )
);

$wp_customize->add_setting('enable_read_time',
    array(
        'default'           => $default['enable_read_time'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'news_base_sanitize_checkbox',
    )
);
$wp_customize->add_control('enable_read_time',
    array(
        'label'       => esc_html__('Enable Read Time', 'news-base'),
        'section'     => 'theme_option_section_settings',
        'type'        => 'checkbox',
        'priority'    => 175,

    )
);

/*content excerpt in global*/
$wp_customize->add_setting('number_of_words_per_min',
    array(
        'default'           => $default['number_of_words_per_min'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'news_base_sanitize_positive_integer',
    )
);
$wp_customize->add_control('number_of_words_per_min',
    array(
        'label'       => esc_html__('Number of Words Per Minute', 'news-base'),
        'section'     => 'theme_option_section_settings',
        'type'        => 'number',
        'priority'    => 175,
        'input_attrs' => array('min' => 1, 'max' => 200, 'style' => 'width: 150px;'),

    )
);

$wp_customize->add_setting('enable_category_archive_title',
    array(
        'default'           => $default['enable_category_archive_title'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'news_base_sanitize_checkbox',
    )
);
$wp_customize->add_control('enable_category_archive_title',
    array(
        'label'    => esc_html__('Enable Category Archive Title', 'news-base'),
        'section'  => 'theme_option_section_settings',
        'type'     => 'checkbox',
        'priority' => 176,
    )
);
/*Archive Layout text*/
$wp_customize->add_setting('archive_layout',
    array(
        'default'           => $default['archive_layout'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'news_base_sanitize_select',
    )
);
$wp_customize->add_control('archive_layout',
    array(
        'label'         => esc_html__('Archive Layout', 'news-base'),
        'section'       => 'theme_option_section_settings',
        'choices'       => array(
            'excerpt-only' => esc_html__('Excerpt Only', 'news-base'),
            'full-post'    => esc_html__('Full Post', 'news-base'),
        ),
        'type'     => 'select',
        'priority' => 180,
    )
);

/*Archive Layout image*/
$wp_customize->add_setting('archive_layout_image',
    array(
        'default'           => $default['archive_layout_image'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'news_base_sanitize_select',
    )
);
$wp_customize->add_control('archive_layout_image',
    array(
        'label'     => esc_html__('Archive Image Alocation', 'news-base'),
        'section'   => 'theme_option_section_settings',
        'choices'   => array(
            'full'     => esc_html__('Full', 'news-base'),
            'right'    => esc_html__('Right', 'news-base'),
            'left'     => esc_html__('Left', 'news-base'),
            'no-image' => esc_html__('No image', 'news-base')
        ),
        'type'     => 'select',
        'priority' => 185,
    )
);

// Pagination Section.
$wp_customize->add_section('pagination_section',
    array(
        'title'      => esc_html__('Pagination Options', 'news-base'),
        'priority'   => 110,
        'capability' => 'edit_theme_options',
        'panel'      => 'theme_option_panel',
    )
);

// Setting pagination_type.
$wp_customize->add_setting('pagination_type',
    array(
        'default'           => $default['pagination_type'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'news_base_sanitize_select',
    )
);
$wp_customize->add_control('pagination_type',
    array(
        'label'    => esc_html__('Pagination Type', 'news-base'),
        'section'  => 'pagination_section',
        'type'     => 'select',
        'choices'  => array(
            'default' => esc_html__('Default (Older / Newer Post)', 'news-base'),
            'numeric' => esc_html__('Numeric', 'news-base'),
        ),
        'priority' => 100,
    )
);


// Fullwidth video slider Section.
$wp_customize->add_section('fullwidth_video_section_settings',
    array(
        'title'      => esc_html__('Fullwidth Video Section', 'news-base'),
        'priority'   => 130,
        'capability' => 'edit_theme_options',
        'panel'      => 'theme_home_page_panel',
    )
);

// Setting - show_fullwidth_video_section.
$wp_customize->add_setting('show_fullwidth_video_section',
    array(
        'default'           => $default['show_fullwidth_video_section'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'news_base_sanitize_checkbox',
    )
);
$wp_customize->add_control('show_fullwidth_video_section',
    array(
        'label'    => esc_html__('Enable Fullwidth Video', 'news-base'),
        'section'  => 'fullwidth_video_section_settings',
        'type'     => 'checkbox',
        'priority' => 100,
    )
);


// Setting - drop down category for fullwidth slider.
$wp_customize->add_setting('select_category_for_fullwidth_video',
    array(
        'default'           => $default['select_category_for_fullwidth_video'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(new News_Base_Dropdown_Taxonomies_Control($wp_customize, 'select_category_for_fullwidth_video',
    array(
        'label'    => esc_html__('Category For Fullwidth Video slider', 'news-base'),
        'section'  => 'fullwidth_video_section_settings',
        'type'     => 'dropdown-taxonomies',
        'taxonomy' => 'category',
        'priority' => 130,
    )));

/*content number of Fullwidth Video*/
$wp_customize->add_setting('number_of_home_fullwidth_video',
    array(
        'default'           => $default['number_of_home_fullwidth_video'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'news_base_sanitize_positive_integer',
    )
);
$wp_customize->add_control('number_of_home_fullwidth_video',
    array(
        'label'       => esc_html__('Number of Post Fullwidth Video', 'news-base'),
        'section'     => 'fullwidth_video_section_settings',
        'type'        => 'number',
        'priority'    => 110,
        'input_attrs' => array('min' => 0, 'max' => 10, 'style' => 'width: 150px;'),

    )
);


/*content excerpt in Video Slider*/
$wp_customize->add_setting('number_of_content_video_slider',
    array(
        'default'           => $default['number_of_content_video_slider'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'news_base_sanitize_positive_integer',
    )
);
$wp_customize->add_control('number_of_content_video_slider',
    array(
        'label'       => esc_html__('Select no words of Video Slider', 'news-base'),
        'section'     => 'fullwidth_video_section_settings',
        'type'        => 'number',
        'priority'    => 110,
        'input_attrs' => array('min' => 0, 'max' => 200, 'style' => 'width: 150px;'),

    )
);
// Footer recomended Section.
$wp_customize->add_section('footer_recomended_section_settings',
    array(
        'title'      => esc_html__('Footer Recomended Section', 'news-base'),
        'priority'   => 130,
        'capability' => 'edit_theme_options',
        'panel'      => 'theme_home_page_panel',
    )
);

// Setting - show_footer_recomended_section.
$wp_customize->add_setting('show_footer_recomended_section',
    array(
        'default'           => $default['show_footer_recomended_section'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'news_base_sanitize_checkbox',
    )
);
$wp_customize->add_control('show_footer_recomended_section',
    array(
        'label'    => esc_html__('Enable Footer Recomended', 'news-base'),
        'section'  => 'footer_recomended_section_settings',
        'type'     => 'checkbox',
        'priority' => 100,
    )
);
// Setting footer_recomended_section_title.
$wp_customize->add_setting('footer_recomended_section_title',
    array(
        'default'           => $default['footer_recomended_section_title'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control('footer_recomended_section_title',
    array(
        'label'    => esc_html__('Footer Recomended Title', 'news-base'),
        'section'  => 'footer_recomended_section_settings',
        'type'     => 'text',
        'priority' => 120,
    )
);


// Setting - drop down category for fullwidth slider.
$wp_customize->add_setting('select_category_for_footer_recomended',
    array(
        'default'           => $default['select_category_for_footer_recomended'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(new News_Base_Dropdown_Taxonomies_Control($wp_customize, 'select_category_for_footer_recomended',
    array(
        'label'    => esc_html__('Category For Fullwidth slider', 'news-base'),
        'section'  => 'footer_recomended_section_settings',
        'type'     => 'dropdown-taxonomies',
        'taxonomy' => 'category',
        'priority' => 130,
    )));

/*content number of Footer Recomended*/
$wp_customize->add_setting('number_of_home_footer_recomended',
    array(
        'default'           => $default['number_of_home_footer_recomended'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'news_base_sanitize_positive_integer',
    )
);
$wp_customize->add_control('number_of_home_footer_recomended',
    array(
        'label'       => esc_html__('Number of Post Footer Recomended', 'news-base'),
        'section'     => 'footer_recomended_section_settings',
        'type'        => 'number',
        'priority'    => 110,
        'input_attrs' => array('min' => 0, 'max' => 10, 'style' => 'width: 150px;'),

    )
);

// Footer Section.
$wp_customize->add_section('footer_section',
    array(
        'title'      => esc_html__('Footer Options', 'news-base'),
        'priority'   => 130,
        'capability' => 'edit_theme_options',
        'panel'      => 'theme_option_panel',
    )
);

// Setting social_content_heading.
$wp_customize->add_setting('number_of_footer_widget',
    array(
        'default'           => $default['number_of_footer_widget'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'news_base_sanitize_select',
    )
);
$wp_customize->add_control('number_of_footer_widget',
    array(
        'label'    => esc_html__('Number Of Footer Widget', 'news-base'),
        'section'  => 'footer_section',
        'type'     => 'select',
        'priority' => 100,
        'choices'  => array(
            0         => esc_html__('Disable footer sidebar area', 'news-base'),
            1         => esc_html__('1', 'news-base'),
            2         => esc_html__('2', 'news-base'),
            3         => esc_html__('3', 'news-base'),
        ),
    )
);

// Setting copyright_text.
$wp_customize->add_setting('copyright_text',
    array(
        'default'           => $default['copyright_text'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control('copyright_text',
    array(
        'label'    => esc_html__('Footer Copyright Text', 'news-base'),
        'section'  => 'footer_section',
        'type'     => 'text',
        'priority' => 120,
    )
);

// Preloader Section.
$wp_customize->add_section('enable_preloader_option',
    array(
        'title'      => __('Preloader Options', 'news-base'),
        'priority'   => 120,
        'capability' => 'edit_theme_options',
        'panel'      => 'theme_option_panel',
    )
);

// Setting enable_preloader.
$wp_customize->add_setting('enable_preloader',
    array(
        'default'           => $default['enable_preloader'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'news_base_sanitize_checkbox',
    )
);
$wp_customize->add_control('enable_preloader',
    array(
        'label'    => __('Enable Preloader', 'news-base'),
        'section'  => 'enable_preloader_option',
        'type'     => 'checkbox',
        'priority' => 150,
    )
);

// Breadcrumb Section.
$wp_customize->add_section('breadcrumb_section',
    array(
        'title'      => esc_html__('Breadcrumb Options', 'news-base'),
        'priority'   => 120,
        'capability' => 'edit_theme_options',
        'panel'      => 'theme_option_panel',
    )
);

// Setting breadcrumb_type.
$wp_customize->add_setting('breadcrumb_type',
    array(
        'default'           => $default['breadcrumb_type'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'news_base_sanitize_select',
    )
);
$wp_customize->add_control('breadcrumb_type',
    array(
        'label'       => esc_html__('Breadcrumb Type', 'news-base'),
        'description' => sprintf(esc_html__('Advanced: Requires %1$sBreadcrumb NavXT%2$s plugin', 'news-base'), '<a href="https://wordpress.org/plugins/breadcrumb-navxt/" target="_blank">', '</a>'),
        'section'     => 'breadcrumb_section',
        'type'        => 'select',
        'choices'     => array(
            'disabled'   => esc_html__('Disabled', 'news-base'),
            'simple'     => esc_html__('Simple', 'news-base'),
            'advanced'   => esc_html__('Advanced', 'news-base'),
        ),
        'priority' => 100,
    )
);