<?php
/**
 * Default theme options.
 *
 * @package news-base
 */

if (!function_exists('news_base_get_default_theme_options')):

/**
 * Get default theme options
 *
 * @since 1.0.0
 *
 * @return array Default theme options.
 */
function news_base_get_default_theme_options() {

	$defaults = array();

	// Top Section.
	$defaults['header_text_color']       = '#fff';
	$defaults['show_top_bar']       = 1;
	$defaults['show_navigation_collaps']       = 1;
	$defaults['show_social_menu']       = 1;
	$defaults['show_current_date']       = 1;
	$defaults['show_search_option']       = 1;
	$defaults['show_advertisement_option']       = 1;
	$defaults['top_section_advertisement']     = '';
	$defaults['top_section_advertisement_url'] = '';
	$defaults['show_single_latest_news_header']       = 1;
	$defaults['category_single_latest_news_header']   = 1;
	$defaults['number_of_content_home_slider'] = 0;
	$defaults['enable_language_switcher'] = 1;
	$defaults['shortcode_for_language_switcher'] = "";

	$defaults['home_grid_layout'] = 'homepage-style-1';
	//Single Posts Section
	$defaults['show_related_posts'] = true;
	$defaults['related_posts_title'] = __( 'Related Articles' , 'news-base');


	/*trending news section*/
	$defaults['show_trending_news_section']        = 1;
	$defaults['select_category_for_trending_news'] = 1;
	$defaults['trending_news_title']               = esc_html__('Trending Now', 'news-base');


	// Fullwidth Slider Section.
	$defaults['show_fullwidth_slider_section']                    = 1;
	$defaults['number_of_home_fullwidth_slider']                  = 4;
	$defaults['select_category_for_fullwidth_slider']             = 1;


	// Slider Section.
	$defaults['show_slider_section']                    = 1;
	$defaults['number_of_home_slider']                  = 3;
	$defaults['select_category_for_slider']             = 1;
	$defaults['select_category_for_slider_double_post'] = 1;

	/*Latest Blog Default Value*/
	$defaults['show_featured_section']        = 0;
	$defaults['main_title_featured_section']  = '';
	$defaults['select_category_for_featured'] = 0;

	/*layout*/
	$defaults['home_page_content_status'] = 1;
	$defaults['homepage_layout_option']   = 'full-width';
	$defaults['global_layout']            = 'right-sidebar';
	$defaults['excerpt_length_global']    = 50;
    $defaults['enable_category_archive_title']    = 1;
    $defaults['archive_layout']           = 'excerpt-only';
	$defaults['archive_layout_image']     = 'full';
	$defaults['pagination_type']          = 'numeric';
	$defaults['copyright_text']           = esc_html__('Copyright All rights reserved', 'news-base');
	$defaults['enable_preloader']         = 1;
	$defaults['enable_read_time'] 		  = 1;
	$defaults['number_of_words_per_min']  = 150;

	$defaults['number_of_footer_widget'] = 3;
	$defaults['breadcrumb_type']         = 'simple';


	// footer recomended Section.
	$defaults['show_footer_recomended_section']                    = 1;
	$defaults['footer_recomended_section_title']           = esc_html__('The news you may have missed', 'news-base');
	$defaults['number_of_home_footer_recomended']                  = 6;
	$defaults['select_category_for_footer_recomended']             = 1;


	// fullwidth video Section.
	$defaults['show_fullwidth_video_section']                    = 1;
	$defaults['number_of_home_fullwidth_video']                  = 6;
	$defaults['select_category_for_fullwidth_video']             = 1;
	$defaults['number_of_content_video_slider']             = 25;


	// Pass through filter.
	$defaults = apply_filters('news_base_filter_default_theme_options', $defaults);

	return $defaults;

}

endif;
