<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package news-base
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php if (function_exists('wp_body_open')) {
    wp_body_open();
}
?>
<?php if ((news_base_get_option('enable_preloader')) == 1) { ?>
    <div class="preloader">
        <div class="preloader-wrapper">
            <div class="circle circle-1"></div>
            <div class="circle circle-1a"></div>
            <div class="circle circle-2"></div>
            <div class="circle circle-3"></div>
        </div>
    </div>
<?php } ?>
<?php if (news_base_get_option('homepage_layout_option') == 'full-width') {
    $news_base_homepage_layout = 'full-screen-layout';
} elseif (news_base_get_option('homepage_layout_option') == 'boxed') {
    $news_base_homepage_layout = 'boxed-layout';
}
?>

<div id="page"
     class="site <?php echo esc_attr($news_base_homepage_layout); ?>">
    <a class="skip-link screen-reader-text" href="#main"><?php esc_html_e('Skip to content', 'news-base'); ?></a>
    <header id="masthead" class="site-header" role="banner">
        <?php $show_top_bar = absint(news_base_get_option('show_top_bar')); ?>
        <?php if (1 == $show_top_bar) { ?>
            <div class="top-bar">
                <div class="container">
                    <?php $navigation_collaps_enable = absint(news_base_get_option('show_navigation_collaps')); ?>
                    <?php if (1 == $navigation_collaps_enable) { ?>
                        <div class="top-bar-items popular-post">
                            <a href="#trendingCollapse" class="trending-news">
                                <span class="burger-bars">
                                    <span></span>
                                    <span></span>
                                    <span></span>
                                </span>
                            </a>
                        </div>
                    <?php } ?>
                    <?php $show_social_menu = absint(news_base_get_option('show_social_menu')); ?>
                    <?php if (1 == $show_social_menu) { ?>
                        <div class="top-bar-items tm-social-share">
                            <div class="social-icons">
                                <?php
                                wp_nav_menu(
                                    array('theme_location' => 'social',
                                        'link_before' => '<span class="screen-reader-text">',
                                        'link_after' => '</span>',
                                        'menu_id' => 'social-menu',
                                        'fallback_cb' => false,
                                        'menu_class' => false
                                    )); ?>
                            </div>
                        </div>
                    <?php } ?>
                    <div class="top-bar-items pull-right hidden-xs">
                        <?php $show_current_date = absint(news_base_get_option('show_current_date')); ?>
                        <?php if (1 == $show_current_date) { ?>
                            <div class="right-items">
                                <div class="news-base-date">
                                    <?php $time = current_time('timestamp');
                                      echo date_i18n('l, M j, Y',$time); ?>
                                </div>
                            </div>
                        <?php } ?>
                        <?php $show_search_option = absint(news_base_get_option('show_search_option')); ?>
                        <?php if (1 == $show_search_option) { ?>
                            <div class="right-items">
                                <div class="icon-search">
                                    <?php get_search_form(); ?>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        <?php } ?>
        <div class="header-middle <?php if (has_header_image()) { echo 'data-bg'; } ?>" data-background="<?php echo esc_url(get_header_image()); ?>">
            <div class="container">
                <div class="row-flex">
                    <div class="topbar-left">
                        <div class="site-branding">
                           <?php echo csl_CustomSiteLogo_show_logo(); ?>
                            <span class="site-title">
                                <a href="<?php echo esc_url(home_url('/')); ?>" rel="home">
                                    <?php bloginfo('name'); ?>
                                </a>
                            </span>
                            <?php
                            $description = get_bloginfo('description', 'display');
                            if ($description || is_customize_preview()):?>
                                <p class="site-description"><span><?php echo $description; ?></span></p>
                            <?php endif; ?>
                        </div>
                    </div>

                    <?php
                    if (1 == news_base_get_option('show_single_latest_news_header')) {
                        $news_base_single_latest_category = absint(news_base_get_option('category_single_latest_news_header'));
                        ?>
                        <div class="topbar-right hidden-xs">
                            <div class="tm-exclusive">
                                <?php
                                $news_base_header_latest_news_post_args = array(
                                    'post_type' => 'post',
                                    'cat' => absint($news_base_single_latest_category),
                                    'ignore_sticky_posts' => true,
                                    'posts_per_page' => 3,
                                );
                                $news_base_header_latest_post_query = new WP_Query($news_base_header_latest_news_post_args);
                                if ($news_base_header_latest_post_query->have_posts()) :
                                    while ($news_base_header_latest_post_query->have_posts()) : $news_base_header_latest_post_query->the_post();
                                        global $post;
                                        $author_id = $post->post_author;
                                        ?>
                                        <div class="exclusive-items">
                                            <figure class="tm-article-item">
                                                <figcaption class="figcaption-2">
                                                    <div class="item-metadata item-metadata-1 posted-on">
                                                        <?php
                                                        $archive_year = get_the_time('Y');
                                                        $archive_month = get_the_time('m');
                                                        $archive_day = get_the_time('d');
                                                        ?>
                                                        <a href="<?php echo esc_url(get_day_link($archive_year, $archive_month, $archive_day)) ?>">
                                                            <?php echo esc_html(get_the_date()); ?>
                                                        </a>
                                                    </div>
                                                    <h3 class="item-title item-title-small">
                                                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                                    </h3>
                                                </figcaption>
                                            </figure>
                                        </div>
                                    <?php
                                    endwhile;
                                endif;
                                wp_reset_postdata();
                                ?>
                            </div>
                        </div>

                    <?php } ?>


                </div>
            </div>
        </div>

        <div class="navigation-bar">
            <div class="container">
                <nav class="main-navigation" role="navigation">

                    <span class="toggle-menu" aria-controls="primary-menu" aria-expanded="false">
                         <span class="screen-reader-text">
                            <?php esc_html_e('Primary Menu', 'news-base'); ?>
                        </span>
                        <i class="ham"></i>
                    </span>

                    <?php
                    if (has_nav_menu('primary')) {
                        wp_nav_menu(array(
                            'theme_location' => 'primary',
                            'menu_id' => 'primary-menu',
                            'container' => 'div',
                            'container_class' => 'menu',
                            'depth' => 3,
                            'walker' => new News_Base_Walker_Nav_Menu()
                        ));
                    } else {
                        wp_nav_menu(array(
                            'menu_id' => 'primary-menu',
                            'container' => 'div',
                            'container_class' => 'menu',
                            'depth' => 3,
                        ));
                    } ?>

                    <?php if (1 == news_base_get_option('enable_language_switcher')) { ?>
                        <div class="nav-language hidden-xs hidden-sm">
                                <?php echo do_shortcode(news_base_get_option('shortcode_for_language_switcher')); ?>
                        </div>
                    <?php } ?>
                </nav>
            </div>
        </div>
    </header>

    <?php
    $banner_adv = news_base_get_option('top_section_advertisement');
    $banner_adv_url = news_base_get_option('top_section_advertisement_url');
    if (!empty($banner_adv)) { ?>
    <section class="section-block section-block-a">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="tm-promt-image">
                        <a href="<?php echo esc_url($banner_adv_url); ?>" target="_blank">
                            <img src="<?php echo esc_url($banner_adv); ?>">
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php } ?>



    <?php
    if ( !is_front_page() && !is_home()) {
        do_action('news-base-page-inner-title'); ?>
        <div id="content" class="site-content">
            <div id="content-container">
                <div class="container">
    <?php } ?>
