<?php
/**
 * Template part for displaying single posts
 *
 * @package Latest
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<?php if ( ! is_active_sidebar( 'latest-sidebar' ) ) { ?>
	<div class="entry-meta no-sidebar">
		<?php
		$author_id = get_post_field( 'post_author', get_the_ID() );
			$author_name = get_the_author_meta( 'display_name', $author_id );
			$author_url = get_author_posts_url( $author_id );
			$author_avatar = get_avatar( $author_id, 80);
			echo '<div class="byline"><span class="author vcard"><a class="url fn n" href="' . esc_url( $author_url ) . '">' . $author_avatar . esc_html( $author_name ) . '</a></div>';

			if ( function_exists( 'epc_get_primary_term_posts' ) ) {
				$primary_category = get_post_meta( get_the_ID(), 'epc_primary_category', true );
				if ( $primary_category ) {
					$the_category = '<a href="' . esc_url( get_category_link( $primary_category ) ) . '" class="entry-cat">' . esc_html( get_cat_name( $primary_category ) ) . '</a><span class="entry-cat-sep"> / </span>';
				} else {
					$categories = get_the_category();
					if ( ! empty( $categories ) ) {
						$the_category = '<a href="' . esc_url( get_category_link( $categories[0]->term_id ) ) . '" class="entry-cat">' . esc_html( $categories[0]->name ) . '</a><span class="entry-cat-sep"> / </span>';
					} else {
						$the_category = '';
					}					
				}
				echo $the_category;
			}
		latest_posted_on(); ?>
	</div><!-- .entry-meta.no-sidebar -->
	<?php } ?>

	<div class="entry-content single-entry-content">



	<?php if ( get_post_format() == 'video' ) {
		$video_content = apply_filters( 'the_content', get_the_content() );
		$video = false;
		// Only get video from the content if a playlist isn't present.
		if ( false === strpos( $video_content, 'wp-playlist-script' ) ) {
			$video = get_media_embedded_in_content( $video_content, array( 'video', 'object', 'embed', 'iframe' ) );
		}
		if ( ! empty( $video ) ) {
			echo latest_strip_media_embedded_in_content( $video_content );
		} else {
			the_content();
		}
	} else {

		if ( has_post_thumbnail() ) { 
		$image_attributes = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
			if ( $image_attributes[1] <= $image_attributes[2] ) { ?>
				<p class="featured-image"><?php the_post_thumbnail( 'full' ); ?></p>
			<?php } 
		}
		
		the_content();
	} ?>

		<?php
			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'latest' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->

	<footer class="entry-footer">
		<?php latest_entry_footer(); ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-## -->

