<?php
/**
 * Custom template tags for this theme
 *
 * Eventually, some of the functionality here could be replaced by core features
 *
 * @package Latest
 */

if ( ! function_exists( 'latest_posted_on' ) ) :
/**
 * Prints HTML with meta information for the current post-date/time, author and comments
 */
function latest_posted_on() {

		$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
		if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
			$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
		}

		$time_string = sprintf( $time_string,
			esc_attr( get_the_date( 'c' ) ),
			esc_html( get_the_date() ),
			esc_attr( get_the_modified_date( 'c' ) ),
			esc_html( get_the_modified_date() )
		);

		if ( get_the_title() ) {
			$posted_on = '<span class="posted-on">' . $time_string . '</span>';
		} else {
			$posted_on = '<span class="posted-on"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">' . $time_string . '</a></span>';
		}

		if ( ! is_single() ) {
			$byline = '<span class="entry-meta-sep"> / </span><span class="byline"><span class="author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span></span>';
		} else {
			$byline = '';
		}

	$comment_count = get_comments_number(); // get_comments_number returns only a numeric value

	if ( comments_open() ) {
		if ( $comment_count == 0 ) {
			$comment_count = '';
		}
		$comment_link = '<span class="entry-meta-sep comment-sep"> / </span><span class="comment-count"><a href="' . get_comments_link() .'"><i class="fa fa-commenting"></i>'. $comment_count.'</a></span>';
	} else {
		$comment_link = '';
	}

	echo $posted_on . $byline . $comment_link ; // WPCS: XSS OK.

}
endif;

if ( ! function_exists( 'latest_entry_footer' ) ) :
/**
 * Prints HTML with meta information for the categories and tags.
 */
function latest_entry_footer( $exclude_cat_id = false ) {
	// Hide category and tag text for pages.
	if ( 'post' === get_post_type() ) {

		$categories_list = latest_get_the_category_list( $exclude_cat_id, ' / ' );
		if ( $categories_list && latest_categorized_blog() ) {
			echo '<span class="cat-links">' . $categories_list . '</span>';
		}

		$tags_list = get_the_tag_list( '', ' ' );
		if ( $tags_list ) {
			echo '<span class="tags-links">' . $tags_list . '</span>';
		}

		edit_post_link(
			sprintf(
				/* translators: %s: Name of current post for screen readers */
				'<i class="fa fa-pencil"></i>' . esc_html__( 'Edit %s', 'latest' ),
				the_title( '<span class="screen-reader-text">"', '"</span>', false )
			),
			'<span class="edit-link">',
			'</span>'
		);

	}
}
endif;

/**
 * Returns true if a blog has more than 1 category.
 *
 * @return bool
 */
function latest_categorized_blog() {
	if ( false === ( $all_the_cool_cats = get_transient( 'latest_categories' ) ) ) {
		// Create an array of all the categories that are attached to posts.
		$all_the_cool_cats = get_categories( array(
			'fields'     => 'ids',
			'hide_empty' => 1,

			// We only need to know if there is more than one category.
			'number'     => 2,
		) );

		// Count the number of categories that are attached to the posts.
		$all_the_cool_cats = count( $all_the_cool_cats );

		set_transient( 'latest_categories', $all_the_cool_cats );
	}

	if ( $all_the_cool_cats > 1 ) {
		// This blog has more than 1 category so latest_categorized_blog should return true.
		return true;
	} else {
		// This blog has only 1 category so latest_categorized_blog should return false.
		return false;
	}
}

/**
 * Flush out the transients used in latest_categorized_blog.
 */
function latest_category_transient_flusher() {
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}
	// Like, beat it. Dig?
	delete_transient( 'latest_categories' );
}
add_action( 'edit_category', 'latest_category_transient_flusher' );
add_action( 'save_post', 'latest_category_transient_flusher' );
