<?php
/**
 * Latest Theme Customizer
 *
 * @package Latest
 */

/**
 * @param WP_Customize_Manager $wp_customize Theme Customizer object
 */
function latest_customize_register( $wp_customize ) {
	$wp_customize->get_setting('blogname')->transport         = 'postMessage';
	$wp_customize->get_setting('blogdescription')->transport  = 'postMessage';
	$wp_customize->get_setting('header_textcolor')->transport = 'postMessage';

	$wp_customize->add_setting(
		'hi_color',
		array(
			'default'			=> '#ff5a79',
			'transport'			=> 'postMessage',
			'sanitize_callback' => 'sanitize_hex_color'
		)
	);
	$wp_customize->add_control( 
		new WP_Customize_Color_Control(
			$wp_customize,
			'hi_color',
			array( 
				'label'      => esc_html__( 'Primary Color', 'latest' ),
				'settings'   => 'hi_color',
				'section'    => 'colors',
			)
		)
	);

	$wp_customize->add_section(
		'theme_options',
		array(
			'title'		=> esc_html__( 'Theme Options', 'latest' ),
			'priority'	=> 6,
		)
	);

	$wp_customize->add_setting(
		'masonry_off',
		array(
			'default'			=> 0,
			'sanitize_callback'	=> 'absint'
		)
	);
	$wp_customize->add_control(
			'masonry_off',
			array(
				'settings'	=> 'masonry_off',
				'section'	=> 'theme_options',
				'label'		=> esc_html__( 'Disable Masonry Grid Layout', 'latest' ),
				'type'		=> 'checkbox',
			)
	);

	$wp_customize->add_setting(
		'masonry_columns',
		array(
			'default'			=> '3',
			'sanitize_callback'	=> 'latest_sanitize_choices',
		)
	);
	$wp_customize->add_control(
		'masonry_columns',
		array(
			'label'		=> esc_html__( 'Masonry Columns', 'latest' ),
			'type'		=> 'select',
			'section'	=> 'theme_options',
			'choices'	=> array(
				'2'	=> esc_html__( '2', 'latest' ),
				'3'	=> esc_html__( '3', 'latest' ),
				'4'	=> esc_html__( '4', 'latest' ),
				'5'	=> esc_html__( '5', 'latest' ),
				'6'	=> esc_html__( '6', 'latest' ),
			),
		)
	);

	$wp_customize->add_setting(
		'sidebar_position',
		array(
			'default'			=> 'right',
			'sanitize_callback'	=> 'latest_sanitize_choices',
		)
	);
	$wp_customize->add_control(
		'sidebar_position',
		array(
			'label'		=> esc_html__( 'Sidebar Position', 'latest' ),
			'type'		=> 'select',
			'section'	=> 'theme_options',
			'choices'	=> array(
				'left'	=> esc_html__( 'Left', 'latest' ),
				'right'	=> esc_html__( 'Right', 'latest' ),
			),
		)
	);

	// Section - Go Pro
/*
	$wp_customize->add_section( 'go_pro_sec' , array(
		'title'      => esc_html__( 'Go Pro', 'latest' ),
		'priority'   => 1,
		'description' => esc_html__( 'Upgrade to Latest Pro for even more cool features and customization options.', 'latest' ),
	) );
	$wp_customize->add_control(
		new Latest_Customize_Extra_Control(
			$wp_customize,
			'go_pro',
			array(
				'section'   => 'go_pro_sec',
				'type'      => 'pro-link',
				'label'		=> esc_html__( 'Go Pro', 'latest' ),
				'url'		=> 'https://uxlthemes.com/theme/latest-pro/',
				'priority'	=> 10
			)
		)
	);
*/

}
add_action('customize_register', 'latest_customize_register');


/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function latest_customize_preview_js() {
	wp_enqueue_script('latest_customizer', get_template_directory_uri() . '/js/customizer.js', array('customize-preview'), '1.1.2', true );
}
add_action('customize_preview_init', 'latest_customize_preview_js');


if( class_exists('WP_Customize_Control') ):

class Latest_Customize_Extra_Control extends WP_Customize_Control {
	public $settings = 'blogname';
	public $description = '';
	public $url = '';
	public $group = '';

	public function render_content() {
		switch ( $this->type ) {
			default:

			case 'pro-link':
				echo sprintf(
							'<a href="%1$s" class="button-primary" target="_blank">%2$s</a>',
							esc_url( $this->url ),
							esc_html__( 'Go Pro', 'latest' )
						);
				break;

		}
	}
}

endif;


/**
 * Sanitization functions
 */

function latest_sanitize_choices( $input, $setting ) {
    global $wp_customize;
 
    $control = $wp_customize->get_control( $setting->id );
 
    if ( array_key_exists( $input, $control->choices ) ) {
        return $input;
    } else {
        return $setting->default;
    }
}
