<?php
/**
 * Latest functions and definitions
 *
 * @package Latest
 */

if ( ! function_exists( 'latest_setup' ) ) :

//Sets up theme defaults and registers support for various WordPress features

function latest_setup() {
	// Make theme available for translation
	load_theme_textdomain( 'latest', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head
	add_theme_support( 'automatic-feed-links' );

	// Let WordPress manage the document title
	add_theme_support( 'title-tag' );

	//Enable support for Post Thumbnails on posts and pages.
	add_theme_support( 'post-thumbnails' );

	// This theme uses wp_nav_menu() in two locations
	register_nav_menus( array(
		'primary' => esc_html__( 'Primary Menu', 'latest' ),
		'footer' => esc_html__( 'Footer Menu', 'latest' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	// Enable support for post formats
	add_theme_support( 'post-formats', array(
		'aside', 'image', 'video', 'quote', 'link', 'gallery', 'status', 'audio', 'chat',
	) );

	// Set up the WordPress core custom background feature
	add_theme_support( 'custom-background', apply_filters( 'latest_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	) ) );

	// Enable support for Custom Logo
	add_theme_support( 'custom-logo', array(
		'width'		=> '520',
		'height'	=> '130',
		'flex-height' => true,
		'flex-width'  => true,
	) );

	// Enable support for widgets selective refresh
	add_theme_support( 'customize-selective-refresh-widgets' );

	// Style the visual editor to resemble the theme style
	add_editor_style( array( 'css/editor-style.css', latest_editor_fonts_url() ) );

	// Support for Gutenberg (5.0+ block editor)
	add_theme_support( 'align-wide' );

}
endif; // latest_setup
add_action( 'after_setup_theme', 'latest_setup' );

function latest_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'latest_content_width', 1160 );
}
add_action( 'after_setup_theme', 'latest_content_width', 0 );

// Set up the WordPress core custom header feature
function latest_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'latest_custom_header_args', array(
		'default-image'			=> '',
		'default-text-color'	=> '2d3139',
		'header_text'			=> true,
		'width'					=> 1920,
		'height'				=> 200,
		'flex-height'			=> false,
		'flex-width'			=> false,
		'wp-head-callback'		=> '',
	) ) );
}
add_action( 'after_setup_theme', 'latest_custom_header_setup' );

// Enables the Excerpt meta box in Page edit screen
function latest_add_excerpt_support_for_pages() {
	add_post_type_support( 'page', 'excerpt' );
}
add_action( 'init', 'latest_add_excerpt_support_for_pages' );

// Register widget area
function latest_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'latest' ),
		'id'            => 'latest-sidebar',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h4 class="widget-title">',
		'after_title'   => '</h4>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Top Bar', 'latest' ),
		'id'            => 'latest-top-bar',
		'description'   => esc_html__( 'Add your own content above the header.', 'latest' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<b>',
		'after_title'   => '</b>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer Column 1', 'latest' ),
		'id'            => 'latest-footer1',
		'description'   => '',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h5 class="widget-title">',
		'after_title'   => '</h5>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer Column 2', 'latest' ),
		'id'            => 'latest-footer2',
		'description'   => '',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h5 class="widget-title">',
		'after_title'   => '</h5>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer Column 3', 'latest' ),
		'id'            => 'latest-footer3',
		'description'   => '',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h5 class="widget-title">',
		'after_title'   => '</h5>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Middle Footer', 'latest' ),
		'id'            => 'latest-about-footer',
		'description'   => '',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h5 class="widget-title">',
		'after_title'   => '</h5>',
	) );

}
add_action( 'widgets_init', 'latest_widgets_init' );

if ( ! function_exists( 'latest_fonts_url' ) ) :
/**
 * Register Google fonts for Latest
 * @return string Google fonts URL for the theme
 */
function latest_fonts_url() {
	$fonts_url = '';
	$fonts     = array();
	$subsets   = 'latin,latin-ext';

	/*
	 * Translators: If there are characters in your language that are not supported
	 * translate this to 'off'. Do not translate into your own language.
	 */
	if ( 'off' !== _x( 'on', 'Google fonts: on or off', 'latest' ) ) {

		$fonts[] = 'Lato:300,400,700,900';
		$fonts[] = 'Varela Round:400';

	}

	/*
	 * Translators: To add an additional character subset specific to your language,
	 * translate this to 'greek', 'cyrillic', 'devanagari' or 'vietnamese'. Do not translate into your own language.
	 */
	$subset = _x( 'no-subset', 'Add new subset (greek, cyrillic, devanagari, vietnamese)', 'latest' );

	if ( 'cyrillic' == $subset ) {
		$subsets .= ',cyrillic,cyrillic-ext';
	} elseif ( 'greek' == $subset ) {
		$subsets .= ',greek,greek-ext';
	} elseif ( 'devanagari' == $subset ) {
		$subsets .= ',devanagari';
	} elseif ( 'vietnamese' == $subset ) {
		$subsets .= ',vietnamese';
	}

	if ( $fonts ) {
		$fonts_url = add_query_arg( array(
			'family' =>  urlencode( implode( '|', array_unique($fonts) ) ),
			'subset' =>  urlencode( $subsets ),
		), '//fonts.googleapis.com/css' );
	}

	return esc_url_raw($fonts_url);
}
endif;

if ( ! function_exists( 'latest_editor_fonts_url' ) ) :
/**
 * Register Google fonts for Latest
 * @return string Google fonts URL for the tinyMCE editor
 */
function latest_editor_fonts_url() {
	$fonts_url = '';
	$fonts     = array();
	$subsets   = 'latin,latin-ext';

	/*
	 * Translators: If there are characters in your language that are not supported
	 * translate this to 'off'. Do not translate into your own language.
	 */
	if ( 'off' !== _x( 'on', 'Google fonts: on or off', 'latest' ) ) {

		$fonts[] = 'Lato:300,400,700,900';
		$fonts[] = 'Varela Round:400';

	}

	/*
	 * Translators: To add an additional character subset specific to your language,
	 * translate this to 'greek', 'cyrillic', 'devanagari' or 'vietnamese'. Do not translate into your own language.
	 */
	$subset = _x( 'no-subset', 'Add new subset (greek, cyrillic, devanagari, vietnamese)', 'latest' );

	if ( 'cyrillic' == $subset ) {
		$subsets .= ',cyrillic,cyrillic-ext';
	} elseif ( 'greek' == $subset ) {
		$subsets .= ',greek,greek-ext';
	} elseif ( 'devanagari' == $subset ) {
		$subsets .= ',devanagari';
	} elseif ( 'vietnamese' == $subset ) {
		$subsets .= ',vietnamese';
	}

	if ( $fonts ) {
		$fonts_url = add_query_arg( array(
			'family' =>  urlencode( implode( '|', array_unique($fonts) ) ),
			'subset' =>  urlencode( $subsets ),
		), '//fonts.googleapis.com/css' );
	}

	return esc_url_raw($fonts_url);
}
endif;

/**
 * Enqueue scripts and styles.
 */
function latest_scripts() {
	wp_enqueue_script( 'masonry' );
	wp_enqueue_script( 'modernizr', get_template_directory_uri() . '/js/modernizr.js', array(), '2.6.3', true );
	wp_enqueue_script( 'latest-custom', get_template_directory_uri() . '/js/latest-custom.js', array( 'jquery' ), '1.0', true );
	wp_enqueue_style( 'latest-fonts', latest_fonts_url(), array(), null );
	wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/css/font-awesome.min.css' );
	wp_enqueue_style( 'latest-style', get_stylesheet_uri() );
	wp_add_inline_style( 'latest-style', latest_dynamic_style() );
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'latest_scripts' );

/**
 * Enqueue scripts and styles for Block Editor.
 */
function latest_enqueue_gutenberg_block_editor_assets() {
	wp_enqueue_style( 'latest-block-editor-fonts', latest_editor_fonts_url() );
	wp_enqueue_style( 'latest-block-editor-style', get_template_directory_uri() . '/css/block-editor-style.css' );
	wp_add_inline_style( 'latest-block-editor-style', latest_block_editor_dynamic_style() );
}
add_action( 'enqueue_block_editor_assets', 'latest_enqueue_gutenberg_block_editor_assets' );

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/functions/template-tags.php';

/**
 * Custom functions.
 */
require get_template_directory() . '/functions/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/functions/customizer.php';

/**
 * Theme help page.
 */
if ( is_admin() ) {
	require get_template_directory() . '/functions/theme-help.php';
}

/**
 * TGM Plugin activation.
 */
require_once get_template_directory() . '/functions/class-tgm-plugin-activation.php';
 
add_action( 'tgmpa_register', 'latest_reg_plugin' );
function latest_reg_plugin() {
 
    $plugins[] = array(
    		// Translators: If the plugin name in your language is the same, do not translate into your own language.
            'name'               => esc_html__( 'Easy Primary Category', 'latest' ),
            'slug'               => 'easy-primary-category',
            'required'           => false,
    );

    tgmpa( $plugins);
 
}