<?php
/**
 * The template for displaying archive pages
 *
 * @package Latest
 */

get_header();

if ( ! is_active_sidebar( 'latest-sidebar' ) ) {
	$page_full_width = ' full-width';
} else {
	$page_full_width = '';
}

$masonry_off = get_theme_mod( 'masonry_off' );
?>

	<div id="primary" class="content-area<?php echo $page_full_width;?>">
		<main id="main" class="site-main" role="main">

		<?php if ( have_posts() ) : ?>

			<?php if ( !$masonry_off ) : ?>
			<div id="masonry-loop">
			<?php endif; ?>

				<?php /* Start the Loop */ ?>
				<?php while ( have_posts() ) : the_post(); ?>

					<?php get_template_part( 'template-parts/content' ); ?>

				<?php endwhile; ?>

			<?php if ( !$masonry_off ) : ?>
			</div><!--/#masonry-loop-->
			<?php endif; ?>
		
			<?php the_posts_pagination( array(
						'prev_text' => '<i class="fa fa-arrow-left"></i>',
						'next_text' => '<i class="fa fa-arrow-right"></i>',
					) ); ?>

		<?php else : ?>

			<?php get_template_part( 'template-parts/content', 'none' ); ?>

		<?php endif; ?>

		</main><!-- #main -->
	</div><!-- #primary -->

<?php get_sidebar(); ?>

<?php get_footer(); ?>
