jQuery(document).ready(function($) {
	/*Functions*/

	//Sticky footer
	function fix_footer(){
		var header  = jQuery('header');
		var footer  = jQuery('footer');
		var content = jQuery('.site-content');
		content.css('min-height', '1px');
		var headerHeight  = header.outerHeight();
		var footerHeight  = footer.outerHeight();
		var contentHeight = content.outerHeight();
		var windowHeight  = jQuery( window ).height();
		var totalHeight   = headerHeight + footerHeight + contentHeight;
		if (totalHeight < windowHeight) {
		  content.css('min-height', windowHeight - headerHeight - footerHeight);
		} else {
		  content.css('min-height','1px');
		}
	}

	/*Initialize plugins*/
 
	//Lazyload 
    $('.sp_lazyload_main').lazyload();  
    
    $(window).scroll(function () { 
    	$('.sp_lazyload').lazyload();
    });

    $(window).mousemove(function(){
    	$('.sp_lazyload').lazyload();
   	});

    //WOW
	new WOW().init();

	/*Actions*/

	//Mobile menu show
	$('.close').click(function(){
		$('.mobile-menu').fadeOut(200);
		return false;
	});

	//Mobile menu show
	$('.mobile-menu-icon a').click(function(){
		$('.mobile-menu').fadeIn(100);
		return false;
	});
	
	//To top show by scroll
	$(window).scroll(function() {
		if($(this).scrollTop() != 0) { 
			$('.to-top').fadeIn();
		} else {
			$('.to-top').fadeOut();
		}
	});

	//Go to top
	$('.to-top').click(function() {
		$('body,html').animate({scrollTop:0},800);
	});

	//Add icons to widgets 
	$('.widget_recent_entries a').prepend( '<i class="fas fa-sticky-note widget-fas"></i> ');
	$('.widget_pages a').prepend( '<i class="fas fa-sticky-note widget-fas"></i> ');
	$('.widget_recent_comments span').prepend( '<i class="fas fa-comments widget-fas"></i> ');
	$('.widget_categories a').prepend( '<i class="fas fa-bookmark widget-fas"></i> ');
	$('.widget_archive a').prepend( '<i class="fas fa-calendar-alt widget-fas"></i> ');
	$('.search-submit').val('');

	//Sticky footer	
	jQuery(window).load(function(){fix_footer();});
	jQuery(window).resize(function(){fix_footer();});
	
});	