<?php
/*
 * Functions which enhance the theme by hooking into WordPress
 */

//only numbers
function coralina_only_numbers($number) { 
	return preg_replace('/[^0-9]/', '', $number);
}

//get title 
function coralina_get_title() {
	if(is_front_page() && !is_page()) echo esc_html(get_bloginfo('name'));
	if(is_home()) echo single_post_title();
	if(is_page() || is_single()) the_title();
	if(is_archive()) the_archive_title();
	if(is_search()) echo '<p class="h2 text-center">'.esc_html_e( 'Search Results for: ', 'coralina-lite' ).get_search_query().'</p>';
	if(is_404()) echo '<p class="h2 text-center">'.esc_html_e( 'Page not found ', 'coralina-lite' ).'</p>';
}

function coralina_get_breadcrumbs($spID=null) {
	$bg_img = coralina_get_thumbnail($spID, 'full');
	$post_type = get_post_type(get_the_ID());
	$class = '';

	if(is_page() || is_home()){
		$bg_img = get_template_directory_uri().'/imgs/sections_bg.jpg';
		$class = 'no-bg';
	}

	?>
	<div class="entry-header breadcrumbs text-center" style="background: url(<?php echo esc_url($bg_img);?>) no-repeat 0% 100% / cover;">
		<div class="breadcrumbs-wrapper <?php echo esc_attr($class)?>">
			<?php if(!is_front_page()):?>
				<p>
				<a href="<?php echo esc_url(get_home_url());?>"><?php echo esc_html_e('Home', 'coralina-lite'); ?></a> <i class="fas fa-angle-right"></i>
			<?php endif;

			$coralina_page_for_posts = get_option('page_for_posts');

			if((is_single() && $post_type == 'post' && !empty($coralina_page_for_posts)) || (is_archive() && !empty($coralina_page_for_posts))):?>
			
            <a href="<?php echo esc_url(get_permalink($coralina_page_for_posts));?>"><?php echo get_the_title($coralina_page_for_posts);?> <i class="fas fa-angle-right"></i></a>
        	<?php endif;

        	if(!is_front_page()):?>
        		</p>
        	<?php endif; ?>
			<h1 class="post-title"><?php coralina_get_title();?></h1>
		</div>	
	</div>
<?php

}

//getting thumbnail
function coralina_get_thumbnail($spID, $size){
	$id_img = get_post_thumbnail_id($spID);
	$image = wp_get_attachment_image_src($id_img, $size);

	if($image[0] == '') $result = get_template_directory_uri().'/imgs/none.png';
	else $result = esc_url($image[0]);
	
	return $result;
}	

//getting post/page thumbnail
function coralina_get_page_thumbnail($type){
	if($type):
		if(has_post_thumbnail()):

			$post_medium_img = coralina_get_thumbnail(get_the_ID(), 'medium'); 
            $post_full_img = coralina_get_thumbnail(get_the_ID(), 'full');

			if($type == 'post') $hide_post_img = get_theme_mod('hide_post_img');
			if($type == 'page') $hide_page_img = get_theme_mod('hide_page_img');

			if($type == 'post' && $hide_post_img != 1){
				?><figure class="entry-thumbnail pt-2 pm-2">
					<img src="<?php echo esc_url($post_medium_img);?>"  data-src="<?php echo esc_url($post_full_img);?>" class="img-fluid sp_lazyload" alt="<?php the_title_attribute();?>">
				</figure><?php
			}	

			if($type == 'page' && $hide_page_img != 1){
				?><figure class="entry-thumbnail pt-2 pm-2">
					<img src="<?php echo esc_url($post_medium_img);?>"  data-src="<?php echo esc_url($post_full_img);?>" class="img-fluid sp_lazyload" alt="<?php the_title_attribute();?>">
				</figure><?php
			}

	 	endif;
	endif; 	
}

//get entry meta
function coralina_get_entry_meta() { 
	$blog_tax = get_theme_mod('blog_tax');
	$blog_date = get_theme_mod('blog_date');

	if($blog_date != '1' || $blog_tax != '1') echo '<div class="entry-meta">';

	if($blog_date != '1'){
		$archive_year  = get_the_time('Y');
		$archive_month = get_the_time('m');
		$archive_day   = get_the_time('d');

		echo '<span class="posted-on">';
		echo '<a href="'.esc_url(get_day_link( $archive_year, $archive_month, $archive_day)).'" rel="bookmark"> ';
		the_time(get_option( 'date_format'));
		echo '</a></span>';	
	}

	if($blog_tax != '1'){

		echo '<span class="cat_cloud">';
		the_category(' ');
		echo '</span>';

		if(has_tag()){
			echo '<span class="tags_cloud">';
			the_tags('', ' ','');
			echo '</span>';
		}	
	}

	if($blog_date != '1' || $blog_tax != '1') echo '</div>';
}

//pagination 
function coralina_get_the_pagination(){
	echo '<div class="pagination col-md-12 m-3 text-center">';	
		$args = array(
			'show_all'     => false,
			'end_size'     => 1,
			'mid_size'     => 1,
			'prev_next'    => true,
			'prev_text'    => '<i class="fa fa-angle-left" aria-hidden="true"></i>',
			'next_text'    => '<i class="fa fa-angle-right" aria-hidden="true"></i>',
			'add_args'     => false,
			'add_fragment' => '',
			'screen_reader_text' => __('Posts navigation','coralina-lite'),
		);

		if(function_exists('the_posts_pagination')){
			the_posts_pagination($args);
		} else {
			wp_link_pages($args);
		}

	echo '</div>';	
}

//pagination template
function coralina_pagination_template($template, $class){
	return '<div class="pagination">%3$s</div>';
}
add_filter('navigation_markup_template', 'coralina_pagination_template', 10, 2);

//comment fields
function coralina_comment_form_fields( $fields ){
	$new_fields = array();
	$order = array('author','email','comment');
	foreach( $order as $key ){
		$new_fields[ $key ] = $fields[ $key ];
		unset( $fields[ $key ] );
	}
	return $new_fields;
}
add_filter('comment_form_fields', 'coralina_comment_form_fields');

//get post list category
function coralina_get_post_list_cat(){
	$cat_array = array('0' => 'all'); 

	$categories = get_categories( array(
		'type'         => 'post',
		'child_of'     => 0,
		'orderby'      => 'name',
		'order'        => 'ASC',
		'hide_empty'   => 1,
		'hierarchical' => 1,
		'taxonomy'     => 'category',
		'pad_counts'   => false,
	));

	if( $categories ){
		foreach( $categories as $cat ){
		  $cat_array[$cat->term_id] = $cat->name;
		}
	}

	return $cat_array;
}

//remove prefix category
function coralina_remove_prefix_category_title( $title ) {
    if ( is_category() ) {
        $title = single_cat_title( '', false );
    }
    return $title;
}
add_filter('get_the_archive_title', 'coralina_remove_prefix_category_title');

//setting menu
add_action('admin_menu', 'coralina_admin_menu_setup');
function coralina_admin_menu_setup() {
     add_theme_page(
        'About Coralina Lite',
        'About Coralina Lite',
        'manage_options',
        'coralina-lite',
        'coralina_admin_page_screen'
    );
}

function coralina_admin_page_screen(){?>
	<h1><?php esc_html_e('Coralina Lite', 'coralina-lite')?></h1>
	<p><?php esc_html_e('Coralina is a simple WordPress theme for the blogging and news site. Lightweight and elegant design will make your web project irresistible.', 'coralina-lite')?></p>
	<a href="<?php echo esc_url('https://web-cude.com/coralina-documentation/')?>" target="_blank"> <?php esc_html_e('Documentation', 'coralina-lite')?></a>
<?php }	