<?php
/*
 * The template for displaying archive pages
 */

get_header(); 
$coralina_page_for_posts = get_option('page_for_posts');

if(!empty($coralina_page_for_posts)){
	$coralina_page_ID = $coralina_page_for_posts;
} else {
	$coralina_page_ID = get_the_ID();
}

coralina_get_breadcrumbs($coralina_page_ID);
?>
<div class="site-content container pt-4">
	<div class="row">
		<div class="primary col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

			<div class="posts">
				<div class="container">
					<div class="row">
						<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
							<div class="category-description">
								<?php echo wp_kses_post(category_description());?>
							</div>
						</div>

						<?php if ( have_posts() ) :

							/* Start the Loop */
							while ( have_posts() ) : the_post(); ?>

								<div class="col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12 wow fadeIn">
									<div class="one-post">
										<figure class="entry-thumbnail">
											<a href="<?php echo esc_url(get_the_permalink());?>">
												<?php $post_medium_img = coralina_get_thumbnail(get_the_ID(), 'medium'); 
            									$post_full_img = coralina_get_thumbnail(get_the_ID(), 'full');?>

												<img src="<?php echo esc_url($post_medium_img);?>"  data-src="<?php echo esc_url($post_full_img);?>" class="img-fluid sp_lazyload" alt="<?php the_title_attribute();?>">
											</a>
										</figure>
										<div class="entry-title">
											<a href="<?php echo esc_url(get_the_permalink());?>" class="h3"><?php the_title();?></a>
										</div>	
										<div class="entry-summary">
										<?php
											if(has_excerpt()){ 
												echo wp_kses_post(get_the_excerpt());
											} else {
												echo wp_kses_post(wp_trim_words(get_the_content(), 30, ' ...' ));
											}	
										?>
										</div>
										<?php coralina_get_entry_meta();?>
									</div>	
								</div>	

							<?php endwhile;?>

							<?php coralina_get_the_pagination();?>

						<?php endif; ?>

					</div><!--.row-->	
				</div><!--.container -->
			</div><!--.posts -->
		</div><!--.primary -->
	</div><!--.row-->	
</div><!--.site-content-->
<?php 
get_footer();
