<?php get_header(); ?>
  
<div class="container-fluid">
   <div class="row">
      <div class="col-md-4 col-sm-4 hidden-xs pull-right">
         <?php get_sidebar(); ?>
      </div>

      <div class="col-md-8 col-sm-8">
         <div class="row">
            <div class="col-md-12 col-sm-12">
                  <?php
                     while ( have_posts() ) : the_post();?>
                     
                   <div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                     <h2><?php the_title(); ?></h2>

   	               <div class="media post-meta">
   	                  <p class="pull-left">
   	                     <?php echo get_avatar( get_the_author_meta('email'), '40' ); ?>
   	                  </p>
   	                  <?php the_author(); ?><br />
   	                  <small><?php the_category( ' ' ); ?> <span class="glyphicon glyphicon-option-vertical"></span> <?php echo the_time(get_option('date_format')); ?></small>
   	               </div>

                     <div class="entry">
                           <?php
                              the_content( sprintf(
                                 wp_kses(
                                    /* translators: %s: Name of current post. Only visible to screen readers */
                                    __( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'mdx-opensource' ),
                                    array(
                                       'span' => array(
                                          'class' => array(),
                                       ),
                                    )
                                 ),
                                 get_the_title()
                              ) );

                              wp_link_pages( array(
                                 'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'mdx-opensource' ),
                                 'after'  => '</div>',
                              ) );
                           ?>
                     </div>
                     <p><?php the_tags(); ?></p>
                  </div>
               <?php the_post_navigation(); ?>
               <?php endwhile; ?>
            </div>
         </div><!-- end of postbox -->

         <div class="row">
            <div class="col-md-12 comments-template">
                  <?php         
                   // If comments are open or we have at least one comment, load up the comment template.
                  if ( comments_open() || get_comments_number() ) :
                     comments_template();
                  endif ?>
            </div>
         </div>
      </div>
   </div>
</div>
<?php get_footer(); ?>