<?php
/**
 * mdx-opensource functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package mdx-opensource
 */


if ( ! function_exists( 'mdx_opensource_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function mdx_opensource_setup() {
	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 */
	load_theme_textdomain( 'mdx-opensource', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support( 'post-thumbnails' );
	set_post_thumbnail_size(520, 250, true);

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary-menu' => esc_html__( 'Primary Menu', 'mdx-opensource' ),
		'pages-menu' => __( 'Pages Menu', 'mdx-opensource' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	// Set up the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'mdx_opensource_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	) ) );

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

	// Add theme support for custom header
	add_theme_support( 'custom-header' );

	// Infinite Theme Support
	add_theme_support( 'infinite-scroll', array(
    	'container'    => 'content',
	) );
}
endif;
add_action( 'after_setup_theme', 'mdx_opensource_setup' );


//Some simple code for our widget-enabled sidebar
if ( ! isset( $content_width ) ) {
	$content_width = 900;
}

// Register Custom Navigation Walker
require_once get_template_directory() . '/assets/wp-bootstrap-navwalker.php';

/**
 * Enqueue scripts and styles.
 */
function mdx_opensource_resources() {
    wp_enqueue_style('mdx-opensource-style', get_stylesheet_uri());
    wp_enqueue_style('mdx-opensource-bootstrap', get_template_directory_uri() . '/assets/css/bootstrap.min.css');

    //Loading Google Web Font - Roboto Regular, Regular - Italic, Bold
    wp_enqueue_style( 'mdx-opensource-google-font', 'https://fonts.googleapis.com/css?family=Open+Sans:400,700,300|Cabin' );
    wp_enqueue_script( 'bootstrap-js', get_template_directory_uri() . '/assets/js/bootstrap.min.js', array('jquery'), '3.3.4', true);

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action('wp_enqueue_scripts', 'mdx_opensource_resources');

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function mdx_opensource_widgets_init() {
    register_sidebar( array(
        'name' => __( 'Main Sidebar', 'mdx-opensource' ),
        'id' => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here.', 'mdx-opensource' ),
        'before_widget' => '<li id="%1$s" class="widget %2$s">',
		'after_widget'  => '</li>',
		'before_title'  => '<h2 class="widgettitle">',
		'after_title'   => '</h2>',
    ) );
}
add_action( 'widgets_init', 'mdx_opensource_widgets_init' );

// Changing excerpt length
function mdx_opensource_excerpt_length($length) {
return 22;
}
add_filter('excerpt_length', 'mdx_opensource_excerpt_length');

?>