<?php
/**
 * The single template file
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 * @package Definite_Lite
 */
 
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
	
get_header(); ?>


<div class="row">
    <?php
	$definite_lite_single_layout = get_theme_mod( 'definite_lite_single_layout', 'single-right' );	
	
		switch ( esc_attr($definite_lite_single_layout ) ) {
			
		case "full":
			// single centered no sidebar
			echo '<main id="main" class="col-lg-12">';
				while ( have_posts() ) : the_post();
					get_template_part( 'template-parts/post/content', 'single' );			
						if( true == esc_attr(get_theme_mod( 'definite_lite_post_navigation' ) ) ) {
						definite_lite_post_navigation();
					}	
				endwhile;
			echo '</div>';		
			break;	

		case "left":
			// single left sidebar
			echo '<main id="main" class="col-lg-8 order-lg-2">';
				while ( have_posts() ) : the_post();
					get_template_part( 'template-parts/post/content', 'single' );			
						if( true == esc_attr(get_theme_mod( 'definite_lite_post_navigation' ) ) ) {
						definite_lite_post_navigation();
					}	
				endwhile;
			echo '</main>';		
				get_sidebar(); 
							
			break;	
			
		default:
			// default	right sidebar
			echo '<main id="main" class="col-lg-8">';
				while ( have_posts() ) : the_post();
					get_template_part( 'template-parts/post/content', 'single' );			
					if( true == esc_attr(get_theme_mod( 'definite_lite_post_navigation' ) ) ) {
					definite_lite_post_navigation();
					}	
					
				endwhile;
			echo '</main>';	
				get_sidebar(); 

		}	
		?>

</div>

<?php	
get_footer();
