<?php
/**
 * This template displays the search form.
 * @package Definite_Lite
 */
 
 if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>

<form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
    <label>
        <span class="screen-reader-text">
            <?php echo esc_html_x( 'Search for:', 'label', 'definite-lite' ); ?></span>
        <input type="search" class="search-field" placeholder="<?php echo esc_attr_x( 'Search &hellip;', 'placeholder', 'definite-lite' ); ?>" value="<?php echo get_search_query(); ?>" name="s" title="<?php echo esc_attr_x( 'Search for:', 'label', 'definite-lite' ); ?>" />
    </label>
    <button type="submit" class="search-submit">
        <?php echo definite_lite_get_icon_svg( 'search1' ); // WPCS: XSS Ok. ?>
        <span class="screen-reader-text">
            <?php echo esc_html_x( 'Search', 'submit button', 'definite-lite' ); ?></span>
    </button>
</form>
