<?php
/**
 * The template for displaying Search results.
 * @package Definite_Lite
 */

 if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

get_header(); ?>

<header class="page-header">
    <?php if ( have_posts() ) : ?>
    <h1 class="page-title">
        <?php printf( 
		/* translators: %s: keyword */
		esc_html__( 'Search Results for %s', 'definite-lite' ), '<span>' . get_search_query() . '</span>' ); ?>
    </h1>
    <?php else : ?>
    <h1 class="page-title">
        <?php esc_html_e( 'Nothing Found', 'definite-lite' ); ?>
    </h1>
    <?php endif; ?>
</header><!-- .page-header -->

<div id="search-layout">

    <?php
		if ( have_posts() ) : ?>

    <div id="post-wrapper" class="post-wrapper row">

        <?php while ( have_posts() ) : the_post(); ?>

        <div class="col-lg-6">
            <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

                <div class="post-content">
                    <header class="entry-header">
                        <?php the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
                        <?php if ( 'post' === get_post_type() ) : ?>
                        <ul class="post-details">
                            <?php
									echo definite_lite_posted_on();
									echo definite_lite_summary_first_category();
									?>
                        </ul><!-- .entry-meta -->
                        <?php endif; ?>
                    </header>

                    <div class="entry-content entry-excerpt clearfix">
                        <?php the_excerpt(); ?>
                    </div>
                </div>

            </article>
        </div>

        <?php endwhile; ?>

    </div>

    <?php
			definite_lite_blog_navigation();
		else :
			get_template_part( 'template-parts/post/content', 'none' );
		endif; ?>


</div>

<?php
get_footer();
