<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Definite_Lite
 */

get_header();
?>

<?php
	
		// Blog Content
		if ( have_posts() ) :
			
			$definite_lite_blog_layout = get_theme_mod( 'definite_lite_blog_layout', 'default' );	
				switch ( esc_attr($definite_lite_blog_layout ) ) {
				
				case "grid":
					// grid full width
					echo '<ul id="blog-layout" class="row">';
						while ( have_posts() ) : the_post();
							get_template_part( 'template-parts/post/content', get_post_format() );
						endwhile;
					echo '</ul>';
				break;	
	
				case "default-left":
					// default blog left
					echo '<main id="main" class="site-main row"><div id="blog-layout" class="col-lg-8 order-lg-2">';
						while ( have_posts() ) : the_post();
							get_template_part( 'template-parts/post/content', get_post_format() );
						endwhile;
					echo '</div>';	
						get_sidebar(); 
					echo '</main>';		
				break;
				
				default:
					// default blog
					echo '<main id="main" class="site-main row"><div id="blog-layout" class="col-lg-8">';
						while ( have_posts() ) : the_post();
							get_template_part( 'template-parts/post/content', get_post_format() );
						endwhile;
					echo '</div>';	
						get_sidebar(); 
					echo '</main>';
				}
		
				definite_lite_blog_navigation();
			
		else :
			get_template_part( 'template-parts/post/content', 'none' );
		endif; 
			
		?>

<?php
get_footer();
