<?php
/**
 * Add inline styles to the head area
 * @package Definite_Lite
*/
 
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

 // Dynamic styles
function definite_lite_inline_styles($definite_lite_customizer_css) {
	

// BEGIN CUSTOM CSS	
// site identity group
$definite_lite_sitetitle_colour = esc_attr(get_theme_mod( 'definite_lite_sitetitle_colour', '#000' ) );	
$definite_lite_tagline_colour = esc_attr(get_theme_mod( 'definite_lite_tagline_colour', '#9a9a9a' ) );
$definite_lite_customizer_css .="#site-title a,#site-title a:visited,#site-title a:hover { color: $definite_lite_sitetitle_colour;	}
#site-description { color: $definite_lite_tagline_colour;	}	";
	
// Colours
$definite_lite_accent_colour = esc_attr(get_theme_mod( 'definite_lite_accent_colour', '#cd4433' ) );
$definite_lite_second_colour = esc_attr(get_theme_mod( 'definite_lite_second_colour', '#3e8cc1' ) );
$definite_lite_third_colour = esc_attr(get_theme_mod( 'definite_lite_third_colour', '#2f3335' ) );
$definite_lite_fourth_colour = esc_attr(get_theme_mod( 'definite_lite_fourth_colour', '#fff' ) );

$definite_lite_content_bg = esc_attr(get_theme_mod( 'definite_lite_content_bg', '#fff' ) );

$definite_lite_body_text = esc_attr(get_theme_mod( 'definite_lite_body_text', '#484848' ) );
$definite_lite_headings = esc_attr(get_theme_mod( 'definite_lite_headings', '#262626' ) );
$definite_lite_intro_text = esc_attr(get_theme_mod( 'definite_lite_intro_text', '#9a9a9a' ) );
$definite_lite_link_colour = esc_attr(get_theme_mod( 'definite_lite_link_colour', '#cd4433' ) );
$definite_lite_link_hcolour = esc_attr(get_theme_mod( 'definite_lite_link_hcolour', '#484848' ) );

$definite_lite_menu_link_colour = esc_attr(get_theme_mod( 'definite_lite_menu_link_colour', '#262626' ) );
$definite_lite_menu_link_hover_colour = esc_attr(get_theme_mod( 'definite_lite_menu_link_hover_colour', '#cd4433' ) );
$definite_lite_submenu_bg = esc_attr(get_theme_mod( 'definite_lite_submenu_bg', '#fff' ) );
$definite_lite_submenu_link_colour = esc_attr(get_theme_mod( 'definite_lite_submenu_link_colour', '#262626' ) );

$definite_lite_bottom_text = esc_attr(get_theme_mod( 'definite_lite_bottom_text', '#ccc' ) );
$definite_lite_bottom_widget_titles = esc_attr(get_theme_mod( 'definite_lite_bottom_widget_titles', '#fff' ) );
$definite_lite_line_colour = esc_attr(get_theme_mod( 'definite_lite_line_colour', '#dedede' ) );
$definite_lite_top_social_icon = esc_attr(get_theme_mod( 'definite_lite_top_social_icon', '#fff' ) );

$definite_lite_footer_bg = esc_attr(get_theme_mod( 'definite_lite_footer_bg', '#202325' ) );
$definite_lite_footer_text_icons = esc_attr(get_theme_mod( 'definite_lite_footer_text_icons', '#fff' ) );
$definite_lite_widget_social_icon = esc_attr(get_theme_mod( 'definite_lite_widget_social_icon', '#fff' ) );
$definite_lite_toggle_icon = esc_attr(get_theme_mod( 'definite_lite_toggle_icon', '#fff' ) );
$definite_lite_select_text = esc_attr(get_theme_mod( 'definite_lite_select_text', '#3e8cc1' ) );
$definite_lite_customizer_css .=".login.wp-core-ui .button-primary { background-color: $definite_lite_accent_colour !important; border-color: $definite_lite_accent_colour !important;	}

::-moz-selection {background-color: $definite_lite_select_text;}
::selection { background-color:  $definite_lite_select_text;}

.pagination .page-numbers,
.pagination .page-numbers:visited,
.nav-links a:hover .nav-entry-title,
#footer-menu a:hover,
.entry-title a:hover,
.featured-label,
.hentry .post-details a:hover,
#blog-featured-title a:hover,
#blog-featured-post .readmore:hover,
.blog-gallery .hentry .post-header a:hover,
.related-posts-title a:hover,
#post-categories a:hover,
#post-tags a:hover	{color: $definite_lite_accent_colour; }

.pagination .page-numbers,
.pagination .page-numbers:visited,
.nav-links a:hover .nav-entry-title,
.pagination .current,
.pagination .page-numbers:hover,
.pagination .page-numbers:active {border-color: $definite_lite_accent_colour; }

.pagination .current,
.pagination .page-numbers:hover,
.pagination .page-numbers:active,
#top-bar-wrapper,
#cbottom-wrapper .mc4wp-form input[type=\"submit\"],
.rp-social-icons-list a,
.rp-social-icons-list a:visited,
#blog-featured-post .readmore:hover,
.gallery figcaption {background-color: $definite_lite_accent_colour; }

.main-navigation-menu .cart:focus .icon,
.main-navigation-menu .cart:hover .icon {fill: $definite_lite_accent_colour; }


.btn-primary,
.btn-primary:visited,
table thead,
a.button,
button,
input[type=\"button\"],
input[type=\"reset\"],
input[type=\"submit\"],
.button.style-1,
.main-navigation-toggle:focus,
.main-navigation-toggle:hover,
.main-navigation-toggle:active,
.main-navigation-toggle:focus:hover,
#top-search,
#blog-post-header,
.blog-gallery .post-content,
#cbottom-wrapper,
.widget_calendar #prev a,
.widget_calendar #next a,
.widget_tag_cloud a:hover,
.rp-social-icons-list a:hover {background-color: $definite_lite_third_colour; }

.btn-primary:focus,
.btn-primary:hover,
table th,
a.button:focus,
a.button:hover,
button:focus,
button:hover,
input[type=\"button\"]:focus,
input[type=\"button\"]:hover,
input[type=\"reset\"]:focus,
input[type=\"reset\"]:hover,
input[type=\"submit\"]:focus,
input[type=\"submit\"]:hover,
.main-navigation-toggle,
.featured-caption,
p.no-comments,
#blog-featured-post .readmore {background-color: $definite_lite_second_colour; }

@media (min-width: 768px) {
.menu ul { }
}

table thead,
a.button,
a.button:visited,
button,
input[type=\"button\"],
input[type=\"reset\"],
input[type=\"submit\"],
a.button:focus,
a.button:hover,
button:focus,
button:hover,
input[type=\"button\"]:focus,
input[type=\"button\"]:hover,
input[type=\"reset\"]:focus,
input[type=\"reset\"]:hover,
input[type=\"submit\"]:focus,
input[type=\"submit\"]:hover,
.button.style-1,
.main-navigation-toggle:hover,
.main-navigation-toggle:active,
.main-navigation-toggle:focus:hover,
.pagination .current,
.pagination .page-numbers:hover,
.pagination .page-numbers:active,
#site-footer,
.featured-caption,
#blog-featured-content,
#blog-featured-title a,
#blog-featured-post .readmore,
#blog-featured-post .readmore:hover,
.widget_calendar #prev a,
.widget_calendar #next a,
.widget_tag_cloud a:hover,
#cbottom-sidebar .widget_tag_cloud a,
#cbottom-sidebar .widget_tag_cloud a:visited,
.gallery figcaption {color: $definite_lite_fourth_colour; }

.main-navigation-toggle .icon,
.main-navigation-toggle:hover .icon,
.main-navigation-toggle:active .icon,
.social-menu li a .icon,
#footer-social-menu .social-menu li a .icon,
#top-bar-wrapper .icon,
.rp-social-icons-list li:hover .icon,
.rp-social-icons-list li .icon,
.widget_search .icon {fill: $definite_lite_fourth_colour; }

@media (min-width: 1024px) {
.menu ul .menu-item-has-children a .sub-menu-icon .icon  {fill: $definite_lite_fourth_colour; }
}

body,
a.readmore, 
a.readmore:visited,
.menu li.home.current-menu-item > a {color: $definite_lite_body_text;}

#site-footer {background-color: $definite_lite_footer_bg; color: $definite_lite_footer_text_icons;}

#footer-social-menu .social-menu li a .icon { fill: $definite_lite_footer_text_icons;	}

h1, h2, h3, h4, h5, h6, .entry-title a, .entry-title a:visited, .widget-title { color: $definite_lite_headings; }

a,
a:visited,
a.readmore:focus,
a.readmore:hover,
#blog-sidebar li a:focus,
#blog-sidebar li a:hover,
#left-sidebar li a:focus,
#left-sidebar li a:hover,
#right-sidebar li a:focus,
#right-sidebar li a:hover,
.entry-title a:hover { color: $definite_lite_accent_colour; }

@media (min-width: 768px) {	
	.main-navigation-menu li.home.current-menu-item a,
	.main-navigation-menu li a, 
	.main-navigation-menu li a:visited	{ color: $definite_lite_menu_link_colour; }

	.main-navigation-menu li.home.current-menu-item > a:focus,
	.main-navigation-menu li.home.current-menu-item > a:hover,	
	.main-navigation-menu li.current-menu-item a,	
	.main-navigation-menu ul a:active, 
	.main-navigation-menu .sub-menu li.current-menu-item > a,
	.main-navigation-menu .sub-menu li > a:hover,
	.main-navigation-menu li a:focus,
	.main-navigation-menu li a:hover { color: $definite_lite_menu_link_hover_colour; }

	.main-navigation-menu li.menu-item-has-children:hover > ul, .main-navigation-menu li.page_item_has_children:hover > ul, .main-navigation-menu li.menu-item-has-children > ul { background: $definite_lite_submenu_bg; }
	.main-navigation-menu ul a, 
	.main-navigation-menu ul a:visited { color: $definite_lite_submenu_link_colour; }
}

#page { background: $definite_lite_content_bg; }

#blog-description,
#category-description,
#page-excerpt { color: $definite_lite_intro_text;	}

#cbottom-wrapper,
#cbottom-sidebar a, #cbottom-sidebar a:visited,
#cbottom-wrapper .mailchimp-label  { color: $definite_lite_bottom_text;	}

#top-bar .social-menu li a .icon { fill: $definite_lite_top_social_icon;	}

.rp-social-icons-list li .icon,
.rp-social-icons-list li:hover .icon { fill: $definite_lite_widget_social_icon;	}
#cbottom-wrapper .widget-title, #footer-sidebar .widget-title { color: $definite_lite_bottom_widget_titles;	}

#site-header, #cboxError, .single .entry-content, #author-info, .post-navigation, #related-posts-wrapper, input[type=\"text\"], input[type=\"email\"], input[type=\"url\"], input[type=\"password\"], input[type=\"search\"], input[type=\"number\"], input[type=\"tel\"], input[type=\"range\"], input[type=\"date\"], input[type=\"month\"], input[type=\"week\"], input[type=\"time\"], input[type=\"datetime\"], input[type=\"datetime-local\"], input[type=\"color\"], select, textarea { border-color: $definite_lite_line_colour; }

.widget_pages li:after, .widget_meta li:after, .widget_archive li:after, .widget_categories li:after, .widget_recent_comments li:after, .widget_recent_entries li:after { background: $definite_lite_line_colour; }

.main-navigation-toggle .icon,
.main-navigation-toggle:hover .icon,
.main-navigation-toggle:active .icon { fill: $definite_lite_toggle_icon; } ";
		
// END CUSTOM CSS - Output all the styles
wp_add_inline_style( 'definite-lite-style', $definite_lite_customizer_css );
	
}
add_action( 'wp_enqueue_scripts', 'definite_lite_inline_styles' );
