<?php
/**
 * Post Settings
 *
 * Register Post Settings section, settings and controls for Theme Customizer
 *
 * @package Definite_Lite
 */

/**
 * Adds post settings in the Customizer
 *
 * @param object $wp_customize / Customizer Object.
 */
function definite_lite_customize_register_post_settings( $wp_customize ) {

	// Add Sections for Post Settings.
	$wp_customize->add_section( 'definite_lite_section_post', array(
		'title'    => esc_html__( 'Post Settings', 'definite-lite' ),
		'priority' => 40,
		'panel' => 'definite_lite_options_panel',
	) );

	// Add Settings and Controls for Layout.
	$wp_customize->add_setting( 'definite_lite_single_layout', array(
		'default'           => 'right',
		'sanitize_callback' => 'definite_lite_sanitize_select',
	) );

	$wp_customize->add_control( 'definite_lite_single_layout', array(
		'label'    => esc_html__( 'Full Post Layout', 'definite-lite' ),
		'description' => esc_html__( 'This will let you choose your full post layout.', 'definite-lite' ), 
		'section'  => 'definite_lite_section_post',
		'type'     => 'radio',
		'choices'  => array(
			'right' => esc_html__( 'Post With Right Sidebar', 'definite-lite' ),
			'left' => esc_html__( 'Post With Left Sidebar', 'definite-lite' ),
			'full' => esc_html__( 'Post Full Width No Sidebar', 'definite-lite' ),		
		),
	) );	


	// Add Setting and Control for showing summary image.
	$wp_customize->add_setting( 'definite_lite_show_single_image', array(
		'default'           => false,
		'transport'         => 'postMessage',
		'sanitize_callback' => 'definite_lite_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'definite_lite_show_single_image', array(
		'label'    => esc_html__( 'Hide Full Post Featured Image', 'definite-lite' ),
		'section'  => 'definite_lite_section_post',
		'type'     => 'checkbox',
	) );	
	
	// Add Setting and Control for showing summary image caption.
	$wp_customize->add_setting( 'definite_lite_show_single_image_caption', array(
		'default'           => false,
		'sanitize_callback' => 'definite_lite_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'definite_lite_show_single_image_caption', array(
		'label'    => esc_html__( 'Hide Full Post Featured Image Caption', 'definite-lite' ),
		'section'  => 'definite_lite_section_post',
		'type'     => 'checkbox',
	) );	
	
	// Add Setting and Control for showing post full meta info
	$wp_customize->add_setting( 'definite_lite_single_meta_info', array(
		'default'           => false,
		'transport'         => 'postMessage',
		'sanitize_callback' => 'definite_lite_sanitize_checkbox',
	) );
	
	$wp_customize->add_control( 'definite_lite_single_meta_info', array(
		'label'    => esc_html__( 'Hide Full Post Meta Info', 'definite-lite' ),
		'section'  => 'definite_lite_section_post',
		'type'     => 'checkbox',
	) );		

	// Add Setting and Control for showing summary author.
	$wp_customize->add_setting( 'definite_lite_show_single_author', array(
		'default'           => false,
		'transport'         => 'postMessage',
		'sanitize_callback' => 'definite_lite_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'definite_lite_show_single_author', array(
		'label'    => esc_html__( 'Hide Full Post By Author', 'definite-lite' ),
		'section'  => 'definite_lite_section_post',
		'type'     => 'checkbox',
	) );

	// Add Setting and Control for showing summary date.
	$wp_customize->add_setting( 'definite_lite_show_single_date', array(
		'default'           => false,
		'transport'         => 'postMessage',
		'sanitize_callback' => 'definite_lite_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'definite_lite_show_single_date', array(
		'label'    => esc_html__( 'Hide Full Post Date', 'definite-lite' ),
		'section'  => 'definite_lite_section_post',
		'type'     => 'checkbox',
	) );

	// Add Setting and Control for showing summary comments.
	$wp_customize->add_setting( 'definite_lite_show_single_comments', array(
		'default'           => false,
		'transport'         => 'postMessage',
		'sanitize_callback' => 'definite_lite_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'definite_lite_show_single_comments', array(
		'label'    => esc_html__( 'Hide Full Post Comment Count', 'definite-lite' ),
		'section'  => 'definite_lite_section_post',
		'type'     => 'checkbox',
	) );			

	// Add Setting and Control for showing post categories.
	$wp_customize->add_setting( 'definite_lite_footer_categories', array(
		'default'           => false,
		'transport'         => 'postMessage',
		'sanitize_callback' => 'definite_lite_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'definite_lite_footer_categories', array(
		'label'    => esc_html__( 'Hide Categories', 'definite-lite' ),
		'section'  => 'definite_lite_section_post',
		'type'     => 'checkbox',
	) );
	
	// Add Setting and Control for showing post tags.
	$wp_customize->add_setting( 'definite_lite_footer_tags', array(
		'default'           => false,
		'transport'         => 'postMessage',
		'sanitize_callback' => 'definite_lite_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'definite_lite_footer_tags', array(
		'label'    => esc_html__( 'Hide Tags', 'definite-lite' ),
		'section'  => 'definite_lite_section_post',
		'type'     => 'checkbox',
	) );		
	// Add Setting and Control for showing author avatar
	$wp_customize->add_setting( 'definite_lite_display_author_bio', array(
		'default'           => false,
		'transport'         => 'postMessage',
		'sanitize_callback' => 'definite_lite_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'definite_lite_display_author_bio', array(
		'label'    => esc_html__( 'Hide Author Bio', 'definite-lite' ),
		'section'  => 'definite_lite_section_post',
		'type'     => 'checkbox',
	) );	
	
	// Add Setting and Control for showing post navigation.
	$wp_customize->add_setting( 'definite_lite_post_navigation', array(
		'default'           => false,
		'transport'         => 'postMessage',
		'sanitize_callback' => 'definite_lite_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'definite_lite_post_navigation', array(
		'label'    => esc_html__( 'Hide previous/next post navigation', 'definite-lite' ),
		'section'  => 'definite_lite_section_post',
		'type'     => 'checkbox',
	) );

	// Add Setting and Control for showing post date.
	$wp_customize->add_setting( 'definite_lite_show_related_posts', array(
		'default'           => false,
		'transport'         => 'postMessage',
		'sanitize_callback' => 'definite_lite_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'definite_lite_show_related_posts', array(
		'label'    => esc_html__( 'Hide Related Posts', 'definite-lite' ),
		'section'  => 'definite_lite_section_post',
		'type'     => 'checkbox',
	) );
		


}
add_action( 'customize_register', 'definite_lite_customize_register_post_settings' );

