<?php
/**
 * Blog Settings
 *
 * Register Blog Settings section, settings and controls for Theme Customizer
 *
 * @package Definite_Lite
 */

/**
 * Adds blog settings in the Customizer
 *
 * @param object $wp_customize / Customizer Object.
 */
function definite_lite_customize_register_blog_settings( $wp_customize ) {

	// Add Sections for Post Settings.
	$wp_customize->add_section( 'definite_lite_section_blog', array(
		'title'    => esc_html__( 'Blog Settings', 'definite-lite' ),
		'priority' => 30,
		'panel' => 'definite_lite_options_panel',
	) );
		
	

	
	// Add Setting and Control for showing post full meta info
	$wp_customize->add_setting( 'definite_lite_show_blog_title_group', array(
		'default'           => false,
		'transport'         => 'postMessage',
		'sanitize_callback' => 'definite_lite_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'definite_lite_show_blog_title_group', array(
		'label'    => esc_html__( 'Display Blog Title Group', 'definite-lite' ),
		'description' => esc_html__( 'Show or hide your custom blog title and introduction from the blog home page.', 'definite-lite' ), 
		'section'  => 'definite_lite_section_blog',
		'type'     => 'checkbox',
	) );		
	
	// Add Blog Title setting and control.
	$wp_customize->add_setting( 'definite_lite_blog_title', array(
		'default'           => '',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'sanitize_text_field',
	) );

$wp_customize->add_control( 'definite_lite_blog_title', array(
		'label'    => esc_html__( 'Blog Title', 'definite-lite' ),
		'section'  => 'definite_lite_section_blog',
		'type'     => 'text',
	) );

	$wp_customize->selective_refresh->add_partial( 'definite_lite_blog_title', array(
		'selector'         => '#blog-title',
		'render_callback'  => 'definite_lite_customize_partial_blog_title',
		'fallback_refresh' => false,
	) );

	// Add Blog Description setting and control.
	$wp_customize->add_setting( 'definite_lite_blog_description', array(
		'default'           => '',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'wp_kses_post',
	) );

	$wp_customize->add_control( 'definite_lite_blog_description', array(
		'label'    => esc_html__( 'Blog Description', 'definite-lite' ),
		'section'  => 'definite_lite_section_blog',
		'type'     => 'textarea',
	) );

	$wp_customize->selective_refresh->add_partial( 'definite_lite_blog_description', array(
		'selector'         => '#blog-intro',
		'render_callback'  => 'definite_lite_customize_partial_blog_description',
		'fallback_refresh' => false,
	) );

// Add Settings and Controls for blog layout.
	$wp_customize->add_setting( 'definite_lite_blog_layout', array(
		'default'           => 'classic',
		'sanitize_callback' => 'definite_lite_sanitize_select',
	) );

	$wp_customize->add_control( 'definite_lite_blog_layout', array(
		'label'    => esc_html__( 'Blog Layout', 'definite-lite' ),
		'section'  => 'definite_lite_section_blog',
		'settings' => 'definite_lite_blog_layout',
		'type'     => 'select',
		'choices'  => array(
			'classic' => esc_html__( 'Default With Sidebar', 'definite-lite' ),
			'grid'  => esc_html__( 'Grid Full Width No Sidebar', 'definite-lite' ),					
		),
	) );
	
	// Add Settings and Controls for blog content.
	$wp_customize->add_setting( 'definite_lite_blog_content', array(	
		'default'           => 'excerpt',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'definite_lite_sanitize_select',				
	) );

	$wp_customize->add_control( 'definite_lite_blog_content', array(
		'label'    => esc_html__( 'Blog Summary Type', 'definite-lite' ),
		'description' => esc_html__( 'This will let you choose to use excerpts for your blog summaries. This is ONLY for the Default and Large blog layouts.', 'definite-lite' ),
		'section'  => 'definite_lite_section_blog',
		'settings' => 'definite_lite_blog_content',
		'type'     => 'radio',
		'choices'  => array(
			'index'   => esc_html__( 'Post Summary', 'definite-lite' ),
			'excerpt' => esc_html__( 'Post Excerpt', 'definite-lite' ),
		),	
	) );		

	// Add Setting and Control for Excerpt Length.
	$wp_customize->add_setting( 'definite_lite_excerpt_length', array(
		'default'           => 35,
		'sanitize_callback' => 'absint',
	) );

	$wp_customize->add_control( 'definite_lite_excerpt_length', array(
		'label'    => esc_html__( 'Excerpt Length', 'definite-lite' ),
		'section'  => 'definite_lite_section_blog',
		'type'     => 'number',
        'input_attrs' => array(
            'min'   => 10,
            'max'   => 200,
            'step'  => 1,
        ),		
	) );

	// Add Partial for Blog Layout and Excerpt Length.
	$wp_customize->selective_refresh->add_partial( 'definite_lite_blog_content_partial', array(
		'selector'         => '#blog-layout',
		'settings'         => array(
			'definite_lite_blog_layout',
			'definite_lite_blog_content',
			'definite_lite_excerpt_length',
		),
		'render_callback'  => 'definite_lite_customize_partial_blog_content',
		'fallback_refresh' => false,
	) );

		
	
	// Add Setting and Control for showing archive labels
	$wp_customize->add_setting( 'definite_lite_show_archive_labels', array(
		'default'           => false,
		'transport'         => 'postMessage',
		'sanitize_callback' => 'definite_lite_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'definite_lite_show_archive_labels', array(
		'label'    => esc_html__( 'Hide Archive Labels', 'definite-lite' ),
		'section'  => 'definite_lite_section_blog',
		'type'     => 'checkbox',
	) );
	
	// Add Setting and Control for showing featured label.
	$wp_customize->add_setting( 'definite_lite_show_featured_label', array(
		'default'           => false,
		'transport'         => 'postMessage',
		'sanitize_callback' => 'definite_lite_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'definite_lite_show_featured_label', array(
		'label'    => esc_html__( 'Hide Featured Label', 'definite-lite' ),
		'section'  => 'definite_lite_section_blog',
		'type'     => 'checkbox',
	) );	
	

	// Add Setting and Control for showing summary meta.
	$wp_customize->add_setting( 'definite_lite_show_summary_meta', array(
		'default'           => false,
		'transport'         => 'postMessage',
		'sanitize_callback' => 'definite_lite_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'definite_lite_show_summary_meta', array(
		'label'    => esc_html__( 'Hide Post Summary Meta Info', 'definite-lite' ),
		'section'  => 'definite_lite_section_blog',
		'type'     => 'checkbox',
	) );	

	// Add Setting and Control for showing summary image.
	$wp_customize->add_setting( 'definite_lite_show_summary_image', array(
		'default'           => false,
		'transport'         => 'postMessage',
		'sanitize_callback' => 'definite_lite_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'definite_lite_show_summary_image', array(
		'label'    => esc_html__( 'Hide Post Summary Featured Image', 'definite-lite' ),
		'section'  => 'definite_lite_section_blog',
		'type'     => 'checkbox',
	) );	

	// Add Setting and Control for showing summary image caption.
	$wp_customize->add_setting( 'definite_lite_show_summary_image_caption', array(
		'default'           => false,
		//'transport'         => 'postMessage',
		'sanitize_callback' => 'definite_lite_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'definite_lite_show_summary_image_caption', array(
		'label'    => esc_html__( 'Hide Post Summary Featured Image Caption', 'definite-lite' ),
		'section'  => 'definite_lite_section_blog',
		'type'     => 'checkbox',
	) );	
	
	// Add Setting and Control for showing summary author.
	$wp_customize->add_setting( 'definite_lite_show_summary_format', array(
		'default'           => false,
		'transport'         => 'postMessage',
		'sanitize_callback' => 'definite_lite_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'definite_lite_show_summary_format', array(
		'label'    => esc_html__( 'Hide Post Format', 'definite-lite' ),
		'section'  => 'definite_lite_section_blog',
		'type'     => 'checkbox',
	) );
	
	// Add Setting and Control for showing summary author.
	$wp_customize->add_setting( 'definite_lite_show_summary_author', array(
		'default'           => false,
		'transport'         => 'postMessage',
		'sanitize_callback' => 'definite_lite_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'definite_lite_show_summary_author', array(
		'label'    => esc_html__( 'Hide Post Summary By Author', 'definite-lite' ),
		'section'  => 'definite_lite_section_blog',
		'type'     => 'checkbox',
	) );

	// Add Setting and Control for showing summary date.
	$wp_customize->add_setting( 'definite_lite_show_summary_date', array(
		'default'           => false,
		'transport'         => 'postMessage',
		'sanitize_callback' => 'definite_lite_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'definite_lite_show_summary_date', array(
		'label'    => esc_html__( 'Hide Post Summary Date', 'definite-lite' ),
		'section'  => 'definite_lite_section_blog',
		'type'     => 'checkbox',
	) );

	// Add Setting and Control for showing summary category.
	$wp_customize->add_setting( 'definite_lite_show_summary_category', array(
		'default'           => false,
		'transport'         => 'postMessage',
		'sanitize_callback' => 'definite_lite_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'definite_lite_show_summary_category', array(
		'label'    => esc_html__( 'Hide Post Summary Category', 'definite-lite' ),
		'section'  => 'definite_lite_section_blog',
		'type'     => 'checkbox',
	) );
	
	// Add Setting and Control for showing summary comments.
	$wp_customize->add_setting( 'definite_lite_show_summary_comments', array(
		'default'           => false,
		'transport'         => 'postMessage',
		'sanitize_callback' => 'definite_lite_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'definite_lite_show_summary_comments', array(
		'label'    => esc_html__( 'Hide Post Summary Comment Count', 'definite-lite' ),
		'section'  => 'definite_lite_section_blog',
		'type'     => 'checkbox',
	) );	
}
add_action( 'customize_register', 'definite_lite_customize_register_blog_settings' );

/**
 * Render the blog title for the selective refresh partial.
 */
function definite_lite_customize_partial_blog_title() {
	echo wp_kses_post( get_theme_mod('definite_lite_blog_title' )  );
}

/**
 * Render the blog description for the selective refresh partial.
 */
function definite_lite_customize_partial_blog_description() {
	echo wp_kses_post( get_theme_mod( 'definite_lite_blog_description' ) );
}

/**
 * Render the blog content for the selective refresh partial.
 */
function definite_lite_customize_partial_blog_content() {
	while ( have_posts() ) {
		the_post();
		get_template_part( 'template-parts/post/content', get_post_format() );
	}
}
