<?php
/**
 * Basic Settings
 *
 * Register Basic Settings section, settings and controls for Theme Customizer
 *
 * @package Definite_Lite
 */

/**
 * Adds post settings in the Customizer
 *
 * @param object $wp_customize / Customizer Object.
 */
function definite_lite_customize_register_basic_settings( $wp_customize ) {

	// Add Sections for Post Settings.
	$wp_customize->add_section( 'definite_lite_section_basic', array(
		'title'    => esc_html__( 'Basic Settings', 'definite-lite' ),
		'priority' => 8,
		'panel' => 'definite_lite_options_panel',
	) );	
		 
	// Add a copyright setting and control.
	$wp_customize->add_setting( 'definite_lite_copyright', array(
		'transport'         => 'postMessage',
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'definite_lite_copyright', array(
		'label'    => esc_html__( 'Copyright Name', 'definite-lite' ),
		'section'  => 'definite_lite_section_basic',
		'type'     => 'text',
	) );		
	
	// Enable or disable Block Stylesheet
	$wp_customize->add_setting( 'definite_lite_enable_lightbox', array(
		'default'           => true,
		'sanitize_callback' => 'definite_lite_sanitize_checkbox',
	) );

$wp_customize->add_control( 'definite_lite_enable_lightbox', array(
		'label'    => esc_html__( 'Enable the Gallery Lightbox', 'definite-lite' ),
        'description' => esc_html__( 'If you use the WP Gallery, you can enable or disable the built-in Colorbox Lightbox viewer. To disable, uncheck this box.', 'definite-lite' ),
		'section'  => 'definite_lite_section_basic',
		'type'     => 'checkbox',
	) );
	
	// Enable Default Google Fonts
	$wp_customize->add_setting( 'definite_lite_default_google_fonts', array(
		'default'           => true,
		'sanitize_callback' => 'definite_lite_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'definite_lite_default_google_fonts', array(
		'label'    => esc_html__( 'Enable the Default Google Fonts', 'definite-lite' ),
        'description' => esc_html__( 'This theme has a couple Google Fonts included. If you choose to use a plugin for different fonts, you can disable them.', 'definite-lite' ),
		'section'  => 'definite_lite_section_basic',
		'type'     => 'checkbox',
	) );
 
	// Enable or disable Block Stylesheet
	$wp_customize->add_setting( 'definite_lite_block_css', array(
		'default'           => false,
		'sanitize_callback' => 'definite_lite_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'definite_lite_block_css', array(
		'label'    => esc_html__( 'Disable the Block Stylesheet', 'definite-lite' ),
        'description' => esc_html__( 'This theme includes support for the Gutenberg blocks styles, but you can disable all block related stylesheets if you do not use Gutenberg.', 'definite-lite' ),
		'section'  => 'definite_lite_section_basic',
		'type'     => 'checkbox',
	) );
	
	// Add Setting and Control for showing edit link
	$wp_customize->add_setting( 'definite_lite_show_edit', array(
		'default'           => false,
		'transport'         => 'postMessage',
		'sanitize_callback' => 'definite_lite_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'definite_lite_show_edit', array(
		'label'    => esc_html__( 'Hide Edit Links on Pages &amp; Posts', 'definite-lite' ),
		'description' => esc_html__( 'Show or hide the front-end EDIT link for posts and pages.', 'definite-lite' ),
		'section'  => 'definite_lite_section_basic',
		'type'     => 'checkbox',
	) );	
	  	
	
}
add_action( 'customize_register', 'definite_lite_customize_register_basic_settings' );
