<?php
/**
 * Upgrade Control for the Customizer
 * @package Definite_Lite
 */

 /**
 * Control type.
 * For Upsell content in the customizer
 */
 
 if ( class_exists( 'WP_Customize_Control' ) ) :

	/**
	 * Displays the upgrade teasers in thhe Pro Version / More Features section.
	 */
	class Definite_Lite_Customize_Static_Text_Control extends WP_Customize_Control {
		/**
		 * Render Control
		 */
		public function render_content() {
			?>

    <div class="upgrade-pro-version">		
		
    <h1><?php esc_html_e('Definite Lite', 'definite-lite') ?></h1>
    <p class="rp-discount"><?php esc_html_e('Save $20 if you purchase the Pro version with this discount code on checkout:', 'definite-lite') ?>
        <span class="rp-discount-code"><?php esc_html_e('RPDEF20', 'definite-lite') ?></span></p>
    <p class="rp-pro-title"><?php esc_html_e('Pro Features:', 'definite-lite') ?></p>
    <ul class="rp-pro-list">
        <li><?php esc_html_e('&bull; 6 Blog Styles', 'definite-lite')?></li>
        <li><?php esc_html_e('&bull; 12 Dynamic Sidebar Positions', 'definite-lite')?></li>
        <li><?php esc_html_e('&bull; 3 Full Post Layouts', 'definite-lite')?></li>
        <li><?php esc_html_e('&bull; 4 Menu Locations', 'definite-lite')?></li>
		<li><?php esc_html_e('&bull; Option to Disable Gutenberg Styles', 'definite-lite')?></li>
        <li><?php esc_html_e('&bull; WooCommerce Ready if You Have a Store', 'definite-lite')?></li>
        <li><?php esc_html_e('&bull; Thumbnail Creation for the Blogs', 'definite-lite')?></li>
        <li><?php esc_html_e('&bull; Related Posts w/thumbnails', 'definite-lite')?></li>
        <li><?php esc_html_e('&bull; Feature a Post on the Blog', 'definite-lite')?></li>
        <li><?php esc_html_e('&bull; An About Me Widget', 'definite-lite')?></li>
        <li><?php esc_html_e('&bull; A Social Links Widget', 'definite-lite')?></li>
        <li><?php esc_html_e('&bull; Enable a Popup WP Gallery Viewer', 'definite-lite')?></li>
        <li><?php esc_html_e('&bull; Customize the Read More Button Text', 'definite-lite')?></li>
        <li><?php esc_html_e('&bull; Custom Styled Archive Titles', 'definite-lite')?></li>
        <li><?php esc_html_e('&bull; Custom Styled WordPress Login Page', 'definite-lite')?></li>
        <li><?php esc_html_e('&bull; We Made the Customizer Look Better', 'definite-lite')?></li>
        <li><?php esc_html_e('&bull; Show or Hide the Featured Post Label', 'definite-lite')?></li>
        <li><?php esc_html_e('&bull; Mailchimp for WP (Plugin) Styling', 'definite-lite')?></li>
        <li><?php esc_html_e('&bull; Priority Support', 'definite-lite')?></li>
    </ul>

    <p><a class="rp-get-pro button" href="<?php echo esc_url('https://www.roughpixels.com/gutenberg-themes/definite/'); ?>" target="_blank"><?php esc_html_e( 'Save $20 Now', 'definite-lite' ); ?></a></p>			

    </div>

    <?php
		}
	}

endif;














