<?php
/**
 * Definite back compat functionality
 * Prevents Definite from running on WordPress versions prior to 4.7,
 * since this theme is not meant to be backward compatible beyond that and
 * relies on many newer functions and markup changes introduced in 4.7.
 * @package Definite_Lite
 */

/**
 * Prevent switching to Definite on old versions of WordPress.
 * Switches to the default theme.
 */
function definite_lite_switch_theme() {
	switch_theme( WP_DEFAULT_THEME );
	unset( $_GET['activated'] );
	add_action( 'admin_notices', 'definite_lite_upgrade_notice' );
}
add_action( 'after_switch_theme', 'definite_lite_switch_theme' );

/**
 * Adds a message for unsuccessful theme switch.
 * Prints an update nag after an unsuccessful attempt to switch to
 * Definite on WordPress versions prior to 4.7.
 * @global string $wp_version WordPress version.
 */
function definite_lite_upgrade_notice() {
	$message = sprintf( 
	/* translators: %s: version number */
	esc_html__( 'Definite requires at least WordPress version 4.7. You are running version %s. Please upgrade and try again.', 'definite-lite' ), esc_html( $GLOBALS['wp_version'] ) );
	printf( '<div class="error"><p>%s</p></div>', esc_html( $message ) );
}

/**
 * Prevents the Customizer from being loaded on WordPress versions prior to 4.7.
 * @global string $wp_version WordPress version.
 */
function definite_lite_customize() {
	wp_die( sprintf( 
	/* translators: %s: version number */
	esc_html__( 'Definite requires at least WordPress version 4.7. You are running version %s. Please upgrade and try again.', 'definite-lite' ), esc_html( $GLOBALS['wp_version'] ) ), '', array(
		'back_link' => true,
	) );
}
add_action( 'load-customize.php', 'definite_lite_customize' );

/**
 * Prevents the Theme Preview from being loaded on WordPress versions prior to 4.7.
 * @global string $wp_version WordPress version.
 */
function definite_lite_preview() {
	if ( isset( $_GET['preview'] ) ) {
		wp_die( sprintf( 
		/* translators: %s: version number */
		esc_html__( 'Definite requires at least WordPress version 4.7. You are running version %s. Please upgrade and try again.', 'definite-lite' ), esc_html( $GLOBALS['wp_version'] ) ) );
	}
}
add_action( 'template_redirect', 'definite_lite_preview' );
