<?php
/**
 * The template for displaying image attachments
 * @package Definite_Lite
 */

get_header(); ?>

<div class="row">
    <main id="main" class="site-main col-lg-12">

        <?php while ( have_posts() ) : the_post(); ?>

        <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

            <header class="attachment post-header">
                <?php the_title( '<h1 class="attachment-title">', '</h1>' ); 
				if ( has_excerpt() ) : 
				$page_id = get_queried_object_id();
					echo '<div id="page-excerpt">' . esc_html(get_post_field( 'post_excerpt', $page_id, 'display' ) ) . '</div>'; 
				endif; ?>
            </header>

            <div id="attachment-wrapper">
                <?php
				$image_size = apply_filters( 'definite_lite_attachment_size', 'full' );
				echo wp_get_attachment_image( get_the_ID(), $image_size );
				?>
            </div>
			


            <div id="attachment-description">
                <?php the_content();	?>
            </div>

            <footer class="post-footer">
                <nav id="image-navigation" class="image-navigation">

                    <div class="prev-image attachment-button">
                        <?php previous_image_link( false, esc_html__( 'Previous Image', 'definite-lite' ) ); ?>
                    </div>
                    <div class="next-image attachment-button">
                        <?php next_image_link( false, esc_html__( 'Next Image', 'definite-lite' ) ); ?>
                    </div>

                </nav>
            </footer>

        </article>

				<?php
				endwhile;
			?>
			
    </main>
</div>

<?php get_footer(); ?>
