<?php
/**
 * Definite functions and definitions
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 * @package Definite_Lite
 */

 /**
 * This theme only works in WordPress 4.7 or later.
 */
if ( version_compare( $GLOBALS['wp_version'], '4.7', '<' ) ) {
	require get_template_directory() . '/inc/back-compat.php';
	return;
}

if ( ! function_exists( 'definite_lite_setup' ) ) :

	// Set the default content width.
		$GLOBALS['content_width'] = 1140;
		
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function definite_lite_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on Definite, use a find and replace
		 * to change 'definite-lite' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'definite-lite', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );
		
		// Enable support for the showcase crop
		if( esc_attr(get_theme_mod( 'definite_lite_crop_blog_featured_post', false ) ) ) {
			add_image_size( 'definite-lite-featured', 1000, 600, true );
		}		

		// Enable support for the blog grid thumbnail crop
		if( esc_attr(get_theme_mod( 'definite_lite_crop_grid_featured', false ) ) ) {
			add_image_size( 'definite-lite-grid', 600, 395, true );
		}

		// Recent Posts widget thumbnail
		if( esc_attr(get_theme_mod( 'definite_lite_crop_recent', false ) ) ) {
		add_image_size( 'definite-lite-recent', 90, 90, true );
		}
		
		// This theme uses wp_nav_menu() in one location.
		register_nav_menus(
			array(
				'primary' => esc_html__( 'Primary', 'definite-lite' ),
				'footer' => esc_html__( 'Footer Menu', 'definite-lite' ),
				'top-social' => esc_html__( 'Top Social Links', 'definite-lite' ),
				'bottom-social' => esc_html__( 'Bottom Social Links', 'definite-lite' ),
			)
		);

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );
		
		// Add excerpt support to pages
		add_post_type_support( 'page', 'excerpt' );
		
		// Add support for responsive embedded content.
		add_theme_support( 'responsive-embeds' );
		
		// Add support for full and wide align images.
		add_theme_support( 'align-wide' );

		// Add support for editor styles.
		add_theme_support( 'editor-styles' );

		// Enqueue editor styles.
		add_editor_style( array( '/assets/css/classic-editor.css', definite_lite_fonts_url() ) );
		
		// Add support for core custom logo.
		add_theme_support( 'custom-logo', array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		) );
	}
endif;
add_action( 'after_setup_theme', 'definite_lite_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 * Priority 0 to make it available to lower priority callbacks.
 * @global int $content_width
 */
function definite_lite_content_width() {
	$content_width = $GLOBALS['content_width'];
	// Check if the page has a sidebar.
	if ( is_active_sidebar( 'left-sidebar'  ) || is_active_sidebar( 'right-sidebar' ) || is_active_sidebar( 'blog-sidebar' ) ) {
		$content_width = 660;
	}	
  $GLOBALS['content_width'] = apply_filters( 'definite_lite_content_width', $content_width );
}
add_action( 'template_redirect', 'definite_lite_content_width', 0 );

/**
 * Register Google fonts
 * You can disable from the customizer if you want different fonts.
 * @return string Google fonts URL for the theme.
 */
	 
if ( ! function_exists( 'definite_lite_fonts_url' ) ) :

	function definite_lite_fonts_url() {
		$fonts_url = '';
		$fonts     = array();
		$subsets   = 'latin,latin-ext';

		/* translators: If there are characters in your language that are not supported by the PT Serif font, translate this to 'off'. Do not translate into your own language. */
		if ( 'off' !== _x( 'on', 'PT Serif', 'definite-lite' ) ) {
			$fonts[] = 'PT Serif:400';
		}

		/* translators: If there are characters in your language that are not supported by the Roboto font, translate this to 'off'. Do not translate into your own language. */
		if ( 'off' !== _x( 'on', 'Roboto', 'definite-lite' ) ) {
			$fonts[] = 'Roboto:300,400,700';
		}
		
		if ( $fonts ) {
			$fonts_url = add_query_arg(
				array(
					'family' => urlencode( implode( '|', $fonts ) ),
					'subset' => urlencode( $subsets ),
				), 'https://fonts.googleapis.com/css'
			);
		}

		return esc_url_raw( $fonts_url );
	}
endif;
	
// Enqueue admin scripts and styles
function definite_lite_admin_scripts( $hook ) {
	if ( 'post.php' != $hook ) {
        return;
	}
	// Load editor fonts from Google
wp_enqueue_style( 'definite-lite-pro-admin-fonts', definite_lite_fonts_url(), array(), null );
}
add_action( 'admin_enqueue_scripts', 'definite_lite_admin_scripts', 5 );
	
/**
 * Enqueue scripts and styles.
 */
function definite_lite_scripts() {
	
	if( esc_attr(get_theme_mod( 'definite_lite_default_google_fonts', true ) ) ) {
		wp_enqueue_style( 'definite-lite-pro-fonts', definite_lite_fonts_url(), array(), null );
	}
	
	// Disable the theme block front-end stylesheet.
    if ( false == esc_attr(get_theme_mod( 'definite_lite_block_css', false ) ) ) {
		wp_enqueue_style( 'definite-lite-block-style', get_template_directory_uri() . '/assets/css/blocks.css', array(), null );
	}
	// Disable core gutenberg style in Front
	 if ( true == esc_attr(get_theme_mod( 'definite_lite_block_css', false ) ) ) {	
		function definite_lite_deregister_styles() {
			wp_dequeue_style( 'wp-block-library' );
		}
		add_action( 'wp_print_styles', 'definite_lite_deregister_styles', 100 );
	 }

	// Theme stylesheet
	wp_enqueue_style( 'definite-lite-style', get_stylesheet_uri() );

	// Theme navigation script - Load only if active primary menu
	if ( has_nav_menu( 'primary' ) ) {
		wp_enqueue_script( 'definite-lite-navigation', get_template_directory_uri() . '/assets/js/navigation.js', array( 'jquery' ), null, true );	
		wp_localize_script( 'definite-lite-navigation', 'definite_lite_menu_title', definite_lite_get_icon_svg( 'menu' ) . esc_html__( 'Menu', 'definite-lite' ) );
	}
	
	// Skip Link Focus
	wp_enqueue_script( 'definite-lite-skip-link-focus-fix', get_template_directory_uri() . '/assets/js/skip-link-focus-fix.js', array(), null, true );
	
	// Theme scripts
	wp_enqueue_script( 'definite-lite-scripts', get_template_directory_uri() . '/assets/js/theme-scripts.js', array(), null, true );
          	
	// Theme Comments
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'definite_lite_scripts' );



 /*--------------------------------------------------------
 Enqueue Gutenberg editor styles
 -------------------------------------------------------*/
function definite_lite_gutenberg_editor_styles() { 
	wp_enqueue_style( 'definite-lite-editor-styles', get_template_directory_uri() . '/assets/css/block-editor.css'); 
}
// only name the function and leave the enqueue as enqueue_block_editor_assets
add_action( 'enqueue_block_editor_assets', 'definite_lite_gutenberg_editor_styles' );

if ( ! function_exists( 'definite_lite_add_gutenberg_features' ) ) {
	function definite_lite_add_gutenberg_features() {
		
		/* Gutenberg Colour Palette */
		$accent_color = get_theme_mod( 'definite_lite_accent_colour' ) ? get_theme_mod( 'definite_lite_accent_colour' ) : '#cd4433';
		add_theme_support( 'editor-color-palette', array(
			array(
				'name' 	=> _x( 'Accent', 'Name of the accent color in the Gutenberg palette', 'definite-lite' ),
				'slug' 	=> esc_html__( 'accent', 'definite-lite' ),
				'color' => esc_attr($accent_color),
			),		

			array(
				'name' 	=> _x( 'Blue', 'Name of the blue color in the Gutenberg palette', 'definite-lite' ),
				'slug' 	=>  esc_html__( 'blue', 'definite-lite' ),
				'color' => '#3e8cc1',
			),
			
			array(
				'name' 	=> _x( 'Dark Grey', 'Name of the dark grey, almost black color in the Gutenberg palette', 'definite-lite' ),
				'slug' 	=>  esc_html__( 'dark', 'definite-lite' ),
				'color' => '#2f3335',
			),

			array(
				'name' 	=> _x( 'White', 'Name of the white color in the Gutenberg palette', 'definite-lite' ),
				'slug' 	=>  esc_html__( 'white', 'definite-lite' ),
				'color' => '#fff',
			),
		) );
		
		/* Gutenberg Font Sizes */
		add_theme_support( 'editor-font-sizes', array(
			array(
				'name' 		=> _x( 'Small', 'Name of the small font size in Gutenberg', 'definite-lite' ),
				'shortName' => _x( 'S', 'Short name of the small font size in the Gutenberg editor.', 'definite-lite' ),
				'size' 		=> 17,
				'slug' 		=> 'small'
			),
			array(
				'name' 		=> _x( 'Regular', 'Name of the regular font size in Gutenberg', 'definite-lite' ),
				'shortName' => _x( 'M', 'Short name of the regular font size in the Gutenberg editor.', 'definite-lite' ),
				'size' 		=> 18,
				'slug' 		=> 'regular'
			),
			array(
				'name' 		=> _x( 'Large', 'Name of the large font size in Gutenberg', 'definite-lite' ),
				'shortName' => _x( 'L', 'Short name of the large font size in the Gutenberg editor.', 'definite-lite' ),
				'size' 		=> 24,
				'slug' 		=> 'large'
			),
			array(
				'name' 		=> _x( 'Larger', 'Name of the larger font size in Gutenberg', 'definite-lite' ),
				'shortName' => _x( 'XL', 'Short name of the larger font size in the Gutenberg editor.', 'definite-lite' ),
				'size' 		=> 32,
				'slug' 		=> 'larger'
			)
		) );		
	
		}
	add_action( 'after_setup_theme', 'definite_lite_add_gutenberg_features' );

}


// Custom template functions and tags for this theme.
require get_template_directory() . '/inc/icons.php';
require get_template_directory() . '/inc/inline-styles.php';
require get_template_directory() . '/inc/sidebars.php';
require get_template_directory() . '/inc/template-tags.php';
require get_template_directory() . '/inc/template-functions.php';
require get_template_directory() . '/inc/class-comment-walker.php';

// WIDGETS
require get_template_directory() . '/inc/recent-posts-widget.php';

// Customizer
require get_template_directory() . '/inc/customizer/customizer.php';
require get_template_directory() . '/inc/customizer/sanitize-functions.php';
require get_template_directory() . '/inc/customizer/controls/headline-control.php';
require get_template_directory() . '/inc/customizer/sections/customizer-basic.php';
require get_template_directory() . '/inc/customizer/sections/customizer-blog.php';
require get_template_directory() . '/inc/customizer/sections/customizer-post.php';
require get_template_directory() . '/inc/customizer/sections/customizer-page.php';
require get_template_directory() . '/inc/customizer/sections/customizer-thumbnails.php';
require get_template_directory() . '/inc/customizer/sections/customizer-colours.php';
require( get_template_directory() . '/inc/customizer/controls/upgrade-control.php' );
require( get_template_directory() . '/inc/customizer/sections/customizer-pro-upgrade.php' );

// Load Jetpack compatibility file.
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}
