/**
 * Customizer Live Preview
 *
 * Reloads changes on Theme Customizer Preview asynchronously for better usability
 *
 * @package Definite_Lite
 */

(function ($) {

    $head = $('head');


	// functions for our customer show or hide settings
	function hideElement( element ) {
		$( element ).css({
			clip: 'rect(1px, 1px, 1px, 1px)',
			position: 'absolute',
			width: '1px',
			height: '1px',
			overflow: 'hidden'
		});
	}

	function showElement( element ) {
		$( element ).css({
			clip: 'auto',
			position: 'relative',
			width: 'auto',
			height: 'auto',
			overflow: 'visible'
		});
	}

	// Show when you need an absolute position
	function showElementabs( element ) {
		$( element ).css({
			clip: 'auto',
			position: 'absolute',
			width: 'auto',
			height: 'auto',
			overflow: 'visible'
		});
	}
	

	// Site title.	
	wp.customize( 'blogname', function( value ) {
	  value.bind( function( newval ) {
		$( '#site-title a' ).html( newval );
	  } );
	} );
	
	// Site description.	
	wp.customize( 'blogdescription', function( value ) {
	  value.bind( function( newval ) {
		$( '#site-description' ).html( newval );
	  } );
	} );






/* =======================
 Show or hide previews
======================= */

    // Show site title
    wp.customize('definite_lite_show_site_title', function (value) {
        value.bind(function (newval) {
            if (false === newval) {
                showElement('#site-title');
            } else {
                hideElement('#site-title');
            }
        });
    });

    // Show tagline
    wp.customize('definite_lite_show_site_desc', function (value) {
        value.bind(function (newval) {
            if (false === newval) {
                showElement('#site-description');
            } else {
                hideElement('#site-description');
            }
        });
    });
	
    // Show blog title group checkbox.
    wp.customize('definite_lite_show_blog_title_group', function (value) {
        value.bind(function (newval) {
            if (false === newval) {
                hideElement('#page-title-group');
            } else {
                showElement('#page-title-group');
            }
        });
    });
	
    // Show post meta info
    wp.customize('definite_lite_single_meta_info', function (value) {
        value.bind(function (newval) {
            if (false === newval) {
                showElement('.single .post-details');
            } else {
                hideElement('.single .post-details');
            }
			});
    });

    // Show summary image
    wp.customize('definite_lite_show_summary_image', function (value) {
        value.bind(function (newval) {
            if (false === newval) {
                showElement('.blog .post-thumbnail');
            } else {
                hideElement('.blog .post-thumbnail');
            }
        });
    });

    // Show summary meta
    wp.customize('definite_lite_show_summary_meta', function (value) {
        value.bind(function (newval) {
            if (false === newval) {
                showElement('.blog .post-details');
            } else {
                hideElement('.blog .post-details');
            }
        });
    });

    // Show summary author
    wp.customize('definite_lite_show_summary_author', function (value) {
        value.bind(function (newval) {
            if (false === newval) {
                showElement('.blog .byline');
            } else {
                hideElement('.blog .byline');
            }
        });
    });

    // Show summary date
    wp.customize('definite_lite_show_summary_date', function (value) {
        value.bind(function (newval) {
            if (false === newval) {
                showElement('.blog .posted-on');
            } else {
                hideElement('.blog .posted-on');
            }
        });
    });

    // Show summary comment count
    wp.customize('definite_lite_show_summary_category', function (value) {
        value.bind(function (newval) {
            if (false === newval) {
                showElement('.post-category');
            } else {
                hideElement('.post-category');
            }
        });
    });

    // Show summary category
    wp.customize('definite_lite_show_summary_comments', function (value) {
        value.bind(function (newval) {
            if (false === newval) {
                showElement('.blog .comments-link');
            } else {
                hideElement('.blog .comments-link');
            }
        });
    });

    // Show full post image
    wp.customize('definite_lite_show_single_image', function (value) {
        value.bind(function (newval) {
            if (false === newval) {
                showElement('.single-featured-image');
            } else {
                hideElement('.single-featured-image');
            }
        });
    });

    // Show full post author
    wp.customize('definite_lite_show_single_author', function (value) {
        value.bind(function (newval) {
            if (false === newval) {
                showElement('.single .byline');
            } else {
                hideElement('.single .byline');
            }
        });
    });

    // Show full post date
    wp.customize('definite_lite_show_single_date', function (value) {
        value.bind(function (newval) {
            if (false === newval) {
                showElement('.single .posted-on');
            } else {
                hideElement('.single .posted-on');
            }
        });
    });

    // Show full post comment count
    wp.customize('definite_lite_show_single_comments', function (value) {
        value.bind(function (newval) {
            if (false === newval) {
                showElement('.single .comments-link');
            } else {
                hideElement('.single .comments-link');
            }
        });
    });


    // Show edit links
    wp.customize('definite_lite_show_edit', function (value) {
        value.bind(function (newval) {
            if (false === newval) {
                showElement('.edit-link');
            } else {
                hideElement('.edit-link');
            }
        });
    });

    // Show featured label
    wp.customize('definite_lite_show_featured_label', function (value) {
        value.bind(function (newval) {
            if (false === newval) {
                showElement('.featured-label');
            } else {
                hideElement('.featured-label');
            }
        });
    });

    // Show author bio
    wp.customize('definite_lite_display_author_bio', function (value) {
        value.bind(function (newval) {
            if (false === newval) {
                showElement('#author-info');
            } else {
                hideElement('#author-info');
            }
        });
    });

    // Show footer category list
    wp.customize('definite_lite_footer_categories', function (value) {
        value.bind(function (newval) {
            if (false === newval) {
                showElement('#post-categories');
            } else {
                hideElement('#post-categories');
            }
        });
    });

    // Show footer tag list
    wp.customize('definite_lite_footer_tags', function (value) {
        value.bind(function (newval) {
            if (false === newval) {
                showElement('#post-tags');
            } else {
                hideElement('#post-tags');
            }
        });
    });

    // Show related posts
    wp.customize('definite_lite_show_related_posts', function (value) {
        value.bind(function (newval) {
            if (false === newval) {
                showElement('#related-posts-wrapper');
            } else {
                hideElement('#related-posts-wrapper');
            }
        });
    });

    // Show post next prev
    wp.customize('definite_lite_post_navigation', function (value) {
        value.bind(function (newval) {
            if (false === newval) {
                showElement('.post-navigation');
            } else {
                hideElement('.post-navigation');
            }
        });
    });

    // Show page featured image
    wp.customize('definite_lite_show_page_featured_image', function (value) {
        value.bind(function (newval) {
            if (false === newval) {
                showElement('.page .post-thumbnail');
            } else {
                hideElement('.page .post-thumbnail');
            }
        });
    });

/* =======================
 Text based previews
======================= */

    // Blog Title textfield.
    wp.customize('definite_lite_blog_title', function (value) {
        value.bind(function (to) {
            $('#blog-title').text(to);
        });
    });

    // Blog Description textfield.
    wp.customize('definite_lite_blog_description', function (value) {
        value.bind(function (to) {
            $('#blog-description').text(to);
        });
    });

    // Copyright
    wp.customize('definite_lite_copyright', function (value) {
        value.bind(function (to) {
            $('#copyright-name').text(to);
        });
    });

    // Read More textfield.
    wp.customize('definite_lite_read_more_text', function (value) {
        value.bind(function (to) {
            $('a.readmore').text(to);
        });
    });
	
/* =======================
 Colours
======================= */

    // Site Title Colour
    wp.customize('definite_lite_sitetitle_colour', function (value) {
        value.bind(function (to) {
            $('#site-title a').css('color', to);
        });
    });

    // Site Tagline Colour
    wp.customize('definite_lite_tagline_colour', function (value) {
        value.bind(function (to) {
            $('#site-description').css('color', to);
        });
    });




	/* first accent Colour 1 */
	wp.customize( 'definite_lite_accent_colour', function( value ) {
		value.bind( function( to ) {
			var style = $('#custom-accent-colour-css');

			style.remove();
			style = $( '<style type="text/css" id="custom-accent-colour-css"> .login.wp-core-ui .btn-primary, .pagination .current,.pagination .page-numbers:hover,.pagination .page-numbers:active, #top-bar-wrapper,#cbottom-wrapper .mc4wp-form input[type=\"submit\"],.rp-social-icons-list a,.rp-social-icons-list a:visited,#blog-featured-post .readmore:hover,.gallery figcaption { background:' + to + ' } </style>' ).appendTo( $head );
		} );
	} );

	/* first accent Colour 2 */
	wp.customize( 'definite_lite_accent_colour', function( value ) {
		value.bind( function( to ) {
			var style = $('#custom-accent-colour2-css');

			style.remove();
			style = $( '<style type="text/css" id="custom-accent-colour2-css"> .login.wp-core-ui .btn-primary, .pagination .page-numbers, .pagination .page-numbers:visited, .nav-links a:hover .nav-entry-title, .pagination .current, .pagination .page-numbers:hover, .pagination .page-numbers:active { border-color:' + to + ' } </style>' ).appendTo( $head );
		} );
	} );
 
	/* first accent Colour 3 */
	wp.customize( 'definite_lite_accent_colour', function( value ) {
		value.bind( function( to ) {
			var style = $('#custom-accent-colour3-css');

			style.remove();
			style = $( '<style type="text/css" id="custom-accent-colour3-css"> .pagination .page-numbers, .pagination .page-numbers:visited, .nav-links a:hover .nav-entry-title, #footer-menu a:hover, .entry-title a:hover, .featured-label, .hentry .post-details a:hover, #blog-featured-title a:hover, #blog-featured-post .readmore:hover, .blog-gallery .hentry .post-header a:hover, .related-posts-title a:hover, #post-categories a:hover, #post-tags a:hover { color:' + to + ' } </style>' ).appendTo( $head );
		} );
	} );


	/* second accent Colour 1 */
	wp.customize( 'definite_lite_second_colour', function( value ) {
		value.bind( function( to ) {
			var style = $('#custom-second-accent-colour1-css');

			style.remove();
			style = $( '<style type="text/css" id="custom-second-accent-colour1-css"> table th, .btn-primary-hover, .btn-seconday:hover, a.button:focus, a.button:hover, button:focus, button:hover, input[type=\"button\"]:focus, input[type=\"button\"]:hover, input[type=\"reset\"]:focus, input[type=\"reset\"]:hover, input[type=\"submit\"]:focus, input[type=\"submit\"]:hover, .main-navigation-toggle, .featured-caption, p.no-comments, #blog-featured-post .readmore { background:' + to + ' } </style>' ).appendTo( $head );
		} );
	} );

	/* third accent Colour 1 */
	wp.customize( 'definite_lite_third_colour', function( value ) {
		value.bind( function( to ) {
			var style = $('#custom-third-accent-colour1-css');

			style.remove();
			style = $( '<style type="text/css" id="custom-third-accent-colour1-css"> table thead, a.button, .btn-primary, .btn.secondary, button, input[type=\"button\"], input[type=\"reset\"], input[type=\"submit\"], .button.style-1, .main-navigation-toggle:focus, .main-navigation-toggle:hover, .main-navigation-toggle:active, .main-navigation-toggle:focus:hover, #top-search, #blog-post-header, .blog-gallery .post-content, #cbottom-wrapper, .widget_calendar #prev a, .widget_calendar #next a, .widget_tag_cloud a:hover, .rp-social-icons-list a:hover  { background:' + to + ' } </style>' ).appendTo( $head );
		} );
	} );

	/* fourth accent Colour 1 */
	wp.customize( 'definite_lite_fourth_colour', function( value ) {
		value.bind( function( to ) {
			var style = $('#custom-fourth-accent-colour1-css');

			style.remove();
			style = $( '<style type="text/css" id="custom-fourth-accent-colour1-css"> table thead, .btn-primary, .btn.secondary, a.button, a.button:visited, button, input[type=\"button\"], input[type=\"reset\"], input[type=\"submit\"], a.button:focus, a.button:hover, button:focus, button:hover, input[type=\"button\"]:focus, input[type=\"button\"]:hover, input[type=\"reset\"]:focus, input[type=\"reset\"]:hover, input[type=\"submit\"]:focus, input[type=\"submit\"]:hover, .button.style-1, .main-navigation-toggle:hover, .main-navigation-toggle:active, .main-navigation-toggle:focus:hover, .pagination .current, .pagination .page-numbers:hover, .pagination .page-numbers:active, #site-footer, .featured-caption, #blog-featured-content, #blog-featured-title a, #blog-featured-post .readmore, #blog-featured-post .readmore:hover,  .widget_calendar #prev a, .widget_calendar #next a, .widget_tag_cloud a:hover, #cbottom-sidebar  .widget_tag_cloud a, #cbottom-sidebar .widget_tag_cloud a:visited, .gallery figcaption  { color:' + to + ' } </style>' ).appendTo( $head );
		} );
	} );

	/* fourth accent Colour 2 */
	wp.customize( 'definite_lite_fourth_colour', function( value ) {
		value.bind( function( to ) {
			var style = $('#custom-fourth-accent-colour2-css');

			style.remove();
			style = $( '<style type="text/css" id="custom-fourth-accent-colour2-css"> .main-navigation-toggle .icon, .main-navigation-toggle:hover .icon, .main-navigation-toggle:active .icon, .social-menu li a .icon, #footer-social-menu .social-menu li a .icon, #top-bar-wrapper .icon, .rp-social-icons-list li:hover .icon, .rp-social-icons-list li .icon, .widget_search .icon  { fill:' + to + ' } @media (min-width: 1024px) { .menu ul .menu-item-has-children a .sub-menu-icon .icon }</style>' ).appendTo( $head );
		} );
	} );

	/* page content bg */
	wp.customize( 'definite_lite_content_bg', function( value ) {
		value.bind( function( to ) {
			var style = $('#custom-content-bg-css');

			style.remove();
			style = $( '<style type="text/css" id="custom-content-bg-css"> #page  { background:' + to + ' } </style>' ).appendTo( $head );
		} );
	} );

	/* borders and lines */
	wp.customize( 'definite_lite_line_colour', function( value ) {
		value.bind( function( to ) {
			var style = $('#custom-borders-lines-css');

			style.remove();
			style = $( '<style type="text/css" id="custom-borders-lines-css"> #site-header, .single .entry-content, #author-info, .post-navigation, #related-posts-wrapper, #cboxError, input[type=\"text\"], input[type=\"email\"], input[type=\"url\"], input[type=\"password\"], input[type=\"search\"], input[type=\"number\"], input[type=\"tel\"], input[type=\"range\"], input[type=\"date\"], input[type=\"month\"], input[type=\"week\"], input[type=\"time\"], input[type=\"datetime\"], input[type=\"datetime-local\"], input[type=\"color\"], select, textarea { border-color:' + to + ' } </style>' ).appendTo( $head );
		} );
	} );

	/* borders and lines */
	wp.customize( 'definite_lite_line_colour', function( value ) {
		value.bind( function( to ) {
			var style = $('#custom-borders-lines2-css');

			style.remove();
			style = $( '<style type="text/css" id="custom-borders-lines2-css"> .widget_pages li:after, .widget_meta li:after, .widget_archive li:after, .widget_categories li:after, .widget_recent_comments li:after, .widget_recent_entries li:after { background:' + to + ' } </style>' ).appendTo( $head );
		} );
	} );

	/* top social icons */
	wp.customize( 'definite_lite_top_social_icon', function( value ) {
		value.bind( function( to ) {
			var style = $('#custom-top-social-icons-css');

			style.remove();
			style = $( '<style type="text/css" id="custom-top-social-icons-css"> #top-bar .social-menu li a .icon { fill:' + to + ' } </style>' ).appendTo( $head );
		} );
	} );

	/*menu toggle icon */
	wp.customize( 'definite_lite_toggle_icon', function( value ) {
		value.bind( function( to ) {
			var style = $('#custom-menu-toggle-icon-css');

			style.remove();
			style = $( '<style type="text/css" id="custom-menu-toggle-icon-css"> .main-navigation-toggle .icon, .main-navigation-toggle:hover .icon, .main-navigation-toggle:active .icon { fill:' + to + ' } </style>' ).appendTo( $head );
		} );
	} );

	/* main body text */
	wp.customize( 'definite_lite_body_text', function( value ) {
		value.bind( function( to ) {
			var style = $('#custom-body-text-css');

			style.remove();
			style = $( '<style type="text/css" id="custom-body-text-css"> body, a.readmore, a.readmore:visited, .menu li.home.current-menu-item > a { color:' + to + ' } </style>' ).appendTo( $head );
		} );
	} );

	/* headings and titles*/
	wp.customize( 'definite_lite_headings', function( value ) {
		value.bind( function( to ) {
			var style = $('#custom-titles-css');

			style.remove();
			style = $( '<style type="text/css" id="custom-titles-css"> h1, h2, h3, h4, h5, h6, .entry-title a, .entry-title a:visited, .widget-title { color:' + to + ' } </style>' ).appendTo( $head );
		} );
	} );

	/* main menu link colour */
	wp.customize( 'definite_lite_menu_link_colour', function( value ) {
		value.bind( function( to ) {
			var style = $('#custom-menu-links-css');

			style.remove();
			style = $( '<style type="text/css" id="custom-menu-links-css"> @media (min-width: 768px) {.main-navigation-menu li.home.current-menu-item a, .main-navigation-menu li a, .main-navigation-menu li a:visited { color:' + to + ' } }</style>' ).appendTo( $head );
		} );
	} );

	/* main menu link hover colour */
	wp.customize( 'definite_lite_menu_link_hover_colour', function( value ) {
		value.bind( function( to ) {
			var style = $('#custom-menu-links-hover-css');

			style.remove();
			style = $( '<style type="text/css" id="custom-menu-links-hover-css"> @media (min-width: 768px) { .main-navigation-menu li.home.current-menu-item > a:focus, .main-navigation-menu li.home.current-menu-item > a:hover,	.main-navigation-menu li.current-menu-item a,	.main-navigation-menu ul a:active, .main-navigation-menu .sub-menu li.current-menu-item > a, .main-navigation-menu .sub-menu li > a:hover, .main-navigation-menu li a:focus, .main-navigation-menu li a:hover { color:' + to + ' } }</style>' ).appendTo( $head );
		} );
	} );

	/* submenu bg colour */
	wp.customize( 'definite_lite_submenu_bg', function( value ) {
		value.bind( function( to ) {
			var style = $('#custom-submenu-bg-css');

			style.remove();
			style = $( '<style type="text/css" id="custom-submenu-bg-css"> @media (min-width: 768px) { .main-navigation-menu li.menu-item-has-children:hover > ul, .main-navigation-menu li.page_item_has_children:hover > ul, .main-navigation-menu li.menu-item-has-children > ul { background:' + to + ' } }</style>' ).appendTo( $head );
		} );
	} );

	/* submenu link colour */
	wp.customize( 'definite_lite_submenu_link_colour', function( value ) {
		value.bind( function( to ) {
			var style = $('#custom-submenu-links-css');

			style.remove();
			style = $( '<style type="text/css" id="custom-submenu-links-css"> @media (min-width: 768px) { .main-navigation-menu ul a, .main-navigation-menu ul a:visited{ color:' + to + ' } }</style>' ).appendTo( $head );
		} );
	} );

	/* Page Intro text */
	wp.customize( 'definite_lite_intro_text', function( value ) {
		value.bind( function( to ) {
			var style = $('#custom-intro-text-css');

			style.remove();
			style = $( '<style type="text/css" id="custom-intro-text-css"> #blog-description, #category-description, #page-excerpt  { color:' + to + ' }</style>' ).appendTo( $head );
		} );
	} );

	/* bottom text colour */
	wp.customize( 'definite_lite_bottom_text', function( value ) {
		value.bind( function( to ) {
			var style = $('#custom-bottom-text-css');

			style.remove();
			style = $( '<style type="text/css" id="custom-bottom-text-css"> #cbottom-wrapper, #cbottom-sidebar a, #cbottom-sidebar a:visited, #cbottom-wrapper .mailchimp-label { color:' + to + ' }</style>' ).appendTo( $head );
		} );
	} );

	/* Bottom widget titles */
	wp.customize( 'definite_lite_bottom_widget_titles', function( value ) {
		value.bind( function( to ) {
			var style = $('#custom-bottom-widget-title-css');

			style.remove();
			style = $( '<style type="text/css" id="custom-bottom-widget-title-css"> #cbottom-wrapper .widget-title, #footer-sidebar .widget-title { color:' + to + ' }</style>' ).appendTo( $head );
		} );
	} );

	/* Footer background */
	wp.customize( 'definite_lite_footer_bg', function( value ) {
		value.bind( function( to ) {
			var style = $('#custom-footer-bg-css');

			style.remove();
			style = $( '<style type="text/css" id="custom-footer-bg-css"> #site-footer { background:' + to + ' }</style>' ).appendTo( $head );
		} );
	} );

	/* Footer text icons */
	wp.customize( 'definite_lite_footer_text_icons', function( value ) {
		value.bind( function( to ) {
			var style = $('#custom-footer-text-icons-css');

			style.remove();
			style = $( '<style type="text/css" id="custom-footer-text-icons-css"> #site-footer { color:' + to + ' }</style>' ).appendTo( $head );
		} );
	} );

	/* Footer text icons */
	wp.customize( 'definite_lite_footer_text_icons', function( value ) {
		value.bind( function( to ) {
			var style = $('#custom-footer-text-icons2-css');

			style.remove();
			style = $( '<style type="text/css" id="custom-footer-text-icons2-css"> #footer-social-menu .social-menu li a .icon { fill:' + to + ' }</style>' ).appendTo( $head );
		} );
	} );

	/* text selection */
	wp.customize( 'definite_lite_select_text', function( value ) {
		value.bind( function( to ) {
			var style = $('#custom-text-selection-css');

			style.remove();
			style = $( '<style type="text/css" id="custom-text-selection-css"> ::selection { background:' + to + ' } ::-moz-selection { background:' + to + ' }</style>' ).appendTo( $head );
		} );
	} );





















})(jQuery);
