<?php
/**
 * The template for displaying 404 pages (not found)
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 * @package Definite_Lite
 */

get_header();
?>

<div class="row">
    <main id="main" class="site-main col-lg-12">

        <section id="error404" class="hentry">
            <h1 id="error-title">
                <?php esc_html_e( '404', 'definite-lite' ); ?>
            </h1>
            <h3 id="error-sub-title">
                <?php esc_html_e( 'Our Apologies. The page requested cannot be found.', 'definite-lite' ); ?>
            </h3>
            <p>
                <?php esc_html_e( 'It appears we messed up somewhere with a broken link or the page has been removed from our website.', 'definite-lite' ); ?>
            </p>
            <p id="error-button">
                <a class="btn btn-primary" href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
                    <?php esc_html_e( 'Return Home', 'definite-lite' ); ?>
                </a>
            </p>

            <div class="search-form-container">
                <form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                    <?php echo definite_lite_get_icon_svg( 'search' ); ?>
                    <input type="search" id="search-field" placeholder="<?php echo esc_attr_x( 'Search &hellip;', 'placeholder', 'definite-lite' ); ?>" value="<?php echo get_search_query(); ?>" name="s" title="<?php echo esc_attr_x( 'Search for:', 'label', 'definite-lite' ); ?>" />
                </form>
            </div>

        </section>

    </main>
</div>

<?php
get_footer();
