<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package news-site
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'news-site' ); ?></a>
	
	<header id="masthead" class="site-header" style="background-image:url(<?php header_image(); ?>)">
		<span id=sidebarToggle class=menuitems>
			<svg  id="sideToggleShow" class="hide" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 8 8">
							<path d="M3 0v3h-3v2h3v3h2v-3h3v-2h-3v-3h-2z" transform="translate(0 0)" />
			</svg>

			<svg  id="sideToggleHide" class="" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 8 8">
							<path d="M0 0v1h8v-1h-8zm0 2.97v1h8v-1h-8zm0 3v1h8v-1h-8z" transform="translate(0 0)" />
			</svg>
			
		</span>

		<div class="site-branding">
			<?php echo csl_CustomSiteLogo_show_logo(); ?>
			<?php
			the_custom_logo();
			if ( is_front_page() && is_home() ):
				?>
				<h1 class="site-title heading1"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
				<?php
			else :
				?>
				<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
				<?php
			endif;
			$news_site_description = get_bloginfo( 'description', 'display' );
			if ( $news_site_description || is_customize_preview() ) :
				?>
				<p class="site-description"><?php echo $news_site_description; /* WPCS: xss ok. */ ?></p>
			<?php endif; ?>
		</div><!-- .site-branding -->

		<!-- from open ionic fonts -->
		<span id="icons">
			<?php
				if ( is_archive() || (is_front_page() && is_home()) ) : ?>
				<span class=menuitems>
					<svg  id="grid1" class="" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 8 8">
						<path d="M0 0v2h2v-2h-2zm3 0v2h2v-2h-2zm3 0v2h2v-2h-2zm-6 3v2h2v-2h-2zm3 0v2h2v-2h-2zm3 0v2h2v-2h-2zm-6 3v2h2v-2h-2zm3 0v2h2v-2h-2zm3 0v2h2v-2h-2z" transform="translate(0 0)" />
					</svg>
				</span>
		<?php
			endif;
		?>
		</span>
		
		
		</nav><!-- #site-navigation -->
		
	</header><!-- #masthead -->

	
	<div id="content" class="site-content">
	<svg  id="rightArrow" class="arrows" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 8 8">
							<path d="M1.5 0l-1.5 1.5 2.5 2.5-2.5 2.5 1.5 1.5 4-4-4-4z" transform="translate(0 0)" />
	</svg>
	<svg  id="leftArrow" class="arrows" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 8 8">
							<path d="M4 0l-4 4 4 4 1.5-1.5-2.5-2.5 2.5-2.5-1.5-1.5z" transform="translate(0 0)" />
	</svg>

	<div class=loadScreen id="loadingDiv"><?php bloginfo( 'name' ); ?>
		<div class=loadScreen id="loadAnime"></div>
	</div>
	<div class=loadScreen id="loadBackground"></div>

	<div id="modal"></div>
	