<?php
/**
 * @package vt-grid-mag
 * @since 1.0
 */

/*
 *	Class.
/*-------------------------------------------------------------------*/
class vt_social_widget extends WP_Widget {
	// New object.
	function __construct() {
		$widget_ops = array(
			  'classname'   => 'vt-social-widget'
			, 'description' => esc_html__( 'A widget that displays social links', 'vt-grid-mag' )
		);
		parent::__construct('vt-social-widget', esc_html__( '[VT] Social Links', 'vt-grid-mag' ), $widget_ops );
	}

	// Output.
	function widget( $args, $instance ) {
		$instance = (array) $instance;
		$args     = wp_parse_args( (array) $args, array( 'before_widget' => '', 'after_widget' => '', 'before_title' => '', 'after_title' => '' ) );
		$title    = isset( $instance['title'] ) ? apply_filters( 'widget_title', $instance['title'], $instance, $this->id_base ) : esc_html__( 'Subscribe & Follow', 'vt-grid-mag' );
		$output   = vt_grid_mag_tags_social_links('', '', false, false, false );

		if( !empty( $output ) ) {
			echo $args['before_widget'];

				if( $title ) {
					echo $args['before_title'] . $title . $args['after_title'];
				}

				vt_grid_mag_tags_social_links('<div class="widget-content">', '</div>', false, false, true );

			echo $args['after_widget'];
		}
	}

	// Input.
	function form( $instance ) {
		$defaults = array(
			'title' => esc_html__( 'Subscribe & Follow', 'vt-grid-mag' )
		);
		$instance = wp_parse_args( (array) $instance, $defaults );

		?>

		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'vt-grid-mag' ); ?></label>
			<input id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' ) ); ?>" value="<?php if(!empty($instance['title'])) { echo esc_attr($instance['title']); } ?>" class="widefat" type="text" />
		</p>
		<p><?php esc_html_e( 'Note: Set your social links in the Customizer', 'vt-grid-mag' ); ?></p>
		<?php
	}

	// Update.
	function update( $new_instance, $old_instance ) {
		$new_instance      = (array) $new_instance;
		$instance          = (array) $old_instance;
		$instance['title'] = isset( $new_instance['title'] ) ? sanitize_text_field( $new_instance['title'] ) : '';

		return $instance;
	}
}