<?php
/**
 * Registers the main widgetized sidebar area.
 *
 * @since vt-grid-mag 1.0
 */
function vt_grid_mag_widgets_init() {
	// Primary Widget.
	register_sidebar( array(
		  'id'            => 'primary'
		, 'name'          => esc_html__( 'Widget Area', 'vt-grid-mag' )
		, 'description'   => esc_html__( 'Add widgets here to appear in your sidebar.', 'vt-grid-mag' )
		, 'before_widget' => '<aside id="%1$s" class="widget clearfix %2$s">'
		, 'after_widget'  => '</aside>'
		, 'before_title'  => '<h4 class="widget-title"><span>'
		, 'after_title'   => '</span></h4>'
	) );
	
	/***** Register Widgets *****/
	register_widget('vt_latest_posts_widget');
	register_widget('vt_social_widget');

}
add_action( 'widgets_init', 'vt_grid_mag_widgets_init' );

/***** Include Widgets *****/
include( get_template_directory() . '/inc/widgets/latest-posts-widget.php');
include( get_template_directory() . '/inc/widgets/social-widget.php');

?>