<?php
/**
 * @package vt-grid-mag
 * @since 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
	<link rel="profile" href="http://gmpg.org/xfn/11" />
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div id="page" class="hfeed site">

	<header id="masthead" class="site-header clearfix" role="banner">
		<div class="overlay">
			<div class="title-area clearfix">
				<?php echo csl_CustomSiteLogo_show_logo(); ?>
				<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
				<h2 class="site-description"><?php bloginfo( 'description' ); ?></h2>
			</div>
			<!-- .title-area -->
			<nav id="navigation" class="site-navigation clearfix" role="navigation">
				<?php wp_nav_menu( array( 'theme_location' => 'primary', 'container' => '' ) ); ?>
			</nav><!-- .site-navigation -->
		</div><!-- .overlay #masthead -->
	</header><!-- #masthead -->
	
	<main id="main" class="site-main clearfix">
		<div class="container">