<?php
/**
 *	@package vt-grid-mag
 *	@since 1.0
 */
	get_header();
	$layout = vt_grid_mag_external_current_layout();
?>

<div id="primary" class="content-area clearfix" role="main">
<?php
	if( have_posts() ) {

		// Header.
		echo '<header class="page-header clearfix">';
			the_archive_title( '<h1 class="page-title">', '</h1>' );
			the_archive_description( '<div class="taxonomy-description clearfix">', '</div>' );
		echo '</header><!-- .page-header -->';

		// Post Wrap.
		if( 'layout-default' != $layout ) {
			echo '<div class="post-container">';
		}

		// Start the Loop.
		while( have_posts() ) {
			the_post();
						
			// Include template for the content.
			if( 'layout-default' != $layout ) {
				get_template_part( 'content', 'grid' );
			}
			else {
				get_template_part( 'content', get_post_format() );
			}
		}

		// End Post Wrap.
		if( 'layout-default' != $layout ) {
			echo '</div>';
		}

		// Pagination.
		the_posts_pagination( array(
			'prev_text' => false,
			'next_text' => esc_html__( 'More Posts', 'vt-grid-mag' )
		) );
	}
	else {
		// Not Found Template.
		get_template_part( 'content', 'none' );
	}
?>
</div>
<!-- #primary -->

<?php get_footer(); ?>