<?php

/***** Premium upgrade *****/
function vt_grid_mag_register_theme_customizer( $wp_customize ) {
	/**
	 *	Add Sections.
	 *--------------------------------------------------------------*/
	$wp_customize->add_section('vt_upgrade', array(
		'title' 	   => __('Upgrade to Pro Version','vt-grid-mag'),
		'priority' => 200,
	) );

	/**
	 *	Add Settings.
	 *--------------------------------------------------------------*/
	$wp_customize->add_setting('vt_options[premium_version_upgrade]', array(
		'default'			=> '',
		'type'				=> 'option',
		'sanitize_callback' => 'esc_url_raw'
	) );
	
	/**
	 *	Add controls.
	 *--------------------------------------------------------------*/
	class vt_grid_mag_Customize_Upgrade_Control extends WP_Customize_Control {
        public function render_content() {  ?>
        	<p class="vt-upgrade-thumb">
        		<img src="<?php echo get_template_directory_uri(); ?>/images/vt-grid-mag-pro.png" />
        	</p>
        	<p class="vt-upgrade-title">
        		<span class="customize-control-title">
        			<?php _e('More Features and Options', 'vt-grid-mag'); ?>
        		</span>
        	</p>
        	<p class="vt-upgrade-text">
        		<span class="textfield">
        			<?php _e('Check out the Pro Version of this theme which comes with more Great Features, Additional Widgets, Featured Slider and Advanced Customization Options for your website.', 'vt-grid-mag'); ?>
        		</span>
			</p>
			<p class="vt-upgrade-button">
				<a href="http://volthemes.com/theme/vt-grid-mag-pro/?utm_source=vt+grid+mag&amp;utm_campaign=WordPressOrg" target="_blank" class="button button-primary">
					<?php _e('Learn more about Pro Version', 'vt-grid-mag'); ?>
				</a>
			</p><?php
        }
    }
		
	$wp_customize->add_control(
		new vt_grid_mag_Customize_Upgrade_Control(
			$wp_customize,
			'premium_version_upgrade', 
			array(
				'section' => 'vt_upgrade',
				'settings' => 'vt_options[premium_version_upgrade]',
			)
		)
	);
	
}
add_action( 'customize_register', 'vt_grid_mag_register_theme_customizer' );