<?php
/**
 *	@package vt-grid-mag
 *	@since 1.0
 */
function vt_grid_mag_customizer_layouts( $options ) {
	/**
	 *	Add section
	 *--------------------------------------------------------------*/
	$options[] = array(
		  'slug'        => 'layout_section'
		, 'opt_type'    => 'section'
		, 'name'        => esc_html__( 'Layouts', 'vt-grid-mag' )
		, 'priority'    => 31
	);

	/**
	 *	Home Layout
	 *--------------------------------------------------------------*/
	$options[] = array(
		  'slug'        => 'home_layout'
		, 'opt_type'    => 'radio'
		, 'section'     => 'layout_section'
		, 'default'     => 'layout-three-columns'
		, 'sanitize_callback' => 'vt_grid_mag_sanitize_page_layout'
		, 'name'        => esc_html__( 'Home Layout', 'vt-grid-mag' )
		, 'choices'     => array(
			  'layout-two-columns-fully' => esc_html__( 'Grid 2 Columns', 'vt-grid-mag' )
			, 'layout-three-columns'     => esc_html__( 'Grid 3 Columns', 'vt-grid-mag' )
		)
	);

	/**
	 *	Archive Layout
	 *--------------------------------------------------------------*/
	$options[] = array(
		  'slug'        => 'archive_layout'
		, 'opt_type'    => 'radio'
		, 'section'     => 'layout_section'
		, 'default'     => 'layout-three-columns'
		, 'sanitize_callback' => 'vt_grid_mag_sanitize_page_layout'
		, 'name'        => esc_html__( 'Archive Layout', 'vt-grid-mag' )
		, 'choices'     => array(
			  'layout-two-columns-fully' => esc_html__( 'Grid 2 Columns', 'vt-grid-mag' )
			, 'layout-three-columns'     => esc_html__( 'Grid 3 Columns', 'vt-grid-mag' )
		)
	);

	/**
	 *	Sidebar Position
	 *--------------------------------------------------------------*/
	$options[] = array(
		  'slug'        => 'sidebar_position'
		, 'opt_type'    => 'radio'
		, 'section'     => 'layout_section'
		, 'default'     => 'right-sidebar'
		, 'sanitize_callback' => 'vt_grid_mag_sanitize_sidebar_layout'
		, 'name'        => esc_html__( 'Sidebar Position', 'vt-grid-mag' )
		, 'choices'     => array(
			  'right-sidebar' => esc_html__( 'Right Sidebar', 'vt-grid-mag' )
			, 'left-sidebar'  => esc_html__( 'Left Sidebar', 'vt-grid-mag' )
		)
		, 'transport'   => 'refresh'
	);

	return $options;
}
add_filter( 'vt_grid_mag_settings_input', 'vt_grid_mag_customizer_layouts' );