<?php
/**
 * VolThemes Customizer Framework.
 *
 * @version 1.0
 * @author VolThemes
 * @link http://volthemes.com/
 */
/**
 * Define contants.
 *
 * @since 1.0
 */
function vt_grid_mag_define_constants() {
	if( ! defined( 'VT_GRID_MAG_ADMIN_DIR' ) ) {
		define( 'VT_GRID_MAG_ADMIN_DIR', trailingslashit( get_template_directory() . '/admin' ) );
	}
	if( ! defined( 'VT_GRID_MAG_ADMIN_URI' ) ) {
		define( 'VT_GRID_MAG_ADMIN_URI', trailingslashit( get_template_directory_uri() . '/admin/assets' ) );
	}
}
add_action( 'init', 'vt_grid_mag_define_constants' );

/**
 * Load files.
 *
 * @since 1.0
 */
function vt_grid_mag_admin_files() {
	// Customizer Framework.
	include(get_template_directory().'/admin/customizer.php');

	// Custom Controls & Source.
	include(get_template_directory().'/admin/controls/class-sub-title-control.php');

	// Settings input.
	include(get_template_directory().'/admin/settings/color-options.php');
	include(get_template_directory().'/admin/settings/layout-options.php');
	include(get_template_directory().'/admin/settings/social-links.php');
	include(get_template_directory().'/admin/settings/theme-upgrade.php');
	
}
add_action( 'init', 'vt_grid_mag_admin_files' );

/**
 * Get default values.
 *
 * @since 1.0
 */
function vt_grid_mag_option_defaults( $key = 'all' ) {
	$defaults = apply_filters( 'vt_grid_mag_option_defaults', array() );
	if( 'all' != $key ) {
		return isset( $defaults[$key] ) ? $defaults[$key] : NULL;
	}
	return $defaults;
}

/**
 * Retrieve or display value.
 *
 * @since 1.0
 */
function vt_grid_mag( $key = '', $default = null, $echo = false ) {
	$value  = get_theme_mod( $key, $default );
	$output = ( $value != $default ) ? $value : vt_grid_mag_option_defaults( $key );
	if( $echo ) {
		echo $output;
	}
	else {
		return $output;
	}
}