<?php
/**
 * VolThemes Customizer Framework.
 *
 * @version 1.0
 * @author VolThemes
 * @link http://volthemes.com/
 */
class VolThemes_Customizer {
	/**
	 * Create new object.
	 *
	 * @since 1.0
	 */
	public function __construct() {
		// Register WP Customizer.
		add_action( 'customize_register', array( $this, 'register' ) );

		// Enqueue sanitization functions.
		add_action( 'customize_register', array( $this, 'enqueue_sanitization' ) );

		// Custom Controls CSS.
		add_action( 'customize_controls_print_styles', array( $this, 'control_css' ) );

		// Retrieve default values.
		add_filter( 'vt_grid_mag_option_defaults', array( $this, 'get_defaults' ) );

		// CSS output.
		add_action( 'wp_head', array( $this, 'css_output' ) );

	}

	/**
	 * Set args input.
	 *
	 * @since 1.0
	 */
	public function args() {
		$args = array(
			  'slug'                 => ''
			, 'opt_type'             => ''
			, 'name'                 => ''
			, 'description'          => ''
			, 'panel'                => ''
			, 'section'              => ''
			, 'default'              => ''
			, 'priority'             => 160
			, 'capability'           => 'edit_theme_options'
			, 'theme_supports'       => ''
			, 'transport'            => 'refresh'
			, 'sanitize_js_callback' => ''
			, 'choices'              => array()
			, 'input_attrs'          => array()
			, 'css_output'           => array()
			, 'js_mod'               => ''
		);
		return $args;
	}

	/**
	 * Set settings input.
	 *
	 * @since 1.0
	 */
	public function settings_input() {
		return apply_filters( 'vt_grid_mag_settings_input', array() );
	}

	/**
	 * Registers WordPress Customizer.
	 *
	 * @since 1.0
	 */
	public function register( $wp_customize ) {
		$_settings = $this->settings_input();

		foreach( $_settings as $settings ) {

			$settings = wp_parse_args( $settings, self::args() );

			// Add settings.
			if( 'panel' != $settings['opt_type'] || 'section' != $settings['opt_type'] ) {
				$wp_customize->add_setting( $settings['slug'], array(
					  'type'                 => 'theme_mod'
					, 'default'              => $settings['default']
					, 'transport'            => $settings['transport']
					, 'capability'           => $settings['capability']
					, 'sanitize_js_callback' => $settings['sanitize_js_callback']
					, 'theme_supports'       => $settings['theme_supports']
				));
			}

			// Add controls.
			switch ( $settings['opt_type'] ) {
				case 'panel':
					$wp_customize->add_panel( $settings['slug'], array(
						  'title'          => $settings['name']
						, 'priority'       => $settings['priority']
						, 'description'    => $settings['description']
						, 'capability'     => $settings['capability']
						, 'theme_supports' => $settings['theme_supports']
					));
					break;
				
				case 'section':
					$wp_customize->add_section( $settings['slug'], array(
						  'title'          => $settings['name']
						, 'description'    => $settings['description']
						, 'priority'       => $settings['priority']
						, 'capability'     => $settings['capability']
						, 'theme_supports' => $settings['theme_supports']
						, 'panel'          => $settings['panel']
					));
					break;

				case 'sub_title':
					$wp_customize->add_control( new vt_grid_mag_custom_sub_title_control( $wp_customize, $settings['slug'], array(
						  'section'     => $settings['section']
						, 'label'       => $settings['name']
						, 'description' => $settings['description']
						, 'priority'    => $settings['priority']
					)) );
					break;

				case 'image':
					$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, $settings['slug'], array(
						  'section'     => $settings['section']
						, 'type'        => 'image'
						, 'label'       => $settings['name']
						, 'description' => $settings['description']
						, 'choices'     => $settings['choices']
						, 'input_attrs' => $settings['input_attrs']
						, 'priority'    => $settings['priority']
						, 'settings'    => $settings['slug']
					)) );
					break;

				case 'color':
					$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $settings['slug'], array(
						  'section'     => $settings['section']
						, 'type'        => 'color'
						, 'label'       => $settings['name']
						, 'description' => $settings['description']
						, 'choices'     => $settings['choices']
						, 'input_attrs' => $settings['input_attrs']
						, 'priority'    => $settings['priority']
						, 'settings'    => $settings['slug']
					)) );
					break;

				case 'upload':
					$wp_customize->add_control( new WP_Customize_Upload_Control( $wp_customize, $settings['slug'], array(
						  'section'     => $settings['section']
						, 'type'        => 'upload'
						, 'label'       => $settings['name']
						, 'description' => $settings['description']
						, 'choices'     => $settings['choices']
						, 'input_attrs' => $settings['input_attrs']
						, 'priority'    => $settings['priority']
						, 'settings'    => $settings['slug']
					)) );
					break;

				default:
					$wp_customize->add_control( $settings['slug'] , array(
						  'section'              => $settings['section']
						, 'type'                 => $settings['opt_type']
						, 'label'                => $settings['name']
						, 'description'          => $settings['description']
						, 'choices'              => $settings['choices']
						, 'input_attrs'          => $settings['input_attrs']
						, 'priority'             => $settings['priority']
						, 'settings'             => $settings['slug']
					));
					break;
	
			}
		}
		
	}

	/**
	 * Enqueue sanitization functions.
	 *
	 * @since 1.0
	 */
	public function enqueue_sanitization() {
		add_filter( 'sanitize_option_theme_mods_' . get_option( 'stylesheet' ) , array( $this, 'sanitize' ) );
	}

	/**
	 * Sanitizes the setting values.
	 *
	 * @since 1.0
	 */
	public function sanitize( $data ) {
		$_settings = $this->settings_input();
		foreach( $_settings as $settings ) {
			$settings = wp_parse_args( $settings, self::args() );
			$_slug    = $settings['slug'];

			if( ! array_key_exists( $_slug, $data ) ) {
				continue;
			}

			$input    = $data[$_slug];
			$choices  = isset( $settings['choices'] ) ? $settings['choices'] : array();
			$output   = '';

			if( isset( $settings['sanitize_cb'] ) && is_callable( $settings['sanitize_cb'] ) ) {
				$output = call_user_func( $settings['sanitize_cb'], $input );
			}
			else {
				switch ( $settings['opt_type'] ) {
					case 'checkbox':
						$output = ( 1 == $input ) ? 1 : '';
						break;

					case 'number':
						$output = empty( $input ) ? '' : intval( $input );
						break;

					case 'range':
						$output = absint( $input );
						break;

					case 'url':
					case 'image':
					case 'upload':
						$output = esc_url_raw( $input );
						break;

					case 'radio':
					case 'select':
						$output = array_key_exists( $input, $choices ) ? $input : '';
						break;

					case 'text':
					case 'textarea':
						$output = wp_kses_post( force_balance_tags( $input ) );
						break;

					case 'sub_title':
						$output = '';
						break;

					case 'color':
						$output = sanitize_hex_color( $input );
						break;

					default:
						$output = sanitize_text_field( $input );
						break;
				}
			}

			$data[$_slug] = $output;
		}

		return $data;
	}

	/**
	 * Sanitize the page layout options.
	 *
	 * @param string $input Page layout.
	 */
	function vt_grid_mag_sanitize_page_layout( $input ) {
		$valid = array(
			'layout-two-columns-fully' => __( 'Grid 2 Columns', 'vt-grid-mag' ),
			'layout-three-columns' => __( 'Grid 3 Columns', 'vt-grid-mag' ),
		);

		if ( array_key_exists( $input, $valid ) ) {
			return $input;
		}

		return '';
	}

	/**
	 * Sanitize the sidebar layout options.
	 *
	 * @param string $input Page layout.
	 */
	function vt_grid_mag_sanitize_sidebar_layout( $input ) {
		$valid = array(
			'right-sidebar' => __( 'Right Sidebar', 'vt-grid-mag' ),
			'left-sidebar' => __( 'Left Sidebar', 'vt-grid-mag' ),
		);

		if ( array_key_exists( $input, $valid ) ) {
			return $input;
		}

		return '';
	}
	
	/**
	 * Custom WP Customizer Controls CSS.
	 *
	 * @since 1.0
	 */
	public function control_css() {
		if( defined( 'VT_GRID_MAG_ADMIN_URI' ) ) {
			wp_enqueue_style( 'vt-grid-mag-customizer-style', VT_GRID_MAG_ADMIN_URI . 'customizer.css', array(), null );
		}
	}

	/**
	 * Generate CSS.
	 *
	 * @since 1.0
	 */
	public function generate_css( $key = '', $default = '', $selector = '', $style = '', $mix_value = '' ) {
		$value = get_theme_mod( $key, $default );
		$return = '';
		if( !empty( $value ) && $value != $default ) {
			$return = sprintf('%s{%s:%s;}', $selector, $style, $value . $mix_value );
		}
		return $return;
	}

	/**
	 * Print CSS output.
	 */
	public function css_output() {
		$output    = '';
		$_settings = $this->settings_input();
		foreach( $_settings as $settings ) {
			$settings = wp_parse_args( $settings, self::args() );
			if( isset( $settings['css_output'] ) && is_array( $settings['css_output'] ) ) {
				foreach( $settings['css_output'] as $order => $css_output ) {
					$css_output = wp_parse_args( $css_output, array( 'class' => '', 'style' => '', 'val' => '' ) );
					$output    .= self::generate_css( $settings['slug'], $settings['default'], $css_output['class'], $css_output['style'], $css_output['val'] );
				}
			}
		}
		
		$output    = apply_filters( 'vt_grid_mag_customizer_css_output', $output );
		if( ! empty( $output ) ) {
			printf('<style type="text/css">%s</style>' . "\n", $output );
		}
	}

	/**
	 * Retrieve default values.
	 *
	 * @since 1.0
	 */
	public function get_defaults() {
		$output    = array();
		$_settings = $this->settings_input();
		foreach( $_settings as $settings ) {
			$settings = wp_parse_args( $settings, self::args() );
			$output[$settings['slug']] = $settings['default'];
		}
		return $output;
	}

//////////////////////////////////////////////////////////////////
}


/**
 * Return new object.
 *
 * @since 1.0
 */
new VolThemes_Customizer;