<?php
/**
 * Header Style 1
 *
 * @package Chained
 * @since Chained 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
?>

<header id="masthead" class="site-header header-style-1" itemscope itemtype="http://schema.org/WPHeader">

	<div class="wrapper">
		<div class="header-left">
		 	<div class="site-offcanvas-opener">
				<button class="reset" id="offcanvas-navigation-open">
					<span class="screen-reader-text">Menu</span>
					<?php echo get_template_part('assets/images/svg/menu-icon');?>
				</button>
			</div>
			<nav id="site-navigation" class="main-navigation" role="navigation" itemscope itemtype="http://schema.org/SiteNavigationElement">
				<?php
				//the primary menu
				wp_nav_menu( array(
					'theme_location' => 'primary',
					'container'      => '',
					'menu_class'     => 'nav nav--main',
					'fallback_cb' 	 => false,
				
				) ); ?>
				
			</nav>
		</div>

		<div class="site-branding" itemscope itemtype="http://schema.org/Organization">
			<?php echo csl_CustomSiteLogo_show_logo(); ?>
			<?php if ( function_exists( 'jetpack_the_site_logo' ) ) { // display the Site Logo if present
				jetpack_the_site_logo();
			} else {
				the_custom_logo();
			} ?>

			<?php $is_site_title = get_theme_mod('chained_site_identity_show_title', true); ?>

			<?php if ( $is_site_title ) : ?>

				<?php $site_title = get_theme_mod('chained_site_identity_title', 'Chained - Modern Masonry Wordpress Theme for blogs and magazines'); ?>

				<h1 class="site-title" itemprop="name">
					<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home" itemprop="url">
						<?php echo $site_title; ?>
					</a>
				</h1>

			<?php endif; ?>

			<?php $is_description = get_theme_mod('chained_site_identity_show_desc', true); ?>

			<?php if ( $is_description || is_customize_preview() ) : ?>
				<?php $site_description = get_theme_mod('chained_site_identity_desc', 'A different blog or news theme'); ?>

				<h2 class="site-description">
					<span  itemprop="description"  class="site-description-text">
						<?php echo $site_description; ?>
					</span>
				</h2>
			<?php endif; ?>

		</div><!-- .site-branding -->

		<nav id="social-navigation" class="social-navigation" role="navigation" itemscope itemtype="http://schema.org/SiteNavigationElement">
			<?php
			// the social menu
			wp_nav_menu( array(
				'theme_location' => 'social',
				'container'      => '',
				'menu_class'     => 'nav nav--social',
				'link_before'     => '<span class="screen-reader-texts">',
				'link_after'      => '</span>',
				'fallback_cb' => false,
			 ) ); ?>
			
			 <div class="site-search-opener">
			 	<button class="reset" id="offcanvas-search-open">
			 		<?php echo get_template_part('assets/images/svg/search-icon');?>
			 	 </button>
			 </div>
			
		</nav>
	</div>

</header><!-- #masthead -->