<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Tirpitz
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>

<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#main"><?php esc_html_e( 'Skip to content', 'tirpitz' ); ?></a>

	<header id="masthead" class="site-header" role="banner">
	    <div class="social">
	        <?php tirpitz_social_menu() ?>  
	    </div> <!-- end of social -->
		<div class="site-branding">
			<?php echo csl_CustomSiteLogo_show_logo(); ?>
			<?php
			if ( is_front_page() && is_home() ) : ?>
				<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
			<?php else : ?>
				<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
			<?php
			endif;

			$description = get_bloginfo( 'description', 'display' );
			if ( $description || is_customize_preview() ) : ?>
				<p class="site-description"><?php echo $description; /* WPCS: xss ok. */ ?></p>
			<?php
			endif; ?>
		</div><!-- .site-branding -->
        <div id="header-search">
	        <?php 
                get_search_form();
            ?>    
	    </div> <!-- end of search -->
	    
	</header><!-- #masthead -->
	<nav id="site-navigation" class="main-navigation" role="navigation">

			<?php
            //The cssmenu id has been added to the main menu for the Cssmenu to work
            wp_nav_menu(array(
                'theme_location' => 'primary',
                'menu_id' => 'cssmenu',
                'container_id' => 'cssmenu'
            ));

            ?>
    </nav><!-- #site-navigation -->
	
	<div id="content" class="site-content">
