
CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) UNSIGNED NOT NULL,
  `comment_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- --------------------------------------------------------

--
-- Table structure for table `wp_comments`
--

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) UNSIGNED NOT NULL,
  `comment_post_ID` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `user_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Dumping data for table `wp_comments`
--

---
--- INSERT INTO `wp_comments` (`comment_ID`, `comment_post_ID`, `comment_author`, `comment_author_email`, `comment_author_url`, `comment_author_IP`, `comment_date`, `comment_date_gmt`, `comment_content`, `comment_karma`, `comment_approved`, `comment_agent`, `comment_type`, `comment_parent`, `user_id`) VALUES
--- (1, 1, 'A WordPress Commenter', 'wapuu@wordpress.example', 'https://wordpress.org/', '', '2018-07-30 11:09:41', '2018-07-30 11:09:41', 'Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com\">Gravatar</a>.', 0, '1', '', '', 0, 0);
---

-- --------------------------------------------------------

--
-- Table structure for table `wp_links`
--

CREATE TABLE `wp_links` (
  `link_id` bigint(20) UNSIGNED NOT NULL,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) UNSIGNED NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- --------------------------------------------------------

--
-- Table structure for table `wp_options`
--

CREATE TABLE `wp_options` (
  `option_id` bigint(20) UNSIGNED NOT NULL,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Dumping data for table `wp_options`
--

INSERT INTO `wp_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(1, 'siteurl', '{site_url}', 'yes'),
(2, 'home', '{site_url}', 'yes'),
(3, 'blogname', '{blog_name}', 'yes'),
(4, 'blogdescription', '{blog_description}', 'yes'),
(5, 'users_can_register', '0', 'yes'),
(6, 'admin_email', '{admin_email}', 'yes'),
(7, 'start_of_week', '1', 'yes'),
(8, 'use_balanceTags', '0', 'yes'),
(9, 'use_smilies', '1', 'yes'),
(10, 'require_name_email', '1', 'yes'),
(11, 'comments_notify', '1', 'yes'),
(12, 'posts_per_rss', '10', 'yes'),
(13, 'rss_use_excerpt', '0', 'yes'),
(14, 'mailserver_url', 'mail.example.com', 'yes'),
(15, 'mailserver_login', 'login@example.com', 'yes'),
(16, 'mailserver_pass', 'password', 'yes'),
(17, 'mailserver_port', '110', 'yes'),
(18, 'default_category', '1', 'yes'),
(19, 'default_comment_status', 'open', 'yes'),
(20, 'default_ping_status', 'open', 'yes'),
(21, 'default_pingback_flag', '1', 'yes'),
(22, 'posts_per_page', '10', 'yes'),
(23, 'date_format', 'F j, Y', 'yes'),
(24, 'time_format', 'g:i a', 'yes'),
(25, 'links_updated_date_format', 'F j, Y g:i a', 'yes'),
(26, 'comment_moderation', '0', 'yes'),
(27, 'moderation_notify', '1', 'yes'),
(28, 'permalink_structure', '', 'yes'),
(29, 'rewrite_rules', 'a:75:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}', 'yes'),
(30, 'hack_file', '0', 'yes'),
(31, 'blog_charset', 'UTF-8', 'yes'),
(32, 'moderation_keys', '', 'no'),
(33, 'active_plugins', 'a:0:{}', 'yes'),
(34, 'category_base', '', 'yes'),
(35, 'ping_sites', 'http://rpc.pingomatic.com/', 'yes'),
(36, 'comment_max_links', '2', 'yes'),
(37, 'gmt_offset', '0', 'yes'),
(38, 'default_email_category', '1', 'yes'),
(39, 'recently_edited', '', 'no'),
(40, 'template', '{template}', 'yes'),
(41, 'stylesheet', '{stylesheet}', 'yes'),
(42, 'comment_whitelist', '1', 'yes'),
(43, 'blacklist_keys', '', 'no'),
(44, 'comment_registration', '0', 'yes'),
(45, 'html_type', 'text/html', 'yes'),
(46, 'use_trackback', '0', 'yes'),
(47, 'default_role', 'subscriber', 'yes'),
(48, 'db_version', '38590', 'yes'),
(49, 'uploads_use_yearmonth_folders', '1', 'yes'),
(50, 'upload_path', '', 'yes'),
(51, 'blog_public', '1', 'yes'),
(52, 'default_link_category', '2', 'yes'),
(53, 'show_on_front', 'posts', 'yes'),
(54, 'tag_base', '', 'yes'),
(55, 'show_avatars', '1', 'yes'),
(56, 'avatar_rating', 'G', 'yes'),
(57, 'upload_url_path', '', 'yes'),
(58, 'thumbnail_size_w', '150', 'yes'),
(59, 'thumbnail_size_h', '150', 'yes'),
(60, 'thumbnail_crop', '1', 'yes'),
(61, 'medium_size_w', '300', 'yes'),
(62, 'medium_size_h', '300', 'yes'),
(63, 'avatar_default', 'mystery', 'yes'),
(64, 'large_size_w', '1024', 'yes'),
(65, 'large_size_h', '1024', 'yes'),
(66, 'image_default_link_type', 'none', 'yes'),
(67, 'image_default_size', '', 'yes'),
(68, 'image_default_align', '', 'yes'),
(69, 'close_comments_for_old_posts', '0', 'yes'),
(70, 'close_comments_days_old', '14', 'yes'),
(71, 'thread_comments', '1', 'yes'),
(72, 'thread_comments_depth', '5', 'yes'),
(73, 'page_comments', '0', 'yes'),
(74, 'comments_per_page', '50', 'yes'),
(75, 'default_comments_page', 'newest', 'yes'),
(76, 'comment_order', 'asc', 'yes'),
(77, 'sticky_posts', 'a:0:{}', 'yes'),
(78, 'widget_categories', 'a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}', 'yes'),
(79, 'widget_text', 'a:0:{}', 'yes'),
(80, 'widget_rss', 'a:0:{}', 'yes'),
(81, 'uninstall_plugins', 'a:0:{}', 'no'),
(82, 'timezone_string', '', 'yes'),
(83, 'page_for_posts', '0', 'yes'),
(84, 'page_on_front', '0', 'yes'),
(85, 'default_post_format', '0', 'yes'),
(86, 'link_manager_enabled', '0', 'yes'),
(87, 'finished_splitting_shared_terms', '1', 'yes'),
(88, 'site_icon', '0', 'yes'),
(89, 'medium_large_size_w', '768', 'yes'),
(90, 'medium_large_size_h', '0', 'yes'),
(91, 'wp_page_for_privacy_policy', '3', 'yes'),
(92, 'initial_db_version', '38590', 'yes'),
(93, 'wp_user_roles', 'a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:61:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}', 'yes'),
(94, 'fresh_site', '1', 'yes'),
(95, 'widget_search', 'a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
(96, 'widget_recent-posts', 'a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}', 'yes'),
(97, 'widget_recent-comments', 'a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}', 'yes'),
(98, 'widget_archives', 'a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}', 'yes'),
(99, 'widget_meta', 'a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
(100, 'sidebars_widgets', 'a:5:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}s:13:\"array_version\";i:3;}', 'yes'),
(101, 'widget_pages', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(102, 'widget_calendar', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(103, 'widget_media_audio', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(104, 'widget_media_image', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(105, 'widget_media_gallery', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(106, 'widget_media_video', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(107, 'widget_tag_cloud', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(108, 'widget_nav_menu', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(109, 'widget_custom_html', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(110, 'cron', 'a:3:{i:1533125382;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1533164982;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}s:7:\"version\";i:2;}', 'yes'),
(111, 'theme_mods_twentyseventeen', 'a:1:{s:18:\"custom_css_post_id\";i:-1;}', 'yes'),
(115, '_site_transient_update_core', 'O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.9.7.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.9.7.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.9.7-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.9.7-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.9.7\";s:7:\"version\";s:5:\"4.9.7\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1533124097;s:15:\"version_checked\";s:5:\"4.9.7\";s:12:\"translations\";a:0:{}}', 'no'),
(120, '_site_transient_update_themes', 'O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1533124101;s:7:\"checked\";a:3:{s:13:\"twentyfifteen\";s:3:\"2.0\";s:15:\"twentyseventeen\";s:3:\"1.6\";s:13:\"twentysixteen\";s:3:\"1.5\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}}', 'no'),
(122, '_site_transient_timeout_browser_ba69531e76c1a03fc1ec8687c568904e', '1533553793', 'no'),
(123, '_site_transient_browser_ba69531e76c1a03fc1ec8687c568904e', 'a:10:{s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"62.0\";s:8:\"platform\";s:5:\"Linux\";s:10:\"update_url\";s:24:\"https://www.firefox.com/\";s:7:\"img_src\";s:44:\"http://s.w.org/images/browsers/firefox.png?1\";s:11:\"img_src_ssl\";s:45:\"https://s.w.org/images/browsers/firefox.png?1\";s:15:\"current_version\";s:2:\"56\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}', 'no'),
(124, 'can_compress_scripts', '0', 'no'),
(125, '_site_transient_timeout_community-events-1aecf33ab8525ff212ebdffbb438372e', '1532992195', 'no'),
(126, '_site_transient_community-events-1aecf33ab8525ff212ebdffbb438372e', 'a:2:{s:8:\"location\";a:1:{s:2:\"ip\";s:9:\"127.0.0.0\";}s:6:\"events\";a:2:{i:0;a:7:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:50:\"[Free Workshop] Facebook Marketing for WooCommerce\";s:3:\"url\";s:60:\"https://www.meetup.com/WordPress-New-Delhi/events/253186417/\";s:6:\"meetup\";s:32:\"WordPress Delhi NCR Meetup Group\";s:10:\"meetup_url\";s:43:\"https://www.meetup.com/WordPress-New-Delhi/\";s:4:\"date\";s:19:\"2018-08-05 15:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:12:\"Delhi, India\";s:7:\"country\";s:2:\"in\";s:8:\"latitude\";d:28.70385;s:9:\"longitude\";d:77.13377;}}i:1;a:7:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:15:\"WordCamp Kanpur\";s:3:\"url\";s:32:\"https://2018.kanpur.wordcamp.org\";s:6:\"meetup\";N;s:10:\"meetup_url\";N;s:4:\"date\";s:19:\"2018-08-12 00:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:29:\"Kanpur, Uttar Pradesh, India.\";s:7:\"country\";s:2:\"IN\";s:8:\"latitude\";d:26.4717124;s:9:\"longitude\";d:80.303633;}}}}', 'no'),
(127, '_transient_timeout_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca', '1532992197', 'no');
INSERT INTO `wp_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(128, '_transient_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca', 'a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"\n	Tue, 17 Jul 2018 14:45:38 +0000	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=5.0-alpha-43542\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Quarterly Updates | Q2 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/news/2018/07/quarterly-updates-q2-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 Jul 2018 14:50:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Updates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6140\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:347:\"To keep everyone aware of big projects and efforts across WordPress contributor teams, I&#8217;ve reached out to each team&#8217;s listed representatives. I asked each of them to share their Top Priority (and when they hope for it to be completed), as well as their biggest Wins and Worries. Have questions? I&#8217;ve included a link to [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Josepha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:15622:\"<p><em>To keep everyone aware of big projects and efforts across WordPress contributor teams, I&#8217;ve reached out to each team&#8217;s <a href=\"https://make.wordpress.org/updates/team-reps/\">listed representatives</a>. I asked each of them to share their Top Priority (and when they hope for it to be completed), as well as their biggest Wins and Worries. Have questions? I&#8217;ve included a link to each team&#8217;s site in the headings.﻿</em></p>\n\n<h2><a href=\"https://make.wordpress.org/accessibility/\">Accessibility</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/rianrietveld/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rianrietveld</a>, <a href=\'https://profiles.wordpress.org/joedolson/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>joedolson</a>, <a href=\'https://profiles.wordpress.org/afercia/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>afercia</a></li>\n	<li><strong>Priority</strong>: Working to make sure that Gutenberg is reasonably accessible prior to merge. ETA is before 5.0</li>\n	<li><strong>Struggle</strong>: Lack of developers and accessibility experts to help test and code the milestone issues. <em>The team is doing outreach to help solve this problem.</em></li>\n	<li><strong>Big Win</strong>: Interest from companies like The Paciello Group and Tenon.io to help out with Gutenberg code review and testing tools.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/cli/\">CLI</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: @danielbachhuber, <a href=\'https://profiles.wordpress.org/schlessera/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>schlessera</a></li>\n	<li><strong>Priority</strong>: Very first global <a href=\"https://make.wordpress.org/cli/2018/07/04/wp-cli-hack-day/\">Hack Day</a> is coming up July 20. Version 2.0.0 is still in progress (new <a href=\"https://github.com/wp-cli/wp-cli/issues/4752\">ETA</a> is end of July).</li>\n	<li><strong>Struggle</strong>: The team continues to need new contributors. The current team is tiny but tough.</li>\n	<li><strong>Big Win</strong>: WP-CLI is currently one of the project&#8217;s four main focuses, as mentioned in the Summer Update at WordCamp Europe.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/community/\">Community</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/francina/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>francina</a>, <a href=\'https://profiles.wordpress.org/hlashbrooke/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>hlashbrooke</a></li>\n	<li><strong>Priority</strong>: Focusing on smoothing out the processes in our community management by building up our team of volunteers and establishing what tools we need to keep things running well. ETA is ongoing.</li>\n	<li><strong>Struggle</strong>: Our two biggest struggles at the moment are tracking what we need to get done, and making final decisions on things. <em>There is current work on the tools available to assist with tracking progress.﻿</em></li>\n	<li><strong>Big Win</strong>: After making a concerted effort to get more contributors on the Community Team, we now have a much larger group of volunteers working as deputies and WordCamp mentors</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/core/\">Core</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/jeffpaul/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jeffpaul</a></li>\n	<li><strong>Priority</strong>: Following the <a href=\"https://wordpress.tv/2018/07/04/matt-mullenweg-a-summertime-update-keynote-and-qa/\">WordCamp Europe summer update</a> ﻿(and the companion post <a href=\"https://wordpress.org/news/2018/07/update-on-gutenberg/\">here</a>), the team is getting Gutenberg (the new WordPress editing experience) into a strong state for the 5.0 release. Potential ETA as soon as August.</li>\n	<li><strong>Struggle</strong>: Coordinating momentum and direction as we start seeing more contributors offering their time. Still working our way through open issues. <em>﻿The team is starting multiple bug scrubs each week to work through these more quickly and transparently.</em></li>\n	<li><strong>Big Win</strong>: Had a <a href=\"https://wordpress.org/news/2018/05/wordpress-4-9-6-privacy-and-maintenance-release/\">sizable release in 4.9.6</a> which featured major updates around privacy tools and functionality in Core.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/design/\">Design</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/melchoyce/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>melchoyce</a>, <a href=\'https://profiles.wordpress.org/karmatosed/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>karmatosed</a>, <a href=\'https://profiles.wordpress.org/boemedia/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>boemedia</a>, <a href=\'https://profiles.wordpress.org/joshuawold/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>joshuawold</a>, <a href=\'https://profiles.wordpress.org/mizejewski/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mizejewski</a></li>\n	<li><strong>Priority</strong>: Better on-boarding of new contributors, especially creating better documentation. ETA is end of July.</li>\n	<li><strong>Struggle</strong>: It&#8217;s hard to identify reasonably small tasks for first-time contributors.</li>\n	<li><strong>Big Win</strong>: The team is much more organized now which has helped clear out the design backlog, bring in new contributors, and also keep current contributors coming back. <em>Bonus: Joshua Wold will co-lead the upcoming release.</em></li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/docs/\">Documentation</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/kenshino/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>kenshino</a><br /></li>\n	<li><strong>Priority</strong>: Opening up the work on <a href=\"https://make.wordpress.org/docs/2018/02/26/state-of-helphub-february-2018/\">HelpHub</a> to new contributors and easing the onboarding process. No ETA.<br /></li>\n	<li><strong>Struggle</strong>: Some blockers with making sure the code and database can be ready to launch on https://wordpress.org/support/<br /></li>\n	<li><strong>Big Win</strong>: The <a href=\"https://wp-helphub.com/\">first phase of HelpHub</a> creation is complete, which means content updates (current info, more readable, easier discovery), internal search, design improvements, and REST API endpoints.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/hosting/\">Hosting</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/mikeschroder/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mikeschroder</a>, <a href=\'https://profiles.wordpress.org/jadonn/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jadonn</a></li>\n	<li><strong>Priority</strong>: Preparing hosts for supporting Gutenberg, especially support questions they&#8217;re likely to see when the &#8220;Try Gutenberg&#8221; callout is released. ETA July 31st, then before WordPress 5.0<br /><strong></strong></li>\n	<li><strong>Struggle</strong>: Most contributions are still made a by a small team of volunteers. Seeing a few more people join, but progress is slow.<br /><strong></strong></li>\n	<li><strong>﻿Big Win</strong>: New team members and hosting companies have joined the #hosting-community team and have started contributing.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/marketing/\">Marketing</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/bridgetwillard/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>bridgetwillard</a></li>\n	<li><strong>Priority</strong>: Continuing to write and publish case studies from the community. ETA is ongoing.</li>\n	<li><strong>Struggle</strong>: No current team struggles.</li>\n	<li><strong>Big Win</strong>: Wrote and designed a short <a href=\"https://make.wordpress.org/marketing/2018/04/24/contributor-day-onboarding-pdf/\">Contributor Day onboarding card</a>. It was used at Contributor Day at WCEU and onboarding time went down to 1 hour instead of 3 hours.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/meta/\">Meta</a> (WordPress.org Site)</h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/tellyworth/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>tellyworth</a>, <a href=\'https://profiles.wordpress.org/coffee2code/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>coffee2code</a></li>\n	<li><strong>Priority</strong>: Reducing manual work around the contributor space (theme review, GDPR/privacy, plugin review). ETA for small wins is end of quarter, larger efforts after that.</li>\n	<li><strong>Struggle</strong>: Maintaining momentum on tickets. <em>There are also some discussions about updating the ticket management process across teams that use the Meta trac system.</em></li>\n	<li><strong>Big Win</strong>: The new About page launched and has been translated across most locale sites.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/mobile/\">Mobile</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/elibud/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>elibud</a></li>\n	<li><strong>Priority</strong>: Getting Gutenberg in the mobile applications. ETA is late December.</li>\n	<li><strong>Struggle</strong>: Consuming the Gutenberg source in the ReactNative app directly. <em>More info can be found here: https://make.wordpress.org/mobile/2018/07/09/next-steps-for-gutenberg-mobile/</em></li>\n	<li><strong>Big Win</strong>: The WordPress mobile applications now fully support right-to-left languages and are compliant with the latest standards for accessibility.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/plugins/\">Plugins</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/ipstenu/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ipstenu</a></li>\n	<li><strong>Priority</strong>: Clearing ~8,000 unused plugins from the queues. Likely ETA is September.<br /></li>\n	<li><strong>Struggles</strong>: Had to triage a lot of false claims around plugins offering GDPR compliance.</li>\n	<li><strong>Big Win</strong>: Released 4.9.6 and <a href=\"https://make.wordpress.org/plugins/2018/05/17/wp-4-9-6-privacy-hooks-and-you/\">updated expectations</a> with plugin authors. Huge thanks to the Core Privacy team for their hard work on this.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/polyglots/\">Polyglots</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/petya/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>petya</a>, <a href=\'https://profiles.wordpress.org/ocean90/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ocean90</a>, <a href=\'https://profiles.wordpress.org/nao/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>nao</a>, <a href=\'https://profiles.wordpress.org/chantalc/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chantalc</a>, <a href=\'https://profiles.wordpress.org/deconf/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>deconf</a>, <a href=\'https://profiles.wordpress.org/casiepa/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>casiepa</a></li>\n	<li><strong>Priority</strong>: Keep WordPress releases translated to 100% and then concentrate on the top 100 plugins and themes. ETA is ongoing.<br /><strong></strong></li>\n	<li><strong>﻿Struggle</strong>: Getting new PTEs fast enough, and complex tools/systems. Overall, the volume of strings awaiting approval.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/support/\">Support</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/clorith/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>clorith</a></li>\n	<li><strong>Priority:</strong> Getting ready for the Gutenberg callout (it got pushed last quarter). Needing a better presence on the official support forums, and outreach for that is underway, ETA end of July. <br /></li>\n	<li><strong>Struggle</strong>: Keeping contributors participating post-contributor days/drives. <em>﻿Considering the creation of a dedicated post-contributor day survey to get some insight here.</em></li>\n	<li><strong>Big Win</strong>: The increase in international liaisons joining for weekly meetings, helping bring the wider support community together.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/themes/\">Theme Review</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/acosmin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>acosmin</a>, <a href=\'https://profiles.wordpress.org/rabmalin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rabmalin</a>, <a href=\'https://profiles.wordpress.org/thinkupthemes/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>thinkupthemes</a>, <a href=\'https://profiles.wordpress.org/williampatton/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>williampatton</a></li>\n	<li><strong>Priority</strong>: Building a better Theme Check/Sniffer in order to automate most of the checks done right now by reviewers. ETA late 2018, early 2019.</li>\n	<li><strong>Struggle</strong>: Bringing in new contributors to the team.</li>\n	<li><strong>Big Win</strong>: <a href=\"https://make.wordpress.org/themes/2018/04/30/trusted-authors-program/\">Trusted Authors program﻿</a></li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/tide/\">Tide</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/valendesigns/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>valendesigns</a> (but usually <a href=\'https://profiles.wordpress.org/jeffpaul/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jeffpaul</a>)</li>\n	<li><strong>Priority</strong>: Storing PHPCompatibilty results inside the WordPress.org API and building a UI to display those results, an endpoint to request an audit is required for this work to continue.</li>\n	<li><strong>Struggle</strong>: Development has dramatically slowed down while team members are on leave or pulled into internal client work.</li>\n	<li><strong>Big Win</strong>: Migration to Google Cloud Platform (GCP) from Amazon Web Services (AWS) is complete and the audit servers have all been rewritten in Go. (This allows us to be faster with greater capacity and less cost.)</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/training/\">Training</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/bethsoderberg/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>bethsoderberg</a>, <a href=\'https://profiles.wordpress.org/juliek/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>juliek</a></li>\n	<li><strong>Priority:</strong> Lesson plan production. ETA is ongoing.</li>\n	<li><strong>Struggle:</strong> The workflow is a little complex, so recruiting and training enough contributors to keep the process moving is a struggle.</li>\n	<li><strong>Big Win</strong>: WordCamp Europe&#8217;s Contributor Day was very productive. New tools/workflow are in place and two team representatives were there to lead and help.</li>\n</ul>\n\n<p><em>Interested in updates from the first quarter of this year? You can find those here: <a href=\"https://make.wordpress.org/updates/2018/04/24/quarterly-updates-q1-2018/\"><em>https://make.wordpress.org/updates/2018/04/24/quarterly-updates-q1-2018/</em></a>\n	</em>\n</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6140\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Update on Gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/news/2018/07/update-on-gutenberg/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 Jul 2018 19:23:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:5:\"Focus\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:9:\"Gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6118\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:328:\"Progress on the Gutenberg project, the new content creating experience coming to WordPress, has come a long way. Since the start of the project, there have been 30 releases and 12 of those happened after WordCamp US 2017. In total since then, there have been 1,764 issues opened and 1,115 closed as of WordCamp Europe. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Tammie Lister\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2261:\"<p>Progress on the Gutenberg project, the new content creating experience coming to WordPress, has come a long way. Since the start of the project, there have been 30 releases and 12 of those happened after WordCamp US 2017. In total since then, there have been 1,764 issues opened and 1,115 closed as of WordCamp Europe. As the work on phase one moves into its final stretch, here is what you can expect.<br /></p>\n\n<h4>In Progress</h4>\n\n<ul>\n	<li>Freeze new features in Gutenberg (the feature list can be found <a href=\"https://github.com/WordPress/gutenberg/issues/4894\">here</a>).</li>\n	<li>Hosts, agencies, teachers invited to opt-in sites they have influence over.</li>\n	<li>WordPress.com has opt-in for wp-admin users. The number of sites and posts will be tracked.</li>\n	<li>Mobile app support for Gutenberg will be across iOS and Android.</li>\n</ul>\n\n<h4>July</h4>\n\n<ul>\n	<li>4.9.x release with an invitation to install either Gutenberg or Classic Editor plugin.</li>\n	<li>WordPress.com will move to opt-out. There will be tracking to see who opts out and why.</li>\n	<li>Triage increases and bug gardening escalates to get blockers in Gutenberg down to zero.</li>\n	<li>Gutenberg phase two, Customization exploration begins by moving beyond the post.</li>\n</ul>\n\n<h4>August and beyond</h4>\n\n<ul>\n	<li>All critical issues within Gutenberg are resolved.</li>\n	<li>There is full integration with Calypso and there is opt-in for users there.</li>\n	<li>A goal will be 100k+ sites having made 250k+ posts using Gutenberg.</li>\n	<li>Core merge of Gutenberg begins the 5.0 release cycle.</li>\n	<li>5.0 moves into beta releases and translations are completed.</li>\n	<li>There will be a mobile version of Gutenberg by the end of the year.</li>\n</ul>\n\n<p>WordPress 5.0 could be as soon as August with hundreds of thousands of sites using Gutenberg before release. Learn more about Gutenberg <a href=\"https://wordpress.org/gutenberg/\">here</a>, take it for a <a href=\"https://testgutenberg.com/\">test drive</a>, <a href=\"https://wordpress.org/plugins/gutenberg/\">install</a> on your site, follow along on <a href=\"https://github.com/WordPress/gutenberg\">GitHub</a> and give your <a href=\"https://wordpressdotorg.polldaddy.com/s/gutenberg-support\">feedback</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6118\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 4.9.7 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wordpress.org/news/2018/07/wordpress-4-9-7-security-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 05 Jul 2018 17:00:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6091\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:360:\"WordPress 4.9.7 is now available. This is a security and maintenance release for all versions since WordPress 3.7. We strongly encourage you to update your sites immediately. WordPress versions 4.9.6 and earlier are affected by a media issue that could potentially allow a user with certain capabilities to attempt to delete files outside the uploads [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Aaron D. Campbell\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3984:\"<p>WordPress 4.9.7 is now available. This is a <strong>security and maintenance release</strong> for all versions since WordPress 3.7. We strongly encourage you to update your sites immediately.</p>\n\n<p>WordPress versions 4.9.6 and earlier are affected by a media issue that could potentially allow a user with certain capabilities to attempt to delete files outside the uploads directory.</p>\n\n<p>Thank you to <a href=\"https://hackerone.com/slavco\">Slavco</a> for reporting the original issue and <a href=\"https://www.wordfence.com/\">Matt Barry</a> for reporting related issues.</p>\n\n<p>Seventeen other bugs were fixed in WordPress 4.9.7. Particularly of note were:</p>\n\n<ul>\n	<li>Taxonomy: Improve cache handling for term queries.</li>\n	<li>Posts, Post Types: Clear post password cookie when logging out.</li>\n	<li>Widgets: Allow basic HTML tags in sidebar descriptions on Widgets admin screen.</li>\n	<li>Community Events Dashboard: Always show the nearest WordCamp if one is coming up, even if there are multiple Meetups happening first.</li>\n	<li>Privacy: Make sure default privacy policy content does not cause a fatal error when flushing rewrite rules outside of the admin context.</li>\n</ul>\n\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.9.7</a> or venture over to Dashboard → Updates and click &#8220;Update Now.&#8221; Sites that support automatic background updates are already beginning to update automatically.</p>\n\n<p>The previously scheduled 4.9.7 is now referred to as 4.9.8, and will follow the <a href=\"https://make.wordpress.org/core/2018/07/04/dev-chat-summary-july-4th-4-9-7-week-7/\">release schedule posted yesterday</a>.</p>\n\n<p>Thank you to everyone who contributed to WordPress 4.9.7:</p>\n\n<p><a href=\"https://profiles.wordpress.org/1naveengiri/\">1naveengiri</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/abdullahramzan/\">abdullahramzan</a>, <a href=\"https://profiles.wordpress.org/alejandroxlopez/\">alejandroxlopez</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/aryamaaru/\">Arun</a>, <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/bjornw/\">BjornW</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/chetan200891/\">Chetan Prajapati</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/garetharnold/\">Gareth</a>, <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/ianbelanger/\">ibelanger</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a>, <a href=\"https://profiles.wordpress.org/khaihong/\">khaihong</a>, <a href=\"https://profiles.wordpress.org/lbenicio/\">lbenicio</a>, <a href=\"https://profiles.wordpress.org/leanderiversen/\">Leander Iversen</a>, <a href=\"https://profiles.wordpress.org/mermel/\">mermel</a>, <a href=\"https://profiles.wordpress.org/metalandcoffee/\">metalandcoffee</a>, <a href=\"https://profiles.wordpress.org/jbpaul17/\">Migrated to @jeffpaul</a>, <a href=\"https://profiles.wordpress.org/palmiak/\">palmiak</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/skoldin/\">skoldin</a>, <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a>, <a href=\"https://profiles.wordpress.org/itowhid06/\">Towhidul Islam</a>, <a href=\"https://profiles.wordpress.org/warmlaundry/\">warmlaundry</a>, and <a href=\"https://profiles.wordpress.org/yuriv/\">YuriV</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6091\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"The Month in WordPress: June 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wordpress.org/news/2018/07/the-month-in-wordpress-june-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 Jul 2018 09:28:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6087\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:366:\"With one of the two flagship WordCamp events taking place this month, as well as some important WordPress project announcements, there’s no shortage of news. Learn more about what happened in the WordPress community in June. Another Successful WordCamp Europe On June 14th, WordCamp Europe kicked off three days of learning and contributions in Belgrade. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4627:\"<p>With one of the two flagship WordCamp events taking place this month, as well as some important WordPress project announcements, there’s no shortage of news. Learn more about what happened in the WordPress community in June.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Another Successful WordCamp Europe</h2>\n\n<p>On June 14th, WordCamp Europe kicked off three days of learning and contributions in Belgrade. Over 2,000 people attended in person, with hundreds more watching live streams of the sessions.</p>\n\n<p>The WordCamp was a great success with plenty of first-time attendees and new WordPress contributors getting involved in the project and community. Recorded sessions from the 65 speakers at the event will be available on WordPress.tv in the coming weeks. In the meantime, check out the <a href=\"https://www.flickr.com/photos/wceu/albums\">photos from the event</a>.</p>\n\n<p><a href=\"https://2018.europe.wordcamp.org/2018/06/16/wordcamp-europe-2019/\">The next WordCamp Europe</a> takes place on June 20-22 2019 in Berlin, Germany. If you’re based in Europe and would like to serve on the organizing team, <a href=\"https://2019.europe.wordcamp.org/2018/06/16/call-wordcamp-europe-2019-organizers/\">fill in the application form</a>.</p>\n\n<h2>Updated Roadmap for the New WordPress Content Editor</h2>\n\n<p>During his keynote session at WordCamp Europe, Matt Mullenweg presented <a href=\"https://gutenbergtimes.com/mullenweg-on-gutenberg-roll-out-plan/\">an updated roadmap</a> for <a href=\"https://wordpress.org/gutenberg/\">Gutenberg</a>, the new content editor coming in WordPress 5.0.</p>\n\n<p>While the editor is in rapid development, <a href=\"https://make.wordpress.org/core/2018/06/21/whats-new-in-gutenberg-21st-june/\">with v3.1 being released this past month</a>, the team is aiming to ship Gutenberg with WordPress Core in August, 2018. This is not set in stone — the release date may shift as development progresses — but this gives the first realistic idea of when we can expect the editor to be released.</p>\n\n<p>If you would like to contribute to Gutenberg, read <a href=\"https://wordpress.org/gutenberg/handbook/\">the handbook</a>, follow the <a href=\"https://make.wordpress.org/core/\">Core team blog</a>, and join the #core-editor channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<h2>WordCamp Incubator Cities Announced</h2>\n\n<p>The WordCamp Incubator program helps spread WordPress to underserved communities by providing organizing support for their first WordCamp. The first iteration of this program ran successfully in 2016 and empowered three cities to start their own WordPress communities.</p>\n\n<p>This year, the Community Team is running the Incubator program again. After receiving applications from 104 communities, <a href=\"https://make.wordpress.org/community/2018/06/26/wordcamp-incubator-program-2018-locations-announcement/\">they have selected</a> Montevideo, Uruguay and Kota Kinabalu, Malaysia to participate in the program. Both cities will receive direct help from experienced WordCamp organizers to run their first-ever WordCamp as a way to help their WordPress community get started.</p>\n\n<p>To find out more about the Incubator program follow the <a href=\"https://make.wordpress.org/community/\">Community team blog</a>, and join the #community-events channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Further Reading:</h2>\n\n<ul>\n	<li>The WordPress community of Spain recently <a href=\"https://twitter.com/wp_es/status/1004681694660603904\">received an award</a> for being the best open-source community in the country.</li>\n	<li>This month, WordPress reached <a href=\"https://w3techs.com/technologies/details/cm-wordpress/all/all\">the milestone of powering 31% of websites</a>.</li>\n	<li><a href=\"https://wprig.io/introducing-wprig-wordpress/\">WP Rig</a> is a brand new tool to help WordPress developers build better themes.</li>\n	<li><a href=\"https://richtabor.com/gutenberg-block-unit-test/\">Block Unit Test</a> is a new plugin to help theme developers prepare for Gutenberg.</li>\n	<li>Near the end of the month, Zac Gordon hosted <a href=\"https://javascriptforwp.com/conference/\">an online conference</a> focused on JavaScript development in WordPress &#8211; the session videos will be available on YouTube soon.</li>\n</ul>\n\n<p><em>If you have a story we should consider including in the next “Month in WordPress” post, please <a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\">submit it here</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6087\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"The Month in WordPress: May 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2018/06/the-month-in-wordpress-may-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 01 Jun 2018 09:09:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6065\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:360:\"This month saw two significant milestones in the WordPress community — the 15th anniversary of the project, and GDPR-related privacy tools coming to WordPress Core. Read on to find out more about this and everything else that happened in the WordPress community in May. Local Communities Celebrate the 15th Anniversary of WordPress Last Sunday, May [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4537:\"<p>This month saw two significant milestones in the WordPress community — the 15th anniversary of the project, and GDPR-related privacy tools coming to WordPress Core. Read on to find out more about this and everything else that happened in the WordPress community in May.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Local Communities Celebrate the 15th Anniversary of WordPress</h2>\n\n<p>Last Sunday, May 27, WordPress turned 15 years old. This is a noteworthy occasion for an open-source project like WordPress and one well worth celebrating. To mark the occasion, <a href=\"https://wp15.wordpress.net/\">WordPress communities across the world gathered</a> for parties and meetups in honor of the milestone.</p>\n\n<p>Altogether, there were 224 events globally, with <a href=\"https://wp15.wordpress.net/about/\">a few more of those still scheduled</a> to take place in some communities — attend one in your area if you can.</p>\n\n<p>If your city doesn’t have a WordPress meetup group, this is a great opportunity to start one! Learn how with <a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/welcome/\">the Meetup Organizer Handbook</a>, and join the #community-events channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<h2>Privacy Tools added to WordPress core</h2>\n\n<p>In light of recent changes to data privacy regulations in the EU, WordPress Core shipped important updates <a href=\"https://wordpress.org/news/2018/05/wordpress-4-9-6-privacy-and-maintenance-release/\">in the v4.9.6 release</a>, giving site owners tools to help them comply with the new General Data Protection Regulation (GDPR). It is worth noting, however, that WordPress cannot ensure you are compliant — this is still a site owner’s responsibility.</p>\n\n<p>The new privacy tools include a number of features focused on providing privacy and personal data management to all site users — asking commenters for explicit consent to store their details in a cookie, providing site owners with an easy way to publish a Privacy Policy, and providing data export and erasure tools to all site users that can be extended by plugins to allow the handling of data that they introduce.</p>\n\n<p>To find out more about these features and the other updates, read the <a href=\"https://make.wordpress.org/core/2018/05/17/4-9-6-update-guide/\">4.9.6 update guide</a>. You can also get involved in contributing to this part of WordPress Core by jumping into the #core-privacy channel in the<a href=\"https://make.wordpress.org/chat/\"> Making WordPress Slack group</a>, and following<a href=\"https://make.wordpress.org/core/\"> the Core team blog</a>.</p>\n\n<h2>Updates to the WordPress.org Privacy Policy</h2>\n\n<p>In a similar vein, WordPress.org itself has received <a href=\"https://wordpress.org/about/privacy/\">an updated Privacy Policy</a> to make clear what is being tracked and how your data is handled. Along with that, a <a href=\"https://wordpress.org/about/privacy/cookies/\">Cookie Policy</a> has also been added to explain just what is collected and stored in your browser when using the site.</p>\n\n<p>These policies cover all sites on the WordPress.org network — including WordPress.org, WordPress.net, WordCamp.org, BuddyPress.org, bbPress.org, and other related domains and subdomains. It’s important to note that this does not mean that anything has changed in terms of data storage; rather that these documents clarify what data is stored and how it is handled.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Further Reading:</h2>\n\n<ul>\n	<li>WordCamp US 2018 has <a href=\"https://2018.us.wordcamp.org/2018/05/29/speak-at-wordcamp-us/\">opened up speaker submissions</a> for the December event.</li>\n	<li><a href=\"https://2018.europe.wordcamp.org/2018/05/15/wceu-live-stream-tickets/\">Live stream tickets are now available for WordCamp Europe</a>, happening on June 14-16.</li>\n	<li>Gutenberg, the new editor for WordPress Core, is getting ever closer to the final stages with <a href=\"https://make.wordpress.org/core/2018/05/18/whats-new-in-gutenberg-18th-may/\">a major update</a> this month.</li>\n	<li>In preparation for Gutenberg, <a href=\"https://core.trac.wordpress.org/changeset/43309\">significant work has been done</a> to improve WordPress Core’s build process.</li>\n</ul>\n\n<p><em>If you have a story we should consider including in the next “Month in WordPress” post, please <a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\">submit it here</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6065\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"WordPress.org Privacy Policy Updates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://wordpress.org/news/2018/05/wordpress-org-privacy-policy-updates/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 25 May 2018 08:06:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"privacy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6047\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:325:\"The WordPress.org privacy policy has been updated, hurray! While we weren&#8217;t able to remove all the long sentences, we hope you find the revisions make it easier to understand: how we collect and use data, how long the data we collect is retained, and how you can request a copy of the data you&#8217;ve shared [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Andrea Middleton\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:657:\"<p>The <a href=\"https://wordpress.org/about/privacy/\">WordPress.org privacy policy</a> has been updated, hurray! While we weren&#8217;t able to remove <strong>all</strong> the long sentences, we hope you find the revisions make it easier to understand:</p>\n<ul>\n<li>how we collect and use data,</li>\n<li>how long the data we collect is retained, and</li>\n<li>how you can request a copy of the data you&#8217;ve shared with us.</li>\n</ul>\n<p>There hasn&#8217;t been any change to the data that WordPress.org collects or how that data is used; the privacy policy just provides more detail now. Happy reading, and thanks for using WordPress!</p>\n<p>&nbsp;</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6047\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress 4.9.6 Privacy and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://wordpress.org/news/2018/05/wordpress-4-9-6-privacy-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 May 2018 19:21:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=5920\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:358:\"WordPress 4.9.6 is now available. This is a privacy and maintenance release. We encourage you to update your sites to take advantage of the new privacy features. Privacy The European Union&#8217;s General Data Protection Regulation (GDPR) takes effect on May 25. The GDPR requires companies and site owners to be transparent about how they collect, [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Allen Snook\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:13399:\"<p>WordPress 4.9.6 is now available. This is a <strong>privacy and maintenance release</strong>. We encourage you to update your sites to take advantage of the new privacy features.</p>\n\n<figure class=\"wp-block-image\"><img src=\"https://i0.wp.com/wordpress.org/news/files/2018/05/GDPR-Banner.png?w=632&#038;ssl=1\" alt=\"A decorative header featuring the text &quot;GDPR&quot; and a lock inside of a blue shield, on multicolor green background.\" class=\"wp-image-5988\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2018/05/GDPR-Banner.png?w=1264&amp;ssl=1 1264w, https://i0.wp.com/wordpress.org/news/files/2018/05/GDPR-Banner.png?resize=300%2C150&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2018/05/GDPR-Banner.png?resize=768%2C384&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2018/05/GDPR-Banner.png?resize=1024%2C512&amp;ssl=1 1024w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure>\n\n<h2 style=\"text-align:left\">Privacy</h2>\n\n<p>The European Union&#8217;s General Data Protection Regulation (<strong>GDPR</strong>) takes effect on May 25. The GDPR requires companies and site owners to be transparent about how they collect, use, and share personal data. It also gives individuals more access and choice when it comes to how their own personal data is collected, used, and shared.<br /></p>\n\n<p>It’s important to understand that while the GDPR is a European regulation, its requirements apply to all sites and online businesses that collect, store, and process personal data about EU residents no matter where the business is located.<br /></p>\n\n<p>You can learn more about the GDPR from the European Commission&#8217;s <a href=\"http://ec.europa.eu/justice/smedataprotect/index_en.htm\">Data Protection page</a>.<br /></p>\n\n<p>We&#8217;re committed to supporting site owners around the world in their work to comply with this important law. As part of that effort, we’ve added a number of new privacy features in this release.</p>\n\n<h2 style=\"text-align:left\">Comments</h2>\n\n<figure class=\"wp-block-image\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2018/05/comments-border.png?w=632&#038;ssl=1\" alt=\"A screenshot of a comment form, where the new &quot;Save my name, email, and website in this browser for the next time I comment&quot; checkbox is featured.\" class=\"wp-image-5986\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2018/05/comments-border.png?w=1264&amp;ssl=1 1264w, https://i1.wp.com/wordpress.org/news/files/2018/05/comments-border.png?resize=300%2C291&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2018/05/comments-border.png?resize=768%2C744&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2018/05/comments-border.png?resize=1024%2C992&amp;ssl=1 1024w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure>\n\n<p>Logged-out commenters will be given a choice on whether their name, email address, and website are saved in a cookie on their browser.</p>\n\n<h2 style=\"text-align:left\">Privacy Policy Page</h2>\n\n<figure class=\"wp-block-image\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2018/05/privacy-policy-collapsed.png?w=632&#038;ssl=1\" alt=\"A screenshot of the new Privacy Settings page.\" class=\"wp-image-5995\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2018/05/privacy-policy-collapsed.png?w=1898&amp;ssl=1 1898w, https://i1.wp.com/wordpress.org/news/files/2018/05/privacy-policy-collapsed.png?resize=300%2C177&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2018/05/privacy-policy-collapsed.png?resize=768%2C453&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2018/05/privacy-policy-collapsed.png?resize=1024%2C604&amp;ssl=1 1024w, https://i1.wp.com/wordpress.org/news/files/2018/05/privacy-policy-collapsed.png?w=1264&amp;ssl=1 1264w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure>\n\n<p>Site owners can now designate a privacy policy page. This page will be shown on your login and registration pages. You should manually add a link to your policy to every page on your website. If you have a footer menu, that’s a great place to include your privacy policy.<br /></p>\n\n<p>In addition, we’ve created a guide that includes insights from WordPress and participating plugins on how they handle personal data. These insights can be copied and pasted into your site&#8217;s privacy policy to help you get started.<br /></p>\n\n<p>If you maintain a plugin that collects data, we recommend including that information in WordPress’ privacy policy guide. <a href=\"https://developer.wordpress.org/plugins/privacy/\">Learn more in our Privacy section of the Plugin Handbook</a>.</p>\n\n<h2 style=\"text-align:left\">Data Handling</h2>\n\n<figure class=\"wp-block-image\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2018/05/export-data.png?w=632&#038;ssl=1\" alt=\"A screenshot of the new Export Personal Data tools page. Several export requests are listed on the page, to demonstrate how the new feature will work.\" class=\"wp-image-5999\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2018/05/export-data.png?w=2372&amp;ssl=1 2372w, https://i1.wp.com/wordpress.org/news/files/2018/05/export-data.png?resize=300%2C221&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2018/05/export-data.png?resize=768%2C565&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2018/05/export-data.png?resize=1024%2C753&amp;ssl=1 1024w, https://i1.wp.com/wordpress.org/news/files/2018/05/export-data.png?w=1264&amp;ssl=1 1264w, https://i1.wp.com/wordpress.org/news/files/2018/05/export-data.png?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure>\n\n<div class=\"wp-block-columns has-2-columns\">\n		<h3 class=\"layout-column-1\">Data Export</h3>\n	\n		<p class=\"layout-column-1\">Site owners can export a ZIP file containing a user&#8217;s personal data, using data gathered by WordPress and participating plugins.</p>\n	\n		<h3 class=\"layout-column-2\">Data Erasure</h3>\n	\n		<p class=\"layout-column-2\">Site owners can erase a user&#8217;s personal data, including data collected by participating plugins.</p>\n	</div>\n\n<blockquote class=\"wp-block-quote\">\n	<p>Howdy,</p>\n	<p>A request has been made to perform the following action on your account:<br /> </p>\n	<p><strong>Export Personal Data</strong><br /> </p>\n	<p>To confirm this, please click on the following link:<br /><a href=\"#\">http://.wordpress.org/wp-login.php?action=confirmaction&#8230;</a><br /> </p>\n	<p>You can safely ignore and delete this email if you do not want to<br /> take this action.<br /> </p>\n	<p>This email has been sent to <a href=\"#\">you@example.com</a>.<br /> </p>\n	<p>Regards,<br /><em>Your friends at WordPress</em><br /><a href=\"http://wordpress.org\"><em> http://wordpress.org</em></a></p>\n</blockquote>\n\n<p>Site owners have a new email-based method that they can use to confirm personal data requests. This request confirmation tool works for both export and erasure requests, and for both registered users and commenters.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2 style=\"text-align:left\">Maintenance</h2>\n\n<p>95 updates were made in WordPress 4.9.6. In addition to the above, particularly of note were:<br /></p>\n\n<ul>\n	<li>&#8220;Mine&#8221; has been added as a filter in the media library.</li>\n	<li>When viewing a plugin in the admin, it will now tell you the minimum PHP version required.</li>\n	<li>We&#8217;ve added new PHP polyfills for forwards-compatibility and proper variable validation.</li>\n	<li>TinyMCE was updated to the latest version (4.7.11).<br /></li>\n</ul>\n\n<p><a href=\"https://make.wordpress.org/core/2018/05/17/4-9-6-update-guide/\">This post has more information about all of the issues fixed in 4.9.6 if you&#8217;d like to learn more</a>.</p>\n\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.9.6</a> or venture over to Dashboard → Updates and click &#8220;Update Now.&#8221; Sites that support automatic background updates will start updating soon.<br /></p>\n\n<p class=\"has-background has-very-light-gray-background-color\">Please note that if you’re currently on WordPress 4.9.3, you should manually update your site immediately.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<p>Thank you to everyone who contributed to WordPress 4.9.6:<br /><a href=\"https://profiles.wordpress.org/aaroncampbell/\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/abdullahramzan/\">abdullahramzan</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/schlessera/\">Alain Schlesser</a>, <a href=\"https://profiles.wordpress.org/allendav/\">allendav</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/andreamiddleton/\">Andrea Middleton</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a>, <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/bridgetwillard/\">bridgetwillard</a>, <a href=\"https://profiles.wordpress.org/burlingtonbytes/\">Burlington Bytes</a>, <a href=\"https://profiles.wordpress.org/chetan200891/\">Chetan Prajapati</a>, <a href=\"https://profiles.wordpress.org/claudiu/\">claudiu</a>, <a href=\"https://profiles.wordpress.org/coreymckrill/\">Corey McKrill</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling (ocean90)</a>, <a href=\"https://profiles.wordpress.org/iseulde/\">Ella Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/ericdaams/\">Eric Daams</a>, <a href=\"https://profiles.wordpress.org/fclaussen/\">Fernando Claussen</a>, <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a>, <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/idea15/\">Heather Burns</a>, <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a>, <a href=\"https://profiles.wordpress.org/herregroen/\">herregroen</a>, <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/ianbelanger/\">ibelanger</a>, <a href=\"https://profiles.wordpress.org/imath/\">imath</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jesperher/\">Jesper V Nielsen</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">JJJ</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a>, <a href=\"https://profiles.wordpress.org/jrf/\">jrf</a>, <a href=\"https://profiles.wordpress.org/dejliglama/\">Kåre Mulvad Steffensen</a>, <a href=\"https://profiles.wordpress.org/lakenh/\">Laken Hafner</a>, <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a>, <a href=\"https://profiles.wordpress.org/lbenicio/\">lbenicio</a>, <a href=\"https://profiles.wordpress.org/macbookandrew/\">macbookandrew</a>, <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a>, <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce</a>, <a href=\"https://profiles.wordpress.org/mnelson4/\">Michael Nelson</a>, <a href=\"https://profiles.wordpress.org/mikejolley/\">Mike Jolley</a>, <a href=\"https://profiles.wordpress.org/casiepa/\">Pascal Casier</a>, <a href=\"https://profiles.wordpress.org/pbarthmaier/\">pbrocks</a>, <a href=\"https://profiles.wordpress.org/postphotos/\">postphotos</a>, <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a>, <a href=\"https://profiles.wordpress.org/presstigers/\">PressTigers</a>, <a href=\"https://profiles.wordpress.org/programmin/\">programmin</a>, <a href=\"https://profiles.wordpress.org/littlerchicken/\">Robin Cornett</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/satollo/\">Stefano Lissa</a>, <a href=\"https://profiles.wordpress.org/stephdau/\">Stephane Daury (stephdau)</a>, <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a>, <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a>, <a href=\"https://profiles.wordpress.org/teddytime/\">teddytime</a>, <a href=\"https://profiles.wordpress.org/thomasplevy/\">thomasplevy</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/tz-media/\">Tobias Zimpel</a>, <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a>, <a href=\"https://profiles.wordpress.org/tobifjellner/\">Tor-Bjorn Fjellner</a>, <a href=\"https://profiles.wordpress.org/itowhid06/\">Towhidul Islam</a>, <a href=\"https://profiles.wordpress.org/voneff/\">voneff</a>, <a href=\"https://profiles.wordpress.org/earnjam/\">William Earnhardt</a>, and <a href=\"https://profiles.wordpress.org/xkon/\">Xenos (xkon) Konstantinos</a>.<br /></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"5920\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"The Month in WordPress: April 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2018/05/the-month-in-wordpress-april-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 02 May 2018 08:30:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=5891\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:324:\"This past month saw a lot of preparation for upcoming events and releases across the WordPress project. Read on to find out more about these plans, and everything else that happened around the community in April. The WordPress 15th Anniversary is Coming On May 27 2018, WordPress will turn 15 years old — this is [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4981:\"<p>This past month saw a lot of preparation for upcoming events and releases across the WordPress project. Read on to find out more about these plans, and everything else that happened around the community in April.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>The WordPress 15th Anniversary is Coming</h2>\n\n<p>On May 27 2018, <a href=\"https://wordpress.org/news/2018/04/celebrate-the-wordpress-15th-anniversary-on-may-27/\">WordPress will turn 15 years old</a> — this is a huge milestone for the project, or, indeed, for any open-source platform. The Community Team has been hard at work helping communities around the world plan local anniversary parties.</p>\n\n<p>Check <a href=\"https://wp15.wordpress.net/\">the central anniversary website</a> to see if there’s already a party being planned near you. These parties are all organized by local communities — if there’s no local community in your area, you can <a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/welcome/#starting-a-new-meetup-com-group\">start one today</a> and host a party yourself.</p>\n\n<h2>Work has Started on a Gutenberg Migration Guide</h2>\n\n<p>With Gutenberg, the upcoming WordPress content editor, in rapid development, a lot of people have been wondering how they will convert their existing plugins to work with the new features. To mitigate the issues here and help people overcome any migration hurdles, <a href=\"https://make.wordpress.org/core/2018/04/26/your-help-wanted-gutenberg-migration-guide/\">a Gutenberg Migration Guide is underway</a> to assist developers with making their code Gutenberg-compatible.</p>\n\n<p>If you’d like to contribute to this guide, you can review <a href=\"https://github.com/danielbachhuber/gutenberg-migration-guide\">the existing documentation on GitHub</a> and <a href=\"https://github.com/danielbachhuber/gutenberg-migration-guide/issues\">open a new issue</a> if you find something to add.</p>\n\n<h2>Theme Review Team Launches Trusted Authors Program</h2>\n\n<p>Reviews of themes submitted to the Theme Directory can take quite a while to complete. In order to combat this issue and to make the theme submission process smoother for everyone, <a href=\"https://make.wordpress.org/themes/2018/04/30/trusted-authors-program/\">the Theme Review Team is introducing a Trusted Authors Program</a>.</p>\n\n<p>This program will allow frequent and reliable theme authors to apply for trusted status, allowing them to upload themes more frequently and to have their themes automatically approved. This will allow more high-quality themes to be added to the directory, as well as recognize the hard work that authors put in to build their themes.</p>\n\n<p>If you would like to get involved with reviewing themes, you can read <a href=\"https://make.wordpress.org/themes/handbook/get-involved/become-a-reviewer/\">their getting started guide</a>, follow the <a href=\"https://make.wordpress.org/themes/\">team blog</a> and join the #themereview channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Further Reading:</h2>\n\n<ul>\n    <li><a href=\"https://wordpress.org/news/2018/04/wordpress-4-9-5-security-and-maintenance-release/\">WordPress 4.9.5 was released</a> early this month, fixing numerous bugs and potential security issues. The two leads for this release <a href=\"https://make.wordpress.org/core/2018/04/20/4-9-5-feedback-leading-a-wordpress-minor-release/\">published some interesting feedback</a> about the process.</li>\n    <li>In addition to the Trusted Authors Program mentioned above, the Theme Review Team is <a href=\"https://make.wordpress.org/themes/2018/04/09/changes-in-theme-review-process/\">making some changes to their review process</a> to minimize theme review delays.<br /></li>\n    <li>The Marketing Team produced <a href=\"https://make.wordpress.org/marketing/2018/04/24/contributor-day-onboarding-pdf/\">a handy Contributor Day onboarding PDF</a> for organizers to hand out to contributors attending WordCamps.</li>\n    <li>The Accessibility Team is actively looking for contributors for <a href=\"https://make.wordpress.org/accessibility/handbook/\">their handbook</a>.</li>\n    <li>A new type of WordCamp, <a href=\"https://make.wordpress.org/community/2018/04/03/want-to-help-organize-a-wordcamp-for-organizers/\">targeted at organizers</a>, is in the planning stages now.</li>\n    <li><a href=\"https://wordpress.org/about/\">The WordPress.org About pages</a> received a significant redesign to make them more clear and useful.</li>\n    <li>The Community Team <a href=\"https://make.wordpress.org/community/2018/04/27/wordcamp-incubator-program-2018-2019-roadmap/\">posted the roadmap</a> for this year’s WordCamp Incubator program.</li>\n</ul>\n\n<p><em>If you have a story we should consider including in the next “Month in WordPress” post, please <a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\">submit it here</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"5891\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Celebrate the WordPress 15th Anniversary on May 27\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://wordpress.org/news/2018/04/celebrate-the-wordpress-15th-anniversary-on-may-27/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 20 Apr 2018 21:07:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:5:\"Store\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:4:\"wp15\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=5753\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:345:\"May 27, 2018 is the 15th anniversary of the first WordPress release ﻿— and we can&#8217;t wait to celebrate! Party time! Join WordPress fans all over the world in celebrating the 15th Anniversary of WordPress by throwing your own party! Here&#8217;s how you can join in the fun: Check the WordPress 15th Anniversary website to see [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Andrea Middleton\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3948:\"<p>May 27, 2018 is the <strong>15th anniversary</strong> of the <a href=\"https://wordpress.org/news/2003/05/wordpress-now-available/\">first WordPress release</a> <a href=\"https://wordpress.org/news/2003/05/wordpress-now-available/\">﻿</a>— and we can&#8217;t wait to celebrate!</p>\n\n<figure class=\"wp-block-image aligncenter\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2018/04/wp15_mark-1.png?resize=342%2C268&#038;ssl=1\" alt=\"\" class=\"wp-image-5841\" width=\"342\" height=\"268\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2018/04/wp15_mark-1.png?w=2188&amp;ssl=1 2188w, https://i1.wp.com/wordpress.org/news/files/2018/04/wp15_mark-1.png?resize=300%2C236&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2018/04/wp15_mark-1.png?resize=768%2C605&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2018/04/wp15_mark-1.png?resize=1024%2C806&amp;ssl=1 1024w, https://i1.wp.com/wordpress.org/news/files/2018/04/wp15_mark-1.png?w=1264&amp;ssl=1 1264w, https://i1.wp.com/wordpress.org/news/files/2018/04/wp15_mark-1.png?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 342px) 100vw, 342px\" data-recalc-dims=\"1\" /></figure>\n\n<h2>Party time!</h2>\n\n<p>Join WordPress fans all over the world in celebrating the 15th Anniversary of WordPress by throwing your own party! Here&#8217;s how you can join in the fun:</p>\n\n<ol>\n    <li>Check the <a href=\"https://wp15.wordpress.net/about/\">WordPress 15th Anniversary website</a> to see if there&#8217;s a party already planned for your town. If there is, RSVP for the party and invite your friends!<br /></li>\n    <li>If there isn&#8217;t, then pick a place to go where a bunch of people can be merry — a park, a pub, a backyard; any family-friendly venue will do!</li>\n    <li>List your party with <a href=\"https://www.meetup.com/pro/wordpress/\">your local WordPress meetup group</a> (Don&#8217;t have a group? <a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/welcome/#starting-a-new-meetup-com-group\">Start one!</a>)  and then spread the word to other local meetups, tech groups, press, etc and get people to say they’ll come to your party.</li>\n    <li><a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/event-formats/wordpress-15th-anniversary-celebrations/#request-wordpress-15th-anniversary-swag\">Request</a> some special 15th anniversary WordPress swag (no later than April 27, please, so we have time to ship it to you).<br /></li>\n    <li>Have party attendees post photos, videos, and the like with the #WP15 hashtag, and <a href=\"https://wp15.wordpress.net/live/\">check out the social media stream</a> to see how the rest of the world is sharing and celebrating.</li>\n</ol>\n\n<p>Don&#8217;t miss this chance to participate in a global celebration of WordPress!<br /></p>\n\n<h2>Special Swag</h2>\n\n<p>In honor of the 15th anniversary, we’ve added some <a href=\"https://mercantile.wordpress.org/product-category/wordpress-15/\">special 15th anniversary items</a> in the swag store — you can use the offer code <strong>CELEBRATEWP15</strong> to take 15% off this (and any other WordPress swag you buy), all the way through the end of 2018!</p>\n\n<p>Keep checking the swag store, because we&#8217;ll be adding more swag over the next few weeks!</p>\n\n<h2>Share the fun</h2>\n\n<p>However you celebrate the WordPress 15th anniversary — with <a href=\"https://wp15.wordpress.net/about/\">a party</a>, with <a href=\"https://wp15.wordpress.net/swag/\">commemorative swag</a>, by <a href=\"https://wp15.wordpress.net/live/\">telling the world</a> what WordPress means to you — remember to use the #WP15 hashtag to share it! And don&#8217;t forget to <a href=\"https://wp15.wordpress.net/live/\">check the stream of WordPress 15th anniversary posts</a>.</p>\n\n<p>When <a href=\"https://venturebeat.com/2018/03/05/wordpress-now-powers-30-of-websites/\">30% of the internet</a> has a reason to celebrate, you know it&#8217;s going to be great! </p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"5753\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"GDPR Compliance Tools in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://wordpress.org/news/2018/04/gdpr-compliance-tools-in-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 12 Apr 2018 20:11:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Features\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=5728\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:188:\"GDPR compliance is an important consideration for all WordPress websites. The GDPR Compliance team is looking for help to test the privacy tools that are currently being developed in core.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Andrew Ozz\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3914:\"<p>GDPR compliance is an important consideration for all WordPress websites. The GDPR Compliance team is looking for help to test the privacy tools that are currently being developed in core. </p>\n\n<h2>What is GDPR?</h2>\n\n<p>GDPR stands for <a href=\"https://en.wikipedia.org/wiki/General_Data_Protection_Regulation\">General Data Protection Regulation</a> and is intended to strengthen and unify data protection for all individuals within the European Union. Its primary aim is to give control back to the EU residents over their personal data. <br /></p>\n\n<p>Why the urgency? Although the GDPR was introduced two years ago, it becomes  enforceable starting May 25, 2018.</p>\n\n<h2>Make WordPress GDPR Compliance Team</h2>\n\n<p>Currently, the GDPR Compliance Team understands that helping WordPress-based sites become compliant is a large and ongoing task. The team is focusing on creating a comprehensive core policy, plugin guidelines, privacy tools and documentation. All of this requires your help.<br /></p>\n\n<p>The GDPR Compliance Team is focusing on four main areas:</p>\n\n<ul>\n    <li>Add functionality to assist site owners in creating comprehensive privacy policies for their websites.</li>\n    <li>Create guidelines for plugins to become GDPR ready.</li>\n    <li>Add administration tools to facilitate compliance and encourage user privacy in general.</li>\n    <li>Add documentation to educate site owners on privacy, the main GDPR compliance requirements, and on how to use the new privacy tools.</li>\n</ul>\n\n<h2>Don’t we already have a privacy policy?</h2>\n\n<p>Yes and no. That said, The GDPR puts tighter guidelines and restrictions. Though we have many plugins that create privacy pages, we need means to generate a unified, comprehensive privacy policy. We will need tools for users to easily come into compliance.<br /></p>\n\n<p>Site owners will be able to create GDPR compliant privacy policy in three steps:</p>\n\n<ol>\n    <li>Adding a dedicated page for the policy.<br /></li>\n    <li>Adding privacy information from plugins.</li>\n    <li>Reviewing and publishing the policy.</li>\n</ol>\n\n<p>A new &#8220;postbox&#8221; will be added to the Edit Page screen when editing the policy. All plugins that collect or store user data will be able to add privacy information there. In addition it will alert the site owners when any privacy information changes after a plugin is activated, deactivated, or updated.<br /></p>\n\n<p>There is a new functionality to confirm user requests by email address. It is intended for site owners to be able to verify requests from users for displaying, downloading, or anonymizing of personal data.<br /></p>\n\n<p>A new &#8220;Privacy&#8221; page is added under the &#8220;Tools&#8221; menu. It will display new, confirmed requests from users, as well as already fulfilled requests. It will also contain the tools for exporting and anonymizing of personal data and for requesting email confirmation to avoid abuse attempts.<br /></p>\n\n<p>New section on privacy will be added to the <a href=\"https://developer.wordpress.org/plugins/\">Plugin Handbook</a>. It will contain some general information on user privacy, what a plugin should do to be compliant, and also tips and examples on how to use the new privacy related functionality in WordPress.<br /></p>\n\n<p>The new privacy tools are scheduled for release at the end of April or beginning of May 2018.</p>\n\n<h2>How can you get involved?</h2>\n\n<p>We would love to have your help. The first step is awareness and education. For more information about the upcoming privacy tools see ﻿<a href=\"https://make.wordpress.org/core/2018/03/28/roadmap-tools-for-gdpr-compliance/\">the roadmap</a>.</p>\n\n<p>If you would like to get involved in building WordPress Core and testing the new privacy tools, please join the #gdpr-compliance channel in the <a href=\"https://make.wordpress.org/chat/\">Make WordPress</a> Slack group.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"5728\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Mon, 30 Jul 2018 11:09:56 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Tue, 17 Jul 2018 14:45:38 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:9:\"HIT ord 1\";}}s:5:\"build\";s:14:\"20130911040210\";}', 'no');
INSERT INTO `wp_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(129, '_transient_timeout_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca', '1532992197', 'no'),
(130, '_transient_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca', '1532948997', 'no'),
(131, '_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9', '1532992199', 'no');
INSERT INTO `wp_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(132, '_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9', 'a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"WPTavern: Plugin Review: Theme Support for Gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=82710\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wptavern.com/plugin-review-theme-support-for-gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2655:\"<p>As Gutenberg nears a merge with WordPress, Theme Authors are running out of time to ensure that their themes are compatible. The Gutenberg handbook has an <a href=\"https://wordpress.org/gutenberg/handbook/extensibility/theme-support/\">excellent article</a> on how to opt-in and add support for enhanced features.</p>\n\n<p>Most themes will present the default blocks without any issues as the blocks themselves provide their own styles. If you use a theme that does not fully support Gutenberg such as the Wide or Full Block Alignment options, the <a href=\"https://wordpress.org/plugins/theme-support-for-gutenberg/\">Theme Support for Gutenberg</a> plugin may be for you. </p>\n\n<p>Created by <a href=\"https://weavertheme.com/about/\">Weweaver</a>, Theme Support for Gutenberg claims to allow most WordPress themes to be compatible with Gutenberg. In addition to theme support, the plugin adds a Classic Editor button to the admin bar to easily switch between Gutenberg and the Classic Editor.</p>\n\n<p>Since a default WordPress theme is used to show how this plugin is beneficial, I decided to try it for myself. I installed the plugin on a fresh install of WordPress 4.9.7, Gutenberg 3.3, and the latest version of Twenty Sixteen. I published a Gutenberg Demo post which uses many of the default blocks.<br /></p>\n\n<h2>Twenty Sixteen Looks Better Without It<br /></h2>\n\n<p>Here is what the Gallery block looks like in Twenty Sixteen with the plugin disabled. The content looks good and fits within the content column.</p>\n\n<img />Theme Support for Gutenberg Disabled\n\n<p>When the plugin is enabled, the images are so large, a horizontal scroll bar appears. </p>\n\n<img />Theme Support for Gutenberg Enabled\n\n<p>The plugin includes additional styling for default blocks. One block that doesn&#8217;t benefit from the enhanced styles is the Video block. With the plugin disabled, the video block appears normally. </p>\n\n<img />Video Block With The Plugin Disabled<br />\n\n<p>With the plugin enabled, the video block overflows the content column and breaches into the left sidebar.</p>\n\n<img />Video Block With The Plugin Enabled \n\n<p>Although the plugin initially shipped with no options, version 0.2 includes new settings that provide better compatibility for some themes. I checked the box to disable Fitvids support which solved the video block issue. However, the other options had no effect on the oversized image blocks. <br /></p>\n\n<img />Theme Support Options\n\n<p>Twenty Sixteen and Twenty Seventeen do not work well with this plugin. There may be themes, particularly older ones that benefit, but more modern themes will likely be ok without it. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 Jul 2018 22:42:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WPTavern: WooSesh Virtual WooCommerce Conference to be Held October 18-19\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=82508\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wptavern.com/woosesh-virtual-woocommerce-conference-to-be-held-october-18-19\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4964:\"<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/07/woosesh-2018.png?ssl=1\"><img /></a></p>\n<p><a href=\"https://woosesh.com/\" rel=\"noopener noreferrer\" target=\"_blank\">WooSesh</a>, a new two-day virtual conference focused on WooCommerce topics, will be held October 18-19. While wrapping up another successful edition of WordSesh, Brian Richards announced WooSesh as the next event coming under the WordSesh brand. On Wednesday, nearly 500 attendees joined WordSesh. People tuned in from around the world, although the audience was heavily US-based due to the time the event was scheduled.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/07/wordsesh-july-2018.png?ssl=1\"><img /></a></p>\n<p>Since WooConf is not happening this year, WooSesh is an exciting alternative that will be accessible to anyone in the world. Co-organizers Brian Richards and Patrick Rauland will be hosting eight presentations each day, so the event will last between 8-10 hours both days, including breaks and announcements.</p>\n<p>&#8220;Once we learned that WooConf wouldn’t be taking place this year we reached out to our friends at Automattic to see if we could work with them as well to still provide a high-quality event but for a much more global audience,&#8221; Richards said.</p>\n<p>WooCommerce is sponsoring the entire event, making it free for all live attendees. Richards said they are working with other prominent companies in the WooCommerce space who are lending their knowledgeable staff as presenters, as well as providing the event with digital swag for attendees.</p>\n<p>WooSesh organizers are employing an interesting concept for encouraging attendance and engagement. The conference will have a $200 ticket price for those who do not attend live. Those who register in advance and attend live will receive the $200 ticket for free.</p>\n<p>&#8220;That means if a person joins the mailing list and shows up for the event, they’ll be able to experience the whole thing at no cost to them,&#8221; Richards said. &#8220;Similar to WordSesh, a ticket grants attendees access to the entire broadcast, chat, recordings, real-time transcriptions, and some cool digital swag. But with WooSesh they’ll also get some targeted follow-up content, and perhaps a private community, to further help them succeed and increase the impact of this conference.</p>\n<p>&#8220;And I think it’s in everyone’s best interest to register and attend live – at least trying to make it to one of the sessions across the two days – so they can get all of that for free.&#8221;</p>\n<p>Richards said recordings may still make it out there for people to view afterwards but none of the other perks and follow-ups will be available without purchasing a ticket or attending live.</p>\n<p>&#8220;We talked about asking people for a credit card up front and building a mechanism that would either charge them after the fact (like a pre-order) or charge them up-front but then refund them after the fact,&#8221; Richards said. &#8220;Instead we’re going with the simpler route and asking only for a person’s name and email address up-front. If they come to the live event they’ll be able to access all of the content afterwards just as if they had paid, and if they don’t attend live they’ll instead be greeted with a payment form.&#8221;</p>\n<p>Building on their collective knowledge of organizing successful in-person and virtual conferences, Richards said he and his co-organizer wanted to reduce the friction as much as possible for people getting into their seats and engaged with the speakers and other attendees.</p>\n<p>&#8220;Making it a virtual event already knocks down a ton of barriers,&#8221; Richard said. &#8220;Making the content available for free eliminates even more. Except that, people will often discredit free things and we didn’t want anyone to think of this content as any less valuable or serious than it really is.&#8221;</p>\n<p>WooSesh organizers plan to host compelling case studies, as well as talks about SEO, security, tips for building different kinds of e-commerce stores, and share advice from others’ hard-earned lessons. The event will also host sessions for developers that delve into WooCommerce architecture, performance, how to build and support custom extensions, and how to expand service offerings to better support e-commerce projects.</p>\n<p>&#8220;Our biggest goal with WooSesh is that it will help store builders as well as coders to have more impact with what they build,&#8221; Richards said. &#8220;Specifically, we’d like to see them make some measurable progress in their own goals, whether that’s more sales, better customer experiences, greater depth of knowledge, or otherwise. We’re also hoping that some of these talks will inspire attendees to do more than they originally thought possible – either for their own e-commerce stores or for their customers/clients.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 Jul 2018 22:34:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"WPTavern: Slack Acquires HipChat, Moves Blog from Medium to WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=82681\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://wptavern.com/slack-acquires-hipchat-moves-blog-from-medium-to-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2732:\"<p>Slack <a href=\"https://slackhq.com/atlassian-and-slack-partnership\" rel=\"noopener noreferrer\" target=\"_blank\">announced</a> today that it has acquired HipChat from Atlassian. The friendly rivalry between the two competing group chat platforms will be laid to rest as Slack plans to retire HipChat and Stride. Atlassian will receive a stake in Slack&#8217;s business in exchange for shutting down its chat collaboration services and migrating all of its customers over.</p>\n<p><a href=\"https://www.atlassian.com/blog/archives/press-release-atlassian-acquires-hipcha\" rel=\"noopener noreferrer\" target=\"_blank\">Atlassian acquired HipChat in 2012</a> with the intention of scaling the business but found a formidable challenge in taking on the well-funded, market-dominating Slack app. As of May 2018, <a href=\"https://slackhq.com/from-tokyo-to-tallahassee-target-to-ticketmaster-slack-is-where-work-happens\" rel=\"noopener noreferrer\" target=\"_blank\">Slack reported 8 million daily active users</a> and 70,000 paid teams. More than half of the app&#8217;s users are outside the U.S. and 65% of companies in the Fortune 100 pay to use Slack.</p>\n<p>Atlassian and Slack are now joining forces to compete against Microsoft, who jumped into the enterprise collaboration market in 2016 with its Teams product. Teams&#8217; free tier offers support for up to 300 people, with unlimited chat messages and search, and is aimed squarely at competing with Slack.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/07/slack-blog-e1532659145946.png?ssl=1\"><img /></a></p>\n<p>The news was announced on &#8220;<a href=\"https://slackhq.com/\" rel=\"noopener noreferrer\" target=\"_blank\">Several People Are Typing</a>,&#8221; the official Slack blog, which has just <a href=\"https://medium.com/several-people-are-typing/weve-moved-9cf5941a66fe\" rel=\"noopener noreferrer\" target=\"_blank\">moved from Medium to WordPress</a>. It is being hosted on the WordPress.com VIP platform.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\"><img src=\"https://s.w.org/images/core/emoji/11/72x72/1f485.png\" alt=\"💅\" class=\"wp-smiley\" /> I can’t really answer the question (bias, yada yada), but it sure is good to be hosting the Slack blog at <a href=\"https://twitter.com/WordPressVIP?ref_src=twsrc%5Etfw\">@WordPressVIP</a> <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f60e.png\" alt=\"😎\" class=\"wp-smiley\" /> <a href=\"https://t.co/86aQQ5Pkaz\">https://t.co/86aQQ5Pkaz</a></p>\n<p>&mdash; Simon Wheatley (@simonwheatley) <a href=\"https://twitter.com/simonwheatley/status/1022360132053807104?ref_src=twsrc%5Etfw\">July 26, 2018</a></p></blockquote>\n<p></p>\n<p>The answer to that question, by the way, is &#8216;yes.&#8217;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 Jul 2018 02:55:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"WPTavern: How to Create A Gutenberg Block Attributes Glossary\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=82684\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://wptavern.com/how-to-create-a-gutenberg-block-attributes-glossary\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1242:\"<p>If you want to see what Gutenberg blocks are available on a site along with their attributes, check out the <a href=\"https://github.com/OIT-Design/block-attributes-glossary\">Block Attributes Glossary</a> plugin by <a href=\"https://design.oit.ncsu.edu/\">NC State&#8217;s Office of Information Technology and Design</a>.</p>\n\n<img />Block Attributes Glossary Index\n\n<p>The plugin adds a Glossary Attributes Block to Gutenberg that when added to a post or page, displays an index of blocks that are available. Clicking on a block name will display its attributes. </p>\n\n<img />Atomic Blocks Drop Cap Block Attributes\n\n<p>This is especially useful for creating block templates. Note that if you install plugins that add new blocks, you&#8217;ll need to visit the post or page that has the glossary, remove the Glossary block, and re-add it. </p>\n\n<p>You can see a live demo of this plugin in action by visiting <a href=\"https://design.oit.ncsu.edu/docs/gutenberg/block-attributes/\">NC State&#8217;s OIT Block Attributes Glossary</a>. The plugin is not available from the WordPress plugin directory but you can download it for free from the <a href=\"https://github.com/OIT-Design/block-attributes-glossary\">project&#8217;s Github page</a>. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 26 Jul 2018 20:47:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"WPTavern: Font Awesome 5.2 Adds 372 New Icons, Introduces Automotive and Education Categories\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=82617\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"https://wptavern.com/font-awesome-5-2-adds-372-new-icons-introduces-automotive-and-education-categories\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3091:\"<a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2018/07/Screen-Shot-2018-07-25-at-5.15.52-PM.png?ssl=1\"><img /></a>image credit: <a href=\"https://fontawesome.com/\">Font Awesome</a>\n<p><a href=\"https://blog.fontawesome.com/font-awesome-5-2-372-new-icons-adfb42c6c35\" rel=\"noopener noreferrer\" target=\"_blank\">Font Awesome</a> 5.2 was released yesterday with two new categories and 372 new icons, bringing the total number of free icons to 1,295. The open source vector icon font is used on more than <a href=\"https://trends.builtwith.com/widgets/Font-Awesome\" rel=\"noopener noreferrer\" target=\"_blank\">22 million sites</a> across the internet. It&#8217;s also a popular icon font with WordPress theme and plugin developers.</p>\n<p>Version 5.2 introduces automotive and education categories, which should be useful to fill the gaps for designers and developers creating sites around these subjects. The release also adds 66 new and updated icons to the Medical category and 126 new and updated Maps icons.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2018/07/medical.png?ssl=1\"><img /></a></p>\n<p>Font Awesome, originally created by Dave Gandy, is an SIL OFL-licensed icon font, with the code under the MIT License. Thanks to its GPL-friendly license, the icon font is widely used in WordPress&#8217; theme and plugin ecosystem in both commercial and free products. Font Awesome&#8217;s <a href=\"https://github.com/FortAwesome/Font-Awesome/issues?utf8=%E2%9C%93&q=is%3Aissue+is%3Aopen+wordpress\" rel=\"noopener noreferrer\" target=\"_blank\">Github issues queue</a> is also loaded with icon requests that would be used in niche WordPress themes, as well as icons for WordPress-related company logos.</p>\n<p>Two years ago, Font Awesome announced the <a href=\"https://wptavern.com/font-awesome-cdn-now-in-beta-loads-icons-asynchronously-with-automatic-accessibility-best-practices\" rel=\"noopener noreferrer\" target=\"_blank\">beta release of its new CDN</a>, which allows developers to implement it using a single line of code to bring the icons and CSS toolkit into their projects. At that time, Font Awesome was used by more than 300 plugins on WordPress.org. In 2018, searching the official plugin directory turns up more than 800 plugins that make use of the icon font in some way. Thousands of free and commercial themes also use it to provide users with easy customization options.</p>\n<p>Font Awesome support for Gutenberg is going to be fairly important, as hundreds of thousands of websites are using plugins like <a href=\"https://wordpress.org/plugins/better-font-awesome/\" target=\"_blank\" rel=\"noopener noreferrer\">Better Font Awesome</a>, <a href=\"https://wordpress.org/plugins/font-awesome-shortcodes/\" target=\"_blank\" rel=\"noopener noreferrer\">Font Awesome Shortcodes</a>, and <a href=\"https://wordpress.org/plugins/font-awesome-4-menus/\" target=\"_blank\" rel=\"noopener noreferrer\">Font Awesome for Menus</a> to allow users to add icons to content and menus. Currently there are no Gutenberg-compatible plugins for adding Font Awesome icons to content.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 26 Jul 2018 18:08:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"WPTavern: WPWeekly Episode 324 – Getting NC State Gutenready\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=82650&preview=true&preview_id=82650\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wptavern.com/wpweekly-episode-324-getting-nc-state-gutenready\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1804:\"<p>In this episode, <a href=\"http://jjj.me\">John James Jacoby</a> and I are joined by <a href=\"https://design.oit.ncsu.edu/people/jmriehle/\">Jen McFarland</a>, Web Services Coordinator at NC state&#8217;s Office of Information and Technology. McFarland describes how the campus is using WordPress, what they&#8217;re doing to prepare students and staff for Gutenberg, and what they&#8217;ve experienced thus far in the transition.</p>\n<p>Near the end of the show, we cover WordPress 4.9.8 RC 1 and provide an update on WP-CLI Hack Day.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"https://wptavern.com/gutenberg-3-3-released-adds-archives-and-recent-comments-blocks\">Gutenberg 3.3 Released, Adds Archives and Recent Comments Blocks</a><br />\n<a href=\"https://make.wordpress.org/core/2018/07/24/wordpress-4-9-8-release-candidate-1/\">WordPress 4.9.8 RC 1 Released</a><br />\n<a href=\"https://wptavern.com/wp-cli-hack-day-is-a-success\">WP-CLI Hack Day Is A Success</a><br />\n<a href=\"https://wptavern.com/google-chrome-rolls-out-not-secure-warning-for-plain-http-sites\">Google Chrome Rolls Out “Not Secure” Warning for Plain HTTP Sites</a></p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, August 1st 3:00 P.M. Eastern</p>\n<p>Subscribe to <a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\">WordPress Weekly via Itunes</a></p>\n<p>Subscribe to <a href=\"https://www.wptavern.com/feed/podcast\">WordPress Weekly via RSS</a></p>\n<p>Subscribe to <a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\">WordPress Weekly via Stitcher Radio</a></p>\n<p>Subscribe to <a href=\"https://play.google.com/music/listen?u=0#/ps/Ir3keivkvwwh24xy7qiymurwpbe\">WordPress Weekly via Google Play</a></p>\n<p><strong>Listen To Episode #324:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 26 Jul 2018 01:01:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"WPTavern: Frontenberg Lets Users Test Gutenberg on the Frontend\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=82526\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://wptavern.com/frontenberg-lets-users-test-gutenberg-on-the-frontend\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2733:\"<p>WordPress 5.0 will bring the world a brand new editor that is currently code-named Gutenberg. If you have been hearing the buzz around Gutenberg but have yet to try it, <a href=\"https://testgutenberg.com/\" rel=\"noopener noreferrer\" target=\"_blank\">Frontenberg</a> (<a href=\"https://testgutenberg.com/\" rel=\"noopener noreferrer\" target=\"_blank\">testgutenberg.com</a>) is the easiest way to check it out.</p>\n<p>Frontenberg allows visitors to try Gutenberg without having to set up a separate test site of their own. It loads an instance of WordPress plus the Gutenberg plugin on the frontend so visitors don&#8217;t have to log in to play around with the new editor.</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2018/07/frontenberg-e1532540010736.png?ssl=1\"><img /></a></p>\n<p>Frontenberg has a limited range of capabilities for testing purposes. Users have access to a pre-populated media library but cannot upload images to the test site. It&#8217;s also not possible to create shared blocks or save the post. Attempting to save an action will trigger an &#8220;updating failed&#8221; notice. Apart from those few limitations, Frontenberg allows users to test nearly all of Gutenberg&#8217;s features.</p>\n<p>The tool was created by <a href=\"https://tomjn.com/\" rel=\"noopener noreferrer\" target=\"_blank\">Tom Nowell</a>, VIP Wrangler at <a href=\"https://automattic.com/\" rel=\"noopener noreferrer\" target=\"_blank\">Automattic</a>. He launched the frontend testing instance on his own website at <a href=\"https://frontenberg.tomjn.com/\" rel=\"noopener noreferrer\" target=\"_blank\">frontenberg.tomjn.com</a> and the WordPress VIP team built its own version to handle more traffic. Frontenberg contains links to numerous Gutenberg resources, including <a href=\"http://vipgutenberg.com\" rel=\"noopener noreferrer\" target=\"_blank\">vipgutenberg.com</a>, which has some free training videos the team created for VIP clients.</p>\n<p>Nowell has written a post called <a href=\"https://tomjn.com/2018/01/22/how-frontenberg-works/\" rel=\"noopener noreferrer\" target=\"_blank\">How Frontenberg Works</a> for developers who are interested in the tech behind the tool. In it he describes the challenges he encountered in building Frontenberg and the solutions he wrote to make it work.</p>\n<p>The <a href=\"https://wptavern.com/first-look-at-try-gutenberg-prompt-in-wordpress-4-9-8-beta-2\" rel=\"noopener noreferrer\" target=\"_blank\">&#8220;Try Gutenberg&#8221; prompt</a> will soon be going out to millions of users in WordPress 4.9.8. Those who conservatively opt to use the Classic Editor plugin can still give Gutenberg a try using the Frontenberg tool or install it on a test site to see how interacts with themes and plugins.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 25 Jul 2018 19:59:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"WPTavern: WordPress Core Fields API Project is Seeking New Leadership\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=82602\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://wptavern.com/wordpress-core-fields-api-project-is-seeking-new-leadership\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:10702:\"<p>In 2014, <a href=\"https://pods.io/\">Pods</a> lead developer, Scott Kingsley Clark, <a href=\"https://make.wordpress.org/core/2014/02/25/metadata-project-update/\">took over</a> the primary lead role for the Metadata UI project. In 2015, the Metadata UI project <a href=\"https://make.wordpress.org/core/2015/05/27/metadata-api-project-reborn-the-new-fields-api-project/\">was reborn</a> as the <a href=\"https://github.com/sc0ttkclark/wordpress-fields-api\">Fields API</a>.</p>\n\n<p>The Fields API was developed to allow registering fields to different screens in the admin area through a single API. New meta boxes and fields within them could be added to posts while new sections and fields could be added to the profile screen.</p>\n\n<p>The goal of the API is to integrate with all of the various admin screens including, Posts, Terms, Users, Media, and Comments and provide standardization.</p>\n\n<p>Clark has been leading the project for three years and despite seeing <a href=\"https://wptavern.com/wordpress-core-fields-api-project-sees-renewed-interest\">renewed interest</a> last year, <a href=\"https://wordpress.slack.com/messages/C04MWK7PZ/\">announced</a> in the project&#8217;s Slack channel that he is stepping down. <br /></p>\n\n<blockquote class=\"wp-block-quote\"><p>It is with a heavy heart that I must pass the torch on this project. After hundreds of hours of my time, I no longer believe I can effect change within WordPress core. </p><p>The Fields API vision was too big, too much of an undertaking for any one person. I believe so deeply that WordPress needs a Fields API, but the journey to where we are at with the Fields API has been long and arduous. </p><p>The truth is, I burned out years ago while building the first and second prototypes. Not everyone agreed on how to architect the code, it went through many revisions based on core contributor feedback. I just couldn&#8217;t get enough people excited about it, I couldn&#8217;t get enough companies and people interested in supporting it.</p><p>I need to let someone else have their chance, I am dragging it down. If someone steps up to lead in the future, then I would be happy to assist where I am able to. But I am unable to continue leading the Fields API proposal/project. I am sorry, please accept my apology and I hope you can forgive me for failing to take this project over the finish line. I still believe to be such a vital part of WordPress&#8217; future success.</p><cite>Scott Kingsley Clark</cite></blockquote>\n\n<h2>The Trials and Tribulations of Leading an Open Source Project</h2>\n\n<p>In the following interview, Clark explains why he feels personally responsible for the project&#8217;s lack of progress, why the API is important for WordPress&#8217; future, and reflects on what he could have done differently.</p>\n\n<p><strong>Are you looking to pass the torch on to anyone in particular?</strong><br /><br /></p>\n\n<p>No, I&#8217;m not sure who would have the drive and the clout to see the project through. It&#8217;s a large scale project that should be approached with a long-term vision but in small enough increments to make it into WordPress core. It&#8217;s a lot to ask of somebody, it&#8217;s also not a priority for people right now since they are distracted by Gutenberg being released in the near future.<br /></p>\n\n<p><strong>Why is the Fields API a vital part of WordPress&#8217; future?</strong><br /><br /></p>\n\n<p>People look at WordPress today and wonder how they ever survived without the REST API. Well, at least I know I do! The same thing can be said about the Fields API even though it&#8217;s not there yet. There are so many cases where it&#8217;s frustrating to build solutions for WordPress across all of the different hooks.<br /></p>\n\n<p>For consistency, it&#8217;s the wild west out there. You get a meta box registered and you fill it with whatever you want. You need your own CSS to style the form fields and everyone has their own idea of how this interface should look. You are in charge of your own responsive layouts that are mobile-friendly, there&#8217;s just so much you have to handle on your own. You should be able to customize appearances, but every place you want to add a field or form to should really have a proper API.<br /></p>\n\n<p>Long-term, imagine registering fields to WordPress like you register post types. Imagine fields and their configurations being available to the REST API and accessible through the WordPress App or other custom apps. </p>\n\n<p>The whole world opens up because you have a consistent API, the whole world make sense because you have a consistent interface for those fields across the various edit screens. Posts, terms, comments, users, media, even the Customizer would all have the same underlying API to add groups, panels, and fields to their screens.<br /></p>\n\n<p>If Gutenberg was done after the Fields API was in, migration for folks wouldn&#8217;t have been as difficult. Gutenberg could have automatically shown all of the Fields API interfaces like it does for the meta box backward compatibility. It would have looked so much nicer too.<br /></p>\n\n<p><strong>Taking some time to reflect, what could you have done differently to get more core contributors to buy into the project and turn it into a higher priority?</strong><br /><br /></p>\n\n<p>I&#8217;m not sure, it&#8217;s a delicate balance of taking input and being confident in the end result. At first, the feedback was about how the API was foreign for WordPress, they asked if it could be similar in structure to other APIs such as the Customizer. </p>\n\n<p>We scrapped the code and rebuilt from the ground up as a fork of the Customizer, it even supported having the Customizer utilizing the Fields API too. At the height of development, we had all areas of the Fields API implemented.<br /></p>\n\n<p>Core releases were moving pretty fast, there was a lot of code changes from WordPress release to release that we had to keep up with because we had essentially created a project that was a giant patch for WordPress. </p>\n\n<p>There weren&#8217;t enough hooks in place to do what we needed to do, and many sections were not extensible because of code decisions that marked themselves as &#8216;final&#8217;, which means you can&#8217;t extend a specific class to customize how it works.<br /></p>\n\n<p>I wish I could have been at all the big WordCamps in the US and Europe, essentially lobbying for this feature. Gathering supporters and such, it feels like politics in a way. I hung around in Core dev meetings, trying to bring it up. I tried to legitimize the feature by having a dedicated channel in the official WordPress Slack, posting updates on<a href=\"https://make.wordpress.org/core/\"> https://make.wordpress.org/core/</a>, and holding weekly meetings.<br /></p>\n\n<p>Ultimately, I prioritized my time for development over the time to gather the troops. That was the downfall, I began to burn out quickly after the first few rewrites as I had many other responsibilities elsewhere on top of Fields API.</p>\n\n<p>It’s not like companies will easily want to pay you to work on a project like this indefinitely, even though both WebDevStudios and 10up gave me time to push it forward. It wasn’t a blank check, at some point I had to get back to billable work. From then on, it was all in my free time and that was difficult to manage during times of financial stress and house selling/buying.<br /></p>\n\n<p><strong>There&#8217;s demand for a Fields API in core but not enough hands to build it. Why do you think that is?</strong><br /><br /></p>\n\n<p>Everyone is focused elsewhere. There’s a lot of areas of WordPress that need people’s attention. There are things like Accessibility that deserve a lot more attention than it gets. But the focus to me, seems to be on Gutenberg and REST API. </p>\n\n<p>Gutenberg especially has been a huge time sink for people contributing and people implementing. It’s a really large feature. It’s definitely larger in scale than Fields API, it’s like a whole new app that lives in WordPress. Integration with it has required a lot of education and trial/error. People’s focus is where it needs to be right now. It’s just unfortunate that Gutenberg came before Fields API in terms of priority and interest level.<br /></p>\n\n<p><strong>What advice would you give to the next Fields API project leader?</strong><br /><br /></p>\n\n<p>This is a big project, everyone will want to say it should be a certain way. You have to evaluate the options and put forth something bite sized for core to start with. Build upon that, but never lose sight of the long-term goal of integration across all of the WordPress screens. Even the front-end comment forms could thrive with the Fields API.<br /></p>\n\n<p><strong>Why do you feel personally responsible for the project not being a core priority?</strong><br /><br /></p>\n\n<p>At one point, we had momentum. We had at least three to four people who were active. It fell apart because I ran out of time. It’s my shortsightedness, it’s my fault. I spent hundreds of hours developing the project over a couple of years. I should have left myself much more time for organizing the feature proposal text and keeping the fires burning in our contributors’ hearts.<br /></p>\n\n<p><strong>Considering the time and effort you&#8217;ve put into the project the last few years, do you feel any sense of relief passing the torch on?</strong><br /><br /></p>\n\n<p>If the torch gets passed or picked up, I will feel a ton better. The main relief is that it’s officially not a weight I have to carry alone any longer. It’s okay to try and fail, it’s still sad though. </p>\n\n<p>I hope that someone or some company steps up and puts time into this. They could even reignite the fire in my own heart that burned itself out. For now, I have one less major to-do item. I still have a hefty plate but it’s no longer as heavy of a burden.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<p>While the immediate future of the project is unclear, those interested in taking it over are encouraged to read posts marked with the <a href=\"https://make.wordpress.org/core/tag/fields-api/\">Fields API tag</a> on <a href=\"https://make.wordpress.org/core\">Make.WordPress.Core</a> to learn about its history. You can also check out the <a href=\"https://github.com/sc0ttkclark/wordpress-fields-api\">project&#8217;s Github page</a>. </p>\n\n<p>If you&#8217;re interested in taking over the project, you can contact Clark on <a href=\"https://twitter.com/scottkclark\">Twitter</a>, <a href=\"https://wordpress.slack.com/team/U02RSB1LH\">Slack</a>, or through <a href=\"https://www.scottkclark.com/\">his website</a>. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 25 Jul 2018 16:53:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"HeroPress: Global Unity\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://heropress.com/?p=2596\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://heropress.com/global-unity/#utm_source=rss&utm_medium=rss&utm_campaign=global-unity\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3268:\"<img width=\"960\" height=\"480\" src=\"https://s20094.pcdn.co/wp-content/uploads/2017/04/041217-min-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: I am quite lucky to wake up every morning and work, all on my own, in a country where 54% of the population are unemployed and over 70% are youth.\" /><p>One of the things I&#8217;ve loved most about HeroPress is getting to know people far away. It&#8217;s getting harder and harder to name a country where I can&#8217;t say &#8220;Hey, I have a friend there!&#8221;.  This week I&#8217;m in Australia for WordCamp Sydney, and I&#8217;m crazy excited about all the people I&#8217;m going to meet. The global unity of the WordPress community is exhilarating.</p>\n<p>The replay essay I picked for this week is titled &#8220;<strong>A Bottomless World of Possibilities</strong>&#8221; by Jamaal Jaamac in Mogadishu, Somalia. His world is so completely different from mine that sometimes I even have a hard time asking the right questions to find out what it&#8217;s like.</p>\n<p>Jamaal doesn&#8217;t live in a place where good work comes easy or often. It&#8217;s chiseled out of society with labor and love. There&#8217;s a stereotype that people in poor countries are lazy, but I think they have to be stronger and work harder just to make it. Jamaal is one of my heroes.</p>\n<p>Check out his essay.</p>\n<blockquote class=\"wp-embedded-content\"><p><a href=\"https://heropress.com/essays/bottomless-world-possibilities/\">A Bottomless World of Possibilities</a></p></blockquote>\n<p></p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: Global Unity\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=Global%20Unity&via=heropress&url=https%3A%2F%2Fheropress.com%2Fglobal-unity%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: Global Unity\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fglobal-unity%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fglobal-unity%2F&title=Global+Unity\" rel=\"nofollow\" target=\"_blank\" title=\"Share: Global Unity\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/global-unity/&media=https://heropress.com/wp-content/uploads/2017/04/041217-min-150x150.jpg&description=Global Unity\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: Global Unity\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/global-unity/\" title=\"Global Unity\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/global-unity/\">Global Unity</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 25 Jul 2018 10:52:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"WPTavern: Google Chrome Rolls Out “Not Secure” Warning for Plain HTTP Sites\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=82489\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wptavern.com/google-chrome-rolls-out-not-secure-warning-for-plain-http-sites\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7926:\"<p>As part of a long term plan to push the web to adopt HTTPS encryption, <a href=\"https://www.blog.google/products/chrome/milestone-chrome-security-marking-http-not-secure/\" rel=\"noopener noreferrer\" target=\"_blank\">Google Chrome is now marking all plain HTTP sites as &#8220;not secure,&#8221;</a> as of July 24, 2018, with the release of <a href=\"https://chromereleases.googleblog.com/2018/07/stable-channel-update-for-desktop.html\" rel=\"noopener noreferrer\" target=\"_blank\">Chrome 68</a>. Previously, the &#8220;not secure&#8221; warning was hidden behind the security indicator in the URL bar as shown below.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/07/Screen-Shot-2018-07-23-at-8.51.52-PM.png?ssl=1\"><img /></a></p>\n<p>That warning has become more prominent with the release of Chrome 68. The browser now immediately displays the &#8220;Not secure&#8221; message in the omnibox for all HTTP pages.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2018/07/warning-update.jpg?ssl=1\"><img /></a></p>\n<p>Today Google announced a time frame for eventually marking HTTP sites with a red &#8220;not secure&#8221; warning:</p>\n<blockquote><p>Eventually, our goal is to make it so that the only markings you see in Chrome are when a site is not secure, and the default unmarked state is secure. We will roll this out over time, starting by removing the “Secure” wording in September 2018. And in October 2018, we’ll start showing a red “not secure” warning when users enter data on HTTP pages.</p></blockquote>\n<a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2018/07/not-secure-eventual-warning.png?ssl=1\"><img /></a>image source: <a href=\"https://security.googleblog.com/2016/09/moving-towards-more-secure-web.html\">Google Security Blog</a>\n<p>Google Chrome currently captures <a href=\"http://gs.statcounter.com/browser-market-share\" rel=\"noopener noreferrer\" target=\"_blank\">60% of the browser marketshare worldwide</a>, making it one of the company&#8217;s most effective vehicles for driving HTTPS adoption. <a href=\"https://letsencrypt.org/\" rel=\"noopener noreferrer\" target=\"_blank\">Let&#8217;s Encrypt</a>, the free and open certificate authority (of which Chrome is a platinum sponsor), has also been a key player in precipitating the rise in secure traffic over the past few years. Firefox Telemetry shows that HTTPS traffic is at 81% for US users and 73% for all users.</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2018/07/Screen-Shot-2018-07-24-at-10.20.50-AM.png?ssl=1\"><img /></a></p>\n<p><a href=\"https://transparencyreport.google.com/https/overview?hl=en\" rel=\"noopener noreferrer\" target=\"_blank\">Google&#8217;s Transparency report</a> shows similar numbers for percentage of pages loaded over HTTPS in Chrome. 84% of US traffic is encrypted by HTTPS.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/07/Screen-Shot-2018-07-24-at-10.40.02-AM-e1532446916438.png?ssl=1\"><img /></a></p>\n<p>Google has even more weapons in its arsenal for compelling website owners to switch to HTTPS. Even before Chrome began flagging unencrypted sites, the search engine added <a href=\"https://webmasters.googleblog.com/2014/08/https-as-ranking-signal.html\" rel=\"noopener noreferrer\" target=\"_blank\">HTTPS as a ranking signal in 2014</a>. It started as a lightweight signal that affected fewer than 1% of global queries. Google has also indicated that <a href=\"https://searchengineland.com/googles-gary-illyes-https-may-break-ties-between-two-equal-search-results-230691\" rel=\"noopener noreferrer\" target=\"_blank\">HTTPS may break ties between two equal search results</a>, making a difference for competitive niches. With more sites adopting HTTPS as the norm, the company may choose to strengthen the signal in the future.</p>\n<p>Not everyone is comfortable with a for-profit company making an aggressive push to require websites to deliver content over HTTPS. Some fear that prioritizing encryption in search results, while also using Chrome to cast doubt on websites&#8217; security, is just the beginning.</p>\n<p>Dave Winer, one of Google&#8217;s most vocal critics regarding this initiative, sees the push towards HTTPS as <a href=\"http://this.how/googleAndHttp/\" rel=\"noopener noreferrer\" target=\"_blank\">the company&#8217;s attempt to take control of the open web</a>. His concern is that if Google succeeds, it might &#8220;make a lot of the web&#8217;s history inaccessible.&#8221;</p>\n<p>&#8220;Google makes a popular browser and is a tech industry leader,&#8221; Winer said. &#8220;They can, they believe, encircle the web, and at first warn users as they access HTTP content. Very likely they will do more, requiring the user to consent to open a page, and then to block the pages outright.&#8221;</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">BTW, if I had to guess, the *real* reason Google hates HTTP has to do with Google\'s ad revenue, and not wanting Verizon and Comcast to remove their ads and replace them with their own. <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f61c.png\" alt=\"😜\" class=\"wp-smiley\" /></p>\n<p>&mdash; scripting.com (@davewiner) <a href=\"https://twitter.com/davewiner/status/1021500417241427968?ref_src=twsrc%5Etfw\">July 23, 2018</a></p></blockquote>\n<p></p>\n<p>Others have speculated that another driving factor behind Google&#8217;s push for HTTPS adoption may be its investment in <a href=\"https://www.i-programmer.info/news/87-web-development/11367-google-starts-its-push-to-progressive-web-apps-bye-bye-chrome-apps.html\" rel=\"noopener noreferrer\" target=\"_blank\">advancing PWA technologies</a>, which require HTTPS to be enabled. Last year <a href=\"https://www.zdnet.com/article/google-removes-chrome-apps-from-chrome-web-store/\" rel=\"noopener noreferrer\" target=\"_blank\">Google dumped Chrome apps from the Chrome Web Store</a> in favor of building PWAs that can be installed on the desktop. HTTPS is a requirement for the permission workflows, new features, and updated APIs that the company is using to build its future products.</p>\n<p>It&#8217;s easy to see how HTTPS is critical for e-commerce, banking, and other sites that collect highly sensitive data from users, but many wonder if it is necessary for simple blogs and content websites. Google contends that <a href=\"https://developers.google.com/web/fundamentals/security/encrypt-in-transit/why-https\" rel=\"noopener noreferrer\" target=\"_blank\">all websites need HTTPS protection</a> to prevent intruders from injecting ads or exploits.</p>\n<p>Few would dispute the value of HTTPS but critics are wary of Google establishing itself as the arbiter of safe browsing on the web.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">My blog, <a href=\"https://t.co/gPQ9VPYOLB\">https://t.co/gPQ9VPYOLB</a>, is not “not secure.” It uses the standard protocol of the web, HTTP.  It will not hurt you.</p>\n<p>&mdash; scripting.com (@davewiner) <a href=\"https://twitter.com/davewiner/status/1021713459380187136?ref_src=twsrc%5Etfw\">July 24, 2018</a></p></blockquote>\n<p></p>\n<p>For the moment, Winer seems to be committed to using HTTP to deliver his content. In Google&#8217;s feverish quest to push the entire web to adopt HTTPS, sites that are holding fast to HTTP on principle now appear as a sort of protest.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2018/07/Screen-Shot-2018-07-24-at-5.49.33-PM.png?ssl=1\"><img /></a></p>\n<p>&#8220;This blog and all my other sites use HTTP,&#8221; Winer said. &#8220;I don&#8217;t see that changing. I expect this will make writing for the web more of a chore. That&#8217;s life I guess. I don&#8217;t want Google to be able to mold the web to its needs. I never signed on to being a Google developer, and never would. Basic rule: Google is a guest on the web, as we all are, and guests don&#8217;t make the rules.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 24 Jul 2018 23:07:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"Mark Jaquith: Page Links To v3.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"http://markjaquith.wordpress.com/?p=5675\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://markjaquith.wordpress.com/2018/07/23/page-links-to/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2482:\"<p>Today I pushed an update to my redirect and repointing plugin, <a href=\"https://wordpress.org/plugins/page-links-to/\">Page Links To</a>. Tomorrow, this plugin will have been in the WordPress.org Plugin Directory for 13 years (it was the 339th plugin in the WordPress plugin repository; there are now over 75,000!).</p>\n<p>To celebrate its transition to a teenager, I&#8217;ve added some new features and UI enhancements.</p>\n<p>Last month, I received survey responses from over 800 Page Links To users and learned a lot about how it&#8217;s being put to work. One of the most interesting things I found was how many people are using it for URL redirects. For example, they might have a really long URL on their own site or someone else&#8217;s site that they want to be nice. <em>example.com/summer-sale</em> instead of <em>example.com/store/specials.aspx?season=summer&amp;_utm_source=internal</em>. But in order to create these redirects, you have to go through the cluttered and sometimes slow post creation screen. All you really need to create a redirect is a title, a destination URL, and a local short URL.</p>\n<p>You&#8217;ll now find a menu item &#8220;Add Page Link&#8221; that will allow you to quickly add a redirected Page without having to wait for the entire WordPress post editing interface to load. It&#8217;s <em>super</em> fast, and it doesn&#8217;t redirect you away from the screen you&#8217;re on.</p>\n<p><img /></p>\n<p>Since short URLs are better for sharing (and remembering), the UI will give you a little push to shorten the URL if the one generated from your title is too long. From there, you can Save Draft or Publish.</p>\n<img />Hey, that URL is getting a bit long\n<img />Custom slug, for a better short URL\n<p>Additionally, this release includes a &#8220;link&#8221; indicator on post and page list screens, so you can easily see what items have been re-pointed with Page Links To. When hovered, the link icon will reveal the destination URL for a quick view.</p>\n<img />The &#8220;link&#8221; icon means that this item has been pointed elsewhere.\n<p>If you want to grab the &#8220;local&#8221; short URL (which will be redirected to your chosen URL when someone visits it), just click &#8220;Copy Short URL&#8221; from the actions, and it&#8217;ll be in your clipboard.</p>\n<img />Hover the &#8220;link&#8221; icon to see where it&#8217;s pointing.\n<p>That&#8217;s it for version 3.0, but I&#8217;ll have more to announce soon — stay tuned!</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Jul 2018 22:02:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Mark Jaquith\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"WPTavern: Thoughts From Two Founders Who Recently Sold Their WordPress Businesses\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=82531\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://wptavern.com/thoughts-from-two-founders-who-recently-sold-their-wordpress-businesses\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2299:\"<p>Last month, <a href=\"https://wptavern.com/wp-engine-acquires-studiopress\">WP Engine acquired StudioPress</a>. Brian Gardner, founder of StudioPress, recently <a href=\"https://authentik.com/sell/\">shared his thoughts</a> on why he didn&#8217;t want to sell the business, but did. </p>\n\n<blockquote class=\"wp-block-quote\"><p>Making a decision that not only affects your livelihood, the livelihood of your partners and employees, and the livelihood of an entire community isn’t for the faint of heart. It certainly wasn’t a responsibility I took lightly and spent quite a bit of time wrestling with.</p><p>The fact of the matter is this: When you make a decision that affects thousands of people, you <em>have</em> to wrestle with it. And then wrestle with it some more.</p><cite>Brian Gardner</cite></blockquote>\n\n<p>I appreciate Gardner&#8217;s down-to-earth perspective on how he reached the decision to sell. </p>\n\n<p>Ryan Sullivan, founder of WP Site Care, <a href=\"https://www.wpsitecare.com/wp-site-care-joins-forces-with-southern-web/\">sold his WordPress maintenance and support business</a> to Southern Web. On his personal site, <a href=\"https://www.ryandsullivan.com/changes/\">Sullivan describes</a> what it has been like to run a business the last seven years and drifting away from the reason he created the business in the first place. </p>\n\n<blockquote class=\"wp-block-quote\"><p>As the team grew, I slowly moved further and further away from the reason I started my business in the first place. It’s a trend that’s talked about extensively in the E-Myth. </p><p>People start a business because they love what they do, but then the growth of the business, management of people, and demands of administrivia become too much, and the person who started the business finds themselves in a totally foreign land with no roadmap for how to get back to the thing they once loved.</p><cite>Ryan Sullivan</cite></blockquote>\n\n<p>Merging with Southern Web allows Sullivan to get back to what he enjoys doing most, helping people and businesses with their sites. Sullivan also shared a great piece of advice, &#8220;Ask for help before you think you need it.&#8221;</p>\n\n<p>Both articles are great reads and provide insight into the tough decisions founders inevitably have to make. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Jul 2018 21:08:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"WPTavern: WP-CLI Hack Day Is A Success\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=82458\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://wptavern.com/wp-cli-hack-day-is-a-success\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2239:\"<p>Alain Schlesser hosted the first <a href=\"https://wptavern.com/wp-cli-hack-day-friday-july-20th\">WP-CLI Hack Day</a> last Friday and by all accounts, it was a smashing success.</p>\n\n<p>The main goal was to merge 20 pull requests during the event but due to technical issues with <a href=\"https://travis-ci.org/\">Travis CI</a>, only 12 were merged. Travis CI is open source software used to perform automated testing. </p>\n\n<p>In addition to the 12 pull requests that were merged, 13 more were submitted. The last two hours of the event featured a video call where contributors could talk through issues or receive help on submitting pull requests. </p>\n\n<p>&#8220;We peaked at 13 participants to that video chat,&#8221; Schlesser said. &#8220;It allowed for people to make a more personal connection, which added another dimension to the act of contributing.&#8221;</p>\n\n<p>Despite not reaching the goal, Schlesser is pleased with how it turned out.</p>\n\n<p>&#8220;The event was also an experiment, to see whether a more direct, interactive form of contribution would attract more contributors,&#8221; he said. &#8220;I think it did succeed in doing so, and I think it was a positive experience for the participants.&#8221;</p>\n\n<p><a href=\"https://make.wordpress.org/cli/2018/07/21/wp-cli-hack-day-results/\">Feedback from participants</a> is positive and folks enjoyed having Schlesser available to answer questions and walk them through how to set up an environment for testing. </p>\n\n<blockquote class=\"wp-block-quote\"><p>Though we fell a little short of that goal, it was heartening to be a part of the communal experience, learn how to write my first Behat test (something that has been on my to-do list for a long time!), and get immediate feedback on my submitted pull request. And, of course, getting that PR merged was a thrill as well, as I can now say that I’ve contributed back to the project.</p><cite><a href=\"https://make.wordpress.org/cli/2018/07/21/wp-cli-hack-day-results/#comment-133\">Jeremy Ward</a></cite></blockquote>\n\n<p>You can find links to all of the merged and submitted pull requests on the <a href=\"https://make.wordpress.org/cli/2018/07/21/wp-cli-hack-day-results/\">WP-CLI Hack Day summary page</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Jul 2018 19:43:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"WPTavern: WordSesh Returns Wednesday, July 25, Experiments with Charging Attendees for Tickets\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=82496\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"https://wptavern.com/wordsesh-returns-wednesday-july-25-experiments-with-charging-attendees-for-tickets\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6630:\"<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2018/07/wordsesh.png?ssl=1\"><img /></a></p>\n<p><a href=\"https://wordsesh.com/\" rel=\"noopener noreferrer\" target=\"_blank\">WordSesh</a>, a virtual conference dedicated to WordPress topics, is returning for a 5th edition on Wednesday, July 25, 2018. <a href=\"https://twitter.com/scottbasgaard\" rel=\"noopener noreferrer\" target=\"_blank\">Scott Basgaard</a>, the original organizer of the event, has passed the torch this year to <a href=\"https://twitter.com/rzen\" rel=\"noopener noreferrer\" target=\"_blank\">Brian Richards</a>, who has co-organized previous WordSesh events.</p>\n<p>The online-only event will feature 12 hours of sessions on a variety of tech and business topics, including e-commerce, freelancing, and security. In the past, WordSesh has been a marathon 24-hour event, but Richards decided to pare it down to 12 hours this year in order to organize the details quickly and get the next event on the calendar as soon as possible.</p>\n<h3>WordSesh Experiments with Charging Attendees for Tickets, Adds Real-Time Transcription</h3>\n<p>For the first time in WordSesh history, the event is charging attendees for tickets (rather than making it free for everyone as in years past). Richards is using the ticket money to pay speakers and have every video professionally transcribed in real-time. He has received some pushback on the decision but wants to see how things fare with this arrangement.</p>\n<p>&#8220;I thought the community might get behind that so we can stop asking speakers to completely volunteer their time, and the transcriptions are a huge accessibility bonus for non-native English speakers as well as the hard of hearing,&#8221; Richards said. &#8220;There have been just a few people pipe up to voice their distaste that I converted a free event to a paid event, which suggests there are many others stewing about it quietly, and I’m guessing it’s because they don’t realize where the money’s going (not that it should matter in either case).&#8221;</p>\n<p>Richards said tickets are dynamically priced to be the operational equivalent of $25 USD in every person&#8217;s home country. In India, for example, the ticket price is closer to $9 USD. He has kept quiet about the tech until now because he didn&#8217;t want people gaming the system but has since decided that it&#8217;s not a major concern.</p>\n<p>&#8220;The site accounts for purchase power parity so that the cost is not more than a couple of billable hours (or, ideally, much less) for everyone,&#8221; Richards said. &#8220;And for people whom the cost of a ticket is still a stretch, well, that’s where the scholarships come in.&#8221;</p>\n<p>WordSesh still has 18 donated scholarships to give away but Richards said he is struggling to find people willing to apply to watch the event for free. Prospective attendees can <a href=\"https://wordsesh.com/product/wordsesh-scholarship/\" rel=\"noopener noreferrer\" target=\"_blank\">apply for a scholarship or nominate others to receive one</a>.</p>\n<p>A ticket to the event grants attendees access to the sessions, both live and after it has been recorded. Attendees will also receive virtual swag. A few samples include:</p>\n<ul>\n<li>A steep discount on WPSessions annual memberships (33%)</li>\n<li>Stripe is providing an exclusive link to skip the invitation process on their Atlas program and cover the cost for processing their first $5k of payments</li>\n<li>CorgiBytes is offering a $1k discount (~20%) on their code auditing services</li>\n</ul>\n<p>Previous WordSesh events averaged 1,000 online attendees and a good portion of them showed up the same day the events aired. This year there are approximately 400 registered so far. Richards said he won&#8217;t rule out the possibility of making the event free again for the next edition.</p>\n<p>&#8220;Asking more from sponsors could make a free event possible again without paying for everything personally (right now I&#8217;m still about $1000 in the red), but I really want to put the onus on the community at large,&#8221; Richard said. &#8220;Quality events take a lot of time and effort to accomplish, and most of that cost is on the backs of the organizers, speakers, and sponsors rather than attendees (at least in the WP community). Having been in all of those seats I&#8217;d really like to see more responsibility shift to the attendees. I would personally be happy to pay more for an event and be glad knowing that both speakers and organizers weren&#8217;t burning all this time in hopes of a return.&#8221;</p>\n<p>Virtual conferences have started gaining more traction in the global WordPress community after the success of previous WordSesh events. WordPress educator Zac Gordon recently hosted more than 1,000 attendees at his free <a href=\"https://wptavern.com/free-javascript-for-wordpress-conference-to-stream-live-friday-june-29\" rel=\"noopener noreferrer\" target=\"_blank\">JavaScript for WordPress conference</a> in June. The Polyglots&#8217; virtual <a href=\"https://wptranslationday.org/\" rel=\"noopener noreferrer\" target=\"_blank\">Global WordPress Translation day</a> has also attracted hundreds of participants at each event (448 attendees in April 2016, 780 attendees in November 2016, and 1,300 local event RSVPs in September 2017).</p>\n<p>Virtual events often reach far more people than an average local WordCamp, and many also inspire in-person meetups. Watch parties for WordSesh&#8217;s 5th edition are happening in cities across the globe, including Antwerp, Lagos, Minneapolis, Mumbai, and Bar Harbor (Maine).</p>\n<p>&#8220;I’ve always enjoyed seeing people pour in to the event each year, and there was a delightful hum throughout the WordPress community every time a WordSesh took place,&#8221; Richards said.</p>\n<p>WordSesh has been a valuable addition to the virtual event space around WordPress, and attendee numbers at the upcoming event will be important for measuring how much traction the event can retain with its conversion to a paid event. Richards says he is committed to keeping the event alive and hopes to host it two times per year, which is one of the reasons for cutting it back to 12 hours.</p>\n<p>&#8220;I’m already excited for the next event,&#8221; Richards said. &#8220;I’m a little concerned at the moment, only because I don’t expect this one will sell enough tickets to break even, but I’m absolutely committed to hosting WordSesh again in the future. I’m more interested in hosting an incredible event and providing a ton of value to attendees than I am in breaking even this time around.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Jul 2018 17:41:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"WPTavern: Gutenberg 3.3 Released, Adds Archives and Recent Comments Blocks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=82478\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wptavern.com/gutenberg-3-3-released-adds-archives-and-recent-comments-blocks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1354:\"<p><a href=\"https://wordpress.org/plugins/gutenberg/\"></a></p>\n\n<p><a href=\"https://wordpress.org/plugins/gutenberg/\">Gutenberg 3.3</a> is available and <a href=\"https://make.wordpress.org/core/2018/07/20/whats-new-in-gutenberg-20th-july/\">continues the trend</a> of refining the user experience, user interface, and tools. Two new Widget blocks have been added, Post Archives and Recent Comments.<br /></p>\n\n<img />Archive and Recent Comments Widget Blocks\n\n<p>If your archives span across multiple months and years, you can configure the block to display as a drop-down menu. Otherwise, the list may be too long and look unwieldy on your site.</p>\n\n<p>Video blocks now have attributes users can can configure for Autoplay, Loop, Muted, and display Playback Controls. </p>\n\n<img />Video Block Attributes\n\n<p>There are a number of enhancements in this release that you can view via <a href=\"https://make.wordpress.org/core/2018/07/20/whats-new-in-gutenberg-20th-july/\">the change log</a>. </p>\n\n<p>Considering Gutenberg 3.2 <a href=\"https://make.wordpress.org/core/2018/07/06/whats-new-in-gutenberg-6th-july/\">released earlier this month</a> generally completed the MVP or minimum viable product feature set, users can expect more of these types of releases to tie up loose ends and prepare Gutenberg for merge into WordPress 5.0 later this year.  </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 21 Jul 2018 01:31:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"WPTavern: Karachi to Host First WordCamp in Pakistan Following Cancellation of WordCamp Lahore\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=82062\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"https://wptavern.com/karachi-to-host-first-wordcamp-in-pakistan-following-cancellation-of-wordcamp-lahore\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9479:\"<a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2018/06/Karachi_from_above.jpg?ssl=1\"><img /></a>photo credit: <a href=\"https://commons.wikimedia.org/wiki/File:Karachi_from_above.jpg\">Bilalhassan88</a>\n<p><a href=\"https://2018.karachi.wordcamp.org/\" rel=\"noopener noreferrer\" target=\"_blank\">WordCamp Karachi</a> is happening on August 4, 2018, and organizers are expecting more than 400 attendees. Karachi is the largest city in Pakistan with a population of more than 30 million people. Its airport connects the country to other international cities and smaller cities within Pakistan are available by rail or bus. Organizers behind the camp are overcoming a rocky history that has plagued the planning of WordPress-related events in the country for the past several years.</p>\n<p>At the close of 2015, Pakistan was on track to host its first WordCamp in Lahore, building on momentum from the <a href=\"https://wptavern.com/wordpress-community-growing-in-pakistan-500-attend-lahore-meetup\" rel=\"noopener noreferrer\" target=\"_blank\">phenomenal growth of the local meetup group</a>. <a href=\"https://profiles.wordpress.org/xpertone\" rel=\"noopener noreferrer\" target=\"_blank\">Muhammad Kashif</a>, one of the organizers, was averaging 200-500 attendees at meetups and his team&#8217;s application to host <a href=\"https://wptavern.com/wordcamp-pakistan-application-approved-for-2016\" rel=\"noopener noreferrer\" target=\"_blank\">WordCamp Lahore was approved for 2016</a>.</p>\n<p>The meetup events, which attracted young students, developers, freelancers, and entrepreneurs, had grown so large that Kashif was having to close registration ahead of time because they were exceeding the capacity of the venue. Organizers expected 400-500 attendees at the WordCamp before it was cancelled after several delays near the end of the planning stage.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2015/12/lahore-pakistan-wordpress-meetup-featured.jpg?ssl=1\"><img /></a></p>\n<p>After contacting the WordPress Community team for the reason why it was cancelled, I received an official response from representative Hugh Lashbrooke:</p>\n<blockquote><p>Sometimes a WordCamp doesn’t make it all the way from pre-planning to being an actual event — occasionally due to logistical challenges, but other times because of broader concerns. In this case, once the WordCamp planning was underway, some tense dynamics arose within the local team. Everyone worked really hard to reach a positive solution, but we weren’t able to move forward with the event in the end.</p>\n<p>Cancelling an event is never anyone’s preference, to be clear, but it is also a customary response when it’s clear that collaboration isn’t possible in the short term. Local organizers are always encouraged to reapply as soon as the barriers to collaboration have been resolved.</p></blockquote>\n<p>Lashbrooke also cited issues with the camp&#8217;s budget for the venue organizers selected. He said the situation was thoroughly investigated before the camp was cancelled and that they would never take that kind of decision lightly.</p>\n<p>WordCamp Lahore organizers gave me a different report on what happened and were disappointed with the decision from the Community Team.</p>\n<p>&#8220;Representatives from the Foundation cancelled the camp in the last stage based on a complaint from one person out of a community of 3,000 people,&#8221; Kashif said. &#8220;The Foundation made a direct decision of cancellation without giving me a chance for explanation as the Primary Organizer. I suggested the Foundation conduct a survey from the whole Lahore community to know the facts but they had already made the decision to cancel.&#8221;</p>\n<p>Kashif claims there was no disagreement between the organizers, because the community member in question, <a href=\"https://profiles.wordpress.org/mrahmadawais\" rel=\"noopener noreferrer\" target=\"_blank\">Ahmad Awais</a>, was never part of the original organizing team.</p>\n<p>One member of the planning team agreed to speak to me anonymously about why he believes the camp was canceled. He claims that Awais fractured the team after his request to be given a prominent position in the organization was denied.</p>\n<p>&#8220;Ahmad Awais started hijacking Kashif and his team,&#8221; he said. &#8220;He was not a lead organizer at all, but on the planning team. Instead of contributing, Ahmad wanted to speak at every meetup and didn’t spend time with organizing team. He broke the team and started pointing fingers at Kashif and the existing organizing team. He was NOT there until WC Lahore was approved. He joined the team after that.&#8221;</p>\n<p>Multiple leaders from WordCamp Karachi&#8217;s 14-person organizing team, who wish to remain anonymous, have reported that Awais also requested to be named keynote speaker and was unhappy with the team after they told him that speaker decisions do not work like that. Several said they feared his retaliation against the camp, given they previously had no recourse with the Community Team after the experience of WordCamp Lahore getting shut down.</p>\n<p>Awais is not attending WordCamp Karachi and has declined to answer any questions about WordCamp Lahore due to personal reasons.</p>\n<p>Kashif received hundreds of messages from the community after the event in Lahore was cancelled. He had been working since 2013 to bring a WordCamp to the area. He said that while the Community Team was helpful with other queries he had, he was disappointed with how quickly the camp was cancelled.</p>\n<p>&#8220;I worked tirelessly for years to get a WordCamp to Lahore and grew the community from 430 to 2600 in one year but the Foundation didn’t even give me a chance to explain before canceling WC Lahore, Kashif said. &#8220;I am a bit disheartened by that action.&#8221;</p>\n<p>Kashif is now helping with other WordCamps, including Karachi and NYC. He is also willing to work to re-establish a WordCamp Lahore in the future.</p>\n<p>&#8220;Like me there are lots of other WordPress enthusiasts in Pakistan who want to participate in WordCamps but not everyone can do that outside of Pakistan due to financial or visa reasons,&#8221; Kashif said. &#8220;I was accepted as a volunteer in WordCamp Europe but couldn’t join due to visa issues. I have seen so much excitement for WordCamp Karachi in the WordPress community across the whole country. Everyone is willing to help to make it a successful event so that there are more frequent WordCamps in Pakistan. The first one is so important as it will set expectations of outcomes of a WordCamp for people who are new to these events.&#8221;</p>\n<h3>WordCamp Karachi Organizers Aim to Make a Positive Impact on Pakistan</h3>\n<p>WordCamp Karachi organizers are attempting to move past the Pakistani WordPress community&#8217;s checkered history of contention. They are also eager to distance themselves from the conflict that took down WordCamp Lahore.</p>\n<p><a href=\"https://profiles.wordpress.org/usmankhalid/\" rel=\"noopener noreferrer\" target=\"_blank\">Usman Khalid</a>, lead organizer of the camp, said he has put in a lot of effort asking organizers and volunteers to work together, regardless of the credit they will receive, and focus on the community.</p>\n<p>&#8220;I want to spend time on having a positive impact for this country, avoiding any kind of noise,&#8221; Khalid said. &#8220;The Pakistani WordPress community is vibrant in many ways. We have around 6,000 plus WordPressers in our community, with people who are selling their products and services worldwide.&#8221;</p>\n<p>Khalid said there are many users in Karachi, Lahore, Islamabad, Peshawer, and Faisalabad who are doing well with WordPress but are not yet connected to the community or participating in meetups and events. People from all over Pakistan will be attending the event as their first exposure to the WordPress community. Sessions will mostly be conducted in English but a few will be mixed with Urdu, the regional language.</p>\n<p>Khalid has experienced many growing pains in bringing the event to a community that is new to understanding how WordCamps work. In a country that is <a href=\"https://wptavern.com/pakistan-is-blocking-sites-hosted-on-wordpress-com\" rel=\"noopener noreferrer\" target=\"_blank\">notorious for its censorship</a>, WordPress&#8217; mission of democratizing publishing has the potential to change many lives.</p>\n<p>&#8220;Since this is first Wordcamp, many people even don&#8217;t know about it,&#8221; Khalid said. &#8220;Those who know want to be a speaker, or any lead role that can promote them. When we tell them it doesn&#8217;t work like this, they are mostly get annoyed.&#8221;</p>\n<p>Tech publications around Pakistan have not been exposed to WordCamps either. Khalid said several of them have asked for money in order to cover the story of the event, unaware that the purpose of the camps and meetups is not to translate everything into business but to give back to the community.</p>\n<p>&#8220;I am simply working to actually deliver first and prove that this community can create a positive impact,&#8221; Khalid said. &#8220;I am sure after Wordcamp Karachi, the entire community within Pakistan will flourish, regardless of what happened in Lahore.&#8221; He said he hopes the next camps will be even more interesting in the future and that WordCamp Karachi will help to create new jobs and more businesses in Pakistan.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 20 Jul 2018 23:14:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"Post Status: Why the makers of Ninja Forms are getting into eCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=46627\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://poststatus.com/why-the-makers-of-ninja-forms-are-getting-into-ecommerce/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1982:\"<p>Welcome to the Post Status <a href=\"https://poststatus.com/category/draft\">Draft podcast</a>, which you can find <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\">on iTunes</a>, <a href=\"https://play.google.com/music/m/Ih5egfxskgcec4qadr3f4zfpzzm?t=Post_Status__Draft_WordPress_Podcast\">Google Play</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\">Stitcher</a>, and <a href=\"http://simplecast.fm/podcasts/1061/rss\">via RSS</a> for your favorite podcatcher. Post Status Draft is hosted by Brian Krogsgard and co-host Brian Richards.</p>\n<p>In this episode, I bring on James Laws and Kevin Stover &#8212; cofounders of Saturday Drive, the parent company of Ninja Forms &#8212; to discuss why they are entering the world of eCommerce. I found this especially interesting given the market dominance of WooCommerce for general WordPress-based eCommerce needs.</p>\n<p>Saturday Drive purchased Exchange, the plugin initially developed by iThemes and then handed off to A.J. Morris, with the intention of making a play for the eCommerce market, much like they did successfully once already for the somewhat-saturated forms market.</p>\n<p></p>\n<h3>Episode Links</h3>\n<ul>\n<li>Ninja Shop <a href=\"https://wordpress.org/plugins/ninja-shop/\">plugin</a></li>\n<li>Ninja Shop <a href=\"https://ninjashop.site/\">website</a></li>\n<li>James Laws <a href=\"https://wordpress.org/plugins/ninja-shop/\">on Twitter</a></li>\n<li>Kevin Stover <a href=\"https://twitter.com/kstover\">on Twitter</a></li>\n</ul>\n<h3>Sponsor: Sandhills Development</h3>\n<p><a href=\"http://sandhillsdev.com/\">Sandhills Development</a> makes a suite of excellent plugins to power your WordPress website. Whether you need to sell digital downloads, restrict content, create an affiliate program, or manage an events calendar, they&#8217;ve got you covered. Thanks to <a href=\"http://sandhillsdev.com/\">Sandhills</a> for being a Post Status partner.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 20 Jul 2018 22:29:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"WPTavern: WordPress 4.9.8 Will Significantly Reduce Memory Leak\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=82423\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://wptavern.com/wordpress-4-9-8-will-significantly-reduce-memory-leak\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2723:\"<p><a href=\"https://make.wordpress.org/core/2018/07/19/wordpress-4-9-8-beta-2/\">WordPress 4.9.8 Beta two</a> recently shipped and although much of the focus will be on the <a href=\"https://wptavern.com/first-look-at-try-gutenberg-prompt-in-wordpress-4-9-8-beta-2\">&#8220;Try Gutenberg&#8221;  call-out</a>, there&#8217;s a patch included that addresses a memory leak that was quite a problem for some users. </p>\n\n<p>When <a href=\"https://wordpress.org/news/2018/07/wordpress-4-9-7-security-and-maintenance-release/\">WordPress 4.9.7 shipped</a>, ﻿the WordPress.org support forums saw an <a href=\"https://wordpress.org/support/topic/wp_is_stream-crashing-the-server/\">increase</a> in <a href=\"https://wordpress.org/support/topic/fatal-error-allowed-memory-size-of-11/\">reports</a> of memory exhausted errors due to the <a href=\"https://developer.wordpress.org/reference/functions/wp_is_stream/\">wp_is_stream function</a>. </p>\n\n<p>The bug is actually in PHP and is related to the <a href=\"http://php.net/manual/en/function.stream-get-wrappers.php\">stream-get-wrappers</a> function. WordPress 4.9.7 increased the number of times it calls the wp_is_stream() function generating the error more often.</p>\n\n<p>After thoughtful conversations within the <a href=\"https://core.trac.wordpress.org/ticket/44532#comment:46\">trac ticket</a>, a patch was created that after further testing, was committed to core. ﻿<a href=\"https://core.trac.wordpress.org/ticket/44532#comment:46\">According to Gary Pendergast</a>, the patch does the following.</p>\n\n<blockquote class=\"wp-block-quote\">\n	<p>Bailing if the path isn&#8217;t a stream. This isn&#8217;t perfect: it&#8217;s still possible to trigger the PHP bug, but it does significantly reduce the chances of the bug being encountered. For many WordPress sites (those that don&#8217;t have plugins that use streams), it reduces the chance to zero.</p>\n</blockquote>\n\n<p>If you encountered memory exhaustion errors after installing or upgrading to WordPress 4.9.7, try <a href=\"https://make.wordpress.org/core/2018/07/19/wordpress-4-9-8-beta-2/\">WordPress 4.9.8 Beta 2</a> to see if it fixes the issue.</p>\n\n<p>Aside from coming up with a solution, <a href=\"https://core.trac.wordpress.org/ticket/44532\">Trac ticket #44532</a> is a bit refreshing to see. In open source, tickets or issues can get bogged down with suggestions, hypothetical scenarios, and bike-shed commentary.</p>\n\n<p>In this instance, the issue was identified and folks from the community along with core contributors worked together in a focused fashion to create a fix in time for the next point release. The ticket is a good example of what it&#8217;s like when open source is firing on all cylinders.  <br /></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 20 Jul 2018 20:33:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"Donncha: WP Super Cache and Cookie Banners\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://odd.blog/?p=89501949\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://odd.blog/2018/07/20/wp-super-cache-and-cookie-banners/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5290:\"<p>More sites use cookie banners now that the GDPR is active but some are finding that their banners are misbehaving once they enable caching.</p>\n\n<p>This is a similar issue to the one that happened to some page counter plugins in the past. The page counter wouldn&#8217;t increment.</p>\n\n<p>When a cookie banner is clicked a cookie is set in the browser so the website knows this visitor has agreed to accept cookies. If the cookie is set then the cookie banner html is not sent to the browser.</p>\n\n<p>I suspect the main issue is that the code that sets and checks if the cookie is set is PHP. Unfortunately because the page is cached then no PHP code is executed, and the cookie banner is displayed because it was originally cached that way.<br /></p>\n\n<p>Since WP Super Cache only knows about certain WordPress cookies it assumes everyone who doesn&#8217;t have those cookies is a first time &#8220;anonymous&#8221; visitor. It doesn&#8217;t know about your cookie banner cookie.<br /></p>\n\n<p>You have two options:</p>\n\n<ol>\n	<li>Rewrite your cookie banner so it&#8217;s completely in Javascript. Do the cookie detection in Javascript and also set the cookie in Javascript. If the cookie banner has been clicked then you need to trigger an action, and other Javascript that is hooked on to that trigger will run and load the tracking cookies.</li>\n	<li>Modify WP Super Cache so it knows about the cookie your cookie banner uses. Caching won&#8217;t work quite as well as before as it&#8217;ll be split between visitors who have clicked the cookie banner and those that haven&#8217;t. One cached file will display the cookie banner, and the other will not but it will have ad tracking Javascript.<br /></li>\n</ol>\n\n<p>Using Javascript completely is a better solution because it runs in the browser on every page load but that might not be possible every time.</p>\n\n<p>Otherwise, use PHP to get WP Super Cache to play nicely with your existing code:</p>\n\n<ol>\n	<li>You&#8217;ll need to write a <a href=\"https://odd.blog/2017/10/25/writing-wp-super-cache-plugins/\">WP Super Cache plugin</a>.</li>\n	<li>You need to hook into the wp_cache_get_cookies_values cacheaction and add the value of the cookie banner cookie to the end of that string.</li>\n	<li>Caching can only be performed by <em>simple</em> caching now, unless you&#8217;re willing to edit mod_rewrite rules in your .htaccess file.</li>\n</ol>\n\n<p>Something like this will do. Make sure you note the warning about <code>$wp_cache_plugins_dir</code> in the link above about writing these plugins.<br /></p>\n\n<pre class=\"wp-block-code\"><code>function add_cookie_banner_to_cache_cookie( $string ) {\n    if ( isset( $_COOKIE[\'cookie_banner\'] ) ) {\n        $string .= \'cb,\';\n    }\n    return $string\n}\nadd_cacheaction( \'wp_cache_get_cookies_values\', \'add_cookie_banner_to_cache_cookie\' );</code></pre>\n\n<p>Substitute the name of the cookie for your cookie name, change the name of the function, and the text it adds to the string. There is an intentional PHP fatal error in the code above to discourage copy/pasting.<br /></p>\n\n<p>Your cookie banner plugin could automate setting this up, but it may have unforeseen consequences if not done correctly. It should check if <code>$wp_cache_plugins_dir</code> is set already, and use that location, otherwise it will have to make a directory and update the WP Super Cache configuration, where ABC is the new location for the plugins.<br /></p>\n\n<p><code>wp_cache_setting( \'wp_cache_plugins_dir\', ABSPATH . \'wp-content/ABC\' );﻿</code></p>\n\n<p>The new code can be copied into a file in that directory. The files in the original WP Super Cache plugins directory (found at <code>WPCACHEHOME . \'plugins\'</code>) should be copied into that directory too and a warning shown to the user. They may need to set up one of those plugins again.<br /></p>\n\n<p>The reason it is this convoluted is because this code will run before all of WordPress loads. You can&#8217;t rely on blog options or most of the nice configuration tools WordPress provides.<br /></p>\n\n<p>When your plugin is uninstalled it should of course restore the plugins directory to the way it was before.</p>\n\n<p>For future reference, since cookie banners will hopefully not be around forever, here&#8217;s what they looked like in the deep, distant past of 2018. <img src=\"https://s.w.org/images/core/emoji/2.4/72x72/1f642.png\" alt=\"🙂\" class=\"wp-smiley\" /></p>\n\n<img />\n\n<img />\n	The LA Times just gave up and don&#8217;t show anything to EU visitors.\n\n\n<img />\n\n<img />\n\n<img />\n\n<p><strong>Related Posts</strong><ul><li> <a href=\"https://odd.blog/2003/08/12/linuxie-and-free-software-projects/\" rel=\"bookmark\" title=\"Permanent Link: Linux.ie and free software projects\">Linux.ie and free software projects</a></li><li> <a href=\"https://odd.blog/2008/10/24/wp-super-cache-084-the-garbage-collector/\" rel=\"bookmark\" title=\"Permanent Link: WP Super Cache 0.8.4, the garbage collector\">WP Super Cache 0.8.4, the garbage collector</a></li><li> <a href=\"https://odd.blog/2008/03/06/please-sir-can-i-have-more/\" rel=\"bookmark\" title=\"Permanent Link: Please sir, can I have more?\">Please sir, can I have more?</a></li></ul></p>\n<p><a href=\"https://odd.blog/2018/07/20/wp-super-cache-and-cookie-banners/\" rel=\"nofollow\">Source</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 20 Jul 2018 13:33:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Donncha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: First Look at “Try Gutenberg” Prompt in WordPress 4.9.8 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=82425\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"https://wptavern.com/first-look-at-try-gutenberg-prompt-in-wordpress-4-9-8-beta-2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3384:\"<p><a href=\"https://make.wordpress.org/core/2018/07/19/wordpress-4-9-8-beta-2/\" rel=\"noopener noreferrer\" target=\"_blank\">WordPress 4.9.8 Beta 2</a> was released today, featuring the new &#8220;<a href=\"https://core.trac.wordpress.org/ticket/41316\" rel=\"noopener noreferrer\" target=\"_blank\">Try Gutenberg</a>&#8221; prompt that will appear in user dashboards when the official release drops at the end of the month.</p>\n<p>The prompt invites users to install Gutenberg if they want to try the new editor or install the <a href=\"https://wordpress.org/plugins/classic-editor/\" rel=\"noopener noreferrer\" target=\"_blank\">Classic Editor</a> to keep using the current editor until they are ready to make the change. WordPress contributors discussed variations on the design and wording of the callout and finally settled on what you see in 4.9.8 Beta 2.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/07/Screen-Shot-2018-07-19-at-4.02.56-PM.png?ssl=1\"><img /></a></p>\n<p>Even if users don&#8217;t get involved in Gutenberg testing, the callout serves to inform them that the new editor will be enabled by default in the next major release of WordPress. It includes a link to the <a href=\"https://wordpress.org/gutenberg/\" rel=\"noopener noreferrer\" target=\"_blank\">Gutenberg information page</a> so users can learn more about the project.</p>\n<p>Contributors agreed that they wanted to clearly communicate three important points in the callout, as per designer @kjellr&#8217;s <a href=\"https://core.trac.wordpress.org/ticket/41316#comment:148\" rel=\"noopener noreferrer\" target=\"_blank\">suggestions on trac</a>:</p>\n<ol>\n<li>Gutenberg is coming in the next major release.</li>\n<li>If you’re worried about compatibility, there’s a plugin to help ease the transition.</li>\n<li>The plugin lets you use the editor you’re used to until you’re ready to switch.</li>\n</ol>\n<p>The prompt is clearly geared towards encouraging users to test Gutenberg, as that section has a more prominent, colored button. If your clients&#8217; installations are not ready for users to act on the &#8220;Try Gutenberg&#8221; prompt, now is the time to install a plugin that will disable it. Clients with free-range of the WordPress admin, in sites that are running Gutenberg-compatible extensions, are better candidates for testing the new editor.</p>\n<p>The <a href=\"https://wptavern.com/new-classic-editor-addon-plugin-disables-the-try-gutenberg-prompt-coming-in-wordpress-4-9-8\" rel=\"noopener noreferrer\" target=\"_blank\">Classic Editor Addon</a> is one option that will suppress the prompt and automatically suppress Gutenberg when it ships in WordPress 5.0. It was also recently updated to auto-install the Classic Editor plugin as a dependency so users don&#8217;t have to install two plugins as part of the process.</p>\n<p>A release candidate is slated for July 24, and the official 4.9.8 release is scheduled for July 31st. The <a href=\"https://wordpress.org/plugins/gutenberg/\" rel=\"noopener noreferrer\" target=\"_blank\">Gutenberg plugin</a> is currently sitting at 10,000+ active installations and the <a href=\"https://wordpress.org/plugins/classic-editor/\" rel=\"noopener noreferrer\" target=\"_blank\">Classic Editor</a> at 5,000+. After 4.9.8 is released, changes in these numbers will demonstrate how WordPress users across the globe are responding to the call for testing.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 Jul 2018 21:48:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"WPTavern: Insight Into How North Carolina State Is Preparing for Gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=82410\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://wptavern.com/insight-into-how-north-carolina-state-is-preparing-for-gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1838:\"<p>Jennifer McFarland, the web services coordinator for the North Carolina State Office of Information Technology (OIT), recently <a href=\"http://www.technicianonline.com/news/article_878f4bb0-7d8f-11e8-a5ac-4bf05738fe93.html\">did an interview</a> with <a href=\"http://www.technicianonline.com/\">Technician</a>, the official student newspaper of NC State University.</p>\n\n<p>Since Gutenberg&#8217;s announcement in December of 2017, McFarland has published a <a href=\"https://design.oit.ncsu.edu/tag/gutenberg/\">series of articles</a> on the NC State Office of Information Technology website educating staff and students on what to expect.</p>\n\n<p>McFarland was asked how the team plans to help staff and students after Gutenberg ships with WordPress.</p>\n\n<p>&#8220;A couple of times a year, we go and speak at various classes, professors will have us come out and do demos of WordPress,&#8221; McFarland told the Technician. </p>\n\n<p>&#8220;We are expecting an uptake of people requesting us to come out and do a demo of WordPress or something like that, but generally our plan right now, at least for students, is mostly just offer the sort of self-help, like the video tutorials and things like that, and we figure that the students will mostly try and solve their own problems.&#8221;</p>\n\n<p>Speaking of McFarland, she and Brian DeConinck <a href=\"https://2018.wpcampus.org/schedule/gutenready-for-the-gutenpocalypse/\">presented on Gutenberg</a> at WPCampus 2018. The videos from the event are still being processed but we&#8217;ll add a link to the presentation once it becomes available. </p>\n\n<p>It&#8217;s pretty cool to see people in McFarland&#8217;s position in higher education already have a firm grasp of Gutenberg and doing what they can to ease the transition for staff and students</p>\n\n<p></p>\n\n<p><br /></p><br /></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 Jul 2018 00:27:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"WPTavern: Meet Bernhard Kau, Local Lead Organizer of WordCamp Europe 2019 in Berlin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=82335\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://wptavern.com/meet-bernhard-kau-local-lead-organizer-of-wordcamp-europe-2019-in-berlin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4788:\"<p><a href=\"https://twitter.com/2ndkauboy?lang=en\" rel=\"noopener noreferrer\" target=\"_blank\">Bernhard Kau</a>, a WordPress developer, meetup organizer, and four-time organizer of WordCamp Berlin, is the local lead organizer for the next WordCamp Europe. Kau will join Milan Ivanović, the global lead, at the helm of WordCamp Europe in Berlin next June.</p>\n<p>Kau submitted an application with his team to host WCEU and won out over a competing application from the WordPress community in Barcelona. The selection team cited Berlin&#8217;s accessibility, reasonable prices, and its strong community as the final deciding factors.</p>\n<p>Berlin&#8217;s monthly WordPress meetups have 1,300 members. The community also holds dedicated meetups for beginners, developers, and women in WordPress. Five WordCamps have been organized in Berlin since 2010.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Attending <a href=\"https://twitter.com/hashtag/WPBerlin?src=hash&ref_src=twsrc%5Etfw\">#WPBerlin</a> and they are already preparing WordPress community for next <a href=\"https://twitter.com/hashtag/WCEU?src=hash&ref_src=twsrc%5Etfw\">#WCEU</a> <a href=\"https://t.co/MWLwTZ4hrf\">pic.twitter.com/MWLwTZ4hrf</a></p>\n<p>&mdash; Milan Ivanović (@lanche86) <a href=\"https://twitter.com/lanche86/status/1012396086944813057?ref_src=twsrc%5Etfw\">June 28, 2018</a></p></blockquote>\n<p></p>\n<p>&#8220;Compared to other communities in Europe, we are a community that is very likely to travel to other cities to attend meetups and other WordCamps,&#8221; Kau said. &#8220;We usually only have one or two WordCamps per year in Germany but then usually all the German community members travel to that city to attend the WordCamp. Whereas in Spain, for example, they had 11 WordCamps this year that are more local and smaller. As a German community we are more used to traveling to a central place and meeting there.&#8221;</p>\n<h3>What to Expect at WCEU in Berlin: A Diverse Community, More Workshops, and a Unique After Party</h3>\n<p>The <a href=\"https://www.estrel.com/en/home.html\" rel=\"noopener noreferrer\" target=\"_blank\">Estrel Hotel and Congress Center</a> will host the entire event, including both conference days, the contributor day, and the after party. Although the venue has a max capacity of 12,000 people, Kau said organizers are planning for 2,500 &#8211; 3,000 attendees. The local team is excited to introduce the European WordPress community to their home city.</p>\n<p>&#8220;Berlin is one of the most diverse cities in Europe,&#8221; Kau said. &#8220;When I prepared the application, I figured out that there are people from 191 countries living in Berlin. It&#8217;s a very international, very diverse city, so you can be just as you are and feel quite comfortable and welcome in Berlin.&#8221;</p>\n<p>Kau said organizers intend to continue with workshops as a part of the event in 2019 but they are planning to make the signup experience more efficient.</p>\n<p>&#8220;This was the first year we tried workshops,&#8221; Kau said. &#8220;We had three workshop tracks and workshops of 60 minutes, 90 minutes, and three hours. We are not sure how many workshops we want to have in Berlin. The idea was new but turned out quite well. There were workshops with many people waiting to get in and from what I&#8217;ve heard it was quite good.&#8221;</p>\n<p>Kau said he wants to improve the process for workshops, because there was no easy way for attendees to sign up and managing waiting lists was a lot of manual work for the content team. This is one bottleneck from the most recent WCEU experience that he hopes to rectify.</p>\n<p>&#8220;There is also something special planned but I don&#8217;t want to spoil it,&#8221; Kau said. &#8220;It&#8217;s going to be a very unique after party to say the least.&#8221; Although Berlin is renowned for its legendary nightlife, Kau said he doesn&#8217;t anticipate the party lasting all night.</p>\n<p>&#8220;We&#8217;re probably not going to make it Berlin-typical until 10 in the morning but it&#8217;s going to be a bit longer than maybe here [Belgrade] or in Paris where people were kicked at at 3:30,&#8221; he said.</p>\n<p>The <a href=\"https://2019.europe.wordcamp.org/2018/06/16/call-wordcamp-europe-2019-organizers/\" rel=\"noopener noreferrer\" target=\"_blank\">call for applications for organizers</a> is still open. Within 24 hours of announcing Berlin as the next host city, the team had already <a href=\"https://twitter.com/lanche86/status/1008419688009863169\" rel=\"noopener noreferrer\" target=\"_blank\">received 27 applications</a>. The application window closes July 31, 2018.</p>\n<p>Check out the full interview below to learn more about the German WordPress community and what they have planned for WCEU 2019.</p>\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Jul 2018 20:18:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"WPTavern: WP-CLI Hack Day Friday, July 20th\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=82269\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wptavern.com/wp-cli-hack-day-friday-july-20th\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1541:\"<p><a href=\"https://wp-cli.org/\">WP-CLI</a> or WordPress Command Line Interface has become an integral tool for developers to launch and manage sites. To encourage new contributors to the project, Alain Schlesser is organizing the first <a href=\"https://make.wordpress.org/cli/2018/07/04/wp-cli-hack-day/\">WP-CLI Hack Day</a>, Friday, July 20th beginning at 08:00 CEST.</p>\n\n<p>Schlesser and other contributors will be available in the <a href=\"https://wordpress.slack.com/messages/C02RP4T41\">WP-CLI Slack channel</a> all day and on the project&#8217;s <a href=\"https://github.com/wp-cli/\">GitHub site</a> to answer questions and help people contribute to the project. </p>\n\n<p>From 16:00-18:00 CEST, Schlesser will host a video call that&#8217;s open to everyone where people can join in, discuss issues, and visually work through pull requests. The goal is to reach 20 pull requests that have been merged during the event. A post on <a href=\"https://make.wordpress.org/cli/\">Make/CLI  blog</a> will be published once WP-CLI Hack Day concludes summarizing any progress that was made.</p>\n\n<p>To prepare prospecting contributors for the event, Schlesser has published a <a href=\"https://make.wordpress.org/cli/2018/07/14/contributing-to-wp-cli/\">detailed guide</a> on how to contribute to WP-CLI.</p>\n\n<p>Folks can follow along on Twitter using the hashtag <a href=\"https://twitter.com/hashtag/hackwpcli?src=hash\">#hackwpcli</a>. If Hack CLI Day is successful, more events will likely be created in the future to cover more time zones. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Jul 2018 16:47:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"HeroPress: Making A Safe Place\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://heropress.com/?p=2589\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"https://heropress.com/making-a-safe-place/#utm_source=rss&utm_medium=rss&utm_campaign=making-a-safe-place\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2907:\"<img width=\"960\" height=\"480\" src=\"https://s20094.pcdn.co/wp-content/uploads/2017/07/071917-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: The WordPress community is, slowly but surely, helping me get rid of my ingrown fear of the unknown, of others.\" /><p>Being a remote worker makes it easy to hide from a world that you find scary or dangerous. If you&#8217;re never in the presence of other people they can&#8217;t hit you. Retreat becomes so easy. Marius Jensen from Sola, Norway grew up in a society that did not care for him, and made him want to hide from the world forever.</p>\n<p>The WordPress community gave him a safe place to talk to people online, and after time, in person. WordCamps became a place of safety and compassion. This isn&#8217;t the case for all people, but it is for many people, in many places. Check out Marius&#8217; essay from last July, about finding a safe place.</p>\n<blockquote class=\"wp-embedded-content\"><p><a href=\"https://heropress.com/essays/becoming-myself-again/\">Becoming Myself Again</a></p></blockquote>\n<p></p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: Making A Safe Place\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=Making%20A%20Safe%20Place&via=heropress&url=https%3A%2F%2Fheropress.com%2Fmaking-a-safe-place%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: Making A Safe Place\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fmaking-a-safe-place%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fmaking-a-safe-place%2F&title=Making+A+Safe+Place\" rel=\"nofollow\" target=\"_blank\" title=\"Share: Making A Safe Place\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/making-a-safe-place/&media=https://heropress.com/wp-content/uploads/2017/07/071917-150x150.jpg&description=Making A Safe Place\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: Making A Safe Place\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/making-a-safe-place/\" title=\"Making A Safe Place\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/making-a-safe-place/\">Making A Safe Place</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Jul 2018 08:00:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"WPTavern: iThemes Enters the Hosting Space\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=82379\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wptavern.com/ithemes-enters-the-hosting-space\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3428:\"<p>iThemes is <a href=\"https://ithemes.com/wordpress-hosting\">getting into the hosting business</a> after <a href=\"https://ithemes.com/2018/07/17/announcing-ithemes-hosting/\">launching</a> three plans that take advantage of its relationship with Liquid Web. The plans are finely tuned around the company&#8217;s products and come with free SSL certificates. <br /></p>\n\n<p>I reached out to Cory Miller, Founder of iThemes to figure out why they&#8217;ve entered the hosting space, what it means to be able to control the user experience of their products from the top-down, and how their plans compare to those from hosts that offer Jetpack Premium. </p>\n\n<h2>Interview With Cory Miller<br /></h2>\n\n<p><strong>What does it mean for you and iThemes to be able to control the user experience from the top-down?</strong></p>\n\n<p>In short, it means a better overall experience for our customers. For more than 10 years, we’ve dealt with most of the hosts, especially the ones offering catered WordPress offerings, and it has been a terribly frustrating experience for us trying to troubleshoot problems and help our mutual customers. </p>\n\n<p>Additionally, we’ve long said you have to have two things to be our customer: WordPress and web hosting. Now we install WordPress for you, along with SSL, essentially with a click on our own hosting. </p>\n\n<p><strong>How would you compare iThemes hosting packages to hosts that offer Jetpack Premium services as part of their plans?</strong></p>\n\n<p>The thing that sticks out for me is having everything under one brand and team. But we think using iThemes Sync Pro as the hosting control panel gives us a significant edge for our customers to do more with their WP sites, in particular, our reporting features in Sync Pro. </p>\n\n<p>Now our customers can get WP backups, security, site management and in-depth reporting all from one dashboard, along with their hosting. With our Business plan, they get BackupBuddy, our WordPress backup plugin; iThemes Security Pro, our WordPress security plugin &amp; iThemes Sync Pro all in one. Plus they get an awesome team of WordPress pros for support if they need help or have any issues.</p>\n\n<p><strong>What are you most looking forward too offering these hosting packages specifically tuned for iThemes products and WordPress?</strong></p>\n\n<p>The actual implementation of the vision of offering the key essentials we think people want and need, along with a roadmap to do more, from our team at iThemes. It was one of the motivators for joining the Liquid Web family — the ability to finally do what we’ve always wanted to do for our customers, offering a more complete experience for them, from us. </p>\n\n<p><strong>Were there any challenges that you overcame when putting these packages together?</strong></p>\n\n<p>The main one that comes to mind is trying to ensure we offer what people actually want and will buy. But there was several months of hard work by our team and others to get this launched. Some long nights to pull all the pieces together in order to do this, with many more to come.</p>\n\n<p>Prices range from $15 per month to $25 per month billed on an annual basis. New customers can take advantage of a coupon code <a href=\"https://ithemes.com/2018/07/17/announcing-ithemes-hosting/\">on the site</a> to purchase the Business plan, normally $25 for $15. </p>\n\n<p></p>\n\n<p><strong></strong></p>\n\n<p><strong></strong> </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Jul 2018 23:19:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"WPTavern: WooCommerce Custom Product Tables Plugin Now in Beta, Boasts 30% Faster Page Loads\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=82363\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"https://wptavern.com/woocommerce-custom-product-tables-plugin-now-in-beta-boasts-30-faster-page-loads\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3615:\"<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/07/woocommerce-logo.jpg?ssl=1\"><img /></a></p>\n<p>WooCommerce is celebrating <a href=\"https://woocommerce.com/birthday-sale/\" rel=\"noopener noreferrer\" target=\"_blank\">10th years of Woo</a> this week. Over the past several years WooCommerce has grown to become a dominant player among e-commerce solutions on the web. <a href=\"https://trends.builtwith.com/shop\" rel=\"noopener noreferrer\" target=\"_blank\">E-commerce Usage Distribution stats from BuiltWith</a> currently rank WooCommerce as the most commonly used platform for stores in the top 1 million sites.</p>\n<p>Performance and scalability were the main focuses for the WooCommerce development team last year and these issues continue to be top priority. <a href=\"https://wptavern.com/woocommerce-3-0-brings-major-improvements-to-product-gallery-introduces-crud-classes-and-a-new-cli\" rel=\"noopener noreferrer\" target=\"_blank\">Version 3.0</a>, released in April 2017, included significant performance improvements when WooCommerce switched from post meta to taxonomies for features like product visibility, featured products, and out of stock products. It also introduced CRUD (Create, Read, Update, Delete) classes for developers, making it easier to write and retrieve data from the database with less code.</p>\n<p>Building on the CRUD work done last year, WooCommerce has just <a href=\"https://woocommerce.wordpress.com/2018/07/17/woocommerce-custom-product-tables-beta/\" rel=\"noopener noreferrer\" target=\"_blank\">announced</a> the beta of its new Custom Products Tables plugin. It replaces the WooCommerce product Data Store with new, dedicated product tables for significant reductions in page load time across shop, checkout, and admin pages.</p>\n<p>&#8220;The results, so far, have been great – with improvements of up to 30% on page load times!&#8221; WooCommerce engineer Gerhard Potgieter said. &#8220;Checkout, arguably the most important part of the store experience, has seen the biggest performance gains.&#8221;</p>\n<p>The WooCommerce development team tested the plugin&#8217;s impact on performance using two identical stores running the <a href=\"https://woocommerce.com/storefront/\" rel=\"noopener noreferrer\" target=\"_blank\">Storefront</a> theme and no additional plugins. They created a data set of 500 products using the <a href=\"https://github.com/woocommerce/wc-smooth-generator\" rel=\"noopener noreferrer\" target=\"_blank\">WooCommerce Smooth Generator</a>, and both stores had 70,000 orders in the database and meta data in the range of 1.4 million rows.</p>\n<a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2018/07/woocommerce-load-times.png?ssl=1\"><img /></a>image credit: <a href=\"https://woocommerce.wordpress.com/2018/07/17/woocommerce-custom-product-tables-beta/\">WooCommerce Development Blog</a>\n<p>The Custom Product Tables plugin is not ready for use in production but developers can <a href=\"https://github.com/woocommerce/woocommerce-product-tables-feature-plugin/releases\" rel=\"noopener noreferrer\" target=\"_blank\">download version 1</a> and test it against <a href=\"https://github.com/woocommerce/woocommerce/\" rel=\"noopener noreferrer\" target=\"_blank\">WooCommerce 3.5 dev</a> (switch to the master branch).</p>\n<p>Getting the plugin rolled into WooCommerce core is an exciting update on the horizon, as faster page loads generally improve conversion for store owners. WooCommerce engineers anticipate releasing the plugin on WordPress.org as the next step. They plan to include the new product tables in a major version update early next year.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Jul 2018 20:20:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: New WordPress Feature Plugin Adds Support for Progressive Web Apps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=82311\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"https://wptavern.com/new-wordpress-feature-plugin-adds-support-for-progressive-web-apps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5800:\"<p>WordPress contributors are working on getting support for Progressive Web Apps (PWA) into core. A new <a href=\"https://wordpress.org/plugins/pwa/\" rel=\"noopener noreferrer\" target=\"_blank\">PWA feature plugin</a> is now available on WordPress.org, spearheaded by the teams at XWP, Google, and Automattic.</p>\n<p>Progressive Web Apps are applications that run on the web but provide a speedy app-like experience inside a mobile browser. Google describes them as having the following three qualities:</p>\n<ul>\n<li>Reliable – Load instantly and never show the downasaur, even in uncertain network conditions</li>\n<li>Fast – Respond quickly to user interactions with silky smooth animations and no janky scrolling</li>\n<li>Engaging – Feel like a natural app on the device, with an immersive user experience</li>\n</ul>\n<p>The plugin adds support for technologies that PWAs require, including Service Workers, a Web App Manifest, and HTTPS. These technologies support functions like background syncing, offline content, push notifications, mobile home screen icon, and other PWA features.</p>\n<p>XWP CTO Weston Ruter said the purpose of the feature plugin is to curate PWA capabilities for proposed merging into core. The idea is to merge them piece by piece. Core tickets are already in process for adding support for <a href=\"https://core.trac.wordpress.org/ticket/43328\" rel=\"noopener noreferrer\" target=\"_blank\">web app manifests</a> and <a href=\"https://core.trac.wordpress.org/ticket/36995\" rel=\"noopener noreferrer\" target=\"_blank\">support for service workers</a>, as well as bringing <a href=\"https://core.trac.wordpress.org/ticket/28521\" rel=\"noopener noreferrer\" target=\"_blank\">improvements to HTTPS</a>.</p>\n<p>&#8220;This PWA feature plugin is intended to equip and facilitate other plugins which implement PWA features,&#8221; Ruter <a href=\"https://weston.ruter.net/2018/07/12/wceu-2018-recap-amp-and-pwa/\" rel=\"noopener noreferrer\" target=\"_blank\">said</a>. &#8220;It’s not intended to negate any existing plugins with these features, but rather to allow such plugins (and themes) to work together seamlessly and expand upon them.&#8221;</p>\n<p>The first release of the plugin on WordPress.org (v0.1.0) adds support for web app manifests and initial support for allowing theme and plugin developers to register scripts for service workers via <code>wp_register_service_worker()</code>. It also includes an API for detecting whether HTTPS is available.</p>\n<p>&#8220;A next step for service workers in the PWA feature plugin is to integrate <a href=\"https://developers.google.com/web/tools/workbox/\" rel=\"noopener noreferrer\" target=\"_blank\">Workbox</a> to provide a declarative WordPress PHP abstraction for managing the caching strategies for routes, with <a href=\"https://github.com/xwp/pwa-wp/issues/5\" rel=\"noopener noreferrer\" target=\"_blank\">support for detecting conflicts</a>,&#8221; Ruter said. Anyone who is interested to contribute to PWA support for WordPress can check out the discussions and <a href=\"https://github.com/xwp/pwa-wp/\" rel=\"noopener noreferrer\" target=\"_blank\">plugin on GitHub</a>.</p>\n<p>In the past, app-like experiences were only available for sites and services that had their own native mobile apps, but native apps can be costly to develop and maintain. Progressive web apps use the greater web as their platform and are quick to spin up. They make content easier to access on mobile even without an internet connection. It&#8217;s also far easier to tap a home screen icon than to enter a URL on mobile, and this makes users more likely to engage with their favorite sites.</p>\n<p><a href=\"https://www.pwastats.com/\" rel=\"noopener noreferrer\" target=\"_blank\">PWA Stats</a> is a site that features case studies of progressive web apps that have significantly increased performance, engagement, and conversion. A few compelling examples include:</p>\n<ul>\n<li>Tinder <a href=\"https://medium.com/@addyosmani/a-tinder-progressive-web-app-performance-case-study-78919d98ece0\" rel=\"noopener noreferrer\" target=\"_blank\">cut load times from 11.91 seconds to 4.69 seconds</a> with their new PWA. The PWA is 90% smaller than Tinder’s native Android app. User engagement is up across the board on the PWA.</li>\n<li>Grand Velas Riviera Maya resort <a href=\"https://blog.milestoneinternet.com/industry-news/milestone-boosts-website-conversions-by-53-with-progressive-web-apps-pwa/\" rel=\"noopener noreferrer\" target=\"_blank\">increased its Black Friday conversion rate by 53%</a> due to its progressive web app’s speed and notifications.</li>\n<li>Trivago saw an increase of 150% for people who add its PWA to the home screen. Increased engagement led to a <a href=\"https://www.thinkwithgoogle.com/intl/en-gb/consumer-insights/trivago-embrace-progressive-web-apps-as-the-future-of-mobile/\" rel=\"noopener noreferrer\" target=\"_blank\">97% increase in clickouts to hotel offers</a>. Users who go offline while browsing can continue to access the site and 67% continue to browse the site when they come back online.\n<li>Pinterest rebuilt their mobile site as a PWA and <a href=\"https://medium.com/dev-channel/a-pinterest-progressive-web-app-performance-case-study-3bd6ed2e6154\" rel=\"noopener noreferrer\" target=\"_blank\">core engagements increased by 60%</a>. They also saw a 44% increase in user-generated ad revenue and time spent on the site has increased by 40%.</li>\n</ul>\n<p>PWA support in WordPress will enable the plugin and theme ecosystems to work together in providing site owners with more engaging ways to connect with their visitors. Once the market starts building on core support, site owners should soon be able to offer better experiences for mobile users without having to become experts in the technologies that power progressive web apps.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Jul 2018 00:16:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"Dev Blog: Quarterly Updates | Q2 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6140\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/news/2018/07/quarterly-updates-q2-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:15621:\"<p><em>To keep everyone aware of big projects and efforts across WordPress contributor teams, I&#8217;ve reached out to each team&#8217;s <a href=\"https://make.wordpress.org/updates/team-reps/\">listed representatives</a>. I asked each of them to share their Top Priority (and when they hope for it to be completed), as well as their biggest Wins and Worries. Have questions? I&#8217;ve included a link to each team&#8217;s site in the headings.﻿</em></p>\n\n<h2><a href=\"https://make.wordpress.org/accessibility/\">Accessibility</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\"https://profiles.wordpress.org/rianrietveld/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>rianrietveld</a>, <a href=\"https://profiles.wordpress.org/joedolson/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>joedolson</a>, <a href=\"https://profiles.wordpress.org/afercia/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>afercia</a></li>\n	<li><strong>Priority</strong>: Working to make sure that Gutenberg is reasonably accessible prior to merge. ETA is before 5.0</li>\n	<li><strong>Struggle</strong>: Lack of developers and accessibility experts to help test and code the milestone issues. <em>The team is doing outreach to help solve this problem.</em></li>\n	<li><strong>Big Win</strong>: Interest from companies like The Paciello Group and Tenon.io to help out with Gutenberg code review and testing tools.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/cli/\">CLI</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: @danielbachhuber, <a href=\"https://profiles.wordpress.org/schlessera/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>schlessera</a></li>\n	<li><strong>Priority</strong>: Very first global <a href=\"https://make.wordpress.org/cli/2018/07/04/wp-cli-hack-day/\">Hack Day</a> is coming up July 20. Version 2.0.0 is still in progress (new <a href=\"https://github.com/wp-cli/wp-cli/issues/4752\">ETA</a> is end of July).</li>\n	<li><strong>Struggle</strong>: The team continues to need new contributors. The current team is tiny but tough.</li>\n	<li><strong>Big Win</strong>: WP-CLI is currently one of the project&#8217;s four main focuses, as mentioned in the Summer Update at WordCamp Europe.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/community/\">Community</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\"https://profiles.wordpress.org/francina/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>francina</a>, <a href=\"https://profiles.wordpress.org/hlashbrooke/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>hlashbrooke</a></li>\n	<li><strong>Priority</strong>: Focusing on smoothing out the processes in our community management by building up our team of volunteers and establishing what tools we need to keep things running well. ETA is ongoing.</li>\n	<li><strong>Struggle</strong>: Our two biggest struggles at the moment are tracking what we need to get done, and making final decisions on things. <em>There is current work on the tools available to assist with tracking progress.﻿</em></li>\n	<li><strong>Big Win</strong>: After making a concerted effort to get more contributors on the Community Team, we now have a much larger group of volunteers working as deputies and WordCamp mentors</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/core/\">Core</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\"https://profiles.wordpress.org/jeffpaul/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>jeffpaul</a></li>\n	<li><strong>Priority</strong>: Following the <a href=\"https://wordpress.tv/2018/07/04/matt-mullenweg-a-summertime-update-keynote-and-qa/\">WordCamp Europe summer update</a> ﻿(and the companion post <a href=\"https://wordpress.org/news/2018/07/update-on-gutenberg/\">here</a>), the team is getting Gutenberg (the new WordPress editing experience) into a strong state for the 5.0 release. Potential ETA as soon as August.</li>\n	<li><strong>Struggle</strong>: Coordinating momentum and direction as we start seeing more contributors offering their time. Still working our way through open issues. <em>﻿The team is starting multiple bug scrubs each week to work through these more quickly and transparently.</em></li>\n	<li><strong>Big Win</strong>: Had a <a href=\"https://wordpress.org/news/2018/05/wordpress-4-9-6-privacy-and-maintenance-release/\">sizable release in 4.9.6</a> which featured major updates around privacy tools and functionality in Core.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/design/\">Design</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\"https://profiles.wordpress.org/melchoyce/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>melchoyce</a>, <a href=\"https://profiles.wordpress.org/karmatosed/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>karmatosed</a>, <a href=\"https://profiles.wordpress.org/boemedia/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>boemedia</a>, <a href=\"https://profiles.wordpress.org/joshuawold/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>joshuawold</a>, <a href=\"https://profiles.wordpress.org/mizejewski/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mizejewski</a></li>\n	<li><strong>Priority</strong>: Better on-boarding of new contributors, especially creating better documentation. ETA is end of July.</li>\n	<li><strong>Struggle</strong>: It&#8217;s hard to identify reasonably small tasks for first-time contributors.</li>\n	<li><strong>Big Win</strong>: The team is much more organized now which has helped clear out the design backlog, bring in new contributors, and also keep current contributors coming back. <em>Bonus: Joshua Wold will co-lead the upcoming release.</em></li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/docs/\">Documentation</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\"https://profiles.wordpress.org/kenshino/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>kenshino</a><br /></li>\n	<li><strong>Priority</strong>: Opening up the work on <a href=\"https://make.wordpress.org/docs/2018/02/26/state-of-helphub-february-2018/\">HelpHub</a> to new contributors and easing the onboarding process. No ETA.<br /></li>\n	<li><strong>Struggle</strong>: Some blockers with making sure the code and database can be ready to launch on https://wordpress.org/support/<br /></li>\n	<li><strong>Big Win</strong>: The <a href=\"https://wp-helphub.com/\">first phase of HelpHub</a> creation is complete, which means content updates (current info, more readable, easier discovery), internal search, design improvements, and REST API endpoints.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/hosting/\">Hosting</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\"https://profiles.wordpress.org/mikeschroder/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mikeschroder</a>, <a href=\"https://profiles.wordpress.org/jadonn/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>jadonn</a></li>\n	<li><strong>Priority</strong>: Preparing hosts for supporting Gutenberg, especially support questions they&#8217;re likely to see when the &#8220;Try Gutenberg&#8221; callout is released. ETA July 31st, then before WordPress 5.0<br /><strong></strong></li>\n	<li><strong>Struggle</strong>: Most contributions are still made a by a small team of volunteers. Seeing a few more people join, but progress is slow.<br /><strong></strong></li>\n	<li><strong>﻿Big Win</strong>: New team members and hosting companies have joined the #hosting-community team and have started contributing.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/marketing/\">Marketing</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\"https://profiles.wordpress.org/bridgetwillard/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>bridgetwillard</a></li>\n	<li><strong>Priority</strong>: Continuing to write and publish case studies from the community. ETA is ongoing.</li>\n	<li><strong>Struggle</strong>: No current team struggles.</li>\n	<li><strong>Big Win</strong>: Wrote and designed a short <a href=\"https://make.wordpress.org/marketing/2018/04/24/contributor-day-onboarding-pdf/\">Contributor Day onboarding card</a>. It was used at Contributor Day at WCEU and onboarding time went down to 1 hour instead of 3 hours.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/meta/\">Meta</a> (WordPress.org Site)</h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\"https://profiles.wordpress.org/tellyworth/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>tellyworth</a>, <a href=\"https://profiles.wordpress.org/coffee2code/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>coffee2code</a></li>\n	<li><strong>Priority</strong>: Reducing manual work around the contributor space (theme review, GDPR/privacy, plugin review). ETA for small wins is end of quarter, larger efforts after that.</li>\n	<li><strong>Struggle</strong>: Maintaining momentum on tickets. <em>There are also some discussions about updating the ticket management process across teams that use the Meta trac system.</em></li>\n	<li><strong>Big Win</strong>: The new About page launched and has been translated across most locale sites.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/mobile/\">Mobile</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\"https://profiles.wordpress.org/elibud/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>elibud</a></li>\n	<li><strong>Priority</strong>: Getting Gutenberg in the mobile applications. ETA is late December.</li>\n	<li><strong>Struggle</strong>: Consuming the Gutenberg source in the ReactNative app directly. <em>More info can be found here: https://make.wordpress.org/mobile/2018/07/09/next-steps-for-gutenberg-mobile/</em></li>\n	<li><strong>Big Win</strong>: The WordPress mobile applications now fully support right-to-left languages and are compliant with the latest standards for accessibility.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/plugins/\">Plugins</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\"https://profiles.wordpress.org/ipstenu/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ipstenu</a></li>\n	<li><strong>Priority</strong>: Clearing ~8,000 unused plugins from the queues. Likely ETA is September.<br /></li>\n	<li><strong>Struggles</strong>: Had to triage a lot of false claims around plugins offering GDPR compliance.</li>\n	<li><strong>Big Win</strong>: Released 4.9.6 and <a href=\"https://make.wordpress.org/plugins/2018/05/17/wp-4-9-6-privacy-hooks-and-you/\">updated expectations</a> with plugin authors. Huge thanks to the Core Privacy team for their hard work on this.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/polyglots/\">Polyglots</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\"https://profiles.wordpress.org/petya/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>petya</a>, <a href=\"https://profiles.wordpress.org/ocean90/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ocean90</a>, <a href=\"https://profiles.wordpress.org/nao/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>nao</a>, <a href=\"https://profiles.wordpress.org/chantalc/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>chantalc</a>, <a href=\"https://profiles.wordpress.org/deconf/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>deconf</a>, <a href=\"https://profiles.wordpress.org/casiepa/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>casiepa</a></li>\n	<li><strong>Priority</strong>: Keep WordPress releases translated to 100% and then concentrate on the top 100 plugins and themes. ETA is ongoing.<br /><strong></strong></li>\n	<li><strong>﻿Struggle</strong>: Getting new PTEs fast enough, and complex tools/systems. Overall, the volume of strings awaiting approval.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/support/\">Support</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\"https://profiles.wordpress.org/clorith/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>clorith</a></li>\n	<li><strong>Priority:</strong> Getting ready for the Gutenberg callout (it got pushed last quarter). Needing a better presence on the official support forums, and outreach for that is underway, ETA end of July. <br /></li>\n	<li><strong>Struggle</strong>: Keeping contributors participating post-contributor days/drives. <em>﻿Considering the creation of a dedicated post-contributor day survey to get some insight here.</em></li>\n	<li><strong>Big Win</strong>: The increase in international liaisons joining for weekly meetings, helping bring the wider support community together.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/themes/\">Theme Review</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\"https://profiles.wordpress.org/acosmin/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>acosmin</a>, <a href=\"https://profiles.wordpress.org/rabmalin/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>rabmalin</a>, <a href=\"https://profiles.wordpress.org/thinkupthemes/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>thinkupthemes</a>, <a href=\"https://profiles.wordpress.org/williampatton/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>williampatton</a></li>\n	<li><strong>Priority</strong>: Building a better Theme Check/Sniffer in order to automate most of the checks done right now by reviewers. ETA late 2018, early 2019.</li>\n	<li><strong>Struggle</strong>: Bringing in new contributors to the team.</li>\n	<li><strong>Big Win</strong>: <a href=\"https://make.wordpress.org/themes/2018/04/30/trusted-authors-program/\">Trusted Authors program﻿</a></li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/tide/\">Tide</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\"https://profiles.wordpress.org/valendesigns/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>valendesigns</a> (but usually <a href=\"https://profiles.wordpress.org/jeffpaul/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>jeffpaul</a>)</li>\n	<li><strong>Priority</strong>: Storing PHPCompatibilty results inside the WordPress.org API and building a UI to display those results, an endpoint to request an audit is required for this work to continue.</li>\n	<li><strong>Struggle</strong>: Development has dramatically slowed down while team members are on leave or pulled into internal client work.</li>\n	<li><strong>Big Win</strong>: Migration to Google Cloud Platform (GCP) from Amazon Web Services (AWS) is complete and the audit servers have all been rewritten in Go. (This allows us to be faster with greater capacity and less cost.)</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/training/\">Training</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\"https://profiles.wordpress.org/bethsoderberg/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>bethsoderberg</a>, <a href=\"https://profiles.wordpress.org/juliek/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>juliek</a></li>\n	<li><strong>Priority:</strong> Lesson plan production. ETA is ongoing.</li>\n	<li><strong>Struggle:</strong> The workflow is a little complex, so recruiting and training enough contributors to keep the process moving is a struggle.</li>\n	<li><strong>Big Win</strong>: WordCamp Europe&#8217;s Contributor Day was very productive. New tools/workflow are in place and two team representatives were there to lead and help.</li>\n</ul>\n\n<p><em>Interested in updates from the first quarter of this year? You can find those here: <a href=\"https://make.wordpress.org/updates/2018/04/24/quarterly-updates-q1-2018/\"><em>https://make.wordpress.org/updates/2018/04/24/quarterly-updates-q1-2018/</em></a>\n	</em>\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 Jul 2018 14:50:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Josepha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"WPTavern: WordCamp Europe 2018 Draws 2,085 Attendees, Organizers Look Ahead to 2019 in Berlin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=82313\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"https://wptavern.com/wordcamp-europe-2018-draws-2085-attendees-organizers-look-ahead-to-2019-in-berlin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6531:\"<a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2018/07/WCEU-2018.jpg?ssl=1\"><img /></a>photo credit: WCEU Photography Team\n<p>WordCamp Europe closed out a successful event in Belgrade with 2,085 attendees from 76 countries. More than 800 others joined via livestream for a total audience of nearly 3,000 participants. A <a href=\"https://wptavern.com/wordcamp-europe-2018-contributor-day-posts-record-turnout-amid-wi-fi-outage\" rel=\"noopener noreferrer\" target=\"_blank\">record-setting Contributor Day</a> kicked off the event, followed by two days of conference sessions and workshops from 65 speakers.</p>\n<p>A team of 54 organizers and 170 volunteers made WCEU possible, with 10 different organizing teams. Last year WordCamp Europe added a PR team and this year the event introduced an Attendee Services team to fill gaps in the organization. The operation ran smoothly, despite the conference being spread out across many rooms in the sprawling <a href=\"http://www.savacentar.net/\" rel=\"noopener noreferrer\" target=\"_blank\">Sava Centar</a> venue.</p>\n<p><a href=\"https://app.wp-europe.org/\" rel=\"noopener noreferrer\" target=\"_blank\">WordCamp Europe&#8217;s PWA</a> (progressive web app) was the highlight of the new features and services introduced this year. It was a central hub for keeping attendees informed on what was happening at any given moment. Organizers also added new amenities, including a site health check station, Community Room, and info booth to handle attendee questions.</p>\n<p>Gutenberg and Progressive web apps were the hot topics of this year&#8217;s WordCamp Europe. In addition to Matt Mullenweg <a href=\"https://wptavern.com/matt-mullenweg-unveils-gutenberg-roadmap-at-wceu-wordpress-agencies-and-product-developers-sprint-to-prepare\" rel=\"noopener noreferrer\" target=\"_blank\">unveiling a roadmap for Gutenberg&#8217;s inclusion in core</a>, a strong contingent of designers and engineers from the team were present to educate attendees on Gutenberg&#8217;s architecture and the vision behind the project.</p>\n<p>Many attendees were visiting Serbia for the first time and Belgrade delivered with its renowned hospitality and captivating nightlife. Attendees found no shortage of delicious options for food and drink.</p>\n<h3>Berlin to Host WordCamp Europe 2019</h3>\n<p>At the conclusion of the event, organizers announced Berlin as the next host city for <a href=\"https://2019.europe.wordcamp.org/\" rel=\"noopener noreferrer\" target=\"_blank\">WordCamp Europe, June 20-22, 2019</a>. The conference, Contributor Day, and the after party will all be held at the <a href=\"https://www.estrel.com/en/home.html\" rel=\"noopener noreferrer\" target=\"_blank\">Estrel Hotel and Congress Center</a>, a venue with a capacity for 12,000 attendees.</p>\n<p>Organizers said that Berlin&#8217;s accessibility, reasonable prices, and strong community were the final deciding factors for its selection as the next host city.</p>\n<p></p>\n<h3>Behind the Scenes at WordCamp Europe 2018 with Lead Organizers Jenny Beaumont and Milan Ivanović</h3>\n<p>Hosting a volunteer-led event at this scale requires an enormous amount of effort from the organizers, especially those taking the lead for multiple years in a row. There is nearly no down time as the team is already planning for the next edition of the camp.</p>\n<p>I sat down with lead organizers Jenny Beaumont, the global lead, and Milan Ivanović, the local lead, to get a look behind the scenes at what is involved in bringing WordCamp Europe to thousands of WordPress enthusiasts in one weekend. We <a href=\"https://wptavern.com/wordcamp-europe-2018-to-be-held-in-belgrade-serbia-june-14-16\" rel=\"noopener noreferrer\" target=\"_blank\">interviewed</a> them at the conclusion of WCEU 2017 in Paris. Over the past two years these leaders have developed a strong working relationship built on encouraging each other and keeping a positive outlook for their teams.</p>\n<p>Beaumont said she was hesitant going into a third year for this role, as Paris was the project that captured her heart and motivation. After going through this event as the global lead, she said she discovered what she could bring to the role and how she could serve the team.</p>\n<p>&#8220;The event has been their project,&#8221; Beaumont said. &#8220;My project this year has been the team, how I can really concentrate on this team, on its growth, on its health, on its sustainability. That&#8217;s what I learned in Paris &#8211; the importance of making sure that was part of the project.&#8221;</p>\n<p>Beaumont and Ivanović explained the difference between the global and local lead roles, a structure that works well for flagship WordCamps.</p>\n<p>&#8220;The local team is really about making it a good experience in this new place that everybody is going to be discovering for the first time,&#8221; Beaumont said. &#8220;It&#8217;s the hard work, it&#8217;s the logistics, it&#8217;s all of the small details, everything that&#8217;s behind the scenes that make it so you walk in as an attendee and it just feels like you&#8217;re at home. They do all of that hard work. The global role, as it has evolved, is really about being that sort of team care-giver, making sure that there is good communication happening, making sure the team is healthy and happy and motivated. Because you&#8217;ve got to get up and do this every day while you&#8217;re also doing your day job, and that takes a lot.&#8221;</p>\n<p>WordCamp Europe had a strong impact on the local community with more than 400 Serbian attendees and 20 Serbian organizers. They worked to build awareness of WordPress in the local community ahead of the event.</p>\n<p>&#8220;We used this event to grow our community and used our community to promote the event,&#8221; Ivanović said. &#8220;When we announced last year in Paris that Belgrade is going to be next, at that time we had five or six cities for WordPress meetups. Currently, we are in 14 cities and starting the 15th in July. WordCamp Europe and the conference itself was such a win for the whole community.&#8221;</p>\n<p>Ivanović will return next year as the global lead for WCEU in Berlin. Beaumont is taking some time off after three years organizing WordCamp Paris and WordCamp Europe, but she hopes to return in some capacity in the future. They are working together with their team to publish a WordCamp Europe handbook that covers some of the important specifics of the event for upcoming teams. Check out the full interview in the video below.</p>\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 14 Jul 2018 00:24:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"WPTavern: Array Launches Free Gutenberg-Ready Atomic Blocks Theme on WordPress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=82258\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://wptavern.com/array-launches-free-gutenberg-ready-atomic-blocks-theme-on-wordpress-org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6391:\"<p>Mike McAlister and the team at <a href=\"https://arraythemes.com/\" rel=\"noopener noreferrer\" target=\"_blank\">Array Themes</a> have fully embraced Gutenberg and are one of the first shops on the scene with a free WordPress theme designed specifically to work with the new editor. The <a href=\"https://wordpress.org/themes/atomic-blocks/\" rel=\"noopener noreferrer\" target=\"_blank\">Atomic Blocks</a> theme is now available on WordPress.org with minimal styling and seamless support for all core content and media blocks.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2018/07/atomic-blocks-screenshot.png?ssl=1\"><img /></a></p>\n<p>The theme allows users to control the width of the content area to create full-screen posts and pages. It supports full-screen images, videos, and galleries, showcasing the new editor&#8217;s wide alignment styles for content. Atomic Blocks includes Customizer options for uploading a logo, customizing the font style, setting body and title font sizes, and selecting an accent color.</p>\n<p>Check out the theme&#8217;s demo to see the blocks in action: <a href=\"https://preview.arraythemes.com/atomicblocks\" rel=\"noopener noreferrer\" target=\"_blank\">https://preview.arraythemes.com/atomicblocks</a>.</p>\n<p>The theme also seamlessly supports McAlister&#8217;s new Atomic Blocks project, a collection of page-building blocks included in the accompanying <a href=\"https://atomicblocks.com/\" rel=\"noopener noreferrer\" target=\"_blank\">Atomic Blocks plugin</a>. It currently includes blocks for creating a post grid, call-to-action, testimonials, inline notices, sharing icons, author profiles, accordions, customizable buttons, drop caps, and spacer/dividers, with many more blocks planned.</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2018/07/testimonials-block.jpg?ssl=1\"><img /></a></p>\n<p>&#8220;I knew Gutenberg was going to be a game changer from the second I saw it and started hashing out product ideas in October 2017,&#8221; McAlister said. &#8220;To me, it felt like a very natural evolution and transition for WordPress into a more forward-thinking content creator. All of the tools outside of WordPress are evolving and becoming better and easier to use and WordPress is starting to feel quite dated in comparison.&#8221;</p>\n<p>McAlister said his team is building Atomic Blocks into a full-fledged content block solution that will include a commercial version in the future.</p>\n<p>&#8220;We have a long list of blocks that we’ll be releasing into the plugin in the coming months — everything from eCommerce to email marketing to full-page layouts,&#8221; he said. &#8220;There will definitely be a commercial version of the plugin for those extra awesome blocks that will take your site to the next level.&#8221;</p>\n<p>McAlister is keeping Atomic Blocks separate from Array Themes but plans to cross promote between the two. He also plans to update the Array themes collection to support the blocks found in the plugin.</p>\n<p>&#8220;Atomic Blocks aims to solve a different problem in a different way than the traditional WordPress themes you’ll find on Array,&#8221; McAlister said. &#8220;By launching it separately from Array Themes, it gave me the opportunity to diversify my projects a bit and create a dedicated marketing stream for a Gutenberg solution.&#8221;</p>\n<p>Many products in the Array Themes catalog are already working with the new editor, but McAlister and his team intend to provide more in-depth support for specific Gutenberg features in themes where appropriate.</p>\n<p>&#8220;We’ve stayed fiercely committed to beautiful design, simplicity, and core coding standards and practices to ensure wide-spread support and compatibility with our themes,&#8221; McAlister said. &#8220;While this has served us well, we are all ready for a core-supported solution to providing a better experience for our customers. Gutenberg will solve this problem by providing a cohesive, unified way of extending content creation with a core user interface. Gutenberg is quite extensible as is, and will only grow more capable with time.&#8221;</p>\n<p>McAlister said one of the most challenging aspects of launching Atomic Blocks has been keeping pace with Gutenberg&#8217;s rapid development, requiring the team to follow multiple conversations across various WordPress core development discussion channels.</p>\n<p>&#8220;I followed Gutenberg development closely during the second half of last year and then started developing Atomic Blocks for Gutenberg early this year,&#8221; McAlister said. &#8220;You have to follow the Github repo, Make blog posts, and Slack conversations closely to keep up with the changes, deprecations, and feature additions. Luckily, now that features are being frozen, the code is churning less and things are starting to stabilize.&#8221;</p>\n<p>In order to keep up with all the news and changes, McAlister started the <a href=\"http://gutenberg.news/\" rel=\"noopener noreferrer\" target=\"_blank\">Gutenberg News</a> site to collect helpful resources, tutorials, and code snippets he found. The site contains more than 200 links to resources for both beginners and developers.</p>\n<p>McAlister predicts that Gutenberg will bring a greater separation between the roles of themes and plugins in the site-building experience.</p>\n<p>&#8220;The demand for themes will certainly begin to change more drastically in the long term,&#8221; he said. &#8220;Traditional WordPress themes will still be desirable for a number of years, simply due to the number of sites out there and the solutions needed to build them. Eventually, much of what can be provided by a theme will be provided by blocks via a plugin instead. Themes will still be responsible for providing a degree of styling and functionality that will remain critical to the site-building experience, but they will take a secondary role to content blocks.&#8221;</p>\n<p>Gutenberg will inevitably change the landscape of the theme industry, but McAlister sees it as a chance to reach customers in a new way.</p>\n<p>&#8220;Theme designers and developers should be excited about this opportunity and not feel threatened by Gutenberg,&#8221; McAlister said. &#8220;This is a fantastic opportunity to learn a new set of skills, attract a new segment of customers, and start pivoting to a block-based product model.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 12 Jul 2018 22:33:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"WPTavern: WPWeekly Episode 323 – Recap of WordCamp Grand Rapids and A Gutenberg Road Map\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=82285&preview=true&preview_id=82285\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"https://wptavern.com/wpweekly-episode-323-recap-of-wordcamp-grand-rapids-and-a-gutenberg-road-map\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2142:\"<p>In this episode, <a href=\"http://jjj.me\">John James Jacoby</a> recaps his trip to WordCamp Grand Rapids and shares his experience. WordCamp Grand Rapids had a strong focus on tools, plugins, and themes and by all accounts, was a successful event.</p>\n<p>We discussed Matt Mullenweg&#8217;s Summertime update, the roadmap for merging Gutenberg into core, and what comes after Gutenberg. We shared our thoughts on Automattic&#8217;s new board member, General Ann Dunwoody and speculated on Automattic&#8217;s vision.</p>\n<p>We wrap up the show by talking about generational divides in WordPress.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"https://wordpress.org/news/2018/07/wordpress-4-9-7-security-and-maintenance-release/\">WordPress 4.9.7 Security and Maintenance Release</a><br />\n<a href=\"https://wordpress.org/news/2018/07/update-on-gutenberg/\">Update on Gutenberg</a><br />\n<a href=\"https://make.wordpress.org/core/2018/07/06/whats-new-in-gutenberg-6th-july/\">What’s New in Gutenberg? (6th July)</a><br />\n<a href=\"https://ma.tt/2018/06/automattics-first-new-board-member-general-ann-dunwoody/\">Automattic’s First New Board Member: General Ann Dunwoody</a><br />\n<a href=\"https://wptavern.com/block-unit-test-plugin-helps-wordpress-theme-developers-prepare-for-gutenberg\">Block Unit Test Plugin Helps WordPress Theme Developers Prepare for Gutenberg</a><br />\n<a href=\"https://twitter.com/NaomiCBush/status/1014991902691790848\">Generational divides in WordPress</a></p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, July 18th 3:00 P.M. Eastern</p>\n<p>Subscribe to <a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\">WordPress Weekly via Itunes</a></p>\n<p>Subscribe to <a href=\"https://www.wptavern.com/feed/podcast\">WordPress Weekly via RSS</a></p>\n<p>Subscribe to <a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\">WordPress Weekly via Stitcher Radio</a></p>\n<p>Subscribe to <a href=\"https://play.google.com/music/listen?u=0#/ps/Ir3keivkvwwh24xy7qiymurwpbe\">WordPress Weekly via Google Play</a></p>\n<p><strong>Listen To Episode #323:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 12 Jul 2018 00:42:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"WPTavern: Video: A Quick Introduction to Gutenberg and the New WordPress Block Editor from LinkedIn Learning\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=82276\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:118:\"https://wptavern.com/video-a-quick-introduction-to-gutenberg-and-the-new-wordpress-block-editor-from-linkedin-learning\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1005:\"<p>Although WordPress developers and professionals have been inundated with Gutenberg news for more than a year, there&#8217;s a whole wide world of users who will learn about the project for the first time when 4.9.8 includes a &#8220;Try Gutenberg&#8221; prompt in the admin. If you haven&#8217;t been following the news closely and are wondering what all of this <a href=\"https://wordpress.org/plugins/gutenberg/\" rel=\"noopener noreferrer\" target=\"_blank\">Gutenberg</a> talk is about, Morten Rand-Hendriksen provides a succinct introduction to the new editor that is coming in WordPress 5.0.</p>\n<p>The video was created as part of LinkedIn&#8217;s <a href=\"https://www.linkedin.com/learning/wordpress-essential-training/\" rel=\"noopener noreferrer\" target=\"_blank\">WordPress Essentials Training</a> course. The first part explains the basic concept of a block and includes a mini tour of the new interface, followed by a short overview of where the Gutenberg project is going in the future.</p>\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Jul 2018 23:04:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"WPTavern: WordCamp Ticket Sales Move from PayPal to Stripe for Default Payment Gateway\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=82267\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"https://wptavern.com/wordcamp-ticket-sales-move-from-paypal-to-stripe-for-default-payment-gateway\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1857:\"<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2018/07/stripe.jpg?ssl=1\"><img /></a></p>\n<p>The WordPress Community Team <a href=\"https://make.wordpress.org/community/2018/07/10/stripe-is-now-available-to-all-wordcamps/\" rel=\"noopener noreferrer\" target=\"_blank\">announced</a> an update to the CampTix, the plugin used for selling WordCamp tickets, that makes Stripe the default payment method. The gateway was previously available as a beta plugin and could be enabled on a per-site basis but is now available to all WordCamps.</p>\n<p>When <a href=\"https://make.wordpress.org/community/2018/04/03/moving-wordcamp-ticket-sales-from-paypal-to-stripe/\" rel=\"noopener noreferrer\" target=\"_blank\">proposing Stripe as the default payment gateway</a> in April, Hugh Lashbrooke cited the fact that PayPal is entirely blocked and inaccessible in some countries. He also identified Stripe&#8217;s simpler UI and larger number of supported currencies as its chief advantages.</p>\n<p>PayPal has been the default for years on WordCamp websites but it currently supports only 26 currencies. Stripe supports 136 currencies, allowing WordCamp organizers to offer ticket purchases in more places than before. Previously, some communities were forced to build a local gateway integration to sell WordCamp tickets via PayPal, requiring those sales to be inconveniently funneled through a local bank account. The Stripe gateway option is a welcome update to support WordPress&#8217; growing international community, which held camps in 73 countries in 2017.</p>\n<p>It&#8217;s important to note that Stripe isn&#8217;t fully replacing PayPal. The Camptix plugin allows organizers to activate multiple payment gateways for cases where one or both make more sense, retaining the flexibility to support ticket sales at camps with different payment requirements.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Jul 2018 18:02:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"HeroPress: Translating For Love\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://heropress.com/?p=2587\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"https://heropress.com/translating-for-love/#utm_source=rss&utm_medium=rss&utm_campaign=translating-for-love\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3006:\"<img width=\"960\" height=\"480\" src=\"https://s20094.pcdn.co/wp-content/uploads/2016/09/092816-vladimir_petkov-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: I started translating WordPress so that my seven-year-old daughter can share her personal stories.\" /><p>We all have our reasons for the things we do. Money, love, orders, etc. Vladimir Petkov started using WordPress because it solved a problem. As the years went by it continued to solve problems, and he continued to use it. His time to give back didn&#8217;t arrive until much later though.</p>\n<p>His 7 year old daughter wanted a blog, and WordPress wasn&#8217;t completely translated into her language. So Vladimir learned how to translate WordPress, so his little girl (and every other Bulgarian speaker) can use their voice to speak to the world.</p>\n<p>Why do you give back to WordPress? If you&#8217;d like more info about how you can (no coding required!) drop a note in the comments.</p>\n<p>Also, check out Vladimir&#8217;s essay.</p>\n<blockquote class=\"wp-embedded-content\"><p><a href=\"https://heropress.com/essays/rebirth/\">Rebirth</a></p></blockquote>\n<p></p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: Translating For Love\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=Translating%20For%20Love&via=heropress&url=https%3A%2F%2Fheropress.com%2Ftranslating-for-love%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: Translating For Love\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Ftranslating-for-love%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Ftranslating-for-love%2F&title=Translating+For+Love\" rel=\"nofollow\" target=\"_blank\" title=\"Share: Translating For Love\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/translating-for-love/&media=https://heropress.com/wp-content/uploads/2016/09/092816-vladimir_petkov-150x150.jpg&description=Translating For Love\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: Translating For Love\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/translating-for-love/\" title=\"Translating For Love\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/translating-for-love/\">Translating For Love</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Jul 2018 12:13:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WPTavern: Video: Matt Mullenweg’s Summertime Update At WCEU 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=82254\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://wptavern.com/video-matt-mullenwegs-summertime-update-at-wceu-2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:861:\"<p>Sessions from <a href=\"https://wptavern.com/matt-mullenweg-unveils-gutenberg-roadmap-at-wceu-wordpress-agencies-and-product-developers-sprint-to-prepare\">WordCamp Europe 2018</a> are making their way <a href=\"https://wordpress.tv/event/wordcamp-europe-2018/\">onto WordPress.tv</a>, including <a href=\"https://wordpress.tv/2018/07/04/matt-mullenweg-a-summertime-update-keynote-and-qa/\">Matt Mullenweg&#8217;s Summertime Update</a>. </p>\n\n<p>In the video, Mullenweg shares the progress that&#8217;s been made on Gutenberg, WordPress core development, a Gutenberg road map for including it into core, and what to expect after WordPress 5.0 is released. <br /></p>\n\n<p>Be sure to watch the video to the end to catch the memorable, <a href=\"https://twitter.com/dimensionmedia/status/1007605535993221120\">GDPR cookie joke</a>.</p>\n\n\n	<div class=\"embed-wrap\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Jul 2018 23:56:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"WPTavern: WPCampus Will Be Streamed Live For Free July 13-14\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=82252\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wptavern.com/wpcampus-will-be-streamed-live-for-free-july-13-14\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:779:\"<p><a href=\"https://wpcampus.org/\">WPCampus</a>, a conference focused on WordPress in higher-education takes place this week between July 12-14 at Washington University in St. Louis, Missouri. </p>\n\n<p>If you&#8217;re unable to attend in-person or would like to watch the event from home, visit the <a href=\"https://2018.wpcampus.org/watch/\">WPCampus Stream page</a>. Beginning July 13th at 9AM CDT, all general sessions will be streamed live for free. Sessions will be recorded and be available after the event as well. </p>\n\n<p>To see a list of sessions taking place, check out the <a href=\"https://2018.wpcampus.org/schedule/\">event&#8217;s schedule</a> and for more information about WPCampus, visit the <a href=\"https://wpcampus.org/about/\">site&#8217;s about page</a>. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Jul 2018 23:36:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"WPTavern: New Classic Editor Addon Plugin Disables the “Try Gutenberg” Prompt Coming in WordPress 4.9.8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=82232\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"https://wptavern.com/new-classic-editor-addon-plugin-disables-the-try-gutenberg-prompt-coming-in-wordpress-4-9-8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3251:\"<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/07/stop.jpg?ssl=1\"><img /></a>photo credit: <a href=\"https://stocksnap.io/photo/V4WAM6G46H\">Hermes Rivera</a>\n<p>Gutenberg development continues along the roadmap Matt Mullenweg announced at WordCamp Europe with WordPress 4.9.8 set to introduce a <a href=\"https://core.trac.wordpress.org/ticket/41316\" rel=\"noopener noreferrer\" target=\"_blank\">“Try Gutenberg” prompt</a> to increase usage and testing. Core design contributors are currently working on a few new iterations of the callout. They are also considering including a section inside the prompt with an option to install the <a href=\"https://wordpress.org/plugins/classic-editor/\" rel=\"noopener noreferrer\" target=\"_blank\">Classic Editor</a> plugin in preparation for Gutenberg.</p>\n<p>Developers and agencies have time to install the Classic Editor on client sites that are not ready for Gutenberg, but this will not prevent users from seeing the &#8220;Try Gutenberg&#8221; prompt. <a href=\"https://gschoppe.com/\" rel=\"noopener noreferrer\" target=\"_blank\">Greg Schoppe</a>, one of Gutenberg&#8217;s most outspoken critics, partnered with <a href=\"https://so-wp.com/plugin/classic-editor-addon\" rel=\"noopener noreferrer\" target=\"_blank\">Pieter Bos</a> to develop a plugin called <a href=\"https://wordpress.org/plugins/classic-editor-addon/\" rel=\"noopener noreferrer\" target=\"_blank\">Classic Editor Addon</a> that changes how the Classic Editor plugin works.</p>\n<p>&#8220;For agencies supporting many sites, whose users have no way of knowing whether Gutenberg will break their site or not, this nag screen is a danger,&#8221; Schoppe commented on our most recent Gutenberg update. &#8220;Pre-emptively installing Classic Editor unfortunately won’t suppress the nag notice either, but since Classic Editor is being used as a bellwether of the success of Gutenberg, it’s important that you install it, if you expect issues.&#8221;</p>\n<p>Schoppe co-wrote the Classic Editor Addon to solve this problem. It suppresses the &#8220;Try Gutenberg&#8221; prompt and when the new editing experience ships in 5.0, it will automatically suppress Gutenberg as well.</p>\n<p>Since the Classic Editor plugin doesn&#8217;t remove Gutenberg by default, the addon plugin sets the option to fully replace Gutenberg. It also removes the Classic Editor&#8217;s options from the Settings > Writing screen. Schoppe said he believes this is what the Classic Editor plugin should have done out of the box, instead of requiring the user to find the settings screen to replace Gutenberg.</p>\n<p>Installing both the Classic Editor and Classic Editor Addon on tens or hundreds of client sites could be time consuming, so Schoppe suggests using a site management dashboard, such as MainWP, ManageWP, or Jetpack, to bulk install both plugins for clients.</p>\n<p>According to stats on WordPress.org, Gutenberg is active on more than 10,000 sites and the Classic Editor is active on 4,000+ sites. The &#8220;Try Gutenberg&#8221; prompt is expected to go out in WordPress 4.9.8, which is targeted for the end of July. The goal for the prompt is to make users aware of the plugin and get more testers involved before Gutenberg lands in WordPress 5.0.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 10 Jul 2018 22:35:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"Post Status: Working on your own website — Draft Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=46462\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://poststatus.com/working-on-your-own-website-draft-podcast/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1619:\"<p>Welcome to the Post Status <a href=\"https://poststatus.com/category/draft\">Draft podcast</a>, which you can find <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\">on iTunes</a>, <a href=\"https://play.google.com/music/m/Ih5egfxskgcec4qadr3f4zfpzzm?t=Post_Status__Draft_WordPress_Podcast\">Google Play</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\">Stitcher</a>, and <a href=\"http://simplecast.fm/podcasts/1061/rss\">via RSS</a> for your favorite podcatcher. Post Status Draft is hosted by Brian Krogsgard and co-host Brian Richards.</p>\n<p>In this episode, the Brians discuss the challenges of working on your own business website, when your company offers services or makes products for websites. Agencies often disregard their own websites, as do product companies. We discuss our own histories of attempting in-house redesign projects, strategies to get them done, and how we approach things today owning our own tiny businesses.</p>\n<p></p>\n<h3>Episode Links</h3>\n<ul>\n<li><a href=\"https://www.codeinwp.com/blog/redesign-your-business-website-transparency-report-40/\"><span>CodeInWP Transparency Report: Redesigning Your Business Website</span></a></li>\n</ul>\n<h3>Sponsor: Pagely</h3>\n<p><a href=\"https://pagely.com\"><span>Pagely</span></a><span> offers best in class managed WordPress hosting, powered by the Amazon Cloud, the Internet’s most reliable infrastructure. Post Status is proudly hosted by Pagely. Thank you to </span><a href=\"https://pagely.com\"><span>Pagely</span></a><span> for being a Post Status partner</span></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 Jul 2018 18:34:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Katie Richards\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"WPTavern: How WordPress is Powering a New Community on the Remote Island of Ogijima\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=82204\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"https://wptavern.com/how-wordpress-is-powering-a-new-community-on-the-remote-island-of-ogijima\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:10699:\"<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2018/07/junkonukaga.jpg?ssl=1\"><img /></a><a href=\"https://profiles.wordpress.org/nukaga\" rel=\"noopener noreferrer\" target=\"_blank\">Junko Nukaga</a> began her journey into the world of WordPress in 2011, just after her hometown in Fukushima prefecture was hit by the 9.0 magnitude Tōhoku earthquake and tsunami. The catastrophic event, referred to in Japan as the Great East Japan Earthquake, devastated the region&#8217;s infrastructure and took more than 15,000 lives. It also caused a level 7 meltdown at three reactors in the Fukushima Daiichi Nuclear Power Plant complex.</p>\n<p>Until this point Nukaga had only used WordPress as a blogging tool, but her hometown prefecture needed a fast way to get a website up for publishing accurate measurements of the radiation levels. Although she was living in Osaka at the time, Nukaga joined the volunteer team and built the site using WordPress. In addition to local radiation levels, it also had FAQ&#8217;s about radiation from scientists to combat the misinformation that was rampant at the time. People found the site through social networks and word of mouth.</p>\n<p>After making a difference for her hometown with WordPress, Nukaga wanted to find out more about the community behind the software. She joined an offline <a href=\"https://www.meetup.com/ja-JP/WordBench/?_cookie-check=ng_FrFUqDlEMFkbN\">WordBench</a> meetup and got connected to the WordPress community. The next year she co-organized WordCamp Osaka 2012, and in 2014 she became the lead organizer of WordCamp Kansai, an area that includes seven prefectures: Mie, Shiga, Kyoto, Osaka, Hyogo, Nara, Wakayama.</p>\n<p>As Nukaga became more deeply involved in the WordPress community as a speaker, organizer, and contributor, she developed a new understanding of the power of open source collaboration. After moving to the remote island of Ogijima in 2014, she was inspired to create a library and cultural center, using WordPress to organize a team of more than 200 volunteers.</p>\n<p>“When my family and I moved to this island, the school here was closed, because there were no kids on Ogijima,” Nukaga said. “We have a daughter, so we urged the government to reopen the school.</p>\n<p>&#8220;Although the school restarted, I thought that it would be meaningless for the school to stop or close again when our daughter graduated. The island is an aging society and no new children will be born here. I figured that if there was a library, I could call migrants to the island. A library which is free and an open space would help solve many things, such as children’s learning environment, communication support for the islanders, and migration consultation, for example.”</p>\n<p>Nukaga set up a WordPress website before constructing the library so her team of volunteers could disclose the progress of the building and recruit followers. They promoted the website through social networks and were able to crowdfund efforts to construct and maintain the building.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2018/07/ogijima-library.jpg?ssl=1\"><img /></a></p>\n<p>The <a href=\"https://ogijima-library.or.jp/\" rel=\"noopener noreferrer\" target=\"_blank\">Ogijima Library</a> opened in February 2014 as a non-profit organization that is rooted in the community, providing a place where people can connect through books and share knowledge with one another. Residents on the island now have access to titles and periodicals that would previously have required a boat trip to acquire. More than 50 migrants have moved to the island within the last four years since the library opened, including families with babies born last year.</p>\n<p>&#8220;Without WordPress, none of this would have been possible,&#8221; Nukaga said.  “WordPress opened my way. It taught me the philosophy of open source. I have used this philosophy to involve many unspecified people from the beginning of the process of making the library. We built the building ourselves with the help of 200 volunteers, and we continue to get support through book donations. Also, thanks to the flexibility of WordPress, the things I wanted to do, such as updating, providing a search system for books, and linking to social networks, were all possible.”</p>\n<h3>WordCamp Ogijima: “Empowering the Smalls to Go Big”</h3>\n<p>The WordPress community on the island is also thriving, thanks to community organizers who call Ogijima home. Nukaga organizes the meetups, which average 5 to 20 attendees at each event. <a href=\"https://ogi.osampo-radio.com/\" rel=\"noopener noreferrer\" target=\"_blank\">Shinichi Nishikawa</a>, who organized WordCamp Tokyo in 2012 and helped build a new WordPress community in Bangkok, made his home on the island in March 2016. He is joining forces with Nukaga and a team of 35 leaders and volunteers to organize the first <a href=\"https://2018.ogijima.wordcamp.org\" rel=\"noopener noreferrer\" target=\"_blank\">WordCamp Ogijima</a> on July 15, 2018.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/07/wc-ogijima.jpg?ssl=1\"><img /></a></p>\n<p>This will be the first Japanese WordCamp not held in the cities. Organizers have chartered two ferries to transport more than 250 attendees to the island. Camping is the primary lodging option in tents beside the island’s lighthouse and organizers have planned a BBQ after party. Although the event is currently sold out, 10 additional <a href=\"https://2018.ogijima.wordcamp.org/2018/05/20/registration-information-en/\" rel=\"noopener noreferrer\" target=\"_blank\">tickets</a> will go on sale on July 10 due to cancellations and an estimation of no-shows.</p>\n<p>“The uniqueness of the community in this area is that there are many with different backgrounds,” Shinichi Nishikawa said. “WordCamps in the city are mainly attended by engineers, designers and bloggers, but here there are people who are restaurant managers, farmers, a barber, an illustrator, a ranger (nature protection officer), baker, and others who are interested in WordPress.”</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2018/07/wcogijima-organizers.jpg?ssl=1\"><img /></a></p>\n<p>The organizing team, which includes many new contributors from all walks of life, along with meetup organizers in the Setouchi inland sea area, has adopted the theme “Empowering the smalls to go big.”</p>\n<p>Ogijima’s local community includes members like Kaisho Damonte, who is using WordPress and WooCommerce to power <a href=\"https://wptavern.com/feed\">a website for the bakery and cafe business he started</a> after renovating a 100-year-old barn on the island. Kentaro Yamaguchi, another island resident, uses WordPress for his <a href=\"https://wptavern.com/feed\">barber shop’s website</a>.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2018/07/screely-1531150922541.png?ssl=1\"><img /></a></p>\n<p>Nishikawa said he sees WordCamp Ogijima as “a WordCamp in a new place, for new audiences, by new organizers.&#8221; He appreciates the openness of the islanders who are willing to embrace new things.</p>\n<p>“The WordPress community on the island represents this atmosphere,” Nishikawa said. “Everyone has their own views, plans for their lives, and their own ways of thinking. WordPress, with its ‘Democratization of Publishing’ mission is a great match to us, who are trying to make our lives in different ways. We have built a library, cafe, a barbershop, and offices DIY ourselves.  When it comes to websites, WordPress helps us a lot.”</p>\n<h3>The WordPress Community in Ogijima is Defined by a Focus on Cooperative Learning</h3>\n<p>One of the most inspirational aspects of the community in Ogijima, along with the greater Japanese WordPress community, is the strong emphasis on helping each other learn and succeed. New members are often woven into the community through meetups that focus on connecting around specific interests outside of WordPress technical skill. The community warmly welcomes users who are new to WordPress who want to get help with their websites. Nishikawa said this is the particular audience that the Ogijima meetup is trying to reach.</p>\n<p>“We want to connect with individuals who want to achieve something; small business owners, designers, photographers, writers, editors, and anyone who is struggling doing something on the web,” Nishikawa said. “By coming together, you notice that there are many friends who are struggling as well. Experienced developers attend as usual but their role this time is to share their knowledge to the new people. We help each other build and improve our websites. It&#8217;s a very relaxed and helping atmosphere in the meetups. We do have some presentations sometimes but that&#8217;s not the main thing.”</p>\n<p>WordPress Core Committer <a href=\"https://profiles.wordpress.org/mikeschroder/\" rel=\"noopener noreferrer\" target=\"_blank\">Mike Schroder</a> will be speaking at WordCamp Ogijima about how everyone has something unique to bring to the community to help it grow.</p>\n<p>“I initially visited Japan for WordCamp Tokyo a few years ago — largely because it was the biggest WordCamp in the world at the time,” Schroder said. “The community in Japan is extremely active and welcoming, and I quickly made many friends. One unique part of the community is that it has a big focus on education. The <a href=\"http://wordbench.org\" rel=\"noopener noreferrer\" target=\"_blank\">WordBench</a> events are excellent!”</p>\n<p>“As the theme of the event is ‘Empower the smalls to go big,’ I’m looking forward to sharing some bits of my background, and how others have helped me grow, in an effort to show folks that they have a lot to offer,” Schroder said. (He’s also doing a bit of research and is interested to hear stories from others about unique aspects of their lives that have helped them succeed in the WordPress ecosystem. You can ping him @mike on WP Slack if you want to contribute.)</p>\n<p>The community in Ogijima is a beautiful example of how WordPress is powering a new wave of makers and doers on the island. The software has enabled them to establish new businesses, commerce, and cultural centers in a remote area where they are building their lives. WordCamp Ogijima is a classic example of what a WordCamp should be &#8211; an event that highlights the successes of local WordPress users.</p>\n<p>“While I don&#8217;t think our numbers will grow, our lives will always need WordPress and its community,” Nishikawa said regarding the local meetups. “And we welcome ambitious attendees who need help.”</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 Jul 2018 16:09:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Dev Blog: Update on Gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6118\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/news/2018/07/update-on-gutenberg/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2260:\"<p>Progress on the Gutenberg project, the new content creating experience coming to WordPress, has come a long way. Since the start of the project, there have been 30 releases and 12 of those happened after WordCamp US 2017. In total since then, there have been 1,764 issues opened and 1,115 closed as of WordCamp Europe. As the work on phase one moves into its final stretch, here is what you can expect.<br /></p>\n\n<h4>In Progress</h4>\n\n<ul>\n	<li>Freeze new features in Gutenberg (the feature list can be found <a href=\"https://github.com/WordPress/gutenberg/issues/4894\">here</a>).</li>\n	<li>Hosts, agencies, teachers invited to opt-in sites they have influence over.</li>\n	<li>WordPress.com has opt-in for wp-admin users. The number of sites and posts will be tracked.</li>\n	<li>Mobile app support for Gutenberg will be across iOS and Android.</li>\n</ul>\n\n<h4>July</h4>\n\n<ul>\n	<li>4.9.x release with an invitation to install either Gutenberg or Classic Editor plugin.</li>\n	<li>WordPress.com will move to opt-out. There will be tracking to see who opts out and why.</li>\n	<li>Triage increases and bug gardening escalates to get blockers in Gutenberg down to zero.</li>\n	<li>Gutenberg phase two, Customization exploration begins by moving beyond the post.</li>\n</ul>\n\n<h4>August and beyond</h4>\n\n<ul>\n	<li>All critical issues within Gutenberg are resolved.</li>\n	<li>There is full integration with Calypso and there is opt-in for users there.</li>\n	<li>A goal will be 100k+ sites having made 250k+ posts using Gutenberg.</li>\n	<li>Core merge of Gutenberg begins the 5.0 release cycle.</li>\n	<li>5.0 moves into beta releases and translations are completed.</li>\n	<li>There will be a mobile version of Gutenberg by the end of the year.</li>\n</ul>\n\n<p>WordPress 5.0 could be as soon as August with hundreds of thousands of sites using Gutenberg before release. Learn more about Gutenberg <a href=\"https://wordpress.org/gutenberg/\">here</a>, take it for a <a href=\"https://testgutenberg.com/\">test drive</a>, <a href=\"https://wordpress.org/plugins/gutenberg/\">install</a> on your site, follow along on <a href=\"https://github.com/WordPress/gutenberg\">GitHub</a> and give your <a href=\"https://wordpressdotorg.polldaddy.com/s/gutenberg-support\">feedback</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 Jul 2018 19:23:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Tammie Lister\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WPTavern: WordPress 4.9.8 to Introduce “Try Gutenberg” Callout\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=82174\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wptavern.com/wordpress-4-9-8-to-introduce-try-gutenberg-callout\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2027:\"<p>Paul Biron and Joshua Wold are leading the upcoming WordPress 4.9.8 release, which was originally announced as 4.9.7. WordPress core contributors met yesterday to decide the general focus and set the release schedule. In the meantime, the <a href=\"https://make.wordpress.org/core/2018/07/05/wordpress-4-9-7/\" rel=\"noopener noreferrer\" target=\"_blank\">4.9.7 security and maintenance release</a> was rolled out to fix an authenticated arbitrary file deletion vulnerability, along with a few other minor updates.</p>\n<p>WordPress 4.9.8 is targeted for July 31, 2018, with a beta as early as July 17. The release will focus on introducing the &#8220;<a href=\"https://core.trac.wordpress.org/ticket/41316\" rel=\"noopener noreferrer\" target=\"_blank\">Try Gutenberg</a>&#8221; callout and adding privacy fixes and enhancements. The ticket proposing the callout was opened a year ago and was planned to be included in WordPress 4.9.5 but was eventually <a href=\"https://wptavern.com/try-gutenberg-prompt-pushed-back-to-a-later-release\" rel=\"noopener noreferrer\" target=\"_blank\">pulled</a> before the release in favor of allowing Gutenberg contributors to iron out a few important issues.</p>\n<p>WordPress Core Committer Mel Choyce added the most recent round of designs to the ticket four weeks ago and contributors are still iterating on the design and text for the callout. Another iteration is expected to be added to the ticket early next week.</p>\n<p>WordPress 4.9.8 is another step in Matt Mullenweg&#8217;s <a href=\"https://wptavern.com/matt-mullenweg-unveils-gutenberg-roadmap-at-wceu-wordpress-agencies-and-product-developers-sprint-to-prepare\" rel=\"noopener noreferrer\" target=\"_blank\">roadmap for getting Gutenberg into 5.0</a>. The goal is to make more users aware of Gutenberg and to gather more testing and feedback before the new editor lands in core. The prompt will include a prominent button that users can click to install the Gutenberg plugin, along with links for where to learn more and how to report issues.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 05 Jul 2018 21:39:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"WPTavern: Just Write: A Client-Side React App for Writing and Editing WordPress Posts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=82147\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://wptavern.com/just-write-a-client-side-react-app-for-writing-and-editing-wordpress-posts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5227:\"<p>WordPress developer <a href=\"https://www.jasonbobich.com/\" rel=\"noopener noreferrer\" target=\"_blank\">Jason Bobich</a> has created an open source client-side React app called <a href=\"https://github.com/themeblvd/justwrite\">Just Write</a> that provides a decoupled editing experience for WordPress. Bobich said he built the app in 10 days to explore the possibilities of React and the WP REST API.</p>\n<p>Although it&#8217;s still a work in progress, the app has a <a href=\"http://justwrite.app\" rel=\"noopener noreferrer\" target=\"_blank\">demo</a> where curious testers can manage posts from any WordPress website that&#8217;s secured with HTTPS and has the JWT Authentication plugin installed. Alternatively, testers can click on the &#8220;play in the sandbox&#8221; to bypass authentication.</p>\n<p>Once logged in, the user sees a dashboard with the most recent posts, a deliberate design decision that Bobich made to &#8220;motivate the user to do one thing &#8211; to just write.&#8221;</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/07/just-write-dashboard.jpeg?ssl=1\"><img /></a></p>\n<p>The editor includes support for Markdown and a simple preview with a sticky toolbar at the top. Just Write also allows the user to edit their profile and personal information in a dropdown at the top of the screen.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/07/Screen-Shot-2018-07-03-at-4.17.02-PM.png?ssl=1\"><img /></a></p>\n<p>Bobich said he created to the app to improve his JavaScript skills and doesn&#8217;t have a plan to use it for business.</p>\n<p>&#8220;Ever since we were all told a couple of years ago, &#8216;Learn JavaScript deeply,&#8217; I’ve seen just how many holes I had in my own JavaScript knowledge,&#8221; Bobich said. &#8220;I’ve been working hard the last couple of years to become more than just a jQuery monkey. And so this project is just another step towards my personal growth surrounding the technologies involved here. It’s so exciting to think about the potential things that we can build in the community with React and the WordPress API.&#8221;</p>\n<h3>WP REST API Currently Poses Complicated Hurdles for App Developers</h3>\n<p>After the REST API was merged into core, the time seemed ripe for developers to build a proliferation of different writing experiences for users. However, working with the API still has many hurdles for application developers, limitations that Bobich said he became acquainted with while developing Just Write.</p>\n<p>&#8220;For anyone wanting to build a practical application like this, the first glaring issue is around authentication,&#8221; Bobich said. &#8220;WordPress has no way to securely authenticate from outside of the WordPress admin. So expecting any average user to set up oAuth or JWT with a third-party plugin is a bit of a reach.&#8221;</p>\n<p>Bobich also encountered issues working with media and saving content the WordPress way (which allows shortcodes to get parsed before <code>wpautop()</code>). The application is not yet ready for real, practical use but would require even more API calls to do things like get ahold of categories and tags or add the ability to create new ones.</p>\n<p>&#8220;Think about all the work WordPress has put into the way we embed media in different ways,&#8221; Bobich said. &#8220;Just having basic things we take for granted — pasting a YouTube link, a tweet, uploading an image and having it cropped 100 ways ’til Sunday — for all  work properly would all take custom JavaScript coding.&#8221;</p>\n<p>Bobich said he thinks these limitations are the reason why there aren&#8217;t yet more applications built with decoupled editing experiences. Yet, in the new era of Gutenberg, Just Write&#8217;s alternative writing interface offers a simplicity that some users may prefer.</p>\n<p>&#8220;As the WordPress admin continues to grow and become more complex, some people get excited and others moan and grown,&#8221; Bobich said. &#8220;But building something like Just Write shows us that there’s more to WordPress than just what we see. There’s more than a menu full of plugins and a new editor built in React that we may or may not like. WordPress can be what we want. It can fit our own needs or any client’s. And this all comes from the potential ability to decouple the editing experience.&#8221;</p>\n<p>As WordPress has evolved to accommodate different user types from blogging, websites, and niche applications, Bobich said he thinks the next logical step is for developers to begin creating admin interfaces catered specifically to users&#8217; individual needs.</p>\n<p>&#8220;Gutenberg marks an important turn in the evolution,&#8221; Bobich said. &#8220;For those that were clinging to the simplicity of WordPress and blocking out some of the other noise, this might not be something they end up liking&#8230; or maybe it will?</p>\n<p>&#8220;But the bigger point is that what we see there in the admin doesn’t have to be it. I hope people will be braver than me and really set out to build these different alternatives. If I can polish my React skills and build that myself in 10 days, I can only imagine what others can do.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 05 Jul 2018 18:09:46 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"Dev Blog: WordPress 4.9.7 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6091\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wordpress.org/news/2018/07/wordpress-4-9-7-security-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3983:\"<p>WordPress 4.9.7 is now available. This is a <strong>security and maintenance release</strong> for all versions since WordPress 3.7. We strongly encourage you to update your sites immediately.</p>\n\n<p>WordPress versions 4.9.6 and earlier are affected by a media issue that could potentially allow a user with certain capabilities to attempt to delete files outside the uploads directory.</p>\n\n<p>Thank you to <a href=\"https://hackerone.com/slavco\">Slavco</a> for reporting the original issue and <a href=\"https://www.wordfence.com/\">Matt Barry</a> for reporting related issues.</p>\n\n<p>Seventeen other bugs were fixed in WordPress 4.9.7. Particularly of note were:</p>\n\n<ul>\n	<li>Taxonomy: Improve cache handling for term queries.</li>\n	<li>Posts, Post Types: Clear post password cookie when logging out.</li>\n	<li>Widgets: Allow basic HTML tags in sidebar descriptions on Widgets admin screen.</li>\n	<li>Community Events Dashboard: Always show the nearest WordCamp if one is coming up, even if there are multiple Meetups happening first.</li>\n	<li>Privacy: Make sure default privacy policy content does not cause a fatal error when flushing rewrite rules outside of the admin context.</li>\n</ul>\n\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.9.7</a> or venture over to Dashboard → Updates and click &#8220;Update Now.&#8221; Sites that support automatic background updates are already beginning to update automatically.</p>\n\n<p>The previously scheduled 4.9.7 is now referred to as 4.9.8, and will follow the <a href=\"https://make.wordpress.org/core/2018/07/04/dev-chat-summary-july-4th-4-9-7-week-7/\">release schedule posted yesterday</a>.</p>\n\n<p>Thank you to everyone who contributed to WordPress 4.9.7:</p>\n\n<p><a href=\"https://profiles.wordpress.org/1naveengiri/\">1naveengiri</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/abdullahramzan/\">abdullahramzan</a>, <a href=\"https://profiles.wordpress.org/alejandroxlopez/\">alejandroxlopez</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/aryamaaru/\">Arun</a>, <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/bjornw/\">BjornW</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/chetan200891/\">Chetan Prajapati</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/garetharnold/\">Gareth</a>, <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/ianbelanger/\">ibelanger</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a>, <a href=\"https://profiles.wordpress.org/khaihong/\">khaihong</a>, <a href=\"https://profiles.wordpress.org/lbenicio/\">lbenicio</a>, <a href=\"https://profiles.wordpress.org/leanderiversen/\">Leander Iversen</a>, <a href=\"https://profiles.wordpress.org/mermel/\">mermel</a>, <a href=\"https://profiles.wordpress.org/metalandcoffee/\">metalandcoffee</a>, <a href=\"https://profiles.wordpress.org/jbpaul17/\">Migrated to @jeffpaul</a>, <a href=\"https://profiles.wordpress.org/palmiak/\">palmiak</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/skoldin/\">skoldin</a>, <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a>, <a href=\"https://profiles.wordpress.org/itowhid06/\">Towhidul Islam</a>, <a href=\"https://profiles.wordpress.org/warmlaundry/\">warmlaundry</a>, and <a href=\"https://profiles.wordpress.org/yuriv/\">YuriV</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 05 Jul 2018 17:00:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Aaron D. Campbell\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"HeroPress: Coding under trees and in 24 hour coffee shops\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=2582\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:166:\"https://heropress.com/essays/coding-under-trees-and-in-24-hour-coffee-shops/#utm_source=rss&utm_medium=rss&utm_campaign=coding-under-trees-and-in-24-hour-coffee-shops\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9173:\"<img width=\"960\" height=\"480\" src=\"https://s20094.pcdn.co/wp-content/uploads/2018/07/070418-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: Taking risks and being able to look like a fool have enabled me to become a WordPress core committer.\" /><p>People were paying me to write code two years before I had wifi in my house. Home wifi would have cost $45 a month. The cable company wanted a $100 deposit to create my account. It wasn&#8217;t going to happen, I could get wifi with a cup of coffee for $3 (including the tip) at a coffee shop a few blocks away from my place that meant I got some semblance of being social. I couldn&#8217;t imagine giving up 15 days a month at coffee shops just so it was easier to work from home, not when I could get away with sitting on my porch poaching wifi from my neighbors when I got stuck and had to google regular expressions for the 400th time. Or, my favorite, sit in a park down the street where there were three unprotected wifi networks and a strong tree to lean against.</p>\n<p>My path to becoming a web developer started when I packed up my beat up Chevy Prizm and drove to Portland, Oregon. I had graduated college with degrees in Economics and Political Science. While there, I become a Linux user when I discovered that it used less space meaning I had more space for music. I had never written code, but when my friends and I decided we wanted to create our version of The Onion, I started searching. After a little bit of trial ( blogger ) and error ( blogger ), I found WordPress and it&#8217;s &#8220;Famous Five Minute Install&#8221;. I purchased a domain and hosting from a place that advertised heavily and set about creating our site.</p>\n<p>The public library was my initial source of information. After all, having fun isn&#8217;t hard when you&#8217;ve got a library card. I picked up books on CSS, PHP, Java, Database design, and anything I could get my hands on. I was working evenings as an usher for the Portland Trailblazers and would head over to a 24 hour coffee shop to cowboy code under fluorescent lights until I was ready to crash.</p>\n<hr class=\"ttfmake-hr\" />\n<p>I can think of three big breaks that really helped move me along. Each of these ended up being &#8220;Flash Forward&#8221; moments where I was able to grow.</p>\n<h3>My First Client</h3>\n<p>I was scouring craigslist looking for anything I could get my hands on when I found someone offering $25 to move their WordPress site from one domain to another. Having just done that, I sent an email and crossed my fingers. Somehow, my eagerness (and likely willingness to work for peanuts) got my their trust. I had my first client. It took me way longer than I would have hoped as I learned about things like DNS Propagation, but I completed the task. And did such a good job that I was asked if I could build a website for one of their friends who was a standup comic. I was honest that I had never built a real site from scratch, but they liked how I had communicated, so I got the gig.</p>\n<h3>My First Core Experience</h3>\n<p>Before the first time I contributed to WordPress, I went to the Portland WordPress User Group to ask if something I was seeing was possibly an issue that warranted emailing the wp-hackers mailing list. I was so scared of being wrong that I felt like I needed to ask permission. I assumed that I was going to make a fool of myself and be laughed at. I ended up <a href=\"http://lists.automattic.com/pipermail/wp-hackers/2009-June/026386.html\">emailing the list</a> and it turned out, I had found a <a href=\"https://core.trac.wordpress.org/ticket/10022\">spot where WordPress could be better</a>! In the grand scheme of WordPress, passing a parameter to three `do_action` calls didn&#8217;t help WordPress gain 1% of market share, but it did help me with the plugin I was working on. And I was exposed to the process. I learned about trac, and the weekly devchat, and patches and svn. While I didn&#8217;t get props, I still consider this my first contribution to WordPress Core.</p>\n<h3>My first WordCamp</h3>\n<p>WordCamps are cheap compared to most tech conferences, but when you are playing the game of &#8220;How do I eat on $10 a week&#8221; for months on end, $40 for a conference whose value is unknown is a hard sell. Luckily, the Portland WordPress User Group did a raffle for a ticket and I won. All I had to pay for was the $2 in bus fare each way and I had the chance to learn. The 2009 WordCamp Portland ended up being where Matt Mullenweg announced that WPMU was going to be merged into core in WordPress 3.0 and it&#8217;s where I saw a talk entitled &#8220;<a href=\"https://wordpress.tv/2009/09/20/will-norris-building-plugins-portland09/\">How Not to Build a WordPress Plugin</a>&#8221; by Will Norris. Will&#8217;s talk exposed me to WordPress development in a way that I would never have imagined on my own. It helped me level up from someone who mostly was copy and pasting PHP to someone who was writing code.</p>\n<p>Additionally, I was able to network for the first time. It no longer was the same 15 people who went to the meetup, it was now about 200 WordPress fanatics, many who wanted to hire someone like me to work on their website!</p>\n<p>Looking back, these flash forward moments contributed almost as much to luck to my success. In many ways, a lot of my success can be attributed to the luck of being born as someone who is essentially a white cis-male into a family where I was exposed to computers and had a chance to gain a solid liberal arts education.</p>\n<p>But it&#8217;s not just that luck that helped me. I had to provide good customer service to turn a $25 task into a contract to build my first website. I had to be willing to embarrass myself by asking what I thought was a dumb question. I had to show up and become a part of my local community to get a ticket for a conference where I learned and networked.</p>\n<p>Soon after WordCamp Portland 2009, I had enough client work coming in that it made sense to have wifi. Home wifi meant I could start being connected to the WordPress community more than once a month in person or a few hours here and there at coffee shops. It meant I could read dev chat every week and eventually it meant I could earn props. Networking at meetups, WordCamps and conferences led to full time jobs. Taking risks and being willing to look like a fool in front of the WordPress community have enabled me to become a WordPress Core committer (and sometimes continue to look like a fool). In addition to volunteering on WordPress Core, I&#8217;m now the Director of Editorial Technology for Penske Media Corporation where I help brands like Rolling Stone and Variety run on WordPress, but I&#8217;ll never forget when if I needed to code, I was going to sit under trees in parks or the fluorescent lights of a 24 hour coffee shop.</p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: Coding under trees and in 24 hour coffee shops\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=Coding%20under%20trees%20and%20in%2024%20hour%20coffee%20shops&via=heropress&url=https%3A%2F%2Fheropress.com%2Fessays%2Fcoding-under-trees-and-in-24-hour-coffee-shops%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: Coding under trees and in 24 hour coffee shops\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fessays%2Fcoding-under-trees-and-in-24-hour-coffee-shops%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fessays%2Fcoding-under-trees-and-in-24-hour-coffee-shops%2F&title=Coding+under+trees+and+in+24+hour+coffee+shops\" rel=\"nofollow\" target=\"_blank\" title=\"Share: Coding under trees and in 24 hour coffee shops\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/essays/coding-under-trees-and-in-24-hour-coffee-shops/&media=https://heropress.com/wp-content/uploads/2018/07/070418-150x150.jpg&description=Coding under trees and in 24 hour coffee shops\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: Coding under trees and in 24 hour coffee shops\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/essays/coding-under-trees-and-in-24-hour-coffee-shops/\" title=\"Coding under trees and in 24 hour coffee shops\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/coding-under-trees-and-in-24-hour-coffee-shops/\">Coding under trees and in 24 hour coffee shops</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 04 Jul 2018 18:30:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Aaron Jorbin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"WPTavern: WordCamp Incubator Program 2018 to Host Events in Montevideo, Uruguay and Kota Kinabalu, Malaysia\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=82134\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:116:\"https://wptavern.com/wordcamp-incubator-program-2018-to-host-events-in-montevideo-uruguay-and-kota-kinabalu-malaysia\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2465:\"<a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2018/07/montevideo.jpg?ssl=1\"><img /></a>The Pocitos neighborhood of Montevideo, Uruguay. Skyline from the shore -photo credit: <a href=\"https://en.wikipedia.org/wiki/File:Pocitos,_2017.jpg\">Rimbaldine</a>\n<p>The WordCamp Incubator Program has selected <a href=\"https://make.wordpress.org/community/2018/06/26/wordcamp-incubator-program-2018-locations-announcement/\" rel=\"noopener noreferrer\" target=\"_blank\">Montevideo, Uruguay and Kota Kinabalu, Malaysia to host WordCamps in 2018</a>. The program provides a jump start for new WordPress communities where meetups have not yet been well-established. Montevideo and Kota Kinabalu were selected from a <a href=\"https://make.wordpress.org/community/2018/05/15/wordcamp-incubator-program-2018-update/\" rel=\"noopener noreferrer\" target=\"_blank\">short list of 14 communities</a> that had been whittled down from 104 applications for the program.</p>\n<p>WordPress Community Deputies will co-lead the events and mentor a local team that will organize a one-track WordCamp with approximately 50-75 attendees. The goal is to empower the new organizers and the fledgling communities to host more local events, ideally regular meetups and an annual WordCamp. Mentors will assist in finding speakers and sponsors. A global sponsorship grant will cover 100% of the events&#8217; costs, relieving the organizers of the burden of local fundraising.</p>\n<p>WordPress Community Team member Rocío Valdivia announced the program&#8217;s new cities for 2018 and said she anticipates the events will happen in the last quarter of this year. Local co-leads have been charged with starting a monthly meetup group before setting a date for the new WordCamps.</p>\n<p>Round 2 of the WordCamp Incubator Program follows up a successful run in 2016 that brought WordCamps to Denpasar, Harare, and Medellín. <a href=\"https://wptavern.com/harare-and-nairobi-host-2nd-round-of-successful-wordcamps\" rel=\"noopener noreferrer\" target=\"_blank\">Harare hosted its second WordCamp in 2017</a> and a <a href=\"https://2018.harare.wordcamp.org/\" rel=\"noopener noreferrer\" target=\"_blank\">2018 camp</a> is in the early planning stages. This particular African community, along with the neighboring Nairobi community (on the short list in 2016), are strong examples of how the incubator program can provide a boost in areas of the world where the WordPress community is not yet deeply rooted.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 03 Jul 2018 03:41:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"WPTavern: Block Unit Test Plugin Helps WordPress Theme Developers Prepare for Gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=81919\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"https://wptavern.com/block-unit-test-plugin-helps-wordpress-theme-developers-prepare-for-gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4606:\"<p><a href=\"https://themebeans.com/\" rel=\"noopener noreferrer\" target=\"_blank\">ThemeBeans</a> founder Rich Tabor has released a new plugin called <a href=\"https://wordpress.org/plugins/block-unit-test/\" rel=\"noopener noreferrer\" target=\"_blank\">Block Unit Test for Gutenberg</a> that helps theme authors test their themes for Gutenberg-readiness. It is similar to the <a href=\"https://codex.wordpress.org/Theme_Unit_Test\" rel=\"noopener noreferrer\" target=\"_blank\">Theme Unit Test</a> but is limited to testing Gutenberg blocks.</p>\n<p>After installing and activating both Gutenberg and sBlock Unit Test, the plugin creates a new page as a draft with an example of every core Gutenblock. This makes it easy to see how the blocks will appear on the frontend of any theme. Block Unit Test also includes variations on the core blocks with different alignment and column settings applied.</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2018/06/screely-1530556922797.png?ssl=1\"><img /></a></p>\n<p>Tabor said he knew it would be advantageous to start using/writing in Gutenberg daily to better understand what he needed to do to make his products at ThemeBeans compatible.</p>\n<p>&#8220;I added initial support for Gutenberg in my Tabor WordPress theme, as I use it on my own personal blog with Gutenberg,&#8221; he said. &#8220;I needed a way to easily test each of the core Gutenberg blocks (and eventually third-party blocks) without having to manually add them every time I wanted to test something. As Gutenberg blocks get more dynamic and complicated, it’s a bit trickier to test for &#8211; as many blocks have different variations/styles/columns/grids/etc.&#8221;</p>\n<p>Tabor took inspiration from the Theme Unit Test and created Block Unit Test with Gutenblock variations included. He is using the plugin while preparing the 20+ themes in his ThemeBeans catalog to support Gutenberg. He wrote the plugin to be extensible and made it open source on <a href=\"https://github.com/thatplugincompany/block-unit-test\" rel=\"noopener noreferrer\" target=\"_blank\">GitHub</a> for other developers and theme shops to use.</p>\n<p>Theme developers can install Block Unit Test as a first step towards making sure the front-end styles match the editor styles. This will be essential to making the transition process easier for new Gutenberg users once WordPress 5.0 ships. Tabor also published a tutorial for <a href=\"https://richtabor.com/add-wordpress-theme-styles-to-gutenberg/\" rel=\"noopener noreferrer\" target=\"_blank\">adding WordPress Theme Styles to Gutenberg</a> to help others get started.</p>\n<p>In getting his first theme compatible, Tabor said he relied heavily on the <a href=\"https://wordpress.org/gutenberg/handbook/\" rel=\"noopener noreferrer\" target=\"_blank\">Gutenberg Handbook</a>, as well as following discussions on the <a href=\"https://github.com/WordPress/gutenberg\" rel=\"noopener noreferrer\" target=\"_blank\">Gutenberg GitHub repository</a>.</p>\n<p>&#8220;It’s not terribly difficult to add support for Gutenberg, although applying proper theme styles within the Gutenberg editor is a bit of task — there’s so much that can be accidentally overlooked,&#8221; Tabor said. &#8220;For the theme side of things, there wasn&#8217;t much technical leveling-up — though developing blocks is a different story. I did need to raise the bar and dive deeply into the world of Javascript, though looking at the block examples on the GitHub repository really helped me along.&#8221;</p>\n<p>Tabor said he started &#8220;living and breathing all things Gutenberg&#8221; after WordCamp US 2017, and began writing development articles while learning the ropes. He created several projects focused on the new editor, including <a href=\"https://writy.io/\" rel=\"noopener noreferrer\" target=\"_blank\">Writy</a>, a Gutenberg-centric writing experience for publishers, and <a href=\"https://richtabor.com/coblocks/\" rel=\"noopener noreferrer\" target=\"_blank\">Co-Blocks</a>, a beta suite of Gutenberg blocks for content marketers.</p>\n<p>&#8220;As a founder of a theme shop it was apparent that I needed to hone in on Gutenberg and level-up my knowledge, technical skills, and consequently my products, in order to compete in a post-Gutenberg era of WordPress,&#8221; Tabor said.</p>\n<p>&#8220;I believe the foundation of the future of WordPress lies in the success of Gutenberg. I use the new editor just about daily now. I know it’s a great move in the right direction and I’m doing my part to make sure folks using my themes can experience everything that Gutenberg has to offer.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 Jul 2018 21:43:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"Dev Blog: The Month in WordPress: June 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6087\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wordpress.org/news/2018/07/the-month-in-wordpress-june-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4626:\"<p>With one of the two flagship WordCamp events taking place this month, as well as some important WordPress project announcements, there’s no shortage of news. Learn more about what happened in the WordPress community in June.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Another Successful WordCamp Europe</h2>\n\n<p>On June 14th, WordCamp Europe kicked off three days of learning and contributions in Belgrade. Over 2,000 people attended in person, with hundreds more watching live streams of the sessions.</p>\n\n<p>The WordCamp was a great success with plenty of first-time attendees and new WordPress contributors getting involved in the project and community. Recorded sessions from the 65 speakers at the event will be available on WordPress.tv in the coming weeks. In the meantime, check out the <a href=\"https://www.flickr.com/photos/wceu/albums\">photos from the event</a>.</p>\n\n<p><a href=\"https://2018.europe.wordcamp.org/2018/06/16/wordcamp-europe-2019/\">The next WordCamp Europe</a> takes place on June 20-22 2019 in Berlin, Germany. If you’re based in Europe and would like to serve on the organizing team, <a href=\"https://2019.europe.wordcamp.org/2018/06/16/call-wordcamp-europe-2019-organizers/\">fill in the application form</a>.</p>\n\n<h2>Updated Roadmap for the New WordPress Content Editor</h2>\n\n<p>During his keynote session at WordCamp Europe, Matt Mullenweg presented <a href=\"https://gutenbergtimes.com/mullenweg-on-gutenberg-roll-out-plan/\">an updated roadmap</a> for <a href=\"https://wordpress.org/gutenberg/\">Gutenberg</a>, the new content editor coming in WordPress 5.0.</p>\n\n<p>While the editor is in rapid development, <a href=\"https://make.wordpress.org/core/2018/06/21/whats-new-in-gutenberg-21st-june/\">with v3.1 being released this past month</a>, the team is aiming to ship Gutenberg with WordPress Core in August, 2018. This is not set in stone — the release date may shift as development progresses — but this gives the first realistic idea of when we can expect the editor to be released.</p>\n\n<p>If you would like to contribute to Gutenberg, read <a href=\"https://wordpress.org/gutenberg/handbook/\">the handbook</a>, follow the <a href=\"https://make.wordpress.org/core/\">Core team blog</a>, and join the #core-editor channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<h2>WordCamp Incubator Cities Announced</h2>\n\n<p>The WordCamp Incubator program helps spread WordPress to underserved communities by providing organizing support for their first WordCamp. The first iteration of this program ran successfully in 2016 and empowered three cities to start their own WordPress communities.</p>\n\n<p>This year, the Community Team is running the Incubator program again. After receiving applications from 104 communities, <a href=\"https://make.wordpress.org/community/2018/06/26/wordcamp-incubator-program-2018-locations-announcement/\">they have selected</a> Montevideo, Uruguay and Kota Kinabalu, Malaysia to participate in the program. Both cities will receive direct help from experienced WordCamp organizers to run their first-ever WordCamp as a way to help their WordPress community get started.</p>\n\n<p>To find out more about the Incubator program follow the <a href=\"https://make.wordpress.org/community/\">Community team blog</a>, and join the #community-events channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Further Reading:</h2>\n\n<ul>\n	<li>The WordPress community of Spain recently <a href=\"https://twitter.com/wp_es/status/1004681694660603904\">received an award</a> for being the best open-source community in the country.</li>\n	<li>This month, WordPress reached <a href=\"https://w3techs.com/technologies/details/cm-wordpress/all/all\">the milestone of powering 31% of websites</a>.</li>\n	<li><a href=\"https://wprig.io/introducing-wprig-wordpress/\">WP Rig</a> is a brand new tool to help WordPress developers build better themes.</li>\n	<li><a href=\"https://richtabor.com/gutenberg-block-unit-test/\">Block Unit Test</a> is a new plugin to help theme developers prepare for Gutenberg.</li>\n	<li>Near the end of the month, Zac Gordon hosted <a href=\"https://javascriptforwp.com/conference/\">an online conference</a> focused on JavaScript development in WordPress &#8211; the session videos will be available on YouTube soon.</li>\n</ul>\n\n<p><em>If you have a story we should consider including in the next “Month in WordPress” post, please <a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\">submit it here</a>.</em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 Jul 2018 09:28:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Matt: Work and Play\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=48231\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://ma.tt/2018/06/work-and-play/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:527:\"<blockquote class=\"wp-block-quote\">\n	<p>A master in the art of living draws no sharp distinction between his work and his play; his labor and his leisure; his mind and his body; his education and his recreation. He hardly knows which is which. He simply pursues his vision of excellence through whatever he is doing, and leaves others to determine whether he is working or playing. To himself, he always appears to be doing both.</p>\n</blockquote>\n\n<p>Lawrence Pearsall Jacks in <em>Education through Recreation</em>, 1932</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 01 Jul 2018 01:13:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"Post Status: An Abundance of Acquisitions — Draft Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=46292\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://poststatus.com/an-abundance-of-acquisitions-draft-podcast/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2301:\"<p>Welcome to the Post Status <a href=\"https://poststatus.com/category/draft\">Draft podcast</a>, which you can find <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\">on iTunes</a>, <a href=\"https://play.google.com/music/m/Ih5egfxskgcec4qadr3f4zfpzzm?t=Post_Status__Draft_WordPress_Podcast\">Google Play</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\">Stitcher</a>, and <a href=\"http://simplecast.fm/podcasts/1061/rss\">via RSS</a> for your favorite podcatcher. Post Status Draft is hosted by Brian Krogsgard and co-host Brian Richards.</p>\n<p>In this episode, the Brians have a chat about a number of different acquisitions that have occurred in the WordPress space over these past few weeks. Listen in as they unpack some of the news surrounding StudioPress, WPEngine, Automattic, WPNinjas, Prospress, and AutomateWoo. Check out our episode links for further stories about each of those businesses as well as the virtual JavaScript for WordPress conference taking place live on July 29.</p>\n<p></p>\n<h3>Links</h3>\n<ul>\n<li><a href=\"https://wpengine.com/blog/wp-engine-acquires-studiopress/\">WPEngine acquired StudioPress</a></li>\n<li><a href=\"https://poststatus.com/notes/automattic-acquries-atavist/\">Automattic acquired Atavist</a></li>\n<li><a href=\"http://ninjashop.site/open-letter-exchangewp/\">WPNinjas acquired ExchangeWP (formerly iThemes Exchange)</a></li>\n<li><a href=\"https://prospress.com/automatewoo-joins-prospress/\">Prospress acquires AutomateWoo</a></li>\n<li><a href=\"https://subscribe.me/\">Prospress announced Subscribe.me</a></li>\n<li><a href=\"https://javascriptforwp.com/conference/\">JSforWP Conf on Friday</a></li>\n<li><a href=\"https://2018.grandrapids.wordcamp.org\">WCGR on Saturday</a></li>\n<li><a href=\"https://florianziegler.com/wordcamp-europe-2018/\">WCEU Photos</a></li>\n</ul>\n<h3>Sponsor: Jilt</h3>\n<p><a href=\"https://jilt.com/?utm_source=Post+Status&utm_medium=banner&utm_campaign=Post+Status+Sponsorship\">Jilt</a> offers powerful email marketing built for eCommerce. Join thousands of stores that have already earned over $28,000,000 in extra sales using Jilt. <a href=\"https://jilt.com/?utm_source=Post+Status&utm_medium=banner&utm_campaign=Post+Status+Sponsorship\">Try Jilt for free</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 29 Jun 2018 22:11:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"WPTavern: WCEU Panel Discusses Progressive WordPress Themes, AMP, and Gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=82078\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://wptavern.com/wceu-panel-discusses-progressive-wordpress-themes-amp-and-gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4940:\"<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/06/progressive-themes-panel.png?ssl=1\"><img /></a></p>\n<p>Progressive themes was a hot topic at WordCamp Europe 2018. During the event I had the opportunity to set up a panel with four experts who are working to integrate progressive web development practices more deeply in WordPress core, plugins, and themes. These practices make it possible for a website (or app) to work offline, load quickly, deliver content on unreliable networks, and use device-specific features to provide a better experience for the user. The <a href=\"https://wptavern.com/wordcamp-europe-introduces-official-mobile-app-new-tech-for-on-site-badge-printing\" rel=\"noopener noreferrer\" target=\"_blank\">PWA (progressive web app) created for WordCamp Europe</a> is a good example of this in action.</p>\n<p><a href=\"https://twitter.com/TweetyThierry\" rel=\"noopener noreferrer\" target=\"_blank\">Thierry Muller</a>, <a href=\"https://twitter.com/iAlbMedina\" rel=\"noopener noreferrer\" target=\"_blank\">Alberto Medina</a>, <a href=\"https://twitter.com/westonruter\" rel=\"noopener noreferrer\" target=\"_blank\">Weston Ruter</a>, and <a href=\"https://twitter.com/mor10\" rel=\"noopener noreferrer\" target=\"_blank\">Morten Rand-Hendriksen</a> joined me for an interview, exploring the future of WordPress themes in the era of progressive web development. (see video below)</p>\n<p>&#8220;At the most abstract level, it&#8217;s all about user experience,&#8221; Medina said. &#8220;How do we maximize the pleasure that our users get when they use our websites? And delightfulness in this context means things like performance, speed, having content that isn&#8217;t blocked. If you think about themes built according to those principles, then we are basically seeking an awesome user experience in WordPress.&#8221;</p>\n<p>It&#8217;s not yet clear what this will look like for the WordPress theme landscape, as current solutions are somewhat fragmented. WordPress contributors are working to standardize progressive technologies in core so the ecosystem can collaborate better together.</p>\n<p>&#8220;There are many progressive themes being built these days,&#8221; Medina said. &#8220;One of the problems that is happening is that there is a lot of fragmentation. There&#8217;s a lot of plugins that are using service workers but in their own ways. What we want is to say, &#8216;This is the best way to do things,&#8217; this is a uniform API to do it, and then enable progressive theme developers to take advantage of the core functionality.&#8221;</p>\n<p>Currently, the prospect of setting up a WordPress site that uses progressive web technologies would be a daunting task for regular users, even if they are implementing existing solutions.</p>\n<p>&#8220;There&#8217;s also a user aspect of it, because the people for whom we design WordPress, plugins, and themes, are the people who actually publish their own content onto the web,&#8221; Rand-Hendriksen said. &#8220;There&#8217;s a really valid question in how much should they need to know about how the web works to be able to publish some content. When they spin up a WordPress site, should we impose on them to know that they need to add all these optimization plugins and do all this other stuff just to make the site work properly? How much of that can be offloaded onto the theme itself, or plugins, or even WordPress core?&#8221;</p>\n<p>The members of the panel are working together to on various projects and core contributions that will standardize the use of progressive enhancement technologies in WordPress.</p>\n<p>&#8220;The goal is to have a common API for service workers so that plugins and themes can each install their own logic, just like they can enqueue their own scripts today,&#8221; Ruter said. &#8220;Also to be able to enqueue their own service workers and then core can manage the combination of them, as well as having a common app manifest that plugins and themes can collaborate on and have a single output into the page.&#8221;</p>\n<p>This is how Rand-Hendriksen&#8217;s <a href=\"https://wprig.io/\" rel=\"noopener noreferrer\" target=\"_blank\">WP Rig starter theme</a> project came about &#8211; to help developers take advantage of these best practices in the meantime, without having to figure out how to put all the pieces together.</p>\n<p>&#8220;WP Rig gives you the platform to build a progressive theme that uses all the latest performance and WordPress best practices, in a convenient package, and over time it will evolve with these new progressive technologies,&#8221; Rand-Hendriksen said.</p>\n<p>We also discussed AMP and Gutenberg compatibility, <a href=\"https://core.trac.wordpress.org/ticket/43328\" rel=\"noopener noreferrer\" target=\"_blank\">core support for web app manifests</a>, and how the commercial theme industry will react to these new technologies. Check out the full interview in the video below.</p>\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 29 Jun 2018 22:03:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:8:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Mon, 30 Jul 2018 11:09:59 GMT\";s:12:\"content-type\";s:8:\"text/xml\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:13:\"last-modified\";s:29:\"Mon, 30 Jul 2018 11:00:28 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:9:\"HIT ord 1\";s:16:\"content-encoding\";s:4:\"gzip\";}}s:5:\"build\";s:14:\"20130911040210\";}', 'no');
INSERT INTO `wp_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(133, '_transient_timeout_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9', '1532992200', 'no'),
(134, '_transient_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9', '1532949000', 'no'),
(135, '_transient_timeout_dash_v2_88ae138922fe95674369b1cb3d215a2b', '1532992200', 'no'),
(136, '_transient_dash_v2_88ae138922fe95674369b1cb3d215a2b', '<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2018/07/quarterly-updates-q2-2018/\'>Quarterly Updates | Q2 2018</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wptavern.com/plugin-review-theme-support-for-gutenberg\'>WPTavern: Plugin Review: Theme Support for Gutenberg</a></li><li><a class=\'rsswidget\' href=\'https://wptavern.com/woosesh-virtual-woocommerce-conference-to-be-held-october-18-19\'>WPTavern: WooSesh Virtual WooCommerce Conference to be Held October 18-19</a></li><li><a class=\'rsswidget\' href=\'https://wptavern.com/slack-acquires-hipchat-moves-blog-from-medium-to-wordpress\'>WPTavern: Slack Acquires HipChat, Moves Blog from Medium to WordPress</a></li></ul></div>', 'no'),
(139, '_transient_is_multi_author', '0', 'yes'),
(141, '_site_transient_timeout_theme_roots', '1533125899', 'no'),
(142, '_site_transient_theme_roots', 'a:3:{s:13:\"twentyfifteen\";s:7:\"/themes\";s:15:\"twentyseventeen\";s:7:\"/themes\";s:13:\"twentysixteen\";s:7:\"/themes\";}', 'no'),
(143, '_site_transient_update_plugins', 'O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1533124103;s:7:\"checked\";a:2:{s:19:\"akismet/akismet.php\";s:5:\"4.0.3\";s:9:\"hello.php\";s:3:\"1.7\";}s:8:\"response\";a:1:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:5:\"4.0.8\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/akismet.4.0.8.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:59:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=969272\";s:2:\"1x\";s:59:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=969272\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:61:\"https://ps.w.org/akismet/assets/banner-772x250.jpg?rev=479904\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"4.9.6\";s:12:\"requires_php\";b:0;s:13:\"compatibility\";O:8:\"stdClass\":0:{}}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:1:{s:9:\"hello.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:25:\"w.org/plugins/hello-dolly\";s:4:\"slug\";s:11:\"hello-dolly\";s:6:\"plugin\";s:9:\"hello.php\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/hello-dolly/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/hello-dolly.1.6.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/hello-dolly/assets/icon-256x256.jpg?rev=969907\";s:2:\"1x\";s:63:\"https://ps.w.org/hello-dolly/assets/icon-128x128.jpg?rev=969907\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:65:\"https://ps.w.org/hello-dolly/assets/banner-772x250.png?rev=478342\";}s:11:\"banners_rtl\";a:0:{}}}}', 'no');

-- --------------------------------------------------------

--
-- Table structure for table `wp_postmeta`
--

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) UNSIGNED NOT NULL,
  `post_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Dumping data for table `wp_postmeta`
--

INSERT INTO `wp_postmeta` (`meta_id`, `post_id`, `meta_key`, `meta_value`) VALUES
(1, 2, '_wp_page_template', 'default'),
(2, 3, '_wp_page_template', 'default');

-- --------------------------------------------------------

--
-- Table structure for table `wp_posts`
--

CREATE TABLE `wp_posts` (
  `ID` bigint(20) UNSIGNED NOT NULL,
  `post_author` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Dumping data for table `wp_posts`
--

INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES
(1, 1, '2018-07-30 11:09:41', '2018-07-30 11:09:41', 'Welcome to WordPress. This is your first post. Edit or delete it, then start writing!', 'Hello world!', '', 'publish', 'open', 'open', '', 'hello-world', '', '', '2018-07-30 11:09:41', '2018-07-30 11:09:41', '', 0, 'http://wordpress.anuj/?p=1', 0, 'post', '', 1),
(2, 1, '2018-07-30 11:09:41', '2018-07-30 11:09:41', 'This is an example page. It\'s different from a blog post because it will stay in one place and will show up in your site navigation (in most themes). Most people start with an About page that introduces them to potential site visitors. It might say something like this:\n\n<blockquote>Hi there! I\'m a bike messenger by day, aspiring actor by night, and this is my website. I live in Los Angeles, have a great dog named Jack, and I like pi&#241;a coladas. (And gettin\' caught in the rain.)</blockquote>\n\n...or something like this:\n\n<blockquote>The XYZ Doohickey Company was founded in 1971, and has been providing quality doohickeys to the public ever since. Located in Gotham City, XYZ employs over 2,000 people and does all kinds of awesome things for the Gotham community.</blockquote>\n\nAs a new WordPress user, you should go to <a href=\"http://wordpress.anuj/wp-admin/\">your dashboard</a> to delete this page and create new pages for your content. Have fun!', 'Sample Page', '', 'publish', 'closed', 'open', '', 'sample-page', '', '', '2018-07-30 11:09:41', '2018-07-30 11:09:41', '', 0, 'http://wordpress.anuj/?page_id=2', 0, 'page', '', 0),
(3, 1, '2018-07-30 11:09:41', '2018-07-30 11:09:41', '<h2>Who we are</h2><p>Our website address is: http://wordpress.anuj.</p><h2>What personal data we collect and why we collect it</h2><h3>Comments</h3><p>When visitors leave comments on the site we collect the data shown in the comments form, and also the visitor&#8217;s IP address and browser user agent string to help spam detection.</p><p>An anonymized string created from your email address (also called a hash) may be provided to the Gravatar service to see if you are using it. The Gravatar service privacy policy is available here: https://automattic.com/privacy/. After approval of your comment, your profile picture is visible to the public in the context of your comment.</p><h3>Media</h3><p>If you upload images to the website, you should avoid uploading images with embedded location data (EXIF GPS) included. Visitors to the website can download and extract any location data from images on the website.</p><h3>Contact forms</h3><h3>Cookies</h3><p>If you leave a comment on our site you may opt-in to saving your name, email address and website in cookies. These are for your convenience so that you do not have to fill in your details again when you leave another comment. These cookies will last for one year.</p><p>If you have an account and you log in to this site, we will set a temporary cookie to determine if your browser accepts cookies. This cookie contains no personal data and is discarded when you close your browser.</p><p>When you log in, we will also set up several cookies to save your login information and your screen display choices. Login cookies last for two days, and screen options cookies last for a year. If you select &quot;Remember Me&quot;, your login will persist for two weeks. If you log out of your account, the login cookies will be removed.</p><p>If you edit or publish an article, an additional cookie will be saved in your browser. This cookie includes no personal data and simply indicates the post ID of the article you just edited. It expires after 1 day.</p><h3>Embedded content from other websites</h3><p>Articles on this site may include embedded content (e.g. videos, images, articles, etc.). Embedded content from other websites behaves in the exact same way as if the visitor has visited the other website.</p><p>These websites may collect data about you, use cookies, embed additional third-party tracking, and monitor your interaction with that embedded content, including tracking your interaction with the embedded content if you have an account and are logged in to that website.</p><h3>Analytics</h3><h2>Who we share your data with</h2><h2>How long we retain your data</h2><p>If you leave a comment, the comment and its metadata are retained indefinitely. This is so we can recognize and approve any follow-up comments automatically instead of holding them in a moderation queue.</p><p>For users that register on our website (if any), we also store the personal information they provide in their user profile. All users can see, edit, or delete their personal information at any time (except they cannot change their username). Website administrators can also see and edit that information.</p><h2>What rights you have over your data</h2><p>If you have an account on this site, or have left comments, you can request to receive an exported file of the personal data we hold about you, including any data you have provided to us. You can also request that we erase any personal data we hold about you. This does not include any data we are obliged to keep for administrative, legal, or security purposes.</p><h2>Where we send your data</h2><p>Visitor comments may be checked through an automated spam detection service.</p><h2>Your contact information</h2><h2>Additional information</h2><h3>How we protect your data</h3><h3>What data breach procedures we have in place</h3><h3>What third parties we receive data from</h3><h3>What automated decision making and/or profiling we do with user data</h3><h3>Industry regulatory disclosure requirements</h3>', 'Privacy Policy', '', 'draft', 'closed', 'open', '', 'privacy-policy', '', '', '2018-07-30 11:09:41', '2018-07-30 11:09:41', '', 0, 'http://wordpress.anuj/?page_id=3', 0, 'page', '', 0),
(4, 1, '2018-07-30 11:09:53', '0000-00-00 00:00:00', '', 'Auto Draft', '', 'auto-draft', 'open', 'open', '', '', '', '', '2018-07-30 11:09:53', '0000-00-00 00:00:00', '', 0, 'http://wordpress.anuj/?p=4', 0, 'post', '', 0);

-- --------------------------------------------------------

--
-- Table structure for table `wp_termmeta`
--

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) UNSIGNED NOT NULL,
  `term_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- --------------------------------------------------------

--
-- Table structure for table `wp_terms`
--

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Dumping data for table `wp_terms`
--

INSERT INTO `wp_terms` (`term_id`, `name`, `slug`, `term_group`) VALUES
(1, 'Uncategorized', 'uncategorized', 0);

-- --------------------------------------------------------

--
-- Table structure for table `wp_term_relationships`
--

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Dumping data for table `wp_term_relationships`
--

INSERT INTO `wp_term_relationships` (`object_id`, `term_taxonomy_id`, `term_order`) VALUES
(1, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `wp_term_taxonomy`
--

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) UNSIGNED NOT NULL,
  `term_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Dumping data for table `wp_term_taxonomy`
--

INSERT INTO `wp_term_taxonomy` (`term_taxonomy_id`, `term_id`, `taxonomy`, `description`, `parent`, `count`) VALUES
(1, 1, 'category', '', 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `wp_usermeta`
--

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) UNSIGNED NOT NULL,
  `user_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Dumping data for table `wp_usermeta`
--

INSERT INTO `wp_usermeta` (`umeta_id`, `user_id`, `meta_key`, `meta_value`) VALUES
(1, 1, 'nickname', '{user_nick_name}'),
(2, 1, 'first_name', '{user_first_name}'),
(3, 1, 'last_name', '{user_last_name}'),
(4, 1, 'description', ''),
(5, 1, 'rich_editing', 'true'),
(6, 1, 'syntax_highlighting', 'true'),
(7, 1, 'comment_shortcuts', 'false'),
(8, 1, 'admin_color', 'fresh'),
(9, 1, 'use_ssl', '0'),
(10, 1, 'show_admin_bar_front', 'true'),
(11, 1, 'locale', ''),
(12, 1, 'wp_capabilities', 'a:1:{s:13:\"administrator\";b:1;}'),
(13, 1, 'wp_user_level', '10'),
(14, 1, 'dismissed_wp_pointers', 'wp496_privacy'),
(15, 1, 'show_welcome_panel', '1'),
(16, 1, 'session_tokens', 'a:1:{s:64:\"dd31f6a3ed543e7c4dc55cd33f228cb237fb482493db2b07194ad5971b9c029d\";a:4:{s:10:\"expiration\";i:1533121789;s:2:\"ip\";s:9:\"127.0.0.1\";s:2:\"ua\";s:68:\"Mozilla/5.0 (X11; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";s:5:\"login\";i:1532948989;}}'),
(17, 1, 'wp_dashboard_quick_press_last_post_id', '4'),
(18, 1, 'community-events-location', 'a:1:{s:2:\"ip\";s:9:\"127.0.0.0\";}');

-- --------------------------------------------------------

--
-- Table structure for table `wp_users`
--

CREATE TABLE `wp_users` (
  `ID` bigint(20) UNSIGNED NOT NULL,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Dumping data for table `wp_users`
--

INSERT INTO `wp_users` (`ID`, `user_login`, `user_pass`, `user_nicename`, `user_email`, `user_url`, `user_registered`, `user_activation_key`, `user_status`, `display_name`) VALUES
(1, '{blog_username}', '{blog_password}', '{user_nick_name}', '{admin_email}', '', '{registration_date}', '', 0, '{user_nick_name}');

--
-- Indexes for dumped tables
--

--
-- Indexes for table `wp_commentmeta`
--
ALTER TABLE `wp_commentmeta`
  ADD PRIMARY KEY (`meta_id`),
  ADD KEY `comment_id` (`comment_id`),
  ADD KEY `meta_key` (`meta_key`(191));

--
-- Indexes for table `wp_comments`
--
ALTER TABLE `wp_comments`
  ADD PRIMARY KEY (`comment_ID`),
  ADD KEY `comment_post_ID` (`comment_post_ID`),
  ADD KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  ADD KEY `comment_date_gmt` (`comment_date_gmt`),
  ADD KEY `comment_parent` (`comment_parent`),
  ADD KEY `comment_author_email` (`comment_author_email`(10));

--
-- Indexes for table `wp_links`
--
ALTER TABLE `wp_links`
  ADD PRIMARY KEY (`link_id`),
  ADD KEY `link_visible` (`link_visible`);

--
-- Indexes for table `wp_options`
--
ALTER TABLE `wp_options`
  ADD PRIMARY KEY (`option_id`),
  ADD UNIQUE KEY `option_name` (`option_name`);

--
-- Indexes for table `wp_postmeta`
--
ALTER TABLE `wp_postmeta`
  ADD PRIMARY KEY (`meta_id`),
  ADD KEY `post_id` (`post_id`),
  ADD KEY `meta_key` (`meta_key`(191));

--
-- Indexes for table `wp_posts`
--
ALTER TABLE `wp_posts`
  ADD PRIMARY KEY (`ID`),
  ADD KEY `post_name` (`post_name`(191)),
  ADD KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  ADD KEY `post_parent` (`post_parent`),
  ADD KEY `post_author` (`post_author`);

--
-- Indexes for table `wp_termmeta`
--
ALTER TABLE `wp_termmeta`
  ADD PRIMARY KEY (`meta_id`),
  ADD KEY `term_id` (`term_id`),
  ADD KEY `meta_key` (`meta_key`(191));

--
-- Indexes for table `wp_terms`
--
ALTER TABLE `wp_terms`
  ADD PRIMARY KEY (`term_id`),
  ADD KEY `slug` (`slug`(191)),
  ADD KEY `name` (`name`(191));

--
-- Indexes for table `wp_term_relationships`
--
ALTER TABLE `wp_term_relationships`
  ADD PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  ADD KEY `term_taxonomy_id` (`term_taxonomy_id`);

--
-- Indexes for table `wp_term_taxonomy`
--
ALTER TABLE `wp_term_taxonomy`
  ADD PRIMARY KEY (`term_taxonomy_id`),
  ADD UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  ADD KEY `taxonomy` (`taxonomy`);

--
-- Indexes for table `wp_usermeta`
--
ALTER TABLE `wp_usermeta`
  ADD PRIMARY KEY (`umeta_id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `meta_key` (`meta_key`(191));

--
-- Indexes for table `wp_users`
--
ALTER TABLE `wp_users`
  ADD PRIMARY KEY (`ID`),
  ADD KEY `user_login_key` (`user_login`),
  ADD KEY `user_nicename` (`user_nicename`),
  ADD KEY `user_email` (`user_email`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `wp_commentmeta`
--
ALTER TABLE `wp_commentmeta`
  MODIFY `meta_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `wp_comments`
--
ALTER TABLE `wp_comments`
  MODIFY `comment_ID` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;
--
-- AUTO_INCREMENT for table `wp_links`
--
ALTER TABLE `wp_links`
  MODIFY `link_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `wp_options`
--
ALTER TABLE `wp_options`
  MODIFY `option_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=144;
--
-- AUTO_INCREMENT for table `wp_postmeta`
--
ALTER TABLE `wp_postmeta`
  MODIFY `meta_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;
--
-- AUTO_INCREMENT for table `wp_posts`
--
ALTER TABLE `wp_posts`
  MODIFY `ID` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;
--
-- AUTO_INCREMENT for table `wp_termmeta`
--
ALTER TABLE `wp_termmeta`
  MODIFY `meta_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;
--
-- AUTO_INCREMENT for table `wp_terms`
--
ALTER TABLE `wp_terms`
  MODIFY `term_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;
--
-- AUTO_INCREMENT for table `wp_term_taxonomy`
--
ALTER TABLE `wp_term_taxonomy`
  MODIFY `term_taxonomy_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;
--
-- AUTO_INCREMENT for table `wp_usermeta`
--
ALTER TABLE `wp_usermeta`
  MODIFY `umeta_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=19;
--
-- AUTO_INCREMENT for table `wp_users`
--
ALTER TABLE `wp_users`
  MODIFY `ID` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

