<?php
include("cpaneluapi.class.php");

class CpanelManager
{
    private $username;
    private $password;
    private $url;

    private $cpanel;                        // stores the object of the cpanel connection

    private $data_document_root;            // document root of the domain/subdomain
    private $data_home_dir;                 // home directory path of the server
    private $data_user;                     // user of the server
    private $data_ip;                       // shared ip address of the host server
    private $data_domain;                   // main domain of the server
    private $data_type;                     // server type
    private $data_server_name;              // name of the host server
    private $data_is_ssl = false;           // domain/server support SSL or not

    private $wordpress_local_path = "assets/wordpress/wordpress.zip";
    private $theme_path = "assets/wordpress/themes/";
    private $wordpress_extract_script = 'library/wordpress/raw/extract_bk.php';
    private $wordpress_sql_file_path = 'library/wordpress/raw/wordpress.sql';
    private $themefile_path = 'assets/wordpress/themes/header_bk.php';
    private $wordpress_sql_import = 'library/wordpress/raw/sql_import_bk.php';
    private $wordpress_config = 'library/wordpress/raw/wp_config_bk.php';

    private $new_extract_script_name;       // stores the name of the new extract script created
    private $new_sql_import_script;         // contain name of new import file created for sql
    private $new_sql_import_file;           // name of the new sql file generated

    

    function __construct($username,$password,$url){

        $this->username = $username;
        $this->password = $password;
        $this->url = $url;
        $this->connect();
    }

    


    private function connect(){

        try {
            $cPanel = new cpanelAPI($this->username, $this->password, $this->url); 

            $response = $cPanel->uapi->DomainInfo->single_domain_data(array('domain' => $this->url));
            if($response->status)
            {
                $this->data_document_root = $response->data->documentroot;
                $this->data_home_dir = $response->data->homedir;
                $this->data_user = $response->data->user;
                $this->data_domain = $response->data->domain;
                $this->data_ip = $response->data->ip;
                $this->data_server_name = $response->data->servername;
                $this->data_type = $response->data->type;

                if (key_exists('ssl', $response->data)) {
                    $this->data_is_ssl = $response->data->ssl;
                }
            }
            else{
                throw new Exception('cPanel invalid credentials');
            }

            $this->cpanel = $cPanel;

        } catch(Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    

    public function info(){

        $data = array(
            'response_documentroot' => $this->data_document_root,
            'response_user' => $this->data_user,
            'response_homedir' => $this->data_home_dir,
            'response_ip' => $this->data_ip,
            'response_domain' => $this->data_domain,
            'response_ssl' => $this->data_is_ssl,
            'response_type' => $this->data_type,
            'response_servername' => $this->data_server_name
        );

        return $data;
    }

   
      //process wordpress file
    public function processWordpress($wordpress_data, $path = null){

        $new_extract_script = 'extract'.time().'.php';
        $extract_path = $this->data_document_root.'/';

        if($path) {
            $path = trim($path, '/');
            $extract_path .= $path.'/';
        }

        // read backup file of extract script
        $extract_content = file_get_contents($this->wordpress_extract_script);

        // replace variable symbols with exact values
        $extract_content = str_replace(
            '{extract_path}',
            $extract_path,
            $extract_content
        );
        $extract_content = str_replace(
            '{file_path}',
            $this->data_document_root.'/wordpress.zip',
            $extract_content
        );
        $extract_content = str_replace(
            '{extract_file}',
            $new_extract_script,
            $extract_content
        );
        $extract_content = str_replace(
            '{zip_file}',
            'wordpress.zip',
            $extract_content
        );



        // absolute path of the extract script
        $upload_file_extract = FCPATH.'temp/'.$new_extract_script;

        // save updated content in new script
        file_put_contents($upload_file_extract, $extract_content);

        // upload wordpress and extract script on the server
        $this->cpanel->uapi->post->Fileman->upload_files(array('dir' => $this->data_document_root,
            'file-1' => new CURLFile($this->wordpress_local_path)));

        
        $this->cpanel->uapi->post->Fileman->upload_files(array('dir' => $this->data_document_root,
            'file-2' => new CURLFile($upload_file_extract)));


        // delete local copy of the new script generated
        unlink($upload_file_extract);
        // set name to the new script file in data member
        $this->new_extract_script_name = $new_extract_script;

        // extract wordpress on server
        $this->extractWordpress();


        $this->wordpressConfig($extract_path,$wordpress_data);
    }
    

    //process recomment theme
    public function processTheme($theme,$path = null)
    {
        $theme_extract_script = 'theme_extract'.time().'.php';
        $extract_path = $this->data_document_root.'/wp-content/themes/';

        if($path) {
            $path = trim($path, '/');
            $extract_path = $this->data_document_root.'/'.$path.'/wp-content/themes';
        }

        // read backup file of extract script
        $extract_content = file_get_contents($this->wordpress_extract_script);

        // replace variable symbols with exact values
        $extract_content = str_replace(
            '{extract_path}',
            $extract_path,
            $extract_content
        );
        $extract_content = str_replace(
            '{file_path}',
            $this->data_document_root.'/'.$theme[0]['file'],
            $extract_content
        );
        $extract_content = str_replace(
            '{extract_file}',
            $theme_extract_script,
            $extract_content
        );
        $extract_content = str_replace(
            '{zip_file}',
            $theme[0]['file'],
            $extract_content
        );

        // absolute path of the extract script
        $theme_file = FCPATH.'temp/'.$theme_extract_script;

        // save updated content in new script
        file_put_contents($theme_file, $extract_content);


        // upload wordpress and extract script on the server
        $this->cpanel->uapi->post->Fileman->upload_files(array('dir' => $this->data_document_root,
            'file-1' => new CURLFile($this->theme_path.$theme[0]['file'])));

        $this->cpanel->uapi->post->Fileman->upload_files(array('dir' => $this->data_document_root,
            'file-2' => new CURLFile($theme_file)));


        // delete local copy of the new script generated
        unlink($theme_file);
        // set name to the new script file in data member

        $this->extractTheme($theme_extract_script);
    }



    private function extractTheme($theme_extract_script){

        $url_to_visit = 'https://'.$this->data_domain . '/' . $theme_extract_script;
        echo $url_to_visit;

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url_to_visit);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $curl_response = curl_exec($ch);
        curl_close($ch);
        $curl_response = json_decode($curl_response);
        //print_r($curl_response->status); die;
        if ($curl_response->status) {
            return true;

        } else {
            throw new Exception('Error importing theme on server');
        }
    }

   


    private function extractWordpress(){

        $url_to_visit = 'https://'.$this->data_domain . '/' . $this->new_extract_script_name;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url_to_visit);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $curl_response = curl_exec($ch);
        curl_close($ch);

        $curl_response = json_decode($curl_response);

        if ($curl_response->status) {
            return true;

        } else {
            throw new Exception('Error extracting wordpress on server');
        }

    }

   

    //This function update credentials in wp-config file and upload to the wordpress
    // folder contain wordpress data of from wordpress table
    private function wordpressConfig($extract_path,$wordpress_data)
    {
        $new_wp_config = 'wp-config.php';

        // read sql file of
        $wp_config = file_get_contents($this->wordpress_config);

        $wp_config = str_replace(
            '{wordpress_db_name}',
            $wordpress_data[0]['db_name'],
            $wp_config
        );
        $wp_config = str_replace(
            '{wordpress_db_user}',
            $wordpress_data[0]['db_username'],
            $wp_config
        );
        $wp_config = str_replace(
            '{wordpress_db_password}',
            $wordpress_data[0]['db_password'],
            $wp_config
        );
        $wp_config = str_replace(
            '{wordpress_db_host}',
            'localhost',
            $wp_config
        );

        // absolute path of the extract script
        $wp_config_file = FCPATH.'temp/'.$new_wp_config;

        // save updated content in new script
        file_put_contents($wp_config_file, $wp_config);

        //upload the sql file
        $this->cpanel->uapi->post->Fileman->upload_files(array('dir' => $extract_path,
            'file-2' => new CURLFile($wp_config_file)));

        // delete local copy of the new script generated
        unlink($wp_config_file);
    }

   
     

    // create database for wordpress site 
    public function processDatabase($user_data, $wordpress_data, $cpanel_data, $theme_data, $cpanel_installation_path){

            $userlen = strlen($cpanel_data[0]['username']);

            if($userlen <= 9) {
                $result = substr($cpanel_data[0]['username'], 0, 8);
            }else{
                $result = $cpanel_data[0]['username'];
            }
//             $result = substr($cpanel_data[0]['username'], 0, 8);
             $prefix = $result.'_';  
             
             //create database 
             $create_db = $this->cpanel->uapi->Mysql->create_database(array('name'=> $prefix.$wordpress_data[0]['db_name']));  
             print_r($create_db);
            
             $create_user= $this->cpanel->uapi->Mysql->create_user(array('name'=> $prefix.$wordpress_data[0]['db_username'],
                    'password'=>$wordpress_data[0]['db_password']));
             print_r($create_user);       

                
             $wordpress_data[0]['db_username'] = $prefix.$wordpress_data[0]['db_username'];
             $wordpress_data[0]['db_name'] = $prefix.$wordpress_data[0]['db_name'];
             
             $responser = $this->cpanel->uapi->Mysql->set_privileges_on_database(array(
                        'user'=>$wordpress_data[0]['db_username'],
                        'database'=>$wordpress_data[0]['db_name'],
                        'privileges'=>'ALL PRIVILEGES')
                   );
             print_r($responser);      
             

             //upload sql file for wordpress
             $this->uploadSqlWordpress($user_data,$wordpress_data,$cpanel_data,$theme_data,$cpanel_installation_path);
             
             $this->sqlScript($wordpress_data);  
             $this->importSql();   
             return $wordpress_data;
          }

      

      //This function uploads the Wordpress Sql file to the cPanel
      private function uploadSqlWordpress($user_data, $wordpress_data,$cpanel_data,$theme_data,$cpanel_installation_path){

        $wordpress_sql_file_new = 'wordpress'.time().'.sql';

        if($theme_data[0]['recommend'] == 1)
        {
            $sql_file_path = 'library/wordpress/raw/wordpress1.sql';
        }

        else {
            $sql_file_path = $this->wordpress_sql_file_path;
        }
        
        //make changes to wordpress file
        $w_s_content = file_get_contents($sql_file_path);
        $w_s_content = str_replace(
            '{site_url}',
            'http://'.$cpanel_data[0]['domain'].'/'.$cpanel_installation_path,
            $w_s_content
        );

        $w_s_content = str_replace(
            '{blog_name}',
            $wordpress_data[0]['blog_title'],
            $w_s_content
        );
        $w_s_content = str_replace(
            '{blog_description}',
            $wordpress_data[0]['description'],
            $w_s_content
        );
        $w_s_content = str_replace(
            '{admin_email}',
            $user_data[0]['email'],
            $w_s_content
        );
        $w_s_content = str_replace(
            '{user_nick_name}',
            $user_data[0]['username'],
            $w_s_content
        );
        $w_s_content = str_replace(
            '{blog_username}',
            $wordpress_data[0]['username'],
            $w_s_content
        );
        $w_s_content = str_replace(
            '{blog_password}',
            $wordpress_data[0]['hash_password'],
            $w_s_content
        );
        $w_s_content = str_replace(
            '{user_first_name}',
            $user_data[0]['username'],
            $w_s_content
        );
        
        $w_s_content = str_replace(
            '{registration_date}',
            $user_data[0]['created'],
            $w_s_content
        );
        $w_s_content = str_replace(
            '{template}',
            strtolower(str_replace('.zip','',$theme_data[0]['file'])),
            $w_s_content
        );
        $w_s_content = str_replace(
            '{stylesheet}',
            strtolower(str_replace('.zip','',$theme_data[0]['file'])),
            $w_s_content
        );
          $w_s_content = str_replace(
              '{logo_url}',
              $wordpress_data[0]['logo_url'],
              $w_s_content
          );
          $w_s_content = str_replace(
              '{logo_length}',
              strlen($wordpress_data[0]['logo_url']),
              $w_s_content
          );
          $w_s_content = str_replace(
              '{site_url_length}',
              strlen('http://'.$cpanel_data[0]['domain'].'/'.$cpanel_installation_path),
              $w_s_content
          );


        // absolute path of the extract script
        $tmp_dir = FCPATH.'temp/';

        if (!is_dir($tmp_dir)) {
            mkdir($tmp_dir,0777,true);
        }
        $upload_sql_file = $tmp_dir.$wordpress_sql_file_new;

        // save updated content in new script
        file_put_contents($upload_sql_file, $w_s_content);

        $this->cpanel->uapi->post->Fileman->upload_files(array('dir' => $this->data_document_root,
            'file-2' => new CURLFile($upload_sql_file)));

        // delete local copy of the new script generated
        unlink($upload_sql_file);

        // set name to the new script file in data member
        $this->new_sql_import_file = $wordpress_sql_file_new;

        return true;
    }

    
    private function sqlScript($wordpress_data){

        $new_sql_script = 'import'.time().'.php';

        // read sql file of
        $extract_sql = file_get_contents($this->wordpress_sql_import);

        $extract_sql = str_replace(
            '{username}',
            $wordpress_data[0]['db_username'],
            $extract_sql
        );
        $extract_sql = str_replace(
            '{password}',
            $wordpress_data[0]['db_password'],
            $extract_sql
        );
        $extract_sql = str_replace(
            '{database}',
            $wordpress_data[0]['db_name'],
            $extract_sql
        );
        $extract_sql = str_replace(
            '{sql_script}',
            $new_sql_script,
            $extract_sql
        );
        $extract_sql = str_replace(
            '{new_sql_file}',
            $this->new_sql_import_file,
            $extract_sql
        );

        $tmp_dir = FCPATH.'temp/';

        if (!is_dir($tmp_dir)) {
            mkdir($tmp_dir,0777,true);
        }

        // absolute path of the extract script
        $import_script = $tmp_dir.$new_sql_script;

        // save updated content in new script
        file_put_contents($import_script, $extract_sql);

        //upload the sql file
        $this->cpanel->uapi->post->Fileman->upload_files(array('dir' => $this->data_document_root,
            'file-2' => new CURLFile($import_script)));

        // delete local copy of the new script generated
        unlink($import_script);

        // set name to the new script file in data member
        $this->new_sql_import_script = $new_sql_script;
        $this->new_sql_import_script;

    }

   


    private function importSql(){

        $url_to_visit = $this->data_domain . '/' . $this->new_sql_import_script;
//        $ch = curl_init();
//        curl_setopt($ch, CURLOPT_URL, $url_to_visit);
//        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
//        $curl_response = curl_exec($ch);
//        curl_close($ch);
//        //print_r($curl_response);
//        $curl_response = json_decode($curl_response);
//        //print_r($curl_response);  die;
//        if ($curl_response->status) {
//            return true;
//
//        } else {
//            throw new Exception('SQL: Error importing sql on server');
//        }

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url_to_visit,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));
        $curl_response = curl_exec($curl);
        curl_close($curl);

        print_r($curl_response);
        $curl_response = json_decode($curl_response);

        if ($curl_response->status) {
            return true;

        } else {
            throw new Exception('Error Process importing sql on server ,'.$url_to_visit);
        }
    }

   




    //upload files to the server
    public function uploadFiles($files = array())
    {
        $urls = array();
        
        foreach ($files as $i => $file) {
            $this->cpanel->uapi->post->Fileman->upload_files(array('dir' => $this->data_document_root,
                'file-'.($i+1) => new CURLFile($file)));
            
            $file_explode = explode('/', $file);
            
            $urls[] = $this->url . '/' . end($file_explode);
        }
        
        return $urls;
    }
    

 
    public function themeFile($wordpress, $installation_path,$theme_name){
        
        $extract_path = $this->data_document_root.'/'.$installation_path.'/wp-content/themes/'.$theme_name.'/';
        $new_file = 'header.php';
        $theme_file = file_get_contents($this->themefile_path);


        $theme_file = str_replace(
            '{blog_logo}',
            $wordpress[0]['logo_url'],
            $theme_file
        );

        $theme_file = str_replace(
            '{blog_description}',
            $wordpress[0]['description'],
            $theme_file
        );

        // absolute path of the extract script
        $tmp_dir = FCPATH.'temp/';

        if (!is_dir($tmp_dir)) {
            mkdir($tmp_dir,0777,true);
        }
        $file_to_upload = $tmp_dir.$new_file;

        // save updated content in new script
        file_put_contents($file_to_upload, $theme_file);

       $this->cpanel->uapi->post->Fileman->upload_files(array('dir' => $extract_path,
            'file-2' => new CURLFile($file_to_upload)));

        // delete local copy of the new script generated
        unlink($file_to_upload);
    }

}
