<!DOCTYPE html>
<html>
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<title>View Single Site</title>
<?php $this->load->view('head');?>
<meta http-equiv="refresh" content="40">
</head>
<body>
<?php $this->load->view('header');?>
<?php $this->load->view('side-bar');?>
<div class="col-sm-9 col-sm-offset-3 col-lg-10 col-lg-offset-2 main">
    <div class="p-t-50">
        <div class="row">
            <div class="col-lg-12">
                <h3 class="page-header">Single Sites</h3>
            </div>
        </div><!--/.row-->
    </div>
<div class="row">
			<div class="col-md-12 store-data">
				<div class="panel panel-default">
					<div class="panel-body">
						<table id="table_id" class="display ">
						    <thead>
						        <tr>
						            <th>Title of Site</th>
						            <th>Site Status</th>
						            <th>Theme Selected</th>
						            <th>Visit Site</th>
						            
						        </tr>
						    </thead>
						    <tbody>
						    	<?php foreach ($stores as $store): ?>
							        <tr>
							            <td><?php echo $store['blog_title']?></td>
							            <td>
                                            <?php if($store['failed'] == 0) {?>
                                                <?php if($store['statuses_id'] == 1) {?>
                                                    <p style="color: #00CC00">Ready to create</p>
                                                <?php }elseif($store['statuses_id'] == 2){?>
                                                 <p style="color: #00CC00">Processing...</p>
                                                <?php } elseif($store['statuses_id'] == 3){?>
                                                    <p style="color: #00CC00">Complete</p>
                                                <?php }?>
                                                <?php } else if(strpos($store['message'], 'RequestThro (truncated...)') !== false){?>
                                                <p style="color: red">failed
                                                    <span class="tooltip-title-bg" rel="tooltip" title="Please click on the right side button to know more about this issue.">
                                                        <i class="fa fa-question-circle">
                                                        </i></span> <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/http-503-service-unavailable.html"
                                                                       rel="tooltip"
                                                                       title="Visit the link to know more about error."
                                                                       target="_blank">
                                                        <i class="fas fa-external-link-square-alt"></i>
                                                    </a></p>
                                            <?php } else {?>
                                                <p style="color: #00CC00">Pending...</p>
                                            <?php }?>
                                        </td>
							            <td><?php echo $this->StoreModel->getField('name','themes',$store['theme_id'])?></td>
							            <td><a href="https://<?php echo $this->StoreModel->getDomainName($store['cpanel_id']).'/'.$store['installation_path'];?>"
                                               target="_blank"
                                               title="Go to your blog"
                                               class="btn btn-info btn-xs">
                                                <i class="fas fa-external-link-square-alt"></i>
                                            </a>
                                        </td>
							        </tr>
						        <?php endforeach; ?>
						    </tbody>
						</table>
					</div>
				</div>
			</div>
		</div><!--/.row-->
    <!---footer------>

    <?php $this->load->view('footer');?>
    <!---footer------>
</div>


<!-- Modal -->
<div id="myModal" class="modal fade" role="dialog">
    <div class="modal-dialog">

        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Assign this site to your client(s)</h4>
            </div>
            <div id="modal-body" class="modal-body">
                <p>Some text in the modal.</p>
            </div>
            <div class="modal-footer">
               
            </div>
        </div>

    </div>
</div>

<script type="text/javascript">
	$(document).ready( function () {
    $('#table_id').DataTable();
} );
</script>

<script>
    $(document).on('click', '.btn-del', function () {

        var url = $(this).data('url');
        // alert(url);
        swal({
            title: "Are you sure?",
            text: "Note : Your blog will not be deleted, only this records will be erased.",
            icon: "error",
            buttons: true,
            dangerMode: true,
        })
            .then((willDelete) => {
                if (willDelete) {
                    window.location.href = url;
                }
            });
    });

</script>

<script>
    $(document).on('click','.assign', function () {
        var url = $(this).data('url');

        $('#modal-body').load(url, function () {
            $('#myModal').modal('show');
        });
    });
</script>

</body>
</html>